/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.Inheritance;
import org.eclipse.dali.core.InheritanceType;
import org.eclipse.dali.core.TypeMapping;
import org.eclipse.dali.core.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.core.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaInheritanceModelAdapter
implements IInheritanceModelAdapter {
    private Inheritance inheritance;
    private EnumAnnotationElementAdapter strategyAdapter = new EnumAnnotationElementAdapter(this.buildStrategyInfo());
    private static final String INHERITANCE_ANNOTATION = "Inheritance";

    JavaInheritanceModelAdapter() {
    }

    public void engage(Inheritance inheritance, CompilationUnit astRoot) {
        this.inheritance = inheritance;
        this.updatePersModel(astRoot);
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildStrategyInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String inheritanceType) {
                if (inheritanceType == null) {
                    return;
                }
                if (inheritanceType.equals("JOINED")) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.JOINED_LITERAL);
                } else if (inheritanceType.equals("SINGLE_TABLE")) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.SINGLE_TABLE_LITERAL);
                } else if (inheritanceType.equals("TABLE_PER_CLASS")) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.TABLE_PER_CLASS_LITERAL);
                } else if (inheritanceType.equals(InheritanceType.DEFAULT_LITERAL.getName())) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                InheritanceType inheritanceType = JavaInheritanceModelAdapter.this.getInheritance().getStrategy();
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.JOINED_LITERAL)) {
                    return "JOINED";
                }
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.SINGLE_TABLE_LITERAL)) {
                    return "SINGLE_TABLE";
                }
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.TABLE_PER_CLASS_LITERAL)) {
                    return "TABLE_PER_CLASS";
                }
                return InheritanceType.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return "InheritanceType";
            }

            public String annotationElementName() {
                return "strategy";
            }

            public String annotationName() {
                return JavaInheritanceModelAdapter.INHERITANCE_ANNOTATION;
            }

            public Member member() {
                return JavaInheritanceModelAdapter.this.member();
            }

            public String defaultValue() {
                return InheritanceType.DEFAULT_LITERAL.getName();
            }

            public boolean removeIfEmpty() {
                return true;
            }
        };
    }

    protected Inheritance getInheritance() {
        return this.inheritance;
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersStrategy(astRoot);
    }

    private void updatePersStrategy(CompilationUnit astRoot) {
        this.strategyAdapter.updatePersElement(astRoot);
    }

    public void strategyChanged() {
        this.strategyAdapter.updateJavaElement();
    }

    protected Member member() {
        JavaPersistentTypeModelAdapter modelAdapter = (JavaPersistentTypeModelAdapter)((TypeMapping)this.inheritance.eContainer()).getPersistentType().getModelAdapter();
        return modelAdapter.getType();
    }

    public ITextRange getTextRange() {
        return this.member().getTextRange(this.annotationName());
    }

    protected String annotationName() {
        return INHERITANCE_ANNOTATION;
    }
}

