/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.gen;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.gen.EntityGenerator;
import org.eclipse.dali.gen.GenScope;
import org.eclipse.dali.gen.GenTable;
import org.eclipse.jdt.core.IPackageFragment;

public class PackageGenerator {
    private final Config config;
    private final EntityGenerator.Config entityConfig;
    private final GenScope scope;
    private final IProgressMonitor monitor;

    public static void generateEntities(Config config, EntityGenerator.Config entityConfig, Collection tables, IProgressMonitor monitor) {
        if (config == null || entityConfig == null || tables == null) {
            throw new NullPointerException();
        }
        new PackageGenerator(config, entityConfig, tables, monitor).generateEntities();
    }

    private PackageGenerator(Config config, EntityGenerator.Config entityConfig, Collection tables, IProgressMonitor monitor) {
        this.config = config;
        this.entityConfig = entityConfig;
        this.scope = new GenScope(tables, entityConfig);
        this.monitor = monitor;
    }

    private void generateEntities() {
        Iterator stream = this.scope.entityTables();
        while (stream.hasNext()) {
            this.buildEntity((GenTable)stream.next());
        }
    }

    private void buildEntity(GenTable genTable) {
        EntityGenerator.generateEntity(this.entityConfig, this.config.getPackageFragment(), genTable, this.monitor);
    }

    public static class Config {
        private IPackageFragment packageFragment;

        public IPackageFragment getPackageFragment() {
            return this.packageFragment;
        }

        public void setPackageFragment(IPackageFragment packageFragment) {
            this.packageFragment = packageFragment;
        }
    }
}

