/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.ZipEntryLocation;

public abstract class AbstractZipLocation
extends Location {
    protected static final byte[] fBuffer = new byte[8192];
    protected static final ByteArrayOutputStream fBytesOut = new ByteArrayOutputStream(8192);
    public static final String JAR = "jar";

    public AbstractZipLocation(ILocation parent, String fullName) {
        super(parent, fullName);
    }

    public ILocation createChild(String relativePath) {
        return new ZipEntryLocation(this, relativePath);
    }

    public ILocation createSibling(String relativePath) {
        String path = this.getName();
        int index = path.lastIndexOf(47);
        if (index < 0) {
            return this.parent.createChild(relativePath);
        }
        path = String.valueOf(path.substring(0, index + 1)) + relativePath;
        return this.parent.createChild(path);
    }

    protected ZipInputStream getZipInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ZipInputStream zipIn = null;
        if (Location.getExtension(this.getName()).equalsIgnoreCase(JAR)) {
            try {
                zipIn = new JarInputStream(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            zipIn = new ZipInputStream(inputStream);
        }
        return zipIn;
    }

    protected byte[] readAllBytes(InputStream in) throws IOException {
        fBytesOut.reset();
        int read = in.read(fBuffer);
        while (read != -1) {
            fBytesOut.write(fBuffer, 0, read);
            read = in.read(fBuffer);
        }
        return fBytesOut.toByteArray();
    }

    protected abstract InputStream getChildInputStream(String var1);
}

