/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

class DTDReader {
    protected URL dtdURL;

    public DTDReader(URL uRL) {
        this.dtdURL = uRL;
    }

    public DTDReader(String string) throws IOException {
        try {
            this.dtdURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Invalid DTD URL " + string + ": " + malformedURLException.toString());
        }
    }

    public String[] getElements() throws IOException {
        Vector<String> vector = new Vector<String>();
        PushbackInputStream pushbackInputStream = null;
        try {
            Object[] objectArray;
            URLConnection uRLConnection = this.dtdURL.openConnection();
            pushbackInputStream = new PushbackInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            while (this.scanForLTBang(pushbackInputStream)) {
                objectArray = this.getString(pushbackInputStream);
                if (!objectArray.equals("ELEMENT")) continue;
                this.skipWhiteSpace(pushbackInputStream);
                String string = this.getString(pushbackInputStream);
                vector.addElement(string);
            }
            pushbackInputStream.close();
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            if (pushbackInputStream != null) {
                try {
                    pushbackInputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new IOException("Error reading DTD: " + exception.toString());
        }
    }

    protected boolean scanForLTBang(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        while ((n = pushbackInputStream.read()) >= 0) {
            if (n != 60) continue;
            n = pushbackInputStream.read();
            if (n < 0) {
                return false;
            }
            if (n == 33) {
                return true;
            }
            if (n != 60) continue;
            pushbackInputStream.unread((byte)n);
        }
        return false;
    }

    protected void skipWhiteSpace(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        while ((n = pushbackInputStream.read()) >= 0) {
            if (Character.isWhitespace((char)n)) continue;
            pushbackInputStream.unread((byte)n);
            return;
        }
    }

    protected String getString(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = pushbackInputStream.read()) >= 0) {
            if (Character.isWhitespace((char)n)) {
                pushbackInputStream.unread((byte)n);
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
        return null;
    }
}

