/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.AppResourceLoader;
import com.jeta.open.resources.ResourceLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;

public class ImagePainter
implements Painter {
    private Icon m_icon;
    private int m_halign;
    private int m_valign;
    private static Icon m_design_icon;
    private Rectangle m_rect = new Rectangle();

    public ImagePainter() {
        this(null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePainter(Icon icon, int n, int n2) {
        this.m_icon = icon;
        this.m_halign = n;
        this.m_valign = n2;
        Class clazz = ImagePainter.class;
        synchronized (clazz) {
            if (m_design_icon == null) {
                try {
                    if (FormUtils.isDesignMode()) {
                        ResourceLoader resourceLoader = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
                        FormUtils.safeAssert(resourceLoader != null);
                        if (resourceLoader != null) {
                            m_design_icon = resourceLoader.loadImage("jeta.resources/images/incors/16x16/photo_portrait.png");
                        }
                    } else {
                        m_design_icon = AppResourceLoader.getEmptyIcon();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public int getIconHeight() {
        if (this.m_icon == null) {
            if (m_design_icon == null) {
                return 0;
            }
            return m_design_icon.getIconHeight();
        }
        return this.m_icon.getIconHeight();
    }

    public int getIconWidth() {
        if (this.m_icon == null) {
            if (m_design_icon == null) {
                return 0;
            }
            return m_design_icon.getIconWidth();
        }
        return this.m_icon.getIconWidth();
    }

    public int getHorizontalAlignment() {
        return this.m_halign;
    }

    public int getVerticalAlignment() {
        return this.m_valign;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setHorizontalAlignment(int n) {
        this.m_halign = n;
    }

    public void setVerticalAlignment(int n) {
        this.m_valign = n;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = this.getHorizontalAlignment();
        n5 = n7 == 1 ? (n3 - this.getIconWidth()) / 2 : (n7 == 2 ? n3 - this.getIconWidth() : n);
        int n8 = this.getVerticalAlignment();
        n6 = n8 == 1 ? (n4 - this.getIconHeight()) / 2 : (n8 == 5 ? n4 - this.getIconHeight() : n2);
        if (n5 < n) {
            n5 = n;
        }
        if (n6 < n2) {
            n6 = n2;
        }
        Icon icon = this.getIcon();
        Rectangle rectangle = graphics.getClipBounds();
        this.m_rect.setBounds(n5, n6, n3, n4);
        if (this.m_rect.intersects(rectangle)) {
            this.m_rect = this.m_rect.intersection(rectangle);
            graphics.setClip(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
            if (icon == null) {
                if (m_design_icon != null) {
                    m_design_icon.paintIcon(component, graphics, n5, n6);
                }
            } else {
                icon.paintIcon(component, graphics, n5, n6);
            }
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paint(Component component, Graphics graphics, Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        this.paint(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

