<?php
//TITLE=HTML file character encoding changer

$outset= 'utf-8';
$title = 'HTML file Character set converter';
$progname = 'htmlrecode';

$text = array(
   '1. Purpose' => "

Recodes the HTML file using a new character set, while losing
no characters at all. You can recode shift_jis to euc-jp, utf8 to latin1,
iso-8859-15 to GB18030, iso-2022-jp to koi8-r etc if you wish, and none
of the characters on the page will become unreadable
(unless you specify -l switch, which disables making &amp;#nnnn; escapes).
<p>
Standard-correct HTML is a good thing.
One of the goals in the development of this program is
that it never makes the HTML more broken than it previously was.
It should even make it better than it was. So if you
see that the program does the opposite, please <a href=\"#contact\">tell me</a>.

", '1. Usage' => "

<pre class=smallerpre>htmlrecode 1.2.0 - Copyright (C) 1992,2003 Bisqwit (http://iki.fi/bisqwit/)

Usage: htmlrecode [&lt;option> [&lt;...>]]

Reads stdin, writes stdout.

Options:
    -I, --inset setname   Assumed input character set (default: iso-8859-1)
    -O, --outset setname  Wanted output character set (default: iso-8859-1)
    -V, --version         Displays version information.
    -e, --usehex          Use hexadecimal escapes.
    -g, --signature       Prefix the file with an unicode signature.
    -h, --help            This help.
    -l, --lossy           Disable lossless conversion.
    -q, --quiet           Be less verbose.
    -s, --strict          Turn off support for slightly broken HTML.
    -v, --verbose         Be less quiet.
    -x, --xmlmode         XML mode: all tag param values quoted.

Pipe in the html file and pipe the output to result file.</pre>

", '1. TODO' => "

I'll soon add an interface for modifying the text content of a HTML file.<br>
This should make making filters like Pootpoot or Pikachifier easier. It is
already theoretically supported, but I haven't invented an interface for
it yet.

", '1. Installation' => "

<pre class=smallerpre
>\$ make
\$ su
# make install</pre>

If you do not want to install
<a href=\"http://oktober.stc.cx/source/libargh.html\">libargh</a>
(included in the archive), do not use \"make install\" and edit
Makefile and enable the STATIC linking instead of DYNAMIC.

", '1. Example' => "

This page template is locally stored in iso-8859-1, but is
automatically converted to utf-8 to make the final version.<p>
Here are some latin letters: <br>
Here are some CJK (chinese/japanese/korean ideograms): &#26085;&#26412;<br>
Here are some html escapes: &gt;&quot;&auml;&ouml;&ecirc;<br>
<p>
Source code of the above:<pre class=smallerpre
>Here are some latin letters: &aring;&auml;&ouml;&ntilde;&eacute;&lt;br&gt;
Here are some CJK (chinese/japanese/korean ideograms): &amp;#26085;&amp;#26412;&lt;br&gt;
Here are some html escapes: &amp;gt;&amp;quot;&amp;auml;&amp;ouml;&amp;ecirc;&lt;br&gt;
</pre>
What your browser is getting, is not &amp;#26085; etc but the actual utf-8 characters.

", 'contact:1. Feedback' => "

If you have problems using this program or ideas how to
develop it, email me your questions or ideas.<br>
Please do not omit the details.<br>
My email address (sigh) is: <em>bisqwit a<b style=\"font-weight:lighter\">t i</b>ki <small>dot</small> fi</em>

", '1. Requirements' => "

htmlrecode has been written in C++, utilizing the standard template library.<br>
GNU make is required.<br>
I have g++ version 3.3, and htmlrecode compiles without warnings. For now.

", '1.1. Compilation problems' => "

htmlrecode uses widestrings, which is a feature different g++ versions
are very inconsistent about. <code>htmlrecode.hh</code> has some settings you can
try to choose between. Try this:<p>
Replace<pre>
 //#define wstring ucs4string
 typedef wchar_t ucs4;
 //typedef unsigned int ucs4;
 //typedef basic_string&lt;ucs4> wstring;</pre>
With<pre>
 //#define wstring ucs4string
 //typedef wchar_t ucs4;
 typedef unsigned int ucs4;
 typedef basic_string&lt;ucs4> wstring;</pre>
</p>
This might help compiling on g++-2.95.

", '1. Changelog' => "

<pre>
Since 1.3.0:
  - Compilation fixes on more up-to-date compilers. (Thanks Santiago M. Mola)

Since 1.2.0:
  - Abrubtly terminated multibyte sequences no longer
    cause htmlrecode to enter an infinite loop

Since 1.1.5:
  - Tags are now recognized in all mixed case
  - Tag values can be in '', not only in \"\"
  - -:_. are recognized to be part of tag value if no \"\" is there
  - Nonspace are also recognized as above :((unless -s option was used)
  - SCRIPT and STYLE contents are \"raw\" until the next &lt;/, unless -s was used
  - SCRIPT/STYLE contents are properly rehidden if necessary
  - \" and ' quotes (and no quotes) are used wisely
  - Warnings from some bad HTML
  - Indentations inside tags are now kept mostly intact
  - XHTML support
  - Unicode signature character support
  - Major structural rewrites
  - New \"configure\" script
  
 - Big thanks to Winfried Szukalski for
   his thorough testing efforts and comments.

Since 1.1.4:
  - workaround for g++ versions, now compiles with g++-3

Since 1.1.3:
  - optimizations
  - error resistence

Since 1.1.2:
  - hex support
  - g++ string workarounds

Since 1.1.1:
  - improved documentation
  - fixed &lt; (was outputted as &amp;gt;, should be &amp;lt;)

</pre>

", '1. Copying' => "

htmlrecode has been written by Joel Yliluoma, a.k.a.
<a href=\"http://iki.fi/bisqwit/\">Bisqwit</a>,<br>
and is distributed under the terms of the
<a href=\"http://www.gnu.org/licenses/licenses.html#GPL\">General Public License</a> (GPL).

");
include '/WWW/progdesc.php';
