/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.CheckOpenFilesProcess;
import org.xmind.cathy.internal.EditorStatePersistance;
import org.xmind.cathy.internal.Log;
import org.xmind.cathy.internal.dashboard.DashboardAutomationAddon;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;

public class StartUpProcess {
    private static final boolean DEBUG_CHECK_OPEN_FILE = CathyPlugin.getDefault().isDebugging("/debug/checkopenfile");
    private IWorkbench workbench;

    public StartUpProcess(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public void startUp() {
        this.hideRightStack();
        this.checkAndRecoverFiles();
        if (DEBUG_CHECK_OPEN_FILE) {
            this.checkAndOpenFiles();
        } else {
            Log openFile = Log.get(".opening");
            if (openFile.exists()) {
                openFile.delete();
            }
        }
        this.openStartupMap();
        Display display = this.workbench.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    System.setProperty("org.xmind.cathy.app.status", "workbenchReady");
                }
            });
        }
    }

    private void hideRightStack() {
        MApplication application = (MApplication)this.workbench.getService(MApplication.class);
        for (MWindow window : application.getChildren()) {
            DashboardAutomationAddon.hideVisiblePart(window, "org.xmind.ui.stack.right");
        }
    }

    private void checkAndOpenFiles() {
        new CheckOpenFilesProcess(this.workbench).doCheckAndOpenFiles();
    }

    private void checkAndRecoverFiles() {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                new EditorStatePersistance(StartUpProcess.this.workbench, CathyPlugin.getDefault().getStateLocation(), CathyPlugin.getDefault().getLogger(), CathyPlugin.getDefault().getDebugValue("/debug/autoSaveEditorStateIntervals", 60000)).startUp();
            }
        });
    }

    private void openStartupMap() {
        if (!this.hasOpenedEditors()) {
            int action = CathyPlugin.getDefault().getPreferenceStore().getInt("startupAction2");
            if (action == 3) {
                this.doOpenLastSession();
            }
            if (!this.hasOpenedEditors()) {
                this.closeOpenedDashboard();
            }
        }
    }

    private void doOpenDashboard() {
        EModelService modelService = (EModelService)this.workbench.getService(EModelService.class);
        final MApplication application = (MApplication)this.workbench.getService(MApplication.class);
        if (modelService == null || application == null) {
            return;
        }
        final DashboardAutomationAddon automator = new DashboardAutomationAddon();
        automator.setModelService(modelService);
        automator.setApplication(application);
        this.workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (MWindow window : application.getChildren()) {
                    automator.showDashboard(window);
                }
            }
        });
    }

    private void closeOpenedDashboard() {
        EModelService modelService = (EModelService)this.workbench.getService(EModelService.class);
        final MApplication application = (MApplication)this.workbench.getService(MApplication.class);
        if (modelService == null || application == null) {
            return;
        }
        this.workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (MWindow window : application.getChildren()) {
                    if (!window.getTags().contains("CathyShowDashboard")) continue;
                    window.getTags().remove("CathyShowDashboard");
                }
            }
        });
    }

    private void doOpenLastSession() {
        IPath editorStatusPath = WorkbenchPlugin.getDefault().getDataLocation().append("XMind_Editors.xml");
        final File stateFile = editorStatusPath.toFile();
        if (stateFile.exists()) {
            this.workbench.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            IWorkbenchPage page;
                            IWorkbenchWindow window = StartUpProcess.this.workbench.getActiveWorkbenchWindow();
                            if (window != null && (page = window.getActivePage()) != null) {
                                StartUpProcess.this.openUnclosedMapLastSession(stateFile, page);
                            }
                        }
                    });
                }
            });
        }
    }

    private void openUnclosedMapLastSession(File statusFile, IWorkbenchPage page) throws FileNotFoundException, UnsupportedEncodingException, WorkbenchException, CoreException, PartInitException {
        FileInputStream input = new FileInputStream(statusFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        IMemento childMem = memento.getChild("editors");
        IMemento[] childrenEditor = childMem.getChildren("editor");
        IEditorPart activeEditorPart = null;
        IMemento[] iMementoArray = childrenEditor;
        int n = childrenEditor.length;
        int n2 = 0;
        while (n2 < n) {
            String uri;
            IMemento childEditor = iMementoArray[n2];
            IMemento inputMemeto = childEditor.getChild("input");
            if (inputMemeto != null && (uri = inputMemeto.getString("uri")) != null) {
                IWorkbookRef workbookRef = null;
                try {
                    workbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(new URI(uri), null);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                if (workbookRef != null) {
                    IEditorInput editorInput = MindMapUI.getEditorInputFactory().createEditorInput(workbookRef);
                    IEditorPart editorPart = page.openEditor(editorInput, "org.xmind.ui.MindMapEditor");
                    if ("true".equals(childEditor.getString("activePart"))) {
                        activeEditorPart = editorPart;
                    }
                }
            }
            ++n2;
        }
        if (activeEditorPart != null) {
            page.activate(activeEditorPart);
        }
    }

    private boolean hasOpenedEditors() {
        final boolean[] ret = new boolean[]{false};
        this.workbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = StartUpProcess.this.workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage page = window.getActivePage();
                    if (page != null && page.getEditorReferences().length > 0) {
                        ret[0] = true;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return ret[0];
    }
}

