/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.workbench.internal.notification;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.xmind.workbench.internal.XMindNetWorkbench;
import net.xmind.workbench.internal.notification.ISiteEvent;
import net.xmind.workbench.internal.notification.XMLSiteEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteEventStore {
    private static final String TAG_ROOT = "site-events";
    private static final String TAG_EVENTS = "events";
    private static final String TAG_EVENT = "event";
    private XMLMemento writeRoot;
    private IMemento events;
    private List<ISiteEvent> eventList;
    private Map<String, ISiteEvent> eventMap;

    public SiteEventStore(Reader reader) {
        block13: {
            this.eventList = new ArrayList<ISiteEvent>();
            this.eventMap = new HashMap<String, ISiteEvent>();
            try {
                try {
                    this.writeRoot = XMLMemento.createReadRoot((Reader)reader);
                }
                catch (WorkbenchException e) {
                    XMindNetWorkbench.log(e, "Failed to read site-events.xml.");
                    this.writeRoot = XMLMemento.createWriteRoot((String)TAG_ROOT);
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        this.events = this.writeRoot.getChild(TAG_EVENTS);
        if (this.events == null) {
            this.events = this.writeRoot.createChild(TAG_EVENTS);
        }
        IMemento[] iMementoArray = this.events.getChildren(TAG_EVENT);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            XMLSiteEvent event = new XMLSiteEvent(m);
            this.eventList.add(event);
            this.eventMap.put(event.getId(), event);
            ++n2;
        }
    }

    public SiteEventStore(List<ISiteEvent> events) {
        this.eventList = new ArrayList<ISiteEvent>();
        this.eventMap = new HashMap<String, ISiteEvent>();
        this.writeRoot = XMLMemento.createWriteRoot((String)TAG_ROOT);
        this.events = this.writeRoot.createChild(TAG_EVENTS);
        for (ISiteEvent event : events) {
            this.copyEvent(event);
        }
    }

    public SiteEventStore() {
        this(Collections.EMPTY_LIST);
    }

    public List<ISiteEvent> getEvents() {
        return this.eventList;
    }

    public ISiteEvent findEvent(String id) {
        return this.eventMap.get(id);
    }

    public List<ISiteEvent> calcNewEvents(List<ISiteEvent> updates, boolean startup) {
        ArrayList<ISiteEvent> newEvents = new ArrayList<ISiteEvent>();
        for (ISiteEvent event : updates) {
            if (!this.shouldPrompt(event, startup)) continue;
            newEvents.add(event);
        }
        return newEvents;
    }

    private boolean shouldPrompt(ISiteEvent event, boolean startup) {
        String prompt = event.getPrompt();
        if ("always".equals(prompt)) {
            return true;
        }
        if ("startup".equals(prompt)) {
            return startup;
        }
        if (this.findEvent(event.getId()) == null) {
            return !"never".equals(prompt);
        }
        return prompt != null && prompt.contains("every");
    }

    public XMLSiteEvent copyEvent(ISiteEvent event) {
        XMLSiteEvent e = this.createEvent(event.getId());
        e.setStyle(event.getStyle());
        e.setText(event.getText());
        e.setPrompt(event.getPrompt());
        e.setEventUrl(event.getEventUrl());
        e.setMoreUrl(event.getMoreUrl());
        e.setOpenExternal(event.isOpenExternal());
        e.setActionText(event.getActionText());
        return e;
    }

    public XMLSiteEvent createEvent(String id) {
        IMemento child = this.events.createChild(TAG_EVENT);
        XMLSiteEvent event = new XMLSiteEvent(child);
        event.setId(id);
        this.eventList.add(event);
        this.eventMap.put(id, event);
        return event;
    }

    public void save(Writer writer) throws IOException {
        this.writeRoot.save(writer);
    }
}

