/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.IGraphicalViewer;

public class PopupTaskInfoHelper
extends PopUpHelper
implements FigureListener,
PropertyChangeListener {
    private IGraphicalViewer viewer;
    private IFigure currentSource;
    private boolean resetBoundsScheduled = false;

    public PopupTaskInfoHelper(IGraphicalViewer viewer) {
        super(viewer.getControl(), 16388);
        this.viewer = viewer;
    }

    protected void hookShellListeners() {
        this.getShell().addListener(5, new Listener(){

            public void handleEvent(Event event) {
                PopupTaskInfoHelper.this.hide();
            }
        });
        this.getShell().setForeground(ColorConstants.tooltipForeground);
        this.getShell().setBackground(ColorConstants.tooltipBackground);
        Viewport viewport = this.viewer.getCanvas().getViewport();
        if (viewport != null) {
            viewport.addPropertyChangeListener("viewLocation", (PropertyChangeListener)this);
        }
    }

    public void show(IFigure source, IFigure tooltip) {
        this.setSource(source);
        this.getLightweightSystem().setContents(tooltip);
        this.scheduleResetBounds(true);
    }

    private void setSource(IFigure source) {
        if (source == this.currentSource) {
            return;
        }
        if (this.currentSource != null) {
            this.currentSource.removeFigureListener((FigureListener)this);
        }
        this.currentSource = source;
        if (source != null) {
            source.addFigureListener((FigureListener)this);
        }
    }

    private Point calculateShellLocation(IFigure source, Dimension shellSize) {
        org.eclipse.draw2d.geometry.Rectangle sourceBounds = source.getBounds();
        Point sourceLocation = sourceBounds.getBottomLeft();
        source.translateToAbsolute((Translatable)sourceLocation);
        Point controlLocation = sourceLocation;
        Point shellLocation = new Point(this.viewer.getControl().toDisplay(sourceLocation.x, sourceLocation.y)).translate(0, 2);
        Rectangle controlExtent = this.viewer.getCanvas().getClientArea();
        if (controlLocation.y + shellSize.height > controlExtent.y + controlExtent.height) {
            sourceLocation = sourceBounds.getTopLeft();
            controlLocation = this.viewer.computeToControl(sourceLocation, true);
            shellLocation = this.viewer.computeToDisplay(sourceLocation, true).translate(0, -shellSize.height - 5);
        }
        if (controlLocation.x < controlExtent.x) {
            shellLocation.x -= controlLocation.x - controlExtent.x;
        } else {
            int maxX = controlExtent.x + controlExtent.width - shellSize.width;
            if (controlLocation.x > maxX) {
                shellLocation.x -= controlLocation.x - maxX;
            }
        }
        return shellLocation;
    }

    private Dimension calculateShellSize() {
        return this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
    }

    public void hide(IFigure source) {
        if (source == this.currentSource) {
            this.hide();
            this.resetBoundsScheduled = false;
        }
    }

    public void figureMoved(IFigure source) {
        if (this.isShowing()) {
            this.scheduleResetBounds(false);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isShowing()) {
            this.scheduleResetBounds(false);
        }
    }

    private void scheduleResetBounds(final boolean toShow) {
        if (this.resetBoundsScheduled) {
            return;
        }
        this.resetBoundsScheduled = true;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!PopupTaskInfoHelper.this.resetBoundsScheduled) {
                    return;
                }
                if (toShow) {
                    PopupTaskInfoHelper.this.resetShellBounds();
                    PopupTaskInfoHelper.this.show();
                } else if (PopupTaskInfoHelper.this.isShowing()) {
                    PopupTaskInfoHelper.this.resetShellBounds();
                }
                PopupTaskInfoHelper.this.resetBoundsScheduled = false;
            }
        });
    }

    private void resetShellBounds() {
        Dimension shellSize = this.calculateShellSize();
        Point shellLocation = this.calculateShellLocation(this.currentSource, shellSize);
        this.setShellBounds(shellLocation.x, shellLocation.y, shellSize.width, shellSize.height);
    }

    public IFigure getCurrentSource() {
        return this.currentSource;
    }
}

