/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecoration;
import org.xmind.gef.draw2d.graphics.GradientPattern;

public abstract class AbstractShapeDecoration
extends AbstractDecoration
implements IShapeDecoration {
    protected static final Rectangle NO_OWNER_BOX = new Rectangle();
    private Color fillColor = null;
    private int fillAlpha = 255;
    private int lineAlpha = 255;
    private Color lineColor = null;
    private int lineWidth = 1;
    private int lineStyle = 1;
    private boolean gradient = false;

    protected AbstractShapeDecoration() {
    }

    protected AbstractShapeDecoration(String id) {
        super(id);
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public int getLineAlpha() {
        return this.lineAlpha;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getFillAlpha() {
        return this.fillAlpha;
    }

    public void setFillAlpha(IFigure figure, int alpha) {
        if (alpha == this.fillAlpha) {
            return;
        }
        this.fillAlpha = alpha;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setFillColor(IFigure figure, Color c) {
        if (c == this.fillColor || c != null && c.equals((Object)this.fillColor)) {
            return;
        }
        this.fillColor = c;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setGradient(IFigure figure, boolean gradient) {
        if (gradient == this.gradient) {
            return;
        }
        this.gradient = gradient;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineAlpha(IFigure figure, int alpha) {
        if (alpha == this.lineAlpha) {
            return;
        }
        this.lineAlpha = alpha;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineColor(IFigure figure, Color c) {
        if (c == this.lineColor || c != null && c.equals((Object)this.lineColor)) {
            return;
        }
        this.lineColor = c;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineStyle(IFigure figure, int lineStyle) {
        if (lineStyle == this.lineStyle) {
            return;
        }
        this.lineStyle = lineStyle;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineWidth(IFigure figure, int lineWidth) {
        if (lineWidth == this.lineWidth) {
            return;
        }
        this.lineWidth = lineWidth;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    protected void performPaint(IFigure figure, Graphics g) {
        if (this.isFillVisible(figure)) {
            this.fill(figure, g);
            g.restoreState();
        }
        if (this.isLineVisible(figure)) {
            this.outline(figure, g);
            g.restoreState();
        }
    }

    protected void outline(IFigure figure, Graphics g) {
        g.setAlpha(this.getAppliedLineAlpha());
        g.setForegroundColor(this.getLineColor(figure));
        g.setLineWidth(this.getLineWidth());
        g.setLineStyle(this.getLineStyle());
        this.paintOutline(figure, g);
    }

    protected void fill(IFigure figure, Graphics g) {
        Pattern bgPattern = null;
        int appliedAlpha = this.getAppliedFillAlpha();
        Color bgColor = this.getFillColor(figure);
        if (this.isGradient()) {
            bgPattern = this.createGradientPattern(figure, appliedAlpha, bgColor);
            g.setBackgroundPattern(bgPattern);
        } else {
            g.setAlpha(appliedAlpha);
            g.setBackgroundColor(bgColor);
        }
        this.paintFill(figure, g);
        if (bgPattern != null) {
            g.setBackgroundPattern(null);
            bgPattern.dispose();
        }
    }

    protected int getAppliedLineAlpha() {
        return (int)Math.floor((double)this.getLineAlpha() * 1.0 * (double)this.getAlpha() / 255.0);
    }

    protected int getAppliedFillAlpha() {
        return (int)Math.floor((double)this.getFillAlpha() * 1.0 * (double)this.getAlpha() / 255.0);
    }

    protected Color getFillColor(IFigure figure) {
        Color c = this.getFillColor();
        return c == null ? figure.getBackgroundColor() : c;
    }

    protected Color getLineColor(IFigure figure) {
        Color c = this.getLineColor();
        return c == null ? figure.getForegroundColor() : c;
    }

    protected Pattern createGradientPattern(IFigure figure, int alpha, Color bgColor) {
        Rectangle r = this.getFillBox(figure);
        int delta = (int)((double)r.height * 0.4);
        GradientPattern p = new GradientPattern((Device)Display.getCurrent(), r.x, r.y - delta, r.x, r.y + r.height, ColorConstants.white, alpha, bgColor, alpha);
        return p;
    }

    protected abstract void paintFill(IFigure var1, Graphics var2);

    protected abstract void paintOutline(IFigure var1, Graphics var2);

    protected Rectangle getFillBox(IFigure figure) {
        return this.getFillBox(figure.getBounds());
    }

    protected Rectangle getFillBox(Rectangle box) {
        Rectangle ret = box.getCopy();
        int w = Math.min(ret.width - 1, Math.min(ret.height - 1, this.getLineWidth()));
        int half = w - w / 2;
        return ret.shrink(half, half);
    }

    protected Rectangle getOutlineBox(IFigure figure) {
        return this.getOutlineBox(figure.getBounds());
    }

    protected Rectangle getOutlineBox(Rectangle box) {
        Rectangle ret = box.getCopy();
        int w = Math.min(ret.width - 1, Math.min(ret.height - 1, this.getLineWidth()));
        int half = w - w / 2;
        return ret.shrink(half, half).resize(-1, -1);
    }

    protected boolean isFillVisible(IFigure figure) {
        return this.getFillColor() != null;
    }

    protected boolean isLineVisible(IFigure figure) {
        return this.getLineColor() != null;
    }
}

