/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IFileEntryFilter;
import org.xmind.core.IRevisionManager;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.RevisionRepository;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.RevisionManagerImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionRepositoryImpl
extends RevisionRepository {
    private static final Pattern REVISIONS_RESOURCE_DIR = Pattern.compile("Revisions/([^/]+)/");
    private WorkbookImpl ownedWorkbook;
    private Map<String, RevisionManagerImpl> managers = new HashMap<String, RevisionManagerImpl>();

    public RevisionRepositoryImpl(WorkbookImpl ownedWorkbook) {
        this.ownedWorkbook = ownedWorkbook;
    }

    @Override
    public IRevisionManager getRevisionManager(String resourceId, String contentType) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id is null");
        }
        return this.doGetRevisionManager(resourceId, contentType, true);
    }

    @Override
    public IRevisionManager getRegisteredRevisionManager(String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id is null");
        }
        return this.doGetRevisionManager(resourceId, null, false);
    }

    private RevisionManagerImpl doGetRevisionManager(String resourceId, String contentType, boolean createIfNotFound) {
        RevisionManagerImpl manager = this.managers.get(resourceId);
        if (manager == null && (manager = this.loadRevisionManager(resourceId, contentType, createIfNotFound)) != null) {
            manager.addNotify(this.ownedWorkbook);
            this.managers.put(resourceId, manager);
        }
        return manager;
    }

    private RevisionManagerImpl loadRevisionManager(String resourceId, String contentType, boolean createIfNotFound) {
        RevisionManagerImpl manager;
        String dirPath = "Revisions/" + resourceId + "/";
        String metaPath = String.valueOf(dirPath) + "revisions.xml";
        ManifestImpl manifest = this.ownedWorkbook.getManifest();
        IFileEntry metaEntry = manifest.getFileEntry(metaPath);
        if (metaEntry != null && (manager = this.loadRevisionManager(resourceId, metaEntry, dirPath)) != null) {
            return manager;
        }
        if (!createIfNotFound) {
            return null;
        }
        Document doc = DOMUtils.createDocument();
        Element ele = DOMUtils.createElement(doc, "xmap-revisions");
        ele.setAttribute("resource-id", resourceId);
        ele.setAttribute("media-type", contentType);
        ele.setAttribute("next-rev-num", "1");
        manifest.createFileEntry(metaPath);
        return new RevisionManagerImpl(doc, this.ownedWorkbook, dirPath);
    }

    private RevisionManagerImpl loadRevisionManager(String resourceId, IFileEntry metaEntry, String path) {
        InputStream stream;
        try {
            stream = metaEntry.openInputStream();
        }
        catch (IOException e) {
            Core.getLogger().log(e, "Failed to load document at " + metaEntry.getPath());
            return null;
        }
        if (stream == null) {
            return null;
        }
        try {
            Document doc = DOMUtils.loadDocument(stream);
            return new RevisionManagerImpl(doc, this.ownedWorkbook, path);
        }
        catch (Throwable e) {
            Core.getLogger().log(e, "Failed to load document at " + metaEntry.getPath());
            return null;
        }
    }

    @Override
    public void setRevisionManager(String resourceId, IRevisionManager manager) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id is null");
        }
        if (manager != null && !(manager instanceof RevisionManagerImpl)) {
            throw new IllegalArgumentException("Invalid type of revision manager");
        }
        if (manager != null && manager.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException("Revision manager owned by another workbook");
        }
        RevisionManagerImpl newManager = (RevisionManagerImpl)manager;
        RevisionManagerImpl oldManager = this.doGetRevisionManager(resourceId, null, false);
        if (oldManager == newManager) {
            return;
        }
        if (oldManager != null) {
            oldManager.removeNotify(this.ownedWorkbook);
            this.managers.remove(oldManager);
        }
        if (newManager != null) {
            this.managers.put(resourceId, newManager);
            newManager.addNotify(this.ownedWorkbook);
        }
    }

    @Override
    public Set<String> getRegisteredResourceIds() {
        HashSet<String> resourceIds = new HashSet<String>();
        Iterator<IFileEntry> entryIter = this.ownedWorkbook.getManifest().iterFileEntries(new IFileEntryFilter(){

            public boolean select(String path, String mediaType, boolean isDirectory) {
                return REVISIONS_RESOURCE_DIR.matcher(path).matches();
            }
        });
        while (entryIter.hasNext()) {
            IFileEntry entry = entryIter.next();
            String path = entry.getPath();
            Matcher m = REVISIONS_RESOURCE_DIR.matcher(path);
            if (!m.matches()) continue;
            String resourceId = m.group(1);
            resourceIds.add(resourceId);
        }
        return resourceIds;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return false;
    }
}

