/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.merging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.ICloneData;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.ILabeled;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.AddRelationshipCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.commands.ModifyLabelCommand;
import org.xmind.ui.commands.ModifyNotesCommand;
import org.xmind.ui.commands.ModifyStyleCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.commands.ModifyTopicStructureCommand;
import org.xmind.ui.internal.mindmap.merging.MergeMessages;
import org.xmind.ui.mindmap.IMindMap;

public class MergeCommandBuilder
extends CommandBuilder {
    private static final int MARKER_NOT_FOUND = 0;
    private static final int MARKER_CONFLICT = 1;
    private static final int MARKER_FOUND = 2;
    private static final String LINE_DELIMITER = System.getProperty("line.separator");
    private IMindMap sourceMap;
    private IMindMap targetMap;
    private PrintStream ps;
    private Map<String, String> idMap = new HashMap<String, String>();
    private ICloneData cloneData;

    public MergeCommandBuilder(ICommandStack commandStack, IMindMap sourceMap, IMindMap targetMap) {
        super(commandStack);
        this.sourceMap = sourceMap;
        this.targetMap = targetMap;
    }

    public IMindMap getSourceMap() {
        return this.sourceMap;
    }

    public IMindMap getTargetMap() {
        return this.targetMap;
    }

    protected ISheet getSourceSheet() {
        return this.sourceMap.getSheet();
    }

    protected ISheet getTargetSheet() {
        return this.targetMap.getSheet();
    }

    protected IWorkbook getSourceWorkbook() {
        return this.getSourceSheet().getOwnedWorkbook();
    }

    protected IWorkbook getTargetWorkbook() {
        return this.getTargetSheet().getOwnedWorkbook();
    }

    protected IStyleSheet getSourceStyleSheet() {
        return this.getSourceWorkbook().getStyleSheet();
    }

    protected IStyleSheet getTargetStyleSheet() {
        return this.getTargetWorkbook().getStyleSheet();
    }

    public void setLogHandle(PrintStream ps) {
        this.ps = ps;
    }

    protected void log(String line, Object ... args) {
        if (this.ps != null) {
            this.ps.println("    - " + NLS.bind((String)line, (Object[])args));
        }
    }

    private void add(Command command) {
        super.add(command, false);
    }

    public void start() {
        super.start();
        if (this.ps != null) {
            this.ps.println(NLS.bind((String)MergeMessages.MergeMapCommand_Start, (Object)this.getCurrentTime()));
        }
        ITopic sourceCentral = this.sourceMap.getCentralTopic();
        ITopic targetCentral = this.targetMap.getCentralTopic();
        this.idMap.put(sourceCentral.getId(), targetCentral.getId());
        if (!MergeCommandBuilder.topicEquals(sourceCentral, targetCentral)) {
            String newTitle = NLS.bind((String)MergeMessages.MergeMapCommand_MergedCentralTopicPattern, (Object)targetCentral.getTitleText(), (Object)sourceCentral.getTitleText());
            this.add((Command)new ModifyTitleTextCommand((ITitled)targetCentral, newTitle));
            this.log(MergeMessages.MergeMapCommand_CentralTopicMergedMsg, new Object[0]);
        }
        this.cloneData = this.getTargetWorkbook().clone(Arrays.asList(sourceCentral));
        ITopic clonedCentral = (ITopic)this.cloneData.get((Object)sourceCentral);
        this.mergeTopicAttributes(sourceCentral, targetCentral, clonedCentral);
        this.mergeSubTopics(sourceCentral, targetCentral, clonedCentral);
        this.mergeRelationships();
    }

    public void end() {
        super.end();
        if (this.ps != null) {
            this.ps.println();
        }
    }

    private String getCurrentTime() {
        return String.format("%1$tH:%1$tM, %1$tb %1$td", Calendar.getInstance());
    }

    private void mergeTopicAttributes(ITopic sourceTopic, ITopic targetTopic, ITopic clonedTopic) {
        if (!MergeCommandBuilder.equals(clonedTopic.getStyleId(), targetTopic.getStyleId())) {
            this.add((Command)new ModifyStyleCommand((IStyled)targetTopic, clonedTopic.getStyleId()));
            this.log(MergeMessages.MergeMapCommand_StyleChanged, targetTopic.getTitleText());
        }
        if (!MergeCommandBuilder.equals(clonedTopic.getStructureClass(), targetTopic.getStructureClass())) {
            this.add((Command)new ModifyTopicStructureCommand(targetTopic, clonedTopic.getStructureClass()));
            this.log(MergeMessages.MergeMapCommand_StructureChanged, targetTopic.getTitleText());
        }
        this.mergeMarkers(sourceTopic, targetTopic, clonedTopic);
        this.mergeLabels(sourceTopic, targetTopic, clonedTopic);
        this.mergeNotes(sourceTopic, targetTopic, clonedTopic);
        this.mergeHyperlink(sourceTopic, targetTopic, clonedTopic);
        this.mergeImage(sourceTopic, targetTopic, clonedTopic);
    }

    private void mergeMarkers(ITopic sourceTopic, ITopic targetTopic, ITopic clonedTopic) {
        for (IMarkerRef clonedMarkerRef : clonedTopic.getMarkerRefs()) {
            String clonedMarkerId = clonedMarkerRef.getMarkerId();
            int hint = this.findMarker(clonedMarkerId, targetTopic);
            if (hint == 2) continue;
            if (hint == 1) {
                this.removeConflictedMarkers(clonedMarkerRef, targetTopic);
            }
            this.add((Command)new AddMarkerCommand(targetTopic, clonedMarkerId));
            if (hint != 1) continue;
            this.log(MergeMessages.MergeMapCommand_MarkerAddedTo, this.getMarkerDesc(clonedMarkerId, this.getSourceSheet()), targetTopic.getTitleText());
        }
    }

    private void removeConflictedMarkers(IMarkerRef clonedMarkerRef, ITopic targetTopic) {
        IMarker clonedMarker = clonedMarkerRef.getMarker();
        if (clonedMarker == null) {
            return;
        }
        IMarkerGroup clonedMarkerGroup = clonedMarker.getParent();
        if (clonedMarkerGroup == null) {
            return;
        }
        for (IMarkerRef targetMarkerRef : targetTopic.getMarkerRefs()) {
            IMarkerGroup targetMarkerGroup;
            IMarker targetMarker = targetMarkerRef.getMarker();
            if (targetMarker == null || !MergeCommandBuilder.equals(clonedMarkerGroup, targetMarkerGroup = targetMarker.getParent())) continue;
            this.add((Command)new DeleteMarkerCommand(targetMarkerRef));
        }
    }

    private String getMarkerDesc(String markerId, ISheet sheet) {
        return sheet.getLegend().getMarkerDescription(markerId);
    }

    private int findMarker(String clonedMarkerId, ITopic targetTopic) {
        for (IMarkerRef targetMarkerRef : targetTopic.getMarkerRefs()) {
            String targetMarkerId = targetMarkerRef.getMarkerId();
            if (MergeCommandBuilder.equals(clonedMarkerId, targetMarkerId)) {
                return 2;
            }
            if (!this.markerConflicts(clonedMarkerId, targetMarkerId)) continue;
            this.log(MergeMessages.MergeMapCommand_MarkerReplacedBy, this.getMarkerDesc(targetMarkerId, this.getTargetSheet()), targetTopic.getTitleText(), this.getMarkerDesc(clonedMarkerId, this.getSourceSheet()));
            return 1;
        }
        return 0;
    }

    private boolean markerConflicts(String clonedMarkerId, String targetMarkerId) {
        IMarker targetMarker;
        if (MergeCommandBuilder.equals(clonedMarkerId, targetMarkerId) || clonedMarkerId == null || targetMarkerId == null) {
            return false;
        }
        IMarkerSheet targetMarkerSheet = this.getTargetWorkbook().getMarkerSheet();
        IMarker sourceMarker = targetMarkerSheet.findMarker(clonedMarkerId);
        if (sourceMarker == (targetMarker = targetMarkerSheet.findMarker(targetMarkerId)) || sourceMarker == null || targetMarker == null) {
            return false;
        }
        IMarkerGroup sourceGroup = sourceMarker.getParent();
        IMarkerGroup targetGroup = targetMarker.getParent();
        return sourceGroup != null && targetGroup != null && MergeCommandBuilder.equals(sourceGroup, targetGroup) && sourceGroup.isSingleton() && targetGroup.isSingleton();
    }

    private void mergeLabels(ITopic sourceTopic, ITopic targetTopic, ITopic clonedTopic) {
        HashSet clonedLabels = clonedTopic.getLabels();
        if (clonedLabels.isEmpty()) {
            return;
        }
        HashSet targetLabels = new HashSet(targetTopic.getLabels());
        if (!(clonedLabels = new HashSet(clonedLabels)).equals(targetLabels)) {
            targetLabels.addAll(clonedLabels);
            this.add((Command)new ModifyLabelCommand((ILabeled)targetTopic, targetLabels));
            this.log(MergeMessages.MergeMapCommand_LabelMerged, targetTopic.getTitleText());
        }
    }

    private void mergeNotes(ITopic sourceTopic, ITopic targetTopic, ITopic clonedTopic) {
        IPlainNotesContent clonedPlain;
        if (clonedTopic.getNotes().isEmpty()) {
            return;
        }
        IHtmlNotesContent clonedHtml = (IHtmlNotesContent)clonedTopic.getNotes().getContent("html");
        if (clonedHtml == null) {
            clonedHtml = (IHtmlNotesContent)this.getTargetWorkbook().createNotesContent("html");
        }
        if ((clonedPlain = (IPlainNotesContent)clonedTopic.getNotes().getContent("plain")) == null) {
            clonedPlain = (IPlainNotesContent)this.getTargetWorkbook().createNotesContent("plain");
        }
        if (!targetTopic.getNotes().isEmpty()) {
            INotesContent oldContent = targetTopic.getNotes().getContent("html");
            if (oldContent == null) {
                oldContent = targetTopic.getNotes().getContent("html");
            }
            String clonedTextContent = clonedPlain.getTextContent();
            String oldTextContent = null;
            if (oldContent instanceof IPlainNotesContent) {
                oldTextContent = ((IPlainNotesContent)oldContent).getTextContent();
                if (!"".equals(oldTextContent)) {
                    if (!clonedHtml.getParagraphs().isEmpty()) {
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                        MergeCommandBuilder.addParagraph(clonedHtml, MergeMessages.MergeMapCommand_OriginalNotes);
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                    }
                    String[] stringArray = oldTextContent.split("\\r\\n|\\r|\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        MergeCommandBuilder.addParagraph(clonedHtml, line);
                        ++n2;
                    }
                }
            } else if (oldContent instanceof IHtmlNotesContent) {
                IHtmlNotesContent oldHtml = (IHtmlNotesContent)oldContent;
                StringBuilder sb = new StringBuilder();
                if (!oldHtml.getParagraphs().isEmpty()) {
                    if (!clonedHtml.getParagraphs().isEmpty()) {
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                        MergeCommandBuilder.addParagraph(clonedHtml, MergeMessages.MergeMapCommand_OriginalNotes);
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                        MergeCommandBuilder.addParagraph(clonedHtml, "");
                    }
                    for (IParagraph p : oldHtml.getParagraphs()) {
                        IParagraph p2 = clonedHtml.createParagraph();
                        p2.setStyleId(p.getStyleId());
                        for (ISpan span : p.getSpans()) {
                            if (span instanceof ITextSpan) {
                                ITextSpan t = (ITextSpan)span;
                                String text = t.getTextContent();
                                sb.append(text);
                                ITextSpan t2 = clonedHtml.createTextSpan(text);
                                t2.setStyleId(t.getStyleId());
                                p2.addSpan((ISpan)t2);
                                continue;
                            }
                            if (!(span instanceof IImageSpan)) continue;
                            IImageSpan s = (IImageSpan)span;
                            String source = s.getSource();
                            IImageSpan s2 = clonedHtml.createImageSpan(source);
                            s2.setStyleId(s.getStyleId());
                            p2.addSpan((ISpan)s2);
                        }
                        clonedHtml.addParagraph(p2);
                        sb.append(LINE_DELIMITER);
                    }
                }
                oldTextContent = sb.toString();
            }
            if (oldTextContent != null && !"".equals(oldTextContent)) {
                clonedTextContent = clonedTextContent == null || "".equals(clonedTextContent) ? oldTextContent : String.valueOf(clonedTextContent) + LINE_DELIMITER + LINE_DELIMITER + MergeMessages.MergeMapCommand_OriginalNotes + LINE_DELIMITER + LINE_DELIMITER + LINE_DELIMITER + oldTextContent;
                clonedPlain.setTextContent(clonedTextContent);
            }
        }
        this.add((Command)new ModifyNotesCommand(targetTopic, (INotesContent)clonedPlain, "plain"));
        this.add((Command)new ModifyNotesCommand(targetTopic, (INotesContent)clonedHtml, "html"));
        this.log(MergeMessages.MergeMapCommand_NotesMerged, targetTopic.getTitleText());
    }

    private static void addParagraph(IHtmlNotesContent content, String text) {
        IParagraph p = content.createParagraph();
        p.addSpan((ISpan)content.createTextSpan(text));
        content.addParagraph(p);
    }

    private void mergeHyperlink(ITopic sourceTopic, ITopic targetTopic, ITopic clonedTopic) {
        String url = clonedTopic.getHyperlink();
        if (url == null) {
            return;
        }
        if (MergeCommandBuilder.equals(url, targetTopic.getHyperlink())) {
            return;
        }
        this.add((Command)new ModifyTopicHyperlinkCommand(targetTopic, url));
        this.log(MergeMessages.MergeMapCommand_HyperlinkChanged, targetTopic.getTitleText());
    }

    private void mergeImage(ITopic sourceTopic, ITopic targetTopic, ITopic clonedTopic) {
        String source = clonedTopic.getImage().getSource();
        if (source == null) {
            return;
        }
        if (MergeCommandBuilder.equals(source, targetTopic.getImage().getSource())) {
            return;
        }
        ModifyImageSourceCommand imageCommand = new ModifyImageSourceCommand(targetTopic, source);
        this.add((Command)imageCommand);
        this.log(MergeMessages.MergeMapCommand_ImageChanged, targetTopic);
        Dimension size = this.getImageSize(sourceTopic);
        if (size != null) {
            ModifyImageSizeCommand modifyImageSizeCommand = new ModifyImageSizeCommand(targetTopic, size.width, size.height);
            this.add((Command)modifyImageSizeCommand);
            this.log(MergeMessages.MergeMapCommand_ImageSizeChanged, targetTopic);
        }
    }

    private Dimension getImageSize(ITopic topic) {
        IImage image = topic.getImage();
        if (image != null) {
            int width = image.getWidth();
            int height = image.getHeight();
            return new Dimension(width, height);
        }
        return null;
    }

    private void mergeSubTopics(ITopic sourceTopic, ITopic targetTopic, ITopic clonedParent) {
        clonedParent.getAllChildren();
        for (ITopic sourceSub : sourceTopic.getAllChildren()) {
            ITopic clonedSub = (ITopic)this.cloneData.get((Object)sourceSub);
            this.mergeTopic(sourceSub, targetTopic, clonedSub);
        }
    }

    private void mergeTopic(ITopic sourceTopic, ITopic targetParent, ITopic clonedTopic) {
        ITopic targetTopic = this.findTargetSubtopic(targetParent, sourceTopic);
        if (targetTopic == null) {
            this.add((Command)new AddTopicCommand(clonedTopic, targetParent));
            this.log(MergeMessages.MergeMapCommand_TopicAddedTo, clonedTopic.getTitleText(), targetParent.getTitleText());
        } else {
            this.idMap.put(sourceTopic.getId(), targetTopic.getId());
            this.mergeTopicAttributes(sourceTopic, targetTopic, clonedTopic);
            this.mergeSubTopics(sourceTopic, targetTopic, clonedTopic);
        }
    }

    private ITopic findTargetSubtopic(ITopic targetParent, ITopic sourceTopic) {
        for (ITopic targetTopic : targetParent.getChildren(sourceTopic.getType())) {
            if (!MergeCommandBuilder.topicEquals(targetTopic, sourceTopic)) continue;
            return targetTopic;
        }
        return null;
    }

    private void mergeRelationships() {
        ArrayList<IRelationship> toAdd = new ArrayList<IRelationship>();
        HashMap<IRelationship, IRelationship> toReplace = new HashMap<IRelationship, IRelationship>();
        ArrayList sourceRels = new ArrayList(this.getSourceSheet().getRelationships());
        if (!sourceRels.isEmpty()) {
            ArrayList targetRels = new ArrayList(this.getTargetSheet().getRelationships());
            for (IRelationship sourceRel : sourceRels) {
                IRelationship targetRel = null;
                for (IRelationship rel : targetRels) {
                    if (!this.relationshipEquals(sourceRel, rel)) continue;
                    if (sourceRel.getStyleId() != null) {
                        toReplace.put(sourceRel, rel);
                    }
                    targetRel = rel;
                    targetRels.remove(rel);
                    break;
                }
                if (targetRel != null) continue;
                String targetBeginId = this.cloneData.getString("workbookComponents", sourceRel.getEnd1Id());
                String targetEndId = this.cloneData.getString("workbookComponents", sourceRel.getEnd2Id());
                if (targetBeginId == null || targetEndId == null) continue;
                IRelationship clonedRel = (IRelationship)this.getTargetWorkbook().clone(Arrays.asList(sourceRel)).get((Object)sourceRel);
                clonedRel.setEnd1Id(targetBeginId);
                clonedRel.setEnd2Id(targetEndId);
                toAdd.add(clonedRel);
                toReplace.put(sourceRel, clonedRel);
            }
        }
        for (IRelationship r : toAdd) {
            this.add((Command)new AddRelationshipCommand(r, this.getTargetSheet()));
        }
    }

    private boolean relationshipEquals(IRelationship r1, IRelationship r2) {
        return r1.equals(r2) || MergeCommandBuilder.equals(r1.getTitleText(), r2.getTitleText()) && MergeCommandBuilder.equals(r1.getEnd1Id(), this.cloneData.getString("workbookComponents", r1.getEnd1Id())) && MergeCommandBuilder.equals(r1.getEnd2Id(), this.cloneData.getString("workbookComponents", r2.getEnd2Id()));
    }

    private static boolean topicEquals(ITopic t1, ITopic t2) {
        return MergeCommandBuilder.equals(t1.getTitleText(), t2.getTitleText()) && MergeCommandBuilder.equals(t1.getType(), t2.getType());
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

