/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.HashMap;
import java.util.Map;

public final class ModelCacheManager {
    public static final String MODEL_CACHE_DELAYLAYOUT = "org.xmind.ui.delayLayout";
    private static ModelCacheManager INSTANCE;
    private Map<ModelKeyWrapper, Object> caches = null;

    public void flush(Object model, String key) {
        if (this.caches == null || model == null || key == null) {
            return;
        }
        this.caches.remove(new ModelKeyWrapper(model, key));
    }

    public Object getCache(Object model, String key) {
        if (this.caches == null || model == null || key == null) {
            return null;
        }
        return this.caches.get(new ModelKeyWrapper(model, key));
    }

    public void setCache(Object model, String key, Object cache) {
        if (model == null || key == null) {
            return;
        }
        if (this.caches == null) {
            this.caches = new HashMap<ModelKeyWrapper, Object>();
        }
        if (cache == null) {
            this.caches.remove(new ModelKeyWrapper(model, key));
        } else {
            this.caches.put(new ModelKeyWrapper(model, key), cache);
        }
    }

    public static ModelCacheManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModelCacheManager();
        }
        return INSTANCE;
    }

    private static class ModelKeyWrapper {
        private Object model;
        private String key;

        public ModelKeyWrapper(Object model, String key) {
            this.model = model;
            this.key = key;
        }

        public int hashCode() {
            return this.model.hashCode() ^ this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ModelKeyWrapper)) {
                return false;
            }
            ModelKeyWrapper that = (ModelKeyWrapper)obj;
            return this.model.equals(that.model) && this.key.equals(that.key);
        }
    }
}

