/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.util.Logger;

public class BackgroundSaveWorkbook {
    private static final BackgroundSaveWorkbook INSTANCE = new BackgroundSaveWorkbook();
    private static boolean DEBUGGING = MindMapUIPlugin.isDebugging("/debug/autosave");
    private DaemonJob daemon = null;

    public synchronized void reset(int intervals, boolean enabled) {
        this.stopAll();
        if (enabled) {
            this.daemon = new DaemonJob(intervals);
            this.daemon.schedule();
        }
    }

    public synchronized boolean isRunning() {
        return this.daemon != null;
    }

    public synchronized void stopAll() {
        if (this.daemon != null) {
            Thread thread = this.daemon.getThread();
            this.daemon.cancel();
            if (thread != null) {
                thread.interrupt();
            }
            this.daemon = null;
        }
    }

    public static BackgroundSaveWorkbook getInstance() {
        return INSTANCE;
    }

    private static class DaemonJob
    extends Job {
        private int intervals;

        public DaemonJob(int intervals) {
            super("Background Save Workbooks Daemon");
            this.setSystem(true);
            this.setPriority(30);
            this.intervals = intervals;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(null, 1);
            try {
                do {
                    IWorkbenchWindow[] windows;
                    IStatus slept;
                    if ((slept = this.sleep(monitor)) != null && !slept.isOK()) {
                        return slept;
                    }
                    if (DEBUGGING) {
                        System.out.println("AutoSave starts now...");
                    }
                    IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage[] pages;
                        IWorkbenchWindow ww = iWorkbenchWindowArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = pages = ww.getPages();
                        int n3 = pages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IEditorReference[] ers;
                            IWorkbenchPage wp = iWorkbenchPageArray[n4];
                            IEditorReference[] iEditorReferenceArray = ers = wp.getEditorReferences();
                            int n5 = ers.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IEditorReference er = iEditorReferenceArray[n6];
                                IEditorInput editorInput = er.getEditorInput();
                                if (editorInput != null) {
                                    IWorkbookRef workbookRef = (IWorkbookRef)editorInput.getAdapter(IWorkbookRef.class);
                                    this.save(monitor, workbookRef);
                                    if (monitor.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    if (!DEBUGGING) continue;
                    System.out.println("AutoSave finishes.");
                } while (!monitor.isCanceled());
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    return Status.CANCEL_STATUS;
                }
                if (DEBUGGING) {
                    System.err.println("AutoSave error:");
                    e.printStackTrace();
                }
                String msg = "Background workbook saver daemon ended with unknown error";
                Logger.log(e, msg);
                return new Status(2, "org.xmind.ui", 4, msg, e);
            }
        }

        private IStatus sleep(IProgressMonitor monitor) {
            int total = this.intervals;
            try {
                if (DEBUGGING && total > 5000) {
                    Thread.sleep(total - 5000);
                    System.out.println("AutoSave will start in 5 seconds...");
                    Thread.sleep(3000L);
                    System.out.println("AutoSave will start in 2 seconds...");
                    Thread.sleep(2000L);
                } else {
                    if (DEBUGGING) {
                        System.out.println("AutoSave will start in " + total / 1000 + " seconds...");
                    }
                    Thread.sleep(total);
                }
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        private void save(IProgressMonitor monitor, IWorkbookRef workbookRef) throws InterruptedException, InvocationTargetException {
            if (workbookRef.canSave() && workbookRef.isDirty()) {
                workbookRef.save(monitor);
            }
        }

        protected void canceling() {
            super.canceling();
            Thread t = this.getThread();
            if (t != null) {
                t.interrupt();
            }
        }
    }
}

