/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.core.IRelationship;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicComponent;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyRightNumberOfUnbalancedStructureCommand;
import org.xmind.ui.internal.editpolicies.DeleteCommandBuilder;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class DeletablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "delete".equals(requestType);
    }

    public void handle(Request request) {
        String reqType = request.getType();
        if ("delete".equals(reqType)) {
            this.delete(request);
        }
    }

    protected void delete(Request request) {
        boolean isUnthrowedSideStructure;
        IViewer viewer = request.getTargetViewer();
        List targets = request.getTargets();
        List<Object> elements = this.getElementsToDelete(targets, viewer);
        if (elements == null || elements.isEmpty()) {
            return;
        }
        IPart toFocus = MindMapUtils.findToFocus(targets, viewer);
        String label = this.getDeleteLabel(MindMapUI.getCategoryManager().analyze(elements.toArray()).getMainCategory());
        DeleteCommandBuilder builder = new DeleteCommandBuilder(viewer, request.getTargetCommandStack());
        if (!builder.canStart()) {
            return;
        }
        ITopic centralTopic = (ITopic)viewer.getAdapter(ITopic.class);
        if (centralTopic == null) {
            return;
        }
        String centralTopicStricture = centralTopic.getStructureClass();
        boolean bl = isUnthrowedSideStructure = centralTopicStricture == null || "org.xmind.ui.map.unbalanced".equalsIgnoreCase(centralTopicStricture);
        if (isUnthrowedSideStructure) {
            ITopicExtension extension = centralTopic.createExtension("org.xmind.ui.map.unbalanced");
            ITopicExtensionElement ee = (ITopicExtensionElement)extension.getContent().getCreatedChild("right-number");
            String preDeleteRightNum = ee.getTextContent();
            if (preDeleteRightNum == null) {
                preDeleteRightNum = String.valueOf(0);
            }
            int postDeleteRightNum = Integer.valueOf(preDeleteRightNum);
            for (IPart topicPart : targets) {
                IStructure structure;
                IBranchPart centralBranch;
                IBranchPart mainBranch;
                if (!(topicPart instanceof ITopicPart) || "summary".equals(((ITopicPart)topicPart).getTopic().getType()) || (mainBranch = MindMapUtils.findBranch(topicPart)).isCentral() || (centralBranch = mainBranch.getParentBranch()) == null || !centralBranch.isCentral() || ((IBranchStructureExtension)(structure = centralBranch.getBranchPolicy().getStructure(centralBranch))).getChildTargetOrientation(centralBranch, mainBranch) != 8) continue;
                --postDeleteRightNum;
            }
            if (!preDeleteRightNum.equals(postDeleteRightNum)) {
                builder.addPendingCommand((Command)new ModifyRightNumberOfUnbalancedStructureCommand(centralTopic, preDeleteRightNum, postDeleteRightNum), true);
            }
        }
        builder.start();
        builder.setLabel(label);
        for (Object element : elements) {
            builder.delete(element);
        }
        builder.end();
        if (toFocus != null) {
            this.select(toFocus, viewer);
        } else {
            ITopic topic = (ITopic)viewer.getAdapter(ITopic.class);
            if (topic != null) {
                this.select(topic, viewer);
            } else {
                viewer.setSelection((ISelection)StructuredSelection.EMPTY, true);
            }
        }
    }

    protected List<Object> getElementsToDelete(List<IPart> targets, IViewer viewer) {
        ITopic rootTopic = (ITopic)viewer.getAdapter(ITopic.class);
        List<ITopic> topics = MindMapUtils.getTopics(targets);
        topics.remove(rootTopic);
        topics = MindMapUtils.filterOutDescendents(topics, rootTopic);
        ArrayList<Object> others = new ArrayList<Object>(targets.size() - topics.size());
        for (IPart p : targets) {
            ITopic parent;
            Object m = MindMapUtils.getRealModel(p);
            if (m instanceof IRelationship) {
                IRelationship r = (IRelationship)m;
                if (others.contains(r)) continue;
                others.add(r);
                continue;
            }
            if (!(m instanceof ITopicComponent) || m instanceof ITopic || (parent = ((ITopicComponent)m).getParent()) == null || topics.contains(parent) || MindMapUtils.isAncestorInList(parent, topics)) continue;
            others.add(m);
        }
        if (topics.isEmpty() && others.isEmpty()) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(topics.size() + others.size());
        list.addAll(topics);
        list.addAll(others);
        return list;
    }

    protected String getDeleteLabel(String type) {
        if ("org.xmind.ui.topic".equals(type)) {
            return CommandMessages.Command_DeleteTopic;
        }
        if ("org.xmind.ui.relationship".equals(type)) {
            return CommandMessages.Command_DeleteRelationship;
        }
        if ("org.xmind.ui.marker".equals(type)) {
            return CommandMessages.Command_DeleteMarker;
        }
        if ("org.xmind.ui.sheet".equals(type)) {
            return CommandMessages.Command_DeleteSheet;
        }
        if ("org.xmind.ui.boundary".equals(type)) {
            return CommandMessages.Command_DeleteBoundary;
        }
        return CommandMessages.Command_Delete;
    }
}

