/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.xmind.gef.draw2d.DecoratedShapeFigure;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.draw2d.IShadowedFigure;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.ui.decorations.IBoundaryDecoration;

public class BoundaryFigure
extends DecoratedShapeFigure
implements ITitledFigure,
IMinimizable,
IShadowedFigure {
    protected static final int FLAG_MINIMIZED;
    private ITextFigure title = null;
    private boolean isTitleVisible = false;

    static {
        MAX_FLAG = FLAG_MINIMIZED = MAX_FLAG << 1;
    }

    public ITextFigure getTitle() {
        return this.title;
    }

    public boolean isShadowShowing() {
        return this.isShowing();
    }

    public void setTitle(ITextFigure title) {
        if (title == this.title) {
            return;
        }
        this.title = title;
        this.revalidate();
        this.repaint();
    }

    public boolean isTitleVisible() {
        return this.isTitleVisible;
    }

    public void setTitleVisible(boolean isTitleVisible) {
        if (isTitleVisible == this.isTitleVisible) {
            return;
        }
        this.isTitleVisible = isTitleVisible;
        this.revalidate();
        this.repaint();
    }

    public IBoundaryDecoration getDecoration() {
        return (IBoundaryDecoration)super.getDecoration();
    }

    protected Insets calculatePreferredInsets() {
        if (this.isMinimized()) {
            return NO_INSETS;
        }
        Insets ins = super.calculatePreferredInsets();
        return ins;
    }

    protected void layout() {
        super.layout();
        if (this.title != null && this.title.getParent() == this) {
            Dimension size = this.title.getPreferredSize(this.getBounds().width, -1);
            if (size.width > this.getBounds().width) {
                size = new Dimension(this.getBounds().width, size.height);
            }
            this.title.setSize(size);
            this.title.setLocation(this.getBounds().getLocation());
        }
    }

    public boolean isMinimized() {
        return this.getFlag(FLAG_MINIMIZED);
    }

    public void setMinimized(boolean minimized) {
        if (minimized == this.isMinimized()) {
            return;
        }
        this.setFlag(FLAG_MINIMIZED, minimized);
        this.revalidate();
        this.repaint();
    }

    public void paintShadow(Graphics graphics) {
        if (this.getDecoration() != null && this.getDecoration() instanceof IShadowedDecoration) {
            ((IShadowedDecoration)this.getDecoration()).paintShadow((IFigure)this, graphics);
        }
    }

    public String toString() {
        if (this.title != null) {
            return "BoundaryFigure(" + this.title.getText() + ")";
        }
        return super.toString();
    }
}

