/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.GEF;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.internal.mindmap.LegendPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.tools.DummyCreateTool;
import org.xmind.ui.viewers.SWTUtils;

public class LegendCreateTool
extends DummyCreateTool {
    private ISheetPart sheet = null;
    private ILegendPart dummyLegend = null;

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        if (this.getTargetViewer() instanceof IMindMapViewer) {
            this.sheet = ((IMindMapViewer)this.getTargetViewer()).getSheetPart();
            if (this.sheet != null) {
                this.createDummy();
            }
        }
    }

    protected void onDeactivated(ITool nextTool) {
        this.sheet = null;
        super.onDeactivated(nextTool);
    }

    @Override
    protected IFigure doCreateDummy() {
        if (this.sheet != null) {
            this.dummyLegend = new LegendPart();
            this.dummyLegend.setModel(this.sheet.getSheet().getLegend());
            this.dummyLegend.setParent((IPart)this.getTargetViewer().getRootPart());
            this.addDummyLegendView();
            this.dummyLegend.addNotify();
            this.dummyLegend.getStatus().activate();
            this.dummyLegend.refresh();
            IFigure figure = this.dummyLegend.getFigure();
            figure.setEnabled(false);
            figure.setSize(figure.getPreferredSize());
            ((IReferencedFigure)figure).setReference(this.getCursorPosition());
            return figure;
        }
        return null;
    }

    private void addDummyLegendView() {
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            layer.add(this.dummyLegend.getFigure());
        }
    }

    @Override
    protected void destroyDummy(IFigure dummy) {
        if (this.dummyLegend != null) {
            this.dummyLegend.getStatus().deactivate();
            this.dummyLegend.removeNotify();
        }
        super.destroyDummy(dummy);
        if (this.dummyLegend != null) {
            this.dummyLegend.setParent(null);
            this.dummyLegend = null;
        }
    }

    @Override
    protected void updateDummyPosition(IFigure dummy, Point pos) {
        ((IReferencedFigure)dummy).setReference(pos);
    }

    protected boolean canCancelOnRightMouseDown(MouseEvent me) {
        return true;
    }

    protected boolean canFinishOnLeftMouseDown(MouseEvent me) {
        return true;
    }

    protected boolean canFinish(String requestType) {
        return false;
    }

    protected boolean shouldCancel(KeyEvent ke) {
        return SWTUtils.matchKey((int)ke.getState(), (int)ke.keyCode, (int)0, (int)27);
    }

    @Override
    protected Request createRequest() {
        if (this.sheet != null) {
            Point origin = ((IReferencedFigure)this.sheet.getFigure()).getOrigin();
            Point pos = this.getCursorPosition();
            Point newPosition = new Point(pos.x - origin.x, pos.y - origin.y);
            Request request = new Request("show_legend");
            request.setPrimaryTarget((IPart)this.sheet);
            request.setParameter("property.position", (Object)newPosition);
            return request;
        }
        return null;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        return Cursors.HAND;
    }
}

