/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.Core;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public abstract class MindMapImporter {
    private String sourcePath;
    private IWorkbook targetWorkbook;
    private List<ISheet> targetSheets;
    private final boolean newWorkbook;
    private IProgressMonitor monitor;
    private List<Map.Entry<Throwable, String>> errors = null;

    public MindMapImporter(String sourcePath) {
        this(sourcePath, null);
    }

    public MindMapImporter(String sourcePath, IWorkbook targetWorkbook) {
        this.sourcePath = sourcePath;
        this.targetSheets = new ArrayList<ISheet>();
        this.newWorkbook = targetWorkbook == null;
        this.targetWorkbook = targetWorkbook == null ? Core.getWorkbookBuilder().createWorkbook(MME.createTempStorage()) : targetWorkbook;
    }

    public boolean isNewWorkbook() {
        return this.newWorkbook;
    }

    public IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public IWorkbook getTargetWorkbook() {
        return this.targetWorkbook;
    }

    public abstract void build() throws InvocationTargetException, InterruptedException;

    protected void postBuilded() {
        this.initStyles();
    }

    private void initStyles() {
        for (ISheet sheet : this.getTargetWorkbook().getSheets()) {
            IStyle appliedTheme = this.createAppliedTheme(this.getTargetWorkbook(), MindMapUI.getResourceManager().getDefaultTheme());
            if (appliedTheme == null) continue;
            sheet.setThemeId(appliedTheme.getId());
            List<ITopic> topics = MindMapUtils.getAllTopics(sheet, true, true);
            for (ITopic topic : topics) {
                topic.setStyleId(null);
            }
        }
    }

    private IStyle createAppliedTheme(IWorkbook workbook, IStyle sourceTheme) {
        IStyleSheet ss = workbook.getStyleSheet();
        return ss.importStyle(sourceTheme);
    }

    public List<ISheet> getTargetSheets() {
        return this.targetSheets;
    }

    protected void addTargetSheet(ISheet sheet) {
        if (this.newWorkbook) {
            this.targetWorkbook.addSheet(sheet);
            if (this.targetSheets.isEmpty()) {
                this.targetWorkbook.removeSheet(this.targetWorkbook.getPrimarySheet());
            }
        }
        this.targetSheets.add(sheet);
    }

    protected String getSuggestedSheetTitle() {
        return NLS.bind((String)MindMapMessages.TitleText_Sheet, (Object)(this.newWorkbook ? 1 : this.getTargetWorkbook().getSheets().size() + 1));
    }

    public List<Map.Entry<Throwable, String>> getErrors() {
        return this.errors;
    }

    protected void log(final Throwable e, final String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Map.Entry<Throwable, String>>();
        }
        this.errors.add(new Map.Entry<Throwable, String>(){

            @Override
            public String setValue(String value) {
                return message;
            }

            @Override
            public String getValue() {
                return message;
            }

            @Override
            public Throwable getKey() {
                return e;
            }
        });
    }

    public void dispose() {
    }
}

