/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class DecoratedContainerLayout
extends AbstractHintLayout {
    private Map<IFigure, Object> constraints = new HashMap<IFigure, Object>();

    public void setConstraint(IFigure child, Object constraint) {
        this.constraints.put(child, constraint);
        super.setConstraint(child, constraint);
    }

    public Object getConstraint(IFigure child) {
        Object constraint = this.constraints.get(child);
        return constraint == null ? super.getConstraint(child) : constraint;
    }

    public void layout(IFigure container) {
        Rectangle area = container.getClientArea();
        for (Object child : container.getChildren()) {
            int childY;
            int childX;
            IFigure figure = (IFigure)child;
            Dimension childSize = figure.getPreferredSize(-1, -1);
            int childWidth = Math.min(area.width, childSize.width);
            int childHeight = Math.min(area.height, childSize.height);
            Object constraint = this.getConstraint(figure);
            if (constraint instanceof Integer) {
                int bit = (Integer)constraint;
                if ((bit & 1) != 0) {
                    childX = area.x;
                } else if ((bit & 4) != 0) {
                    childX = area.x + area.width - childWidth;
                } else if ((bit & 2) != 0) {
                    childX = area.x + (area.width - childWidth) / 2;
                } else {
                    childX = area.x;
                    childWidth = area.width;
                }
                if ((bit & 8) != 0) {
                    childY = area.y;
                } else if ((bit & 0x20) != 0) {
                    childY = area.y + area.height - childHeight;
                } else if ((bit & 0x10) != 0) {
                    childY = area.y + (area.height - childHeight) / 2;
                } else {
                    childY = area.y;
                    childHeight = area.height;
                }
            } else {
                childX = area.x;
                childY = area.y;
                childWidth = area.width;
                childHeight = area.height;
            }
            figure.setBounds(new Rectangle(childX, childY, childWidth, childHeight));
        }
    }

    protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (!this.isObservingVisibility() || child.isVisible()) {
                d.union(child.getPreferredSize(wHint, hHint));
            }
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }
}

