/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.builders;

import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.FixedResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThumbnailParameterBuilder {
    private static final int UNINITIALIZED = -1;
    private int width = -1;
    private int height = -1;
    private double widthScalingFactor = Double.NaN;
    private double heightScalingFactor = Double.NaN;
    private int imageType = 2;
    private boolean keepAspectRatio = true;
    private float thumbnailQuality = Float.NaN;
    private String thumbnailFormat = ThumbnailParameter.ORIGINAL_FORMAT;
    private String thumbnailFormatType = ThumbnailParameter.DEFAULT_FORMAT_TYPE;
    private List<ImageFilter> filters = Collections.emptyList();
    private ResizerFactory resizerFactory = DefaultResizerFactory.getInstance();
    private Region sourceRegion = null;
    private boolean fitWithinDimensions = true;
    private boolean useExifOrientation = true;

    public ThumbnailParameterBuilder imageType(int type) {
        this.imageType = type;
        return this;
    }

    public ThumbnailParameterBuilder size(Dimension size) {
        this.size(size.width, size.height);
        return this;
    }

    public ThumbnailParameterBuilder size(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("Width must be greater than 0.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height must be greater than 0.");
        }
        this.width = width;
        this.height = height;
        return this;
    }

    public ThumbnailParameterBuilder scale(double scalingFactor) {
        return this.scale(scalingFactor, scalingFactor);
    }

    public ThumbnailParameterBuilder scale(double widthScalingFactor, double heightScalingFactor) {
        if (widthScalingFactor <= 0.0 || heightScalingFactor <= 0.0) {
            throw new IllegalArgumentException("Scaling factor is less than or equal to 0.");
        }
        if (Double.isNaN(widthScalingFactor) || Double.isInfinite(widthScalingFactor)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
        if (Double.isNaN(heightScalingFactor) || Double.isInfinite(heightScalingFactor)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
        this.widthScalingFactor = widthScalingFactor;
        this.heightScalingFactor = heightScalingFactor;
        return this;
    }

    public ThumbnailParameterBuilder region(Region sourceRegion) {
        this.sourceRegion = sourceRegion;
        return this;
    }

    public ThumbnailParameterBuilder keepAspectRatio(boolean keep) {
        this.keepAspectRatio = keep;
        return this;
    }

    public ThumbnailParameterBuilder quality(float quality) {
        this.thumbnailQuality = quality;
        return this;
    }

    public ThumbnailParameterBuilder format(String format) {
        this.thumbnailFormat = format;
        return this;
    }

    public ThumbnailParameterBuilder formatType(String formatType) {
        this.thumbnailFormatType = formatType;
        return this;
    }

    public ThumbnailParameterBuilder filters(List<ImageFilter> filters) {
        if (filters == null) {
            throw new NullPointerException("Filters is null.");
        }
        this.filters = filters;
        return this;
    }

    public ThumbnailParameterBuilder resizer(Resizer resizer) {
        if (resizer == null) {
            throw new NullPointerException("Resizer is null.");
        }
        this.resizerFactory = new FixedResizerFactory(resizer);
        return this;
    }

    public ThumbnailParameterBuilder resizerFactory(ResizerFactory resizerFactory) {
        if (resizerFactory == null) {
            throw new NullPointerException("Resizer is null.");
        }
        this.resizerFactory = resizerFactory;
        return this;
    }

    public ThumbnailParameterBuilder fitWithinDimensions(boolean fit) {
        this.fitWithinDimensions = fit;
        return this;
    }

    public ThumbnailParameterBuilder useExifOrientation(boolean use) {
        this.useExifOrientation = use;
        return this;
    }

    public ThumbnailParameter build() {
        if (!Double.isNaN(this.widthScalingFactor)) {
            return new ThumbnailParameter(this.widthScalingFactor, this.heightScalingFactor, this.sourceRegion, this.keepAspectRatio, this.thumbnailFormat, this.thumbnailFormatType, this.thumbnailQuality, this.imageType, this.filters, this.resizerFactory, this.fitWithinDimensions, this.useExifOrientation);
        }
        if (this.width != -1 && this.height != -1) {
            return new ThumbnailParameter(new Dimension(this.width, this.height), this.sourceRegion, this.keepAspectRatio, this.thumbnailFormat, this.thumbnailFormatType, this.thumbnailQuality, this.imageType, this.filters, this.resizerFactory, this.fitWithinDimensions, this.useExifOrientation);
        }
        throw new IllegalStateException("The size nor the scaling factor has been set.");
    }
}

