/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.web;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.internal.signedcontent.Base64;
import org.eclipse.swt.graphics.ImageData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.internal.search.web.NL;
import org.xmind.ui.internal.search.web.SearchImages;
import org.xmind.ui.search.IFormData;
import org.xmind.ui.search.ISearchEngineDescriptor;

public class SearchEngineDescriptor
implements ISearchEngineDescriptor {
    private Element implementation;
    private ImageDescriptor icon;
    private IFormData formData;
    private boolean noFormData = false;

    public SearchEngineDescriptor(Element implementation) {
        this.implementation = implementation;
    }

    public String getDescription() {
        return DOMUtils.getTextContentByTag((Node)this.implementation, (String)"Description");
    }

    public IFormData getFormData() {
        if (this.formData == null && !this.noFormData) {
            this.formData = this.createFormDate();
            if (this.formData == null) {
                this.noFormData = true;
            }
        }
        return this.formData;
    }

    private IFormData createFormDate() {
        Element formImplementation = DOMUtils.getFirstChildElementByTag((Node)this.implementation, (String)"Form");
        if (formImplementation == null) {
            return null;
        }
        return new FormDataImpl(formImplementation);
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    private ImageDescriptor createIcon() {
        String imageData = DOMUtils.getTextContentByTag((Node)this.implementation, (String)"Image");
        if (imageData != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(Base64.decode((byte[])imageData.getBytes()));
            try {
                return ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)is));
            }
            catch (Throwable throwable) {}
        }
        return SearchImages.getImageDescriptor("/icons/discovery.gif");
    }

    public String getId() {
        return DOMUtils.getTextContentByTag((Node)this.implementation, (String)"Id");
    }

    public String getInputEncoding() {
        return DOMUtils.getTextContentByTag((Node)this.implementation, (String)"InputEncoding");
    }

    public String getLang() {
        return DOMUtils.getTextContentByTag((Node)this.implementation, (String)"Lang");
    }

    public String getShortName() {
        return DOMUtils.getTextContentByTag((Node)this.implementation, (String)"ShortName");
    }

    public String getUrl() {
        return DOMUtils.getTextContentByTag((Node)this.implementation, (String)"Url");
    }

    public boolean isVisible() {
        return NL.isThisNL(this.getLang());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FormDataImpl
    implements IFormData {
        private Element implementation;
        private Map<String, String> params;

        public FormDataImpl(Element implementation) {
            this.implementation = implementation;
        }

        @Override
        public String getFormAction() {
            return this.implementation.getAttribute("action");
        }

        @Override
        public String getFormMethod() {
            return this.implementation.getAttribute("method");
        }

        @Override
        public Map<String, String> getFormParams() {
            if (this.params == null) {
                this.params = this.createFormParams();
            }
            return this.params;
        }

        private Map<String, String> createFormParams() {
            HashMap<String, String> params = new HashMap<String, String>();
            Element[] elementArray = DOMUtils.getChildElementsByTag((Node)this.implementation, (String)"Param");
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element ele = elementArray[n2];
                params.put(ele.getAttribute("name"), ele.getAttribute("value"));
                ++n2;
            }
            return params;
        }
    }
}

