/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.RGB;
import org.xmind.ui.color.PaletteItem;

public class PaletteContents {
    private static PaletteContents instance = null;
    private List<PaletteItem> items;
    private int prefRows;
    private int prefColumns;

    public static PaletteContents getDefault() {
        if (instance == null) {
            PaletteContents palette = new PaletteContents(70, 7, 10);
            palette.addItem(PaletteItem.Background1);
            palette.addItem(PaletteItem.Text1);
            palette.addItem(PaletteItem.Background2);
            palette.addItem(PaletteItem.Text2);
            palette.addItem(PaletteItem.Accent1);
            palette.addItem(PaletteItem.Accent2);
            palette.addItem(PaletteItem.Accent3);
            palette.addItem(PaletteItem.Accent4);
            palette.addItem(PaletteItem.Accent5);
            palette.addItem(PaletteItem.Accent6);
            palette.addItem(PaletteItem.Background1_Darker5);
            palette.addItem(PaletteItem.Text1_Lighter50);
            palette.addItem(PaletteItem.Background2_Darker10);
            palette.addItem(PaletteItem.Text2_Lighter80);
            palette.addItem(PaletteItem.Accent1_Lighter80);
            palette.addItem(PaletteItem.Accent2_Lighter80);
            palette.addItem(PaletteItem.Accent3_Lighter80);
            palette.addItem(PaletteItem.Accent4_Lighter80);
            palette.addItem(PaletteItem.Accent5_Lighter80);
            palette.addItem(PaletteItem.Accent6_Lighter80);
            palette.addItem(PaletteItem.Background1_Darker15);
            palette.addItem(PaletteItem.Text1_Lighter35);
            palette.addItem(PaletteItem.Background2_Darker25);
            palette.addItem(PaletteItem.Text2_Lighter60);
            palette.addItem(PaletteItem.Accent1_Lighter60);
            palette.addItem(PaletteItem.Accent2_Lighter60);
            palette.addItem(PaletteItem.Accent3_Lighter60);
            palette.addItem(PaletteItem.Accent4_Lighter60);
            palette.addItem(PaletteItem.Accent5_Lighter60);
            palette.addItem(PaletteItem.Accent6_Lighter60);
            palette.addItem(PaletteItem.Background1_Darker25);
            palette.addItem(PaletteItem.Text1_Lighter25);
            palette.addItem(PaletteItem.Background2_Darker50);
            palette.addItem(PaletteItem.Text2_Lighter40);
            palette.addItem(PaletteItem.Accent1_Lighter40);
            palette.addItem(PaletteItem.Accent2_Lighter40);
            palette.addItem(PaletteItem.Accent3_Lighter40);
            palette.addItem(PaletteItem.Accent4_Lighter40);
            palette.addItem(PaletteItem.Accent5_Lighter40);
            palette.addItem(PaletteItem.Accent6_Lighter40);
            palette.addItem(PaletteItem.Background1_Darker35);
            palette.addItem(PaletteItem.Text1_Lighter15);
            palette.addItem(PaletteItem.Background2_Darker75);
            palette.addItem(PaletteItem.Text2_Darker25);
            palette.addItem(PaletteItem.Accent1_Darker25);
            palette.addItem(PaletteItem.Accent2_Darker25);
            palette.addItem(PaletteItem.Accent3_Darker25);
            palette.addItem(PaletteItem.Accent4_Darker25);
            palette.addItem(PaletteItem.Accent5_Darker25);
            palette.addItem(PaletteItem.Accent6_Darker25);
            palette.addItem(PaletteItem.Background1_Darker50);
            palette.addItem(PaletteItem.Text1_Lighter5);
            palette.addItem(PaletteItem.Background2_Darker90);
            palette.addItem(PaletteItem.Text2_Darker50);
            palette.addItem(PaletteItem.Accent1_Darker50);
            palette.addItem(PaletteItem.Accent2_Darker50);
            palette.addItem(PaletteItem.Accent3_Darker50);
            palette.addItem(PaletteItem.Accent4_Darker50);
            palette.addItem(PaletteItem.Accent5_Darker50);
            palette.addItem(PaletteItem.Accent6_Darker50);
            palette.addItem(PaletteItem.Standard_Red_Dark);
            palette.addItem(PaletteItem.Standard_Red);
            palette.addItem(PaletteItem.Standard_Orange);
            palette.addItem(PaletteItem.Standard_Yellow);
            palette.addItem(PaletteItem.Standard_Green_Light);
            palette.addItem(PaletteItem.Standard_Green);
            palette.addItem(PaletteItem.Standard_Blue_Light);
            palette.addItem(PaletteItem.Standard_Blue);
            palette.addItem(PaletteItem.Standard_Blue_Dark);
            palette.addItem(PaletteItem.Standard_Purple_Dark);
            instance = palette;
        }
        return instance;
    }

    public PaletteContents() {
        this(10);
    }

    public PaletteContents(int num) {
        this(num, PaletteContents.calcRows(num));
    }

    public PaletteContents(int num, int preferredRows) {
        this(num, preferredRows, PaletteContents.calcColumns(num, preferredRows));
    }

    public PaletteContents(int num, int preferredRows, int preferredColumns) {
        if (num <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new ArrayList<PaletteItem>(num);
        this.prefRows = Math.min(Math.max(preferredRows, 1), num);
        this.prefColumns = Math.min(Math.max(preferredColumns, 1), num);
    }

    public PaletteContents(PaletteItem[] items) {
        this.items = new ArrayList<PaletteItem>(Arrays.asList(items));
        this.prefRows = PaletteContents.calcRows(items.length);
        this.prefColumns = PaletteContents.calcColumns(items.length, this.prefRows);
    }

    public void addItem(RGB color, String description) {
        this.addItem(new PaletteItem(color, description));
    }

    public void addItem(int r, int g, int b, String description) {
        this.addItem(new RGB(r, g, b), description);
    }

    public void addItem(int color, String description) {
        this.addItem(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, description);
    }

    public void addItem(PaletteItem item) {
        this.items.add(item);
    }

    public void clear() {
        this.items.clear();
    }

    public RGB getColor(int index) {
        return this.items.get((int)index).color;
    }

    public String getDescription(int index) {
        return this.items.get((int)index).description;
    }

    public int getPreferredRows() {
        return this.prefRows;
    }

    public int getPreferredColumns() {
        return this.prefColumns;
    }

    public int size() {
        return this.items.size();
    }

    public PaletteItem[] toArray() {
        return this.items.toArray(new PaletteItem[this.items.size()]);
    }

    public List<PaletteItem> toList() {
        return Collections.unmodifiableList(this.items);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaletteContents)) {
            return false;
        }
        PaletteContents that = (PaletteContents)obj;
        return this.items.equals(that.items);
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    private static int calcRows(int num) {
        return (int)Math.sqrt(num);
    }

    private static int calcColumns(int num, int rows) {
        return rows == 0 ? 0 : (num + rows - 1) / rows;
    }
}

