#! /bin/sh
# Build texi2html.temp from $(texi2html_sources).
# 
# Copyright 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008,
# 2009, 2010 Free Software Foundation, Inc.
#
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

if test -z "$9"; then
  echo "$0: expected nine arguments, see Makefile.am." >&2
  exit 1
fi

echo "generating $1 from $2 and $3 $4 $5 $6 $7 $8 $9" 

sed -e '4a\
'"# $1: generated by `basename $0` from $2 and $3 $4 $5 $6 $7 $8 $9" \
    -e "/@MYSIMPLE@/r $3" \
    -e "/@T2H_I18N@/r $4" \
    -e "/@INIT@/r $5" \
    -e "/@T2H_TRANSLATIONS_FILE@/r $6" \
    -e "/@T2H_L2H_INIT@/r $7" \
    -e "/@T2H_L2H@/r $8" \
    -e "/@T2H_DOCUMENT_LANGUAGES@/r $9" \
    $2 >$1

if test $? -ne 0; then
  echo "$0: failed to generate $1, moving to -bad, goodbye." >&2
  mv $1 $1-bad
  exit 1
fi
