/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-variable.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_DEBUGGER_VARIABLE_H_
#define _IANJUTA_DEBUGGER_VARIABLE_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debugger.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUGGER_VARIABLE (ianjuta_debugger_variable_get_type ())
#define IANJUTA_DEBUGGER_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUGGER_VARIABLE, IAnjutaDebuggerVariable))
#define IANJUTA_IS_DEBUGGER_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUGGER_VARIABLE))
#define IANJUTA_DEBUGGER_VARIABLE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUGGER_VARIABLE, IAnjutaDebuggerVariableIface))

#define IANJUTA_DEBUGGER_VARIABLE_ERROR ianjuta_debugger_variable_error_quark()

typedef struct _IAnjutaDebuggerVariable IAnjutaDebuggerVariable;
typedef struct _IAnjutaDebuggerVariableIface IAnjutaDebuggerVariableIface;

/**
 * IAnjutaDebuggerVariableObject:
 * @name: unique variable object name created by backend
 * @expression: corresponding variable name or expression
 * @type: variable type
 * @value: variable value
 * @changed: TRUE if the variable has changed
 * @exited: TRUE if the variable is outside current scope
 * @deleted: TRUE if the variable has been removed
 * @children: Number of variable children, -1 if unknown
 * @has_more: TRUE if the children value is wrong
 * 
 * Defines a variable object.
 */
typedef struct _IAnjutaDebuggerVariableObject IAnjutaDebuggerVariableObject;
struct _IAnjutaDebuggerVariableObject {
	gchar *name;
	gchar *expression;
	gchar *type;
	gchar *value;
	gboolean changed;
	gboolean exited;
	gboolean deleted;
	gint children;
	gboolean has_more;
};

/**
 * IAnjutaDebuggerVariableCallback:
 * @data: a #IAnjutaDebuggerVariableObject object
 * @user_data: user data passed to the function
 * @error: error
 * 
 * This callback function is used to return a #IAnjutaDebuggerVariableObject.
 */
typedef void (*IAnjutaDebuggerVariableCallback) (const IAnjutaDebuggerVariableObject *data, gpointer user_data, GError* err);



struct _IAnjutaDebuggerVariableIface {
	IAnjutaDebuggerIface g_iface;
	

	gboolean (*assign) (IAnjutaDebuggerVariable *obj, const gchar *name,  const gchar *value, GError **err);
	gboolean (*create) (IAnjutaDebuggerVariable *obj, const gchar *expression,  IAnjutaDebuggerVariableCallback callback,  gpointer user_data, GError **err);
	gboolean (*destroy) (IAnjutaDebuggerVariable *obj, const gchar *name, GError **err);
	gboolean (*evaluate) (IAnjutaDebuggerVariable *obj, const gchar *name,  IAnjutaDebuggerGCharCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_children) (IAnjutaDebuggerVariable *obj, const gchar *name,  guint from,  IAnjutaDebuggerGListCallback callback,  gpointer user_data, GError **err);
	gboolean (*update) (IAnjutaDebuggerVariable *obj, IAnjutaDebuggerGListCallback callback,  gpointer user_data, GError **err);

};


GQuark ianjuta_debugger_variable_error_quark     (void);
GType  ianjuta_debugger_variable_get_type        (void);

gboolean ianjuta_debugger_variable_assign (IAnjutaDebuggerVariable *obj, const gchar *name,  const gchar *value, GError **err);

gboolean ianjuta_debugger_variable_create (IAnjutaDebuggerVariable *obj, const gchar *expression,  IAnjutaDebuggerVariableCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_variable_destroy (IAnjutaDebuggerVariable *obj, const gchar *name, GError **err);

gboolean ianjuta_debugger_variable_evaluate (IAnjutaDebuggerVariable *obj, const gchar *name,  IAnjutaDebuggerGCharCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_variable_list_children (IAnjutaDebuggerVariable *obj, const gchar *name,  guint from,  IAnjutaDebuggerGListCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_variable_update (IAnjutaDebuggerVariable *obj, IAnjutaDebuggerGListCallback callback,  gpointer user_data, GError **err);


G_END_DECLS

#endif
