/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-selection.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-selection
 * @title: IAnjutaEditorSelection
 * @short_description: Text editor selection interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-selection.h
 * 
 */

#include "ianjuta-editor-selection.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_selection_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-selection-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_selection_get:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Gets curerntly selected text in editor.
 * 
 * Returns: A newly allocated buffer of currently selected characters.
 * NULL if there is no selection. The returned buffer must be freed after
 * use.
 */
gchar*
ianjuta_editor_selection_get (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj), NULL);
	return IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->get (obj, err);
}

/* Default implementation */
static gchar*
ianjuta_editor_selection_get_default (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_selection_get_end:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get end position of selection. If there is no selection, returns
 * NULL.
 * 
 * Returns: End of selection or NULL if there is no selection.
 */
IAnjutaIterable*
ianjuta_editor_selection_get_end (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj), NULL);
	return IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->get_end (obj, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_editor_selection_get_end_default (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_selection_get_start:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Gets start position of selection text.
 *
 * Return: Start of selection or NULL if there is no selection.
 */
IAnjutaIterable*
ianjuta_editor_selection_get_start (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj), NULL);
	return IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->get_start (obj, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_editor_selection_get_start_default (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_selection_has_selection:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Returns TRUE if editor has any text selected. The selection
 * positions can be retrieved with ianjuta_editor_selection_get_start()
 * and ianjuta_editor_selection_get_end().
 * 
 * Returns: TRUE if there is text selected else FALSE.
 */
gboolean
ianjuta_editor_selection_has_selection (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj), FALSE);
	return IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->has_selection (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_editor_selection_has_selection_default (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_editor_selection_replace:
 * @obj: Self
 * @text: Replacement text.
 * @length: Length of the text to used in @text.
 * @err: Error propagation and reporting
 *
 * Replaces currently selected text with the @text. Only @length amount
 * of characters are used from @text buffer to replace.
 */
void
ianjuta_editor_selection_replace (IAnjutaEditorSelection *obj, const gchar *text,   gint length, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->replace (obj, text, length, err);
}

/* Default implementation */
static void
ianjuta_editor_selection_replace_default (IAnjutaEditorSelection *obj, const gchar *text,   gint length, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_edit_select_all:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Select whole buffer.
 */
void
ianjuta_editor_selection_select_all (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->select_all (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_selection_select_all_default (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_selection_select_block:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Selects current block of code. The definition of block of code
 * depends on highlight mode used (programming language). Some
 * highlight mode does not have block concept, in that case this
 * method does not do anything.
 */
void
ianjuta_editor_selection_select_block (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->select_block (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_selection_select_block_default (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_selection_select_function:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Select current function block. The definition of function block
 * depends on highlight mode used (programming language). Some
 * highlight mode does not have function concept, in that case this
 * method does not do anything.
 */
void
ianjuta_editor_selection_select_function (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->select_function (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_selection_select_function_default (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_selection_set:
 * @obj: Self
 * @start: Begin of selection
 * @end: End of selection
 * @scroll: Scroll selection onscreen
 * @err: Error propagation and reporting
 *
 * Select characters between start and end. Start and end don't have to
 * be ordered.
 */
void
ianjuta_editor_selection_set (IAnjutaEditorSelection *obj, IAnjutaIterable* start,   IAnjutaIterable* end,   gboolean scroll, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	g_return_if_fail ((start == NULL) ||IANJUTA_IS_ITERABLE(start));
	g_return_if_fail ((end == NULL) ||IANJUTA_IS_ITERABLE(end));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->set (obj, start, end, scroll, err);
}

/* Default implementation */
static void
ianjuta_editor_selection_set_default (IAnjutaEditorSelection *obj, IAnjutaIterable* start,   IAnjutaIterable* end,   gboolean scroll, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_selection_base_init (IAnjutaEditorSelectionIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get = ianjuta_editor_selection_get_default;
	klass->get_end = ianjuta_editor_selection_get_end_default;
	klass->get_start = ianjuta_editor_selection_get_start_default;
	klass->has_selection = ianjuta_editor_selection_has_selection_default;
	klass->replace = ianjuta_editor_selection_replace_default;
	klass->select_all = ianjuta_editor_selection_select_all_default;
	klass->select_block = ianjuta_editor_selection_select_block_default;
	klass->select_function = ianjuta_editor_selection_select_function_default;
	klass->set = ianjuta_editor_selection_set_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_selection_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorSelectionIface),
			(GBaseInitFunc) ianjuta_editor_selection_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorSelection", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
