/* provider.c generated by valac 0.11.2.22-6303f, the Vala compiler
 * generated from provider.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <libanjuta/libanjuta.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <vala.h>
#include <valagee.h>


#define TYPE_VALA_PROVIDER (vala_provider_get_type ())
#define VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PROVIDER, ValaProvider))
#define VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PROVIDER, ValaProviderClass))
#define IS_VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PROVIDER))
#define IS_VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PROVIDER))
#define VALA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PROVIDER, ValaProviderClass))

typedef struct _ValaProvider ValaProvider;
typedef struct _ValaProviderClass ValaProviderClass;
typedef struct _ValaProviderPrivate ValaProviderPrivate;

#define TYPE_VALA_PLUGIN (vala_plugin_get_type ())
#define VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PLUGIN, ValaPlugin))
#define VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PLUGIN, ValaPluginClass))
#define IS_VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PLUGIN))
#define IS_VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PLUGIN))
#define VALA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PLUGIN, ValaPluginClass))

typedef struct _ValaPlugin ValaPlugin;
typedef struct _ValaPluginClass ValaPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ValaPluginPrivate ValaPluginPrivate;
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaProvider {
	GObject parent_instance;
	ValaProviderPrivate * priv;
};

struct _ValaProviderClass {
	GObjectClass parent_class;
};

struct _ValaProviderPrivate {
	IAnjutaIterable* start_pos;
	ValaPlugin* plugin;
};

struct _ValaPlugin {
	AnjutaPlugin parent_instance;
	ValaPluginPrivate * priv;
	IAnjutaEditor* current_editor;
	GSettings* settings;
};

struct _ValaPluginClass {
	AnjutaPluginClass parent_class;
};


static gpointer vala_provider_parent_class = NULL;
static GRegex* vala_provider_member_access;
static GRegex* vala_provider_member_access = NULL;
static GRegex* vala_provider_member_access_split;
static GRegex* vala_provider_member_access_split = NULL;
static GRegex* vala_provider_function_call;
static GRegex* vala_provider_function_call = NULL;
static IAnjutaProviderIface* vala_provider_ianjuta_provider_parent_iface = NULL;
static GType vala_provider_type_id = 0;

GType vala_provider_get_type (void) G_GNUC_CONST;
GType vala_provider_register_type (GTypeModule * module);
GType vala_plugin_get_type (void) G_GNUC_CONST;
GType vala_plugin_register_type (GTypeModule * module);
#define VALA_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_PROVIDER, ValaProviderPrivate))
enum  {
	VALA_PROVIDER_DUMMY_PROPERTY
};
#define VALA_PROVIDER_PREF_AUTOCOMPLETE_ENABLE "cpp-completion-enable"
#define VALA_PROVIDER_PREF_SPACE_AFTER_FUNC "cpp-completion-space-after-func"
#define VALA_PROVIDER_PREF_BRACE_AFTER_FUNC "cpp-code-brace-after-func"
#define VALA_PROVIDER_PREF_CALLTIP_ENABLE "cpp-calltip-enable"
ValaProvider* vala_provider_new (ValaPlugin* plugin);
ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin);
static const gchar* vala_provider_real_get_name (IAnjutaProvider* base, GError** error);
static void vala_provider_real_populate (IAnjutaProvider* base, IAnjutaIterable* iter, GError** error);
GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block);
static ValaExpression* vala_provider_construct_member_access (ValaProvider* self, gchar** names, int names_length1);
ValaBlock* vala_plugin_get_current_block (ValaPlugin* self, IAnjutaEditor* editor);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static IAnjutaEditorAssistProposal* _ianjuta_editor_assist_proposal_dup (IAnjutaEditorAssistProposal* self);
static IAnjutaIterable* vala_provider_real_get_start_iter (IAnjutaProvider* base, GError** error);
static void vala_provider_real_activate (IAnjutaProvider* base, IAnjutaIterable* iter, void* data, GError** error);
void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor);
static void vala_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin) {
	ValaProvider * self = NULL;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (ValaProvider*) g_object_new (object_type, NULL);
	self->priv->plugin = plugin;
	return self;
}


ValaProvider* vala_provider_new (ValaPlugin* plugin) {
	return vala_provider_construct (TYPE_VALA_PROVIDER, plugin);
}


static const gchar* vala_provider_real_get_name (IAnjutaProvider* base, GError** error) {
	ValaProvider * self;
	const gchar* result = NULL;
	self = (ValaProvider*) base;
	result = "Vala";
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static IAnjutaEditorAssistProposal* _ianjuta_editor_assist_proposal_dup (IAnjutaEditorAssistProposal* self) {
	IAnjutaEditorAssistProposal* dup;
	dup = g_new0 (IAnjutaEditorAssistProposal, 1);
	memcpy (dup, self, sizeof (IAnjutaEditorAssistProposal));
	return dup;
}


static gpointer __ianjuta_editor_assist_proposal_dup0 (gpointer self) {
	return self ? _ianjuta_editor_assist_proposal_dup (self) : NULL;
}


static void vala_provider_real_populate (IAnjutaProvider* base, IAnjutaIterable* iter, GError** error) {
	ValaProvider * self;
	gboolean _tmp0_;
	IAnjutaEditor* _tmp1_;
	IAnjutaEditorAssist* _tmp2_;
	IAnjutaEditorAssist* editor;
	gint _tmp3_;
	gint _tmp4_;
	IAnjutaIterable* _tmp5_ = NULL;
	IAnjutaIterable* _tmp6_;
	IAnjutaIterable* line_start;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* current_text;
	GMatchInfo* match_info;
	GMatchInfo* _tmp9_ = NULL;
	gboolean _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	glong _tmp13_;
	gboolean _tmp14_;
	IAnjutaIterable* _tmp15_ = NULL;
	IAnjutaIterable* _tmp16_;
	IAnjutaIterable* _tmp17_;
	IAnjutaIterable* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	glong _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp29_;
	gchar** names;
	ValaExpression* _tmp30_ = NULL;
	ValaExpression* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	ValaBlock* _tmp34_ = NULL;
	ValaBlock* _tmp35_;
	GList* _tmp36_ = NULL;
	GList* _tmp37_;
	GList* syms;
	GList* proposals;
	GError * _inner_error_ = NULL;
	self = (ValaProvider*) base;
	g_return_if_fail (iter != NULL);
	_tmp0_ = g_settings_get_boolean (self->priv->plugin->settings, VALA_PROVIDER_PREF_AUTOCOMPLETE_ENABLE);
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = _g_object_ref0 ((_tmp1_ = self->priv->plugin->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp1_) ? ((IAnjutaEditorAssist*) _tmp1_) : NULL));
	editor = _tmp2_;
	_tmp3_ = ianjuta_editor_get_lineno ((IAnjutaEditor*) editor, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (editor);
		return;
	}
	_tmp5_ = ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, _tmp4_, &_inner_error_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	line_start = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (editor);
		return;
	}
	_tmp7_ = ianjuta_editor_get_text ((IAnjutaEditor*) editor, line_start, iter, &_inner_error_);
	_tmp8_ = g_strdup (_tmp7_);
	current_text = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	match_info = NULL;
	_tmp10_ = g_regex_match (vala_provider_member_access, current_text, 0, &_tmp9_);
	_g_match_info_free0 (match_info);
	match_info = _tmp9_;
	if (!_tmp10_) {
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	_tmp11_ = g_match_info_fetch (match_info, 0);
	_tmp12_ = _tmp11_;
	_tmp13_ = strlen (_tmp12_);
	if ((_tmp14_ = _tmp13_ < 2, _g_free0 (_tmp12_), _tmp14_)) {
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	_tmp15_ = ianjuta_iterable_clone (iter, &_inner_error_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_tmp18_ = _tmp17_;
	_g_object_unref0 (self->priv->start_pos);
	self->priv->start_pos = _tmp18_;
	_tmp19_ = ianjuta_iterable_get_position (iter, &_inner_error_);
	_tmp20_ = _tmp19_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	_tmp21_ = g_match_info_fetch (match_info, 2);
	_tmp22_ = _tmp21_;
	_tmp23_ = strlen (_tmp22_);
	ianjuta_iterable_set_position (self->priv->start_pos, _tmp20_ - ((gint) _tmp23_), &_inner_error_);
	_g_free0 (_tmp22_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	_tmp24_ = g_match_info_fetch (match_info, 1);
	_tmp25_ = _tmp24_;
	_tmp27_ = _tmp26_ = g_regex_split (vala_provider_member_access_split, _tmp25_, 0);
	_tmp29_ = (_tmp28_ = _tmp27_, _g_free0 (_tmp25_), _tmp28_);
	names_length1 = _vala_array_length (_tmp26_);
	_names_size_ = names_length1;
	names = _tmp29_;
	_tmp30_ = vala_provider_construct_member_access (self, names, names_length1);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_match_info_fetch (match_info, 2);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_plugin_get_current_block (self->priv->plugin, (IAnjutaEditor*) editor);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_plugin_lookup_symbol (self->priv->plugin, _tmp31_, _tmp33_, TRUE, _tmp35_);
	syms = (_tmp37_ = _tmp36_, _vala_code_node_unref0 (_tmp35_), _g_free0 (_tmp33_), _vala_code_node_unref0 (_tmp31_), _tmp37_);
	proposals = NULL;
	{
		GList* symbol_collection;
		GList* symbol_it;
		symbol_collection = syms;
		for (symbol_it = symbol_collection; symbol_it != NULL; symbol_it = symbol_it->next) {
			ValaSymbol* _tmp38_;
			ValaSymbol* symbol;
			_tmp38_ = _vala_code_node_ref0 ((ValaSymbol*) symbol_it->data);
			symbol = _tmp38_;
			{
				gboolean _tmp39_ = FALSE;
				IAnjutaEditorAssistProposal prop = {0};
				const gchar* _tmp44_ = NULL;
				IAnjutaEditorAssistProposal* _tmp45_;
				if (VALA_IS_LOCAL_VARIABLE (symbol)) {
					gint _tmp40_;
					gint _tmp41_;
					ValaSourceReference* _tmp42_ = NULL;
					gint _tmp43_;
					_tmp40_ = ianjuta_editor_get_lineno ((IAnjutaEditor*) editor, &_inner_error_);
					_tmp41_ = _tmp40_;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_vala_code_node_unref0 (symbol);
						__g_list_free__g_free0_0 (proposals);
						__g_list_free__vala_code_node_unref0_0 (syms);
						names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
						_g_match_info_free0 (match_info);
						_g_free0 (current_text);
						_g_object_unref0 (line_start);
						_g_object_unref0 (editor);
						return;
					}
					_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) symbol);
					_tmp43_ = vala_source_reference_get_first_line (_tmp42_);
					_tmp39_ = _tmp43_ > _tmp41_;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					_vala_code_node_unref0 (symbol);
					continue;
				}
				memset (&prop, 0, sizeof (IAnjutaEditorAssistProposal));
				prop.data = symbol;
				_tmp44_ = vala_symbol_get_name (symbol);
				prop.label = _tmp44_;
				_tmp45_ = __ianjuta_editor_assist_proposal_dup0 (&prop);
				proposals = g_list_prepend (proposals, _tmp45_);
				_vala_code_node_unref0 (symbol);
			}
		}
	}
	proposals = g_list_reverse (proposals);
	ianjuta_editor_assist_proposals (editor, (IAnjutaProvider*) self, proposals, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_list_free__g_free0_0 (proposals);
		__g_list_free__vala_code_node_unref0_0 (syms);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_match_info_free0 (match_info);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
		_g_object_unref0 (editor);
		return;
	}
	__g_list_free__g_free0_0 (proposals);
	__g_list_free__vala_code_node_unref0_0 (syms);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_match_info_free0 (match_info);
	_g_free0 (current_text);
	_g_object_unref0 (line_start);
	_g_object_unref0 (editor);
}


static IAnjutaIterable* vala_provider_real_get_start_iter (IAnjutaProvider* base, GError** error) {
	ValaProvider * self;
	IAnjutaIterable* result = NULL;
	self = (ValaProvider*) base;
	result = self->priv->start_pos;
	return result;
}


static void vala_provider_real_activate (IAnjutaProvider* base, IAnjutaIterable* iter, void* data, GError** error) {
	ValaProvider * self;
	void* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* sym;
	IAnjutaEditor* _tmp2_;
	IAnjutaEditorAssist* _tmp3_;
	IAnjutaEditorAssist* editor;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* assist;
	gboolean is_func;
	gboolean calltip;
	gboolean _tmp6_ = FALSE;
	IAnjutaEditorAssist* _tmp13_;
	IAnjutaEditorAssist* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (ValaProvider*) base;
	g_return_if_fail (iter != NULL);
	_tmp1_ = _vala_code_node_ref0 ((_tmp0_ = data, VALA_IS_SYMBOL (_tmp0_) ? ((ValaSymbol*) _tmp0_) : NULL));
	sym = _tmp1_;
	_tmp3_ = _g_object_ref0 ((_tmp2_ = self->priv->plugin->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp2_) ? ((IAnjutaEditorAssist*) _tmp2_) : NULL));
	editor = _tmp3_;
	_tmp4_ = vala_symbol_get_name (sym);
	_tmp5_ = g_strdup (_tmp4_);
	assist = _tmp5_;
	is_func = FALSE;
	calltip = FALSE;
	if (VALA_IS_METHOD (sym)) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = VALA_IS_SIGNAL (sym);
	}
	if (_tmp6_) {
		is_func = TRUE;
	} else {
		if (VALA_IS_VARIABLE (sym)) {
			ValaDataType* _tmp7_ = NULL;
			_tmp7_ = vala_variable_get_variable_type (VALA_VARIABLE (sym));
			if (VALA_IS_DELEGATE_TYPE (_tmp7_)) {
				is_func = TRUE;
			}
		}
	}
	if (is_func) {
		gboolean _tmp8_;
		gboolean _tmp10_;
		_tmp8_ = g_settings_get_boolean (self->priv->plugin->settings, VALA_PROVIDER_PREF_SPACE_AFTER_FUNC);
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strconcat (assist, " ", NULL);
			_g_free0 (assist);
			assist = _tmp9_;
		}
		_tmp10_ = g_settings_get_boolean (self->priv->plugin->settings, VALA_PROVIDER_PREF_BRACE_AFTER_FUNC);
		if (_tmp10_) {
			gchar* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = g_strconcat (assist, "(", NULL);
			_g_free0 (assist);
			assist = _tmp11_;
			_tmp12_ = g_settings_get_boolean (self->priv->plugin->settings, VALA_PROVIDER_PREF_CALLTIP_ENABLE);
			if (_tmp12_) {
				calltip = TRUE;
			}
		}
	}
	ianjuta_document_begin_undo_action ((_tmp13_ = editor, IANJUTA_IS_DOCUMENT (_tmp13_) ? ((IAnjutaDocument*) _tmp13_) : NULL), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (assist);
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_editor_erase ((IAnjutaEditor*) editor, self->priv->start_pos, iter, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (assist);
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_editor_insert ((IAnjutaEditor*) editor, self->priv->start_pos, assist, -1, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (assist);
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_document_end_undo_action ((_tmp14_ = editor, IANJUTA_IS_DOCUMENT (_tmp14_) ? ((IAnjutaDocument*) _tmp14_) : NULL), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (assist);
		_g_object_unref0 (editor);
		_vala_code_node_unref0 (sym);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (calltip) {
		_tmp15_ = IANJUTA_IS_EDITOR_TIP (editor);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		vala_provider_show_call_tip (self, IANJUTA_EDITOR_TIP (editor));
	}
	_g_free0 (assist);
	_g_object_unref0 (editor);
	_vala_code_node_unref0 (sym);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor) {
	IAnjutaIterable* _tmp0_ = NULL;
	IAnjutaIterable* _tmp1_;
	IAnjutaIterable* current_position;
	gint _tmp2_;
	gint _tmp3_;
	IAnjutaIterable* _tmp4_ = NULL;
	IAnjutaIterable* _tmp5_;
	IAnjutaIterable* line_start;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* to_complete;
	GList* tips;
	GMatchInfo* match_info;
	GMatchInfo* _tmp8_ = NULL;
	gboolean _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	gboolean creation_method;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp18_;
	gchar** names;
	ValaExpression* _tmp19_ = NULL;
	ValaExpression* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	ValaBlock* _tmp23_ = NULL;
	ValaBlock* _tmp24_;
	GList* _tmp25_ = NULL;
	GList* _tmp26_;
	GList* syms;
	IAnjutaIterable* _tmp52_ = NULL;
	IAnjutaIterable* _tmp53_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	_tmp0_ = ianjuta_editor_get_position ((IAnjutaEditor*) editor, &_inner_error_);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current_position = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = ianjuta_editor_get_lineno ((IAnjutaEditor*) editor, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (current_position);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, _tmp3_, &_inner_error_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	line_start = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (current_position);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = ianjuta_editor_get_text ((IAnjutaEditor*) editor, line_start, current_position, &_inner_error_);
	_tmp7_ = g_strdup (_tmp6_);
	to_complete = _tmp7_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (line_start);
		_g_object_unref0 (current_position);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tips = NULL;
	match_info = NULL;
	_tmp9_ = g_regex_match (vala_provider_function_call, to_complete, 0, &_tmp8_);
	_g_match_info_free0 (match_info);
	match_info = _tmp8_;
	if (!_tmp9_) {
		_g_match_info_free0 (match_info);
		__g_list_free__g_free0_0 (tips);
		_g_free0 (to_complete);
		_g_object_unref0 (line_start);
		_g_object_unref0 (current_position);
		return;
	}
	_tmp10_ = g_match_info_fetch (match_info, 1);
	_tmp11_ = _tmp10_;
	creation_method = (_tmp12_ = g_strcmp0 (_tmp11_, "") != 0, _g_free0 (_tmp11_), _tmp12_);
	_tmp13_ = g_match_info_fetch (match_info, 2);
	_tmp14_ = _tmp13_;
	_tmp16_ = _tmp15_ = g_regex_split (vala_provider_member_access_split, _tmp14_, 0);
	_tmp18_ = (_tmp17_ = _tmp16_, _g_free0 (_tmp14_), _tmp17_);
	names_length1 = _vala_array_length (_tmp15_);
	_names_size_ = names_length1;
	names = _tmp18_;
	_tmp19_ = vala_provider_construct_member_access (self, names, names_length1);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_match_info_fetch (match_info, 3);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_plugin_get_current_block (self->priv->plugin, (IAnjutaEditor*) editor);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_plugin_lookup_symbol (self->priv->plugin, _tmp20_, _tmp22_, FALSE, _tmp24_);
	syms = (_tmp26_ = _tmp25_, _vala_code_node_unref0 (_tmp24_), _g_free0 (_tmp22_), _vala_code_node_unref0 (_tmp20_), _tmp26_);
	{
		GList* sym_collection;
		GList* sym_it;
		sym_collection = syms;
		for (sym_it = sym_collection; sym_it != NULL; sym_it = sym_it->next) {
			ValaSymbol* _tmp27_;
			ValaSymbol* sym;
			_tmp27_ = _vala_code_node_ref0 ((ValaSymbol*) sym_it->data);
			sym = _tmp27_;
			{
				ValaList* parameters;
				GString* _tmp41_ = NULL;
				GString* calltip;
				gboolean first;
				gchar* _tmp51_;
				parameters = NULL;
				if (VALA_IS_METHOD (sym)) {
					ValaList* _tmp28_ = NULL;
					ValaList* _tmp29_;
					_tmp28_ = vala_method_get_parameters (VALA_METHOD (sym));
					_tmp29_ = _tmp28_;
					_vala_iterable_unref0 (parameters);
					parameters = _tmp29_;
				} else {
					if (VALA_IS_SIGNAL (sym)) {
						ValaList* _tmp30_ = NULL;
						ValaList* _tmp31_;
						_tmp30_ = vala_signal_get_parameters (VALA_SIGNAL (sym));
						_tmp31_ = _tmp30_;
						_vala_iterable_unref0 (parameters);
						parameters = _tmp31_;
					} else {
						gboolean _tmp32_ = FALSE;
						if (creation_method) {
							_tmp32_ = VALA_IS_CLASS (sym);
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							ValaMethod* _tmp33_ = NULL;
							ValaList* _tmp34_ = NULL;
							ValaList* _tmp35_;
							_tmp33_ = vala_class_get_default_construction_method (VALA_CLASS (sym));
							_tmp34_ = vala_method_get_parameters (_tmp33_);
							_tmp35_ = _tmp34_;
							_vala_iterable_unref0 (parameters);
							parameters = _tmp35_;
						} else {
							if (VALA_IS_VARIABLE (sym)) {
								ValaDataType* _tmp36_ = NULL;
								ValaDataType* _tmp37_;
								ValaDataType* var_type;
								_tmp36_ = vala_variable_get_variable_type (VALA_VARIABLE (sym));
								_tmp37_ = _vala_code_node_ref0 (_tmp36_);
								var_type = _tmp37_;
								if (VALA_IS_DELEGATE_TYPE (var_type)) {
									ValaDelegate* _tmp38_ = NULL;
									ValaList* _tmp39_ = NULL;
									ValaList* _tmp40_;
									_tmp38_ = vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (var_type));
									_tmp39_ = vala_delegate_get_parameters (_tmp38_);
									_tmp40_ = _tmp39_;
									_vala_iterable_unref0 (parameters);
									parameters = _tmp40_;
								} else {
									_vala_code_node_unref0 (var_type);
									_vala_iterable_unref0 (parameters);
									_vala_code_node_unref0 (sym);
									__g_list_free__vala_code_node_unref0_0 (syms);
									names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
									_g_match_info_free0 (match_info);
									__g_list_free__g_free0_0 (tips);
									_g_free0 (to_complete);
									_g_object_unref0 (line_start);
									_g_object_unref0 (current_position);
									return;
								}
								_vala_code_node_unref0 (var_type);
							} else {
								_vala_iterable_unref0 (parameters);
								_vala_code_node_unref0 (sym);
								__g_list_free__vala_code_node_unref0_0 (syms);
								names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
								_g_match_info_free0 (match_info);
								__g_list_free__g_free0_0 (tips);
								_g_free0 (to_complete);
								_g_object_unref0 (line_start);
								_g_object_unref0 (current_position);
								return;
							}
						}
					}
				}
				_tmp41_ = g_string_new ("(");
				calltip = _tmp41_;
				first = TRUE;
				{
					ValaList* _tmp42_;
					ValaList* _p_list;
					gint _tmp43_;
					gint _p_size;
					gint _p_index;
					_tmp42_ = _vala_iterable_ref0 (parameters);
					_p_list = _tmp42_;
					_tmp43_ = vala_collection_get_size ((ValaCollection*) _p_list);
					_p_size = _tmp43_;
					_p_index = -1;
					while (TRUE) {
						gpointer _tmp44_ = NULL;
						ValaParameter* p;
						gboolean _tmp45_;
						_p_index = _p_index + 1;
						if (!(_p_index < _p_size)) {
							break;
						}
						_tmp44_ = vala_list_get (_p_list, _p_index);
						p = (ValaParameter*) _tmp44_;
						if (first) {
							first = FALSE;
						} else {
							g_string_append (calltip, ", ");
						}
						_tmp45_ = vala_parameter_get_ellipsis (p);
						if (_tmp45_) {
							g_string_append (calltip, "...");
						} else {
							ValaDataType* _tmp46_ = NULL;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							GString* _tmp49_ = NULL;
							const gchar* _tmp50_ = NULL;
							_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) p);
							_tmp47_ = vala_data_type_to_qualified_string (_tmp46_, NULL);
							_tmp48_ = _tmp47_;
							g_string_append (calltip, _tmp48_);
							_g_free0 (_tmp48_);
							_tmp49_ = g_string_append (calltip, " ");
							_tmp50_ = vala_symbol_get_name ((ValaSymbol*) p);
							g_string_append (_tmp49_, _tmp50_);
						}
						_vala_code_node_unref0 (p);
					}
					_vala_iterable_unref0 (_p_list);
				}
				g_string_append (calltip, ")");
				_tmp51_ = g_strdup (calltip->str);
				tips = g_list_append (tips, _tmp51_);
				_g_string_free0 (calltip);
				_vala_iterable_unref0 (parameters);
				_vala_code_node_unref0 (sym);
			}
		}
	}
	_tmp52_ = ianjuta_editor_get_position ((IAnjutaEditor*) editor, &_inner_error_);
	_tmp53_ = _tmp52_;
	if (_inner_error_ != NULL) {
		__g_list_free__vala_code_node_unref0_0 (syms);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_match_info_free0 (match_info);
		__g_list_free__g_free0_0 (tips);
		_g_free0 (to_complete);
		_g_object_unref0 (line_start);
		_g_object_unref0 (current_position);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_editor_tip_show (editor, tips, _tmp53_, &_inner_error_);
	if (_inner_error_ != NULL) {
		__g_list_free__vala_code_node_unref0_0 (syms);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_match_info_free0 (match_info);
		__g_list_free__g_free0_0 (tips);
		_g_free0 (to_complete);
		_g_object_unref0 (line_start);
		_g_object_unref0 (current_position);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	__g_list_free__vala_code_node_unref0_0 (syms);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_match_info_free0 (match_info);
	__g_list_free__g_free0_0 (tips);
	_g_free0 (to_complete);
	_g_object_unref0 (line_start);
	_g_object_unref0 (current_position);
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}


static ValaExpression* vala_provider_construct_member_access (ValaProvider* self, gchar** names, int names_length1) {
	ValaExpression* result = NULL;
	ValaExpression* expr;
	g_return_val_if_fail (self != NULL, NULL);
	expr = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(names[i] != NULL)) {
					break;
				}
				if (g_strcmp0 (names[i], "") != 0) {
					ValaMemberAccess* _tmp1_ = NULL;
					ValaExpression* _tmp2_;
					gboolean _tmp3_ = FALSE;
					_tmp1_ = vala_member_access_new (expr, names[i], NULL);
					_tmp2_ = (ValaExpression*) _tmp1_;
					_vala_code_node_unref0 (expr);
					expr = _tmp2_;
					if (names[i + 1] != NULL) {
						gchar* _tmp4_ = NULL;
						gchar* _tmp5_;
						gboolean _tmp6_;
						_tmp4_ = string_chug (names[i + 1]);
						_tmp5_ = _tmp4_;
						_tmp6_ = g_str_has_prefix (_tmp5_, "(");
						_tmp3_ = _tmp6_;
						_g_free0 (_tmp5_);
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						ValaMethodCall* _tmp7_ = NULL;
						ValaExpression* _tmp8_;
						_tmp7_ = vala_method_call_new (expr, NULL);
						_tmp8_ = (ValaExpression*) _tmp7_;
						_vala_code_node_unref0 (expr);
						expr = _tmp8_;
						i++;
					}
				}
			}
		}
	}
	result = expr;
	return result;
}


static void vala_provider_class_init (ValaProviderClass * klass) {
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	GRegex* _tmp3_ = NULL;
	GRegex* _tmp4_;
	GRegex* _tmp5_;
	GRegex* _tmp6_ = NULL;
	GRegex* _tmp7_;
	GRegex* _tmp8_;
	GError * _inner_error_ = NULL;
	vala_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_provider_finalize;
	_tmp0_ = g_regex_new ("((?:\\w+(?:\\s*\\([^()]*\\))?\\.)*)(\\w*)$", 0, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch7_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp2_ = _tmp1_;
	_g_regex_unref0 (vala_provider_member_access);
	vala_provider_member_access = _tmp2_;
	_tmp3_ = g_regex_new ("(\\s*\\([^()]*\\))?\\.", 0, 0, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch7_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp5_ = _tmp4_;
	_g_regex_unref0 (vala_provider_member_access_split);
	vala_provider_member_access_split = _tmp5_;
	_tmp6_ = g_regex_new ("(new )?((?:\\w+(?:\\s*\\([^()]*\\))?\\.)*)(\\w+)\\s*\\(([^(,)]+,)*([^(" \
",)]*)$", 0, 0, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch7_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp8_ = _tmp7_;
	_g_regex_unref0 (vala_provider_function_call);
	vala_provider_function_call = _tmp8_;
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("provider.vala:37: Regular expressions failed to compile : %s", err->message);
		_g_error_free0 (err);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void vala_provider_ianjuta_provider_interface_init (IAnjutaProviderIface * iface) {
	vala_provider_ianjuta_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (const gchar* (*)(IAnjutaProvider* ,GError**)) vala_provider_real_get_name;
	iface->populate = (void (*)(IAnjutaProvider* ,IAnjutaIterable* ,GError**)) vala_provider_real_populate;
	iface->get_start_iter = (IAnjutaIterable* (*)(IAnjutaProvider* ,GError**)) vala_provider_real_get_start_iter;
	iface->activate = (void (*)(IAnjutaProvider* ,IAnjutaIterable* ,void* ,GError**)) vala_provider_real_activate;
}


static void vala_provider_instance_init (ValaProvider * self) {
	self->priv = VALA_PROVIDER_GET_PRIVATE (self);
}


static void vala_provider_finalize (GObject* obj) {
	ValaProvider * self;
	self = VALA_PROVIDER (obj);
	_g_object_unref0 (self->priv->start_pos);
	G_OBJECT_CLASS (vala_provider_parent_class)->finalize (obj);
}


GType vala_provider_get_type (void) {
	return vala_provider_type_id;
}


GType vala_provider_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ValaProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProvider), 0, (GInstanceInitFunc) vala_provider_instance_init, NULL };
	static const GInterfaceInfo ianjuta_provider_info = { (GInterfaceInitFunc) vala_provider_ianjuta_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vala_provider_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ValaProvider", &g_define_type_info, 0);
	g_type_module_add_interface (module, vala_provider_type_id, IANJUTA_TYPE_PROVIDER, &ianjuta_provider_info);
	return vala_provider_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



