/* plugin.c generated by valac 0.11.2.24-c8ac0, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libanjuta/libanjuta.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <gio/gio.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_VALA_PLUGIN (vala_plugin_get_type ())
#define VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PLUGIN, ValaPlugin))
#define VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PLUGIN, ValaPluginClass))
#define IS_VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PLUGIN))
#define IS_VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PLUGIN))
#define VALA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PLUGIN, ValaPluginClass))

typedef struct _ValaPlugin ValaPlugin;
typedef struct _ValaPluginClass ValaPluginClass;
typedef struct _ValaPluginPrivate ValaPluginPrivate;

#define TYPE_BLOCK_LOCATOR (block_locator_get_type ())
#define BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_LOCATOR, BlockLocator))
#define BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_LOCATOR, BlockLocatorClass))
#define IS_BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_LOCATOR))
#define IS_BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_LOCATOR))
#define BLOCK_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_LOCATOR, BlockLocatorClass))

typedef struct _BlockLocator BlockLocator;
typedef struct _BlockLocatorClass BlockLocatorClass;

#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;

#define TYPE_VALA_PROVIDER (vala_provider_get_type ())
#define VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PROVIDER, ValaProvider))
#define VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PROVIDER, ValaProviderClass))
#define IS_VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PROVIDER))
#define IS_VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PROVIDER))
#define VALA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PROVIDER, ValaProviderClass))

typedef struct _ValaProvider ValaProvider;
typedef struct _ValaProviderClass ValaProviderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaPlugin {
	AnjutaPlugin parent_instance;
	ValaPluginPrivate * priv;
	IAnjutaEditor* current_editor;
	GSettings* settings;
};

struct _ValaPluginClass {
	AnjutaPluginClass parent_class;
};

struct _ValaPluginPrivate {
	guint editor_watch_id;
	ValaCodeContext* context;
	GStaticRecMutex __lock_context;
	ValaMap* source_files;
	BlockLocator* locator;
	AnjutaReport* report;
	ValaProvider* provider;
	ValaParser* parser;
	ValaGenieParser* genie_parser;
	ValaSymbolResolver* resolver;
	ValaSemanticAnalyzer* analyzer;
};


static gpointer vala_plugin_parent_class = NULL;
static GType vala_plugin_type_id = 0;

GType vala_plugin_get_type (void) G_GNUC_CONST;
GType vala_plugin_register_type (GTypeModule * module);
GType block_locator_get_type (void) G_GNUC_CONST;
GType block_locator_register_type (GTypeModule * module);
GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
GType vala_provider_get_type (void) G_GNUC_CONST;
GType vala_provider_register_type (GTypeModule * module);
#define VALA_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_PLUGIN, ValaPluginPrivate))
enum  {
	VALA_PLUGIN_DUMMY_PROPERTY
};
BlockLocator* block_locator_new (void);
BlockLocator* block_locator_construct (GType object_type);
static ValaPlugin* vala_plugin_new (void);
static ValaPlugin* vala_plugin_construct (GType object_type);
static gboolean vala_plugin_real_activate (AnjutaPlugin* base);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void* _lambda0_ (ValaPlugin* self);
gboolean anjuta_report_errors_found (AnjutaReport* self);
static gpointer __lambda0__gthread_func (gpointer self);
ValaProvider* vala_provider_new (ValaPlugin* plugin);
ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin);
void vala_plugin_editor_value_added (ValaPlugin* self, const gchar* name, GValue* value);
void vala_plugin_editor_value_removed (ValaPlugin* self, const gchar* name);
static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base);
void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditorTip* editor, GObject* position, gchar ch);
static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditorTip* _sender, GObject* position, gchar ch, gpointer self);
void anjuta_report_on_hover_over (AnjutaReport* self, IAnjutaEditorHover* editor, GObject* pos);
static void _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over (IAnjutaEditorHover* _sender, GObject* position, gpointer self);
static void _lambda1_ (IAnjutaFileSavable* savable, GObject* gfile, ValaPlugin* self);
static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file);
static void __lambda1__ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GObject* file, gpointer self);
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
#define VALA_PROVIDER_PREF_CALLTIP_ENABLE "cpp-calltip-enable"
void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor);
ValaBlock* vala_plugin_get_current_block (ValaPlugin* self, IAnjutaEditor* editor);
ValaBlock* block_locator_locate (BlockLocator* self, ValaSourceFile* file, gint line, gint column);
GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block);
static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
void anjuta_report_clear_error_indicators (AnjutaReport* self);
static void vala_plugin_finalize (GObject* obj);
GType anjuta_glue_register_components (GTypeModule* module);


static ValaPlugin* vala_plugin_construct (GType object_type) {
	ValaPlugin * self = NULL;
	self = (ValaPlugin*) g_object_new (object_type, NULL);
	return self;
}


static ValaPlugin* vala_plugin_new (void) {
	return vala_plugin_construct (TYPE_VALA_PLUGIN);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void* _lambda0_ (ValaPlugin* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	{
		ValaReport* _tmp0_ = NULL;
		ValaReport* _tmp1_;
		AnjutaReport* _tmp2_;
		AnjutaReport* report;
		ValaParser* _tmp3_ = NULL;
		ValaParser* _tmp4_;
		ValaGenieParser* _tmp5_ = NULL;
		ValaGenieParser* _tmp6_;
		ValaSymbolResolver* _tmp7_ = NULL;
		ValaSymbolResolver* _tmp8_;
		ValaSemanticAnalyzer* _tmp9_ = NULL;
		ValaSemanticAnalyzer* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		vala_code_context_push (self->priv->context);
		_tmp0_ = vala_code_context_get_report (self->priv->context);
		_tmp2_ = _g_object_ref0 ((_tmp1_ = _tmp0_, IS_ANJUTA_REPORT (_tmp1_) ? ((AnjutaReport*) _tmp1_) : NULL));
		report = _tmp2_;
		_tmp3_ = vala_parser_new ();
		_tmp4_ = _tmp3_;
		_vala_code_visitor_unref0 (self->priv->parser);
		self->priv->parser = _tmp4_;
		_tmp5_ = vala_genie_parser_new ();
		_tmp6_ = _tmp5_;
		_vala_code_visitor_unref0 (self->priv->genie_parser);
		self->priv->genie_parser = _tmp6_;
		_tmp7_ = vala_symbol_resolver_new ();
		_tmp8_ = _tmp7_;
		_vala_code_visitor_unref0 (self->priv->resolver);
		self->priv->resolver = _tmp8_;
		_tmp9_ = vala_semantic_analyzer_new ();
		_tmp10_ = _tmp9_;
		_vala_code_visitor_unref0 (self->priv->analyzer);
		self->priv->analyzer = _tmp10_;
		vala_parser_parse (self->priv->parser, self->priv->context);
		vala_genie_parser_parse (self->priv->genie_parser, self->priv->context);
		_tmp11_ = anjuta_report_errors_found (report);
		if (_tmp11_) {
			vala_code_context_pop ();
			result = NULL;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
			_g_object_unref0 (report);
			return result;
		}
		vala_symbol_resolver_resolve (self->priv->resolver, self->priv->context);
		_tmp12_ = anjuta_report_errors_found (report);
		if (_tmp12_) {
			vala_code_context_pop ();
			result = NULL;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
			_g_object_unref0 (report);
			return result;
		}
		vala_semantic_analyzer_analyze (self->priv->analyzer, self->priv->context);
		vala_code_context_pop ();
		_g_object_unref0 (report);
		__finally0:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static gpointer __lambda0__gthread_func (gpointer self) {
	gpointer result;
	result = _lambda0_ (self);
	return result;
}


static gboolean vala_plugin_real_activate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	AnjutaReport* _tmp2_ = NULL;
	AnjutaReport* _tmp3_;
	AnjutaShell* _tmp4_ = NULL;
	AnjutaShell* _tmp5_;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GObject* _tmp8_;
	AnjutaShell* _tmp9_ = NULL;
	AnjutaShell* _tmp10_;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GObject* _tmp13_;
	IAnjutaProjectManager* _tmp14_;
	IAnjutaProjectManager* project;
	GList* _tmp15_ = NULL;
	GList* packages;
	AnjutaShell* _tmp16_ = NULL;
	AnjutaShell* _tmp17_;
	AnjutaStatus* _tmp18_ = NULL;
	AnjutaStatus* _tmp19_;
	AnjutaStatus* _tmp20_;
	AnjutaStatus* status;
	ValaHashMap* _tmp22_ = NULL;
	ValaMap* _tmp23_;
	GList* _tmp24_ = NULL;
	GList* sources;
	void* parse_target = NULL;
	GDestroyNotify parse_target_destroy_notify = NULL;
	GThreadFunc _tmp62_;
	GThreadFunc parse;
	ValaProvider* _tmp63_ = NULL;
	ValaProvider* _tmp64_;
	guint _tmp65_;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	_tmp0_ = vala_code_context_new ();
	_tmp1_ = _tmp0_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = anjuta_report_new ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->report);
	self->priv->report = _tmp3_;
	_tmp5_ = (g_object_get ((AnjutaPlugin*) self, "shell", &_tmp4_, NULL), _tmp4_);
	_tmp6_ = anjuta_shell_get_object (_tmp5_, "IAnjutaDocumentManager", &_inner_error_);
	_tmp8_ = (_tmp7_ = _tmp6_, _g_object_unref0 (_tmp5_), _tmp7_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	anjuta_report_set_docman (self->priv->report, IANJUTA_DOCUMENT_MANAGER (_tmp8_));
	vala_code_context_set_report (self->priv->context, (ValaReport*) self->priv->report);
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	_tmp10_ = (g_object_get ((AnjutaPlugin*) self, "shell", &_tmp9_, NULL), _tmp9_);
	_tmp11_ = anjuta_shell_get_object (_tmp10_, "IAnjutaProjectManager", &_inner_error_);
	_tmp13_ = (_tmp12_ = _tmp11_, _g_object_unref0 (_tmp10_), _tmp12_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp14_ = _g_object_ref0 (IANJUTA_PROJECT_MANAGER (_tmp13_));
	project = _tmp14_;
	_tmp15_ = ianjuta_project_manager_get_packages (project, &_inner_error_);
	packages = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	vala_code_context_add_package (self->priv->context, "glib-2.0");
	vala_code_context_add_package (self->priv->context, "gobject-2.0");
	_tmp17_ = (g_object_get ((AnjutaPlugin*) self, "shell", &_tmp16_, NULL), _tmp16_);
	_tmp18_ = anjuta_shell_get_status (_tmp17_, &_inner_error_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	status = (_tmp20_ = _tmp19_, _g_object_unref0 (_tmp17_), _tmp20_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		GList* pkg_collection;
		GList* pkg_it;
		pkg_collection = packages;
		for (pkg_it = pkg_collection; pkg_it != NULL; pkg_it = pkg_it->next) {
			gchar* _tmp21_;
			gchar* pkg;
			_tmp21_ = g_strdup ((const gchar*) pkg_it->data);
			pkg = _tmp21_;
			{
				vala_code_context_add_package (self->priv->context, pkg);
				_g_free0 (pkg);
			}
		}
	}
	_tmp22_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, vala_source_file_unref, g_str_hash, g_str_equal, g_direct_equal);
	_tmp23_ = (ValaMap*) _tmp22_;
	_vala_map_unref0 (self->priv->source_files);
	self->priv->source_files = _tmp23_;
	_tmp24_ = ianjuta_project_manager_get_elements (project, ANJUTA_PROJECT_SOURCE, &_inner_error_);
	sources = _tmp24_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (status);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		GList* src_collection;
		GList* src_it;
		src_collection = sources;
		for (src_it = src_collection; src_it != NULL; src_it = src_it->next) {
			GFile* _tmp25_;
			GFile* src;
			_tmp25_ = _g_object_ref0 ((GFile*) src_it->data);
			src = _tmp25_;
			{
				gboolean _tmp26_ = FALSE;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gboolean _tmp29_;
				_tmp27_ = g_file_get_path (src);
				_tmp28_ = _tmp27_;
				if ((_tmp29_ = _tmp28_ != NULL, _g_free0 (_tmp28_), _tmp29_)) {
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gboolean _tmp32_;
					_tmp30_ = g_file_get_path (src);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_map_contains (self->priv->source_files, _tmp31_);
					_tmp26_ = !_tmp32_;
					_g_free0 (_tmp31_);
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					gboolean _tmp33_ = FALSE;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_;
					gboolean _tmp36_;
					gboolean _tmp37_;
					_tmp34_ = g_file_get_basename (src);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_str_has_suffix (_tmp35_, "vala");
					if ((_tmp37_ = _tmp36_, _g_free0 (_tmp35_), _tmp37_)) {
						_tmp33_ = TRUE;
					} else {
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_;
						gboolean _tmp40_;
						_tmp38_ = g_file_get_basename (src);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_str_has_suffix (_tmp39_, "gs");
						_tmp33_ = _tmp40_;
						_g_free0 (_tmp39_);
					}
					if (_tmp33_) {
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_;
						ValaSourceFile* _tmp43_ = NULL;
						ValaSourceFile* _tmp44_;
						ValaSourceFile* vsrc;
						ValaUnresolvedSymbol* _tmp45_ = NULL;
						ValaUnresolvedSymbol* _tmp46_;
						ValaUsingDirective* _tmp47_ = NULL;
						ValaUsingDirective* _tmp48_;
						ValaUsingDirective* ns_ref;
						ValaNamespace* _tmp49_ = NULL;
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_;
						_tmp41_ = g_file_get_path (src);
						_tmp42_ = _tmp41_;
						_tmp43_ = vala_source_file_new (self->priv->context, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp42_, NULL);
						vsrc = (_tmp44_ = _tmp43_, _g_free0 (_tmp42_), _tmp44_);
						vala_code_context_add_source_file (self->priv->context, vsrc);
						_tmp45_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
						_tmp46_ = _tmp45_;
						_tmp47_ = vala_using_directive_new ((ValaSymbol*) _tmp46_, NULL);
						ns_ref = (_tmp48_ = _tmp47_, _vala_code_node_unref0 (_tmp46_), _tmp48_);
						vala_source_file_add_using_directive (vsrc, ns_ref);
						_tmp49_ = vala_code_context_get_root (self->priv->context);
						vala_namespace_add_using_directive (_tmp49_, ns_ref);
						_tmp50_ = g_file_get_path (src);
						_tmp51_ = _tmp50_;
						vala_map_set (self->priv->source_files, _tmp51_, vsrc);
						_g_free0 (_tmp51_);
						_vala_code_node_unref0 (ns_ref);
						_vala_source_file_unref0 (vsrc);
					} else {
						gchar* _tmp52_ = NULL;
						gchar* _tmp53_;
						gboolean _tmp54_;
						gboolean _tmp55_;
						_tmp52_ = g_file_get_basename (src);
						_tmp53_ = _tmp52_;
						_tmp54_ = g_str_has_suffix (_tmp53_, "vapi");
						if ((_tmp55_ = _tmp54_, _g_free0 (_tmp53_), _tmp55_)) {
							gchar* _tmp56_ = NULL;
							gchar* _tmp57_;
							ValaSourceFile* _tmp58_ = NULL;
							ValaSourceFile* _tmp59_;
							ValaSourceFile* vsrc;
							gchar* _tmp60_ = NULL;
							gchar* _tmp61_;
							_tmp56_ = g_file_get_path (src);
							_tmp57_ = _tmp56_;
							_tmp58_ = vala_source_file_new (self->priv->context, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp57_, NULL);
							vsrc = (_tmp59_ = _tmp58_, _g_free0 (_tmp57_), _tmp59_);
							vala_code_context_add_source_file (self->priv->context, vsrc);
							_tmp60_ = g_file_get_path (src);
							_tmp61_ = _tmp60_;
							vala_map_set (self->priv->source_files, _tmp61_, vsrc);
							_g_free0 (_tmp61_);
							_vala_source_file_unref0 (vsrc);
						}
					}
				}
				_g_object_unref0 (src);
			}
		}
	}
	_tmp62_ = __lambda0__gthread_func;
	parse_target = g_object_ref (self);
	parse_target_destroy_notify = g_object_unref;
	parse = _tmp62_;
	g_thread_create (parse, parse_target, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_THREAD_ERROR) {
			goto __catch1_g_thread_error;
		}
		(parse_target_destroy_notify == NULL) ? NULL : (parse_target_destroy_notify (parse_target), NULL);
		parse = NULL;
		parse_target = NULL;
		parse_target_destroy_notify = NULL;
		_g_object_unref0 (status);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_debug ("plugin.vala:109: Using threads");
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		parse (parse_target);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		(parse_target_destroy_notify == NULL) ? NULL : (parse_target_destroy_notify (parse_target), NULL);
		parse = NULL;
		parse_target = NULL;
		parse_target_destroy_notify = NULL;
		_g_object_unref0 (status);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp63_ = vala_provider_new (self);
	_tmp64_ = _tmp63_;
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = _tmp64_;
	_tmp65_ = anjuta_plugin_add_watch ((AnjutaPlugin*) self, "document_manager_current_document", (AnjutaPluginValueAdded) vala_plugin_editor_value_added, (AnjutaPluginValueRemoved) vala_plugin_editor_value_removed, self);
	self->priv->editor_watch_id = _tmp65_;
	result = TRUE;
	(parse_target_destroy_notify == NULL) ? NULL : (parse_target_destroy_notify (parse_target), NULL);
	parse = NULL;
	parse_target = NULL;
	parse_target_destroy_notify = NULL;
	_g_object_unref0 (status);
	_g_object_unref0 (project);
	return result;
}


static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	anjuta_plugin_remove_watch ((AnjutaPlugin*) self, self->priv->editor_watch_id, TRUE);
	{
		ValaCodeContext* _tmp0_;
		ValaMap* _tmp1_;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		_tmp0_ = NULL;
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp0_;
		_tmp1_ = NULL;
		_vala_map_unref0 (self->priv->source_files);
		self->priv->source_files = _tmp1_;
		__finally2:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditorTip* _sender, GObject* position, gchar ch, gpointer self) {
	vala_plugin_on_char_added (self, _sender, position, ch);
}


static void _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over (IAnjutaEditorHover* _sender, GObject* position, gpointer self) {
	anjuta_report_on_hover_over (self, _sender, position);
}


static void _lambda1_ (IAnjutaFileSavable* savable, GObject* gfile, ValaPlugin* self) {
	GFile* _tmp0_;
	GFile* file;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gpointer _tmp3_ = NULL;
	ValaSourceFile* _tmp4_;
	ValaSourceFile* source_file;
	gchar* contents;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (savable != NULL);
	g_return_if_fail (gfile != NULL);
	_tmp0_ = _g_object_ref0 (G_FILE (gfile));
	file = _tmp0_;
	_tmp1_ = g_file_get_path (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_map_get (self->priv->source_files, _tmp2_);
	source_file = (_tmp4_ = (ValaSourceFile*) _tmp3_, _g_free0 (_tmp2_), _tmp4_);
	contents = NULL;
	g_file_load_contents (file, NULL, &_tmp5_, NULL, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp5_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		_vala_source_file_unref0 (source_file);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	vala_source_file_set_content (source_file, contents);
	vala_plugin_update_file (self, source_file);
	_g_free0 (contents);
	_vala_source_file_unref0 (source_file);
	_g_object_unref0 (file);
}


static void __lambda1__ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GObject* file, gpointer self) {
	_lambda1_ (_sender, file, self);
}


void vala_plugin_editor_value_added (ValaPlugin* self, const gchar* name, GValue* value) {
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_assert (self->current_editor == NULL);
	_tmp0_ = g_value_get_object (value);
	g_assert (IANJUTA_IS_EDITOR (_tmp0_));
	_tmp1_ = g_value_get_object (value);
	self->current_editor = (_tmp2_ = _tmp1_, IANJUTA_IS_EDITOR (_tmp2_) ? ((IAnjutaEditor*) _tmp2_) : NULL);
	if (self->current_editor != NULL) {
		if (IANJUTA_IS_EDITOR_ASSIST (self->current_editor)) {
			IAnjutaEditor* _tmp3_;
			ianjuta_editor_assist_add ((_tmp3_ = self->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp3_) ? ((IAnjutaEditorAssist*) _tmp3_) : NULL), (IAnjutaProvider*) self->priv->provider, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (IANJUTA_IS_EDITOR_TIP (self->current_editor)) {
			IAnjutaEditor* _tmp4_;
			g_signal_connect_object ((IAnjutaEditor*) (_tmp4_ = self->current_editor, IANJUTA_IS_EDITOR_TIP (_tmp4_) ? ((IAnjutaEditorTip*) _tmp4_) : NULL), "char-added", (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self, 0);
		}
		if (IANJUTA_IS_EDITOR_HOVER (self->current_editor)) {
			IAnjutaEditor* _tmp5_;
			g_signal_connect_object ((_tmp5_ = self->current_editor, IANJUTA_IS_EDITOR_HOVER (_tmp5_) ? ((IAnjutaEditorHover*) _tmp5_) : NULL), "hover-over", (GCallback) _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over, self->priv->report, 0);
		}
		if (IANJUTA_IS_FILE_SAVABLE (self->current_editor)) {
			IAnjutaFileSavable* _tmp6_;
			IAnjutaFileSavable* file_savable;
			_tmp6_ = _g_object_ref0 (IANJUTA_FILE_SAVABLE (self->current_editor));
			file_savable = _tmp6_;
			g_signal_connect_object (file_savable, "saved", (GCallback) __lambda1__ianjuta_file_savable_saved, self, 0);
			_g_object_unref0 (file_savable);
		}
	}
	anjuta_report_update_errors (self->priv->report, self->current_editor);
}


void vala_plugin_editor_value_removed (ValaPlugin* self, const gchar* name) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (IANJUTA_IS_EDITOR_ASSIST (self->current_editor)) {
		IAnjutaEditor* _tmp0_;
		ianjuta_editor_assist_remove ((_tmp0_ = self->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp0_) ? ((IAnjutaEditorAssist*) _tmp0_) : NULL), (IAnjutaProvider*) self->priv->provider, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (IANJUTA_IS_EDITOR_TIP (self->current_editor)) {
		IAnjutaEditor* _tmp1_;
		guint _tmp2_;
		g_signal_parse_name ("char-added", IANJUTA_TYPE_EDITOR, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((IAnjutaEditor*) (_tmp1_ = self->current_editor, IANJUTA_IS_EDITOR_TIP (_tmp1_) ? ((IAnjutaEditorTip*) _tmp1_) : NULL), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self);
	}
	if (IANJUTA_IS_EDITOR_HOVER (self->current_editor)) {
		IAnjutaEditor* _tmp3_;
		guint _tmp4_;
		g_signal_parse_name ("hover-over", IANJUTA_TYPE_EDITOR_HOVER, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((_tmp3_ = self->current_editor, IANJUTA_IS_EDITOR_HOVER (_tmp3_) ? ((IAnjutaEditorHover*) _tmp3_) : NULL), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over, self->priv->report);
	}
	if (IANJUTA_IS_FILE_SAVABLE (self->current_editor)) {
		guint _tmp5_;
		_tmp5_ = g_signal_handlers_disconnect_matched (self->current_editor, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
		g_assert (_tmp5_ == 1);
	}
	self->current_editor = NULL;
}


void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditorTip* editor, GObject* position, gchar ch) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	_tmp0_ = g_settings_get_boolean (self->settings, VALA_PROVIDER_PREF_CALLTIP_ENABLE);
	if (!_tmp0_) {
		return;
	}
	if (ch == '(') {
		vala_provider_show_call_tip (self->priv->provider, editor);
	} else {
		if (ch == ')') {
			ianjuta_editor_tip_cancel (editor, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


ValaBlock* vala_plugin_get_current_block (ValaPlugin* self, IAnjutaEditor* editor) {
	ValaBlock* result = NULL;
	IAnjutaEditor* _tmp0_;
	IAnjutaFile* _tmp1_;
	IAnjutaFile* file;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	g_return_val_if_fail (IANJUTA_IS_FILE (editor), NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = editor, IANJUTA_IS_FILE (_tmp0_) ? ((IAnjutaFile*) _tmp0_) : NULL));
	file = _tmp1_;
	_tmp2_ = ianjuta_file_get_file (file, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_file_get_path (_tmp3_);
	path = _tmp4_;
	{
		gboolean _tmp5_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gpointer _tmp13_ = NULL;
		ValaSourceFile* _tmp14_;
		ValaBlock* _tmp15_ = NULL;
		ValaBlock* _tmp16_;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		_tmp5_ = vala_map_contains (self->priv->source_files, path);
		if (!_tmp5_) {
			ValaSourceFileType _tmp6_ = 0;
			gboolean _tmp7_;
			ValaSourceFile* _tmp8_ = NULL;
			ValaSourceFile* src;
			_tmp7_ = g_str_has_suffix (path, "vapi");
			if (_tmp7_) {
				_tmp6_ = VALA_SOURCE_FILE_TYPE_PACKAGE;
			} else {
				_tmp6_ = VALA_SOURCE_FILE_TYPE_SOURCE;
			}
			_tmp8_ = vala_source_file_new (self->priv->context, _tmp6_, path, NULL);
			src = _tmp8_;
			vala_code_context_add_source_file (self->priv->context, src);
			vala_map_set (self->priv->source_files, path, src);
			vala_plugin_update_file (self, src);
			_vala_source_file_unref0 (src);
		}
		_tmp9_ = ianjuta_editor_get_lineno (editor, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __finally4;
		}
		_tmp11_ = ianjuta_editor_get_column (editor, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __finally4;
		}
		_tmp13_ = vala_map_get (self->priv->source_files, path);
		_tmp14_ = (ValaSourceFile*) _tmp13_;
		_tmp15_ = block_locator_locate (self->priv->locator, _tmp14_, _tmp10_, _tmp12_);
		result = (_tmp16_ = _tmp15_, _vala_source_file_unref0 (_tmp14_), _tmp16_);
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		_g_free0 (path);
		_g_object_unref0 (file);
		return result;
		__finally4:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		_g_free0 (path);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	_g_object_unref0 (file);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block) {
	GList* result = NULL;
	GList* matching_symbols;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (block != NULL, NULL);
	matching_symbols = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		if (inner == NULL) {
			{
				ValaSymbol* _tmp0_;
				ValaSymbol* sym;
				_tmp0_ = _vala_code_node_ref0 (VALA_SYMBOL (block));
				sym = _tmp0_;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						GList* _tmp5_ = NULL;
						if (!_tmp1_) {
							ValaSymbol* _tmp2_ = NULL;
							ValaSymbol* _tmp3_;
							ValaSymbol* _tmp4_;
							_tmp2_ = vala_symbol_get_parent_symbol (sym);
							_tmp3_ = _vala_code_node_ref0 (_tmp2_);
							_tmp4_ = _tmp3_;
							_vala_code_node_unref0 (sym);
							sym = _tmp4_;
						}
						_tmp1_ = FALSE;
						if (!(sym != NULL)) {
							break;
						}
						_tmp5_ = vala_plugin_symbol_lookup_inherited (self, sym, name, prefix_match, FALSE);
						matching_symbols = g_list_concat (matching_symbols, _tmp5_);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			{
				ValaSourceReference* _tmp6_ = NULL;
				ValaSourceFile* _tmp7_ = NULL;
				ValaList* _tmp8_ = NULL;
				ValaList* _tmp9_;
				ValaList* _ns_list;
				gint _tmp10_;
				gint _ns_size;
				gint _ns_index;
				_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) block);
				_tmp7_ = vala_source_reference_get_file (_tmp6_);
				_tmp8_ = vala_source_file_get_current_using_directives (_tmp7_);
				_tmp9_ = _vala_iterable_ref0 (_tmp8_);
				_ns_list = _tmp9_;
				_tmp10_ = vala_collection_get_size ((ValaCollection*) _ns_list);
				_ns_size = _tmp10_;
				_ns_index = -1;
				while (TRUE) {
					gpointer _tmp11_ = NULL;
					ValaUsingDirective* ns;
					ValaSymbol* _tmp12_ = NULL;
					GList* _tmp13_ = NULL;
					_ns_index = _ns_index + 1;
					if (!(_ns_index < _ns_size)) {
						break;
					}
					_tmp11_ = vala_list_get (_ns_list, _ns_index);
					ns = (ValaUsingDirective*) _tmp11_;
					_tmp12_ = vala_using_directive_get_namespace_symbol (ns);
					_tmp13_ = vala_plugin_symbol_lookup_inherited (self, _tmp12_, name, prefix_match, FALSE);
					matching_symbols = g_list_concat (matching_symbols, _tmp13_);
					_vala_code_node_unref0 (ns);
				}
				_vala_iterable_unref0 (_ns_list);
			}
		} else {
			ValaSymbol* _tmp14_ = NULL;
			_tmp14_ = vala_expression_get_symbol_reference (inner);
			if (_tmp14_ != NULL) {
				ValaSymbol* _tmp15_ = NULL;
				GList* _tmp16_ = NULL;
				_tmp15_ = vala_expression_get_symbol_reference (inner);
				_tmp16_ = vala_plugin_symbol_lookup_inherited (self, _tmp15_, name, prefix_match, FALSE);
				matching_symbols = g_list_concat (matching_symbols, _tmp16_);
			} else {
				if (VALA_IS_MEMBER_ACCESS (inner)) {
					ValaMemberAccess* _tmp17_;
					ValaMemberAccess* inner_ma;
					ValaExpression* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					GList* _tmp20_ = NULL;
					GList* matching;
					_tmp17_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (inner));
					inner_ma = _tmp17_;
					_tmp18_ = vala_member_access_get_inner (inner_ma);
					_tmp19_ = vala_member_access_get_member_name (inner_ma);
					_tmp20_ = vala_plugin_lookup_symbol (self, _tmp18_, _tmp19_, FALSE, block);
					matching = _tmp20_;
					if (matching != NULL) {
						GList* _tmp21_ = NULL;
						_tmp21_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) matching->data, name, prefix_match, FALSE);
						matching_symbols = g_list_concat (matching_symbols, _tmp21_);
					}
					__g_list_free__vala_code_node_unref0_0 (matching);
					_vala_code_node_unref0 (inner_ma);
				} else {
					if (VALA_IS_METHOD_CALL (inner)) {
						ValaMethodCall* _tmp22_;
						ValaMethodCall* inner_inv;
						ValaExpression* _tmp23_ = NULL;
						ValaExpression* _tmp24_;
						ValaMemberAccess* _tmp25_;
						ValaMemberAccess* inner_ma;
						_tmp22_ = _vala_code_node_ref0 (VALA_METHOD_CALL (inner));
						inner_inv = _tmp22_;
						_tmp23_ = vala_method_call_get_call (inner_inv);
						_tmp25_ = _vala_code_node_ref0 ((_tmp24_ = _tmp23_, VALA_IS_MEMBER_ACCESS (_tmp24_) ? ((ValaMemberAccess*) _tmp24_) : NULL));
						inner_ma = _tmp25_;
						if (inner_ma != NULL) {
							ValaExpression* _tmp26_ = NULL;
							const gchar* _tmp27_ = NULL;
							GList* _tmp28_ = NULL;
							GList* matching;
							_tmp26_ = vala_member_access_get_inner (inner_ma);
							_tmp27_ = vala_member_access_get_member_name (inner_ma);
							_tmp28_ = vala_plugin_lookup_symbol (self, _tmp26_, _tmp27_, FALSE, block);
							matching = _tmp28_;
							if (matching != NULL) {
								GList* _tmp29_ = NULL;
								_tmp29_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) matching->data, name, prefix_match, TRUE);
								matching_symbols = g_list_concat (matching_symbols, _tmp29_);
							}
							__g_list_free__vala_code_node_unref0_0 (matching);
						}
						_vala_code_node_unref0 (inner_ma);
						_vala_code_node_unref0 (inner_inv);
					}
				}
			}
		}
		__finally5:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			__g_list_free__vala_code_node_unref0_0 (matching_symbols);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = matching_symbols;
	return result;
}


static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation) {
	GList* result = NULL;
	GList* _result_;
	ValaScope* _tmp0_ = NULL;
	ValaMap* _tmp1_ = NULL;
	ValaMap* symbol_table;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = NULL;
	if (sym == NULL) {
		result = _result_;
		return result;
	}
	_tmp0_ = vala_symbol_get_scope (sym);
	_tmp1_ = vala_scope_get_symbol_table (_tmp0_);
	symbol_table = _tmp1_;
	if (symbol_table != NULL) {
		{
			ValaSet* _tmp2_ = NULL;
			ValaSet* _tmp3_;
			ValaIterator* _tmp4_ = NULL;
			ValaIterator* _tmp5_;
			ValaIterator* _key_it;
			_tmp2_ = vala_map_get_keys (symbol_table);
			_tmp3_ = _tmp2_;
			_tmp4_ = vala_iterable_iterator ((ValaIterable*) _tmp3_);
			_key_it = (_tmp5_ = _tmp4_, _vala_iterable_unref0 (_tmp3_), _tmp5_);
			while (TRUE) {
				gboolean _tmp6_;
				gpointer _tmp7_ = NULL;
				gchar* key;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				_tmp6_ = vala_iterator_next (_key_it);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = vala_iterator_get (_key_it);
				key = (gchar*) _tmp7_;
				if (prefix_match) {
					gboolean _tmp10_;
					_tmp10_ = g_str_has_prefix (key, name);
					_tmp9_ = _tmp10_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = g_strcmp0 (key, name) == 0;
				}
				if (_tmp8_) {
					gpointer _tmp11_ = NULL;
					_tmp11_ = vala_map_get (symbol_table, key);
					_result_ = g_list_append (_result_, (ValaSymbol*) _tmp11_);
				}
				_g_free0 (key);
			}
			_vala_iterator_unref0 (_key_it);
		}
	}
	if (invocation) {
		_tmp12_ = VALA_IS_METHOD (sym);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaMethod* _tmp13_;
		ValaMethod* func;
		ValaDataType* _tmp14_ = NULL;
		ValaTypeSymbol* _tmp15_ = NULL;
		GList* _tmp16_ = NULL;
		_tmp13_ = _vala_code_node_ref0 (VALA_METHOD (sym));
		func = _tmp13_;
		_tmp14_ = vala_method_get_return_type (func);
		_tmp15_ = vala_data_type_get_data_type (_tmp14_);
		_tmp16_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp15_, name, prefix_match, FALSE);
		_result_ = g_list_concat (_result_, _tmp16_);
		_vala_code_node_unref0 (func);
	} else {
		if (VALA_IS_CLASS (sym)) {
			ValaClass* _tmp17_;
			ValaClass* cl;
			_tmp17_ = _vala_code_node_ref0 (VALA_CLASS (sym));
			cl = _tmp17_;
			{
				ValaList* _tmp18_ = NULL;
				ValaList* _base_type_list;
				gint _tmp19_;
				gint _base_type_size;
				gint _base_type_index;
				_tmp18_ = vala_class_get_base_types (cl);
				_base_type_list = _tmp18_;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
				_base_type_size = _tmp19_;
				_base_type_index = -1;
				while (TRUE) {
					gpointer _tmp20_ = NULL;
					ValaDataType* base_type;
					ValaTypeSymbol* _tmp21_ = NULL;
					GList* _tmp22_ = NULL;
					_base_type_index = _base_type_index + 1;
					if (!(_base_type_index < _base_type_size)) {
						break;
					}
					_tmp20_ = vala_list_get (_base_type_list, _base_type_index);
					base_type = (ValaDataType*) _tmp20_;
					_tmp21_ = vala_data_type_get_data_type (base_type);
					_tmp22_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp21_, name, prefix_match, FALSE);
					_result_ = g_list_concat (_result_, _tmp22_);
					_vala_code_node_unref0 (base_type);
				}
				_vala_iterable_unref0 (_base_type_list);
			}
			_vala_code_node_unref0 (cl);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaStruct* _tmp23_;
				ValaStruct* st;
				ValaDataType* _tmp24_ = NULL;
				ValaTypeSymbol* _tmp25_ = NULL;
				GList* _tmp26_ = NULL;
				_tmp23_ = _vala_code_node_ref0 (VALA_STRUCT (sym));
				st = _tmp23_;
				_tmp24_ = vala_struct_get_base_type (st);
				_tmp25_ = vala_data_type_get_data_type (_tmp24_);
				_tmp26_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp25_, name, prefix_match, FALSE);
				_result_ = g_list_concat (_result_, _tmp26_);
				_vala_code_node_unref0 (st);
			} else {
				if (VALA_IS_INTERFACE (sym)) {
					ValaInterface* _tmp27_;
					ValaInterface* iface;
					_tmp27_ = _vala_code_node_ref0 (VALA_INTERFACE (sym));
					iface = _tmp27_;
					{
						ValaList* _tmp28_ = NULL;
						ValaList* _prerequisite_list;
						gint _tmp29_;
						gint _prerequisite_size;
						gint _prerequisite_index;
						_tmp28_ = vala_interface_get_prerequisites (iface);
						_prerequisite_list = _tmp28_;
						_tmp29_ = vala_collection_get_size ((ValaCollection*) _prerequisite_list);
						_prerequisite_size = _tmp29_;
						_prerequisite_index = -1;
						while (TRUE) {
							gpointer _tmp30_ = NULL;
							ValaDataType* prerequisite;
							ValaTypeSymbol* _tmp31_ = NULL;
							GList* _tmp32_ = NULL;
							_prerequisite_index = _prerequisite_index + 1;
							if (!(_prerequisite_index < _prerequisite_size)) {
								break;
							}
							_tmp30_ = vala_list_get (_prerequisite_list, _prerequisite_index);
							prerequisite = (ValaDataType*) _tmp30_;
							_tmp31_ = vala_data_type_get_data_type (prerequisite);
							_tmp32_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp31_, name, prefix_match, FALSE);
							_result_ = g_list_concat (_result_, _tmp32_);
							_vala_code_node_unref0 (prerequisite);
						}
						_vala_iterable_unref0 (_prerequisite_list);
					}
					_vala_code_node_unref0 (iface);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (sym)) {
						ValaLocalVariable* _tmp33_;
						ValaLocalVariable* variable;
						ValaDataType* _tmp34_ = NULL;
						ValaTypeSymbol* _tmp35_ = NULL;
						GList* _tmp36_ = NULL;
						_tmp33_ = _vala_code_node_ref0 (VALA_LOCAL_VARIABLE (sym));
						variable = _tmp33_;
						_tmp34_ = vala_variable_get_variable_type ((ValaVariable*) variable);
						_tmp35_ = vala_data_type_get_data_type (_tmp34_);
						_tmp36_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp35_, name, prefix_match, FALSE);
						_result_ = g_list_concat (_result_, _tmp36_);
						_vala_code_node_unref0 (variable);
					} else {
						if (VALA_IS_FIELD (sym)) {
							ValaField* _tmp37_;
							ValaField* field;
							ValaDataType* _tmp38_ = NULL;
							ValaTypeSymbol* _tmp39_ = NULL;
							GList* _tmp40_ = NULL;
							_tmp37_ = _vala_code_node_ref0 (VALA_FIELD (sym));
							field = _tmp37_;
							_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) field);
							_tmp39_ = vala_data_type_get_data_type (_tmp38_);
							_tmp40_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp39_, name, prefix_match, FALSE);
							_result_ = g_list_concat (_result_, _tmp40_);
							_vala_code_node_unref0 (field);
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								ValaProperty* _tmp41_;
								ValaProperty* prop;
								ValaDataType* _tmp42_ = NULL;
								ValaTypeSymbol* _tmp43_ = NULL;
								GList* _tmp44_ = NULL;
								_tmp41_ = _vala_code_node_ref0 (VALA_PROPERTY (sym));
								prop = _tmp41_;
								_tmp42_ = vala_property_get_property_type (prop);
								_tmp43_ = vala_data_type_get_data_type (_tmp42_);
								_tmp44_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp43_, name, prefix_match, FALSE);
								_result_ = g_list_concat (_result_, _tmp44_);
								_vala_code_node_unref0 (prop);
							} else {
								if (VALA_IS_PARAMETER (sym)) {
									ValaParameter* _tmp45_;
									ValaParameter* fp;
									ValaDataType* _tmp46_ = NULL;
									ValaTypeSymbol* _tmp47_ = NULL;
									GList* _tmp48_ = NULL;
									_tmp45_ = _vala_code_node_ref0 (VALA_PARAMETER (sym));
									fp = _tmp45_;
									_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) fp);
									_tmp47_ = vala_data_type_get_data_type (_tmp46_);
									_tmp48_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp47_, name, prefix_match, FALSE);
									_result_ = g_list_concat (_result_, _tmp48_);
									_vala_code_node_unref0 (fp);
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	_vala_map_unref0 (symbol_table);
	return result;
}


static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		ValaArrayList* _tmp0_ = NULL;
		ValaArrayList* nodes;
		ValaArrayList* _tmp12_ = NULL;
		ValaArrayList* _tmp13_;
		ValaUnresolvedSymbol* _tmp14_ = NULL;
		ValaUnresolvedSymbol* _tmp15_;
		ValaUsingDirective* _tmp16_ = NULL;
		ValaUsingDirective* _tmp17_;
		ValaUsingDirective* ns_ref;
		ValaNamespace* _tmp18_ = NULL;
		gboolean _tmp19_;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		_tmp0_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
		nodes = _tmp0_;
		{
			ValaList* _tmp1_ = NULL;
			ValaList* _node_list;
			gint _tmp2_;
			gint _node_size;
			gint _node_index;
			_tmp1_ = vala_source_file_get_nodes (file);
			_node_list = _tmp1_;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _node_list);
			_node_size = _tmp2_;
			_node_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				ValaCodeNode* node;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp3_ = vala_list_get (_node_list, _node_index);
				node = (ValaCodeNode*) _tmp3_;
				vala_collection_add ((ValaCollection*) nodes, node);
				_vala_code_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		{
			ValaArrayList* _tmp4_;
			ValaArrayList* _node_list;
			gint _tmp5_;
			gint _node_size;
			gint _node_index;
			_tmp4_ = _vala_iterable_ref0 (nodes);
			_node_list = _tmp4_;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _node_list);
			_node_size = _tmp5_;
			_node_index = -1;
			while (TRUE) {
				gpointer _tmp6_ = NULL;
				ValaCodeNode* node;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp6_ = vala_list_get ((ValaList*) _node_list, _node_index);
				node = (ValaCodeNode*) _tmp6_;
				vala_source_file_remove_node (file, node);
				if (VALA_IS_SYMBOL (node)) {
					ValaSymbol* _tmp7_;
					ValaSymbol* sym;
					ValaScope* _tmp8_ = NULL;
					ValaMethod* _tmp11_ = NULL;
					_tmp7_ = _vala_code_node_ref0 (VALA_SYMBOL (node));
					sym = _tmp7_;
					_tmp8_ = vala_symbol_get_owner (sym);
					if (_tmp8_ != NULL) {
						ValaScope* _tmp9_ = NULL;
						const gchar* _tmp10_ = NULL;
						_tmp9_ = vala_symbol_get_owner (sym);
						_tmp10_ = vala_symbol_get_name (sym);
						vala_scope_remove (_tmp9_, _tmp10_);
					}
					_tmp11_ = vala_code_context_get_entry_point (self->priv->context);
					if (VALA_SYMBOL (_tmp11_) == sym) {
						vala_code_context_set_entry_point (self->priv->context, NULL);
					}
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		_tmp12_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
		_tmp13_ = _tmp12_;
		vala_source_file_set_current_using_directives (file, (ValaList*) _tmp13_);
		_vala_iterable_unref0 (_tmp13_);
		_tmp14_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_using_directive_new ((ValaSymbol*) _tmp15_, NULL);
		ns_ref = (_tmp17_ = _tmp16_, _vala_code_node_unref0 (_tmp15_), _tmp17_);
		vala_source_file_add_using_directive (file, ns_ref);
		_tmp18_ = vala_code_context_get_root (self->priv->context);
		vala_namespace_add_using_directive (_tmp18_, ns_ref);
		anjuta_report_clear_error_indicators (self->priv->report);
		vala_code_context_push (self->priv->context);
		vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->parser, file);
		vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->genie_parser, file);
		_tmp19_ = anjuta_report_errors_found (self->priv->report);
		if (!_tmp19_) {
			gboolean _tmp20_;
			vala_symbol_resolver_resolve (self->priv->resolver, self->priv->context);
			_tmp20_ = anjuta_report_errors_found (self->priv->report);
			if (!_tmp20_) {
				vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->analyzer, file);
			}
		}
		vala_code_context_pop ();
		anjuta_report_update_errors (self->priv->report, self->current_editor);
		_vala_code_node_unref0 (ns_ref);
		_vala_iterable_unref0 (nodes);
		__finally6:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void vala_plugin_class_init (ValaPluginClass * klass) {
	vala_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPluginPrivate));
	ANJUTA_PLUGIN_CLASS (klass)->activate = vala_plugin_real_activate;
	ANJUTA_PLUGIN_CLASS (klass)->deactivate = vala_plugin_real_deactivate;
	G_OBJECT_CLASS (klass)->finalize = vala_plugin_finalize;
}


static void vala_plugin_instance_init (ValaPlugin * self) {
	GSettings* _tmp0_ = NULL;
	BlockLocator* _tmp1_ = NULL;
	self->priv = VALA_PLUGIN_GET_PRIVATE (self);
	_tmp0_ = g_settings_new ("org.gnome.anjuta.cpp");
	self->settings = _tmp0_;
	g_static_rec_mutex_init (&self->priv->__lock_context);
	_tmp1_ = block_locator_new ();
	self->priv->locator = _tmp1_;
}


static void vala_plugin_finalize (GObject* obj) {
	ValaPlugin * self;
	self = VALA_PLUGIN (obj);
	_g_object_unref0 (self->settings);
	g_static_rec_mutex_free (&self->priv->__lock_context);
	_vala_code_context_unref0 (self->priv->context);
	_vala_map_unref0 (self->priv->source_files);
	_vala_code_visitor_unref0 (self->priv->locator);
	_g_object_unref0 (self->priv->report);
	_g_object_unref0 (self->priv->provider);
	_vala_code_visitor_unref0 (self->priv->parser);
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	_vala_code_visitor_unref0 (self->priv->resolver);
	_vala_code_visitor_unref0 (self->priv->analyzer);
	G_OBJECT_CLASS (vala_plugin_parent_class)->finalize (obj);
}


GType vala_plugin_get_type (void) {
	return vala_plugin_type_id;
}


GType vala_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ValaPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPlugin), 0, (GInstanceInitFunc) vala_plugin_instance_init, NULL };
	vala_plugin_type_id = g_type_module_register_type (module, ANJUTA_TYPE_PLUGIN, "ValaPlugin", &g_define_type_info, 0);
	return vala_plugin_type_id;
}


GType anjuta_glue_register_components (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	block_locator_register_type (module);
	vala_plugin_register_type (module);
	vala_provider_register_type (module);
	anjuta_report_register_type (module);
	result = TYPE_VALA_PLUGIN;
	return result;
}



