/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-provider.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-provider
 * @title: IAnjutaProvider
 * @short_description: Provider for autocompletion features
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-provider.h
 */

#include "ianjuta-provider.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_provider_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-provider-quark");
	}
	
	return quark;
}

/**
 * ianjuta_provider_activate:
 * @obj: Self
 * @iter: position where the completion occurs
 * @data: data assigned to the proposal
 * @err: Error propagation and reporting.
 *
 * Show completion for the context at position @iter
 */
void
ianjuta_provider_activate (IAnjutaProvider *obj, IAnjutaIterable* iter,   gpointer data, GError **err)
{
	g_return_if_fail (IANJUTA_IS_PROVIDER(obj));
	g_return_if_fail ((iter == NULL) ||IANJUTA_IS_ITERABLE(iter));
	g_return_if_fail (data != NULL);
	IANJUTA_PROVIDER_GET_IFACE (obj)->activate (obj, iter, data, err);
}

/* Default implementation */
static void
ianjuta_provider_activate_default (IAnjutaProvider *obj, IAnjutaIterable* iter,   gpointer data, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_provider_get_name:
 * @obj: Self
 *
 * Return a (translatable) name for the provider
 */
const gchar*
ianjuta_provider_get_name (IAnjutaProvider *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROVIDER(obj), NULL);
	return IANJUTA_PROVIDER_GET_IFACE (obj)->get_name (obj, err);
}

/* Default implementation */
static const gchar*
ianjuta_provider_get_name_default (IAnjutaProvider *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_provider_get_start_iter:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Get the iter where the current completion started
 *
 * Returns: (transfer none): current start iter
 */
IAnjutaIterable*
ianjuta_provider_get_start_iter (IAnjutaProvider *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROVIDER(obj), NULL);
	return IANJUTA_PROVIDER_GET_IFACE (obj)->get_start_iter (obj, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_provider_get_start_iter_default (IAnjutaProvider *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_provider_populate:
 * @obj: Self
 * @iter: the text iter where the provider should be populated
 * @err: Error propagation and reporting.
 *
 * Show completion for the context at position @iter. The provider should
 * call ianjuta_editor_assist_proposals here to add proposals to the list.
 *
 * Note that this is called after every character typed and the list of proposals
 * has to be completely renewed.
 */
void
ianjuta_provider_populate (IAnjutaProvider *obj, IAnjutaIterable* iter, GError **err)
{
	g_return_if_fail (IANJUTA_IS_PROVIDER(obj));
	g_return_if_fail ((iter == NULL) ||IANJUTA_IS_ITERABLE(iter));
	IANJUTA_PROVIDER_GET_IFACE (obj)->populate (obj, iter, err);
}

/* Default implementation */
static void
ianjuta_provider_populate_default (IAnjutaProvider *obj, IAnjutaIterable* iter, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_provider_base_init (IAnjutaProviderIface* klass)
{
	static gboolean initialized = FALSE;

	klass->activate = ianjuta_provider_activate_default;
	klass->get_name = ianjuta_provider_get_name_default;
	klass->get_start_iter = ianjuta_provider_get_start_iter_default;
	klass->populate = ianjuta_provider_populate_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_provider_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaProviderIface),
			(GBaseInitFunc) ianjuta_provider_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaProvider", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
