/* rygel-relational-expression.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-relational-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <gst/gst.h>


#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelRelationalExpressionPrivate RygelRelationalExpressionPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelImageItemPrivate RygelImageItemPrivate;
typedef struct _RygelPhotoItemPrivate RygelPhotoItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelRelationalExpression {
	RygelSearchExpression parent_instance;
	RygelRelationalExpressionPrivate * priv;
};

struct _RygelRelationalExpressionClass {
	RygelSearchExpressionClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelImageItem {
	RygelMediaItem parent_instance;
	RygelImageItemPrivate * priv;
};

struct _RygelImageItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelPhotoItem {
	RygelImageItem parent_instance;
	RygelPhotoItemPrivate * priv;
	gchar* creator;
};

struct _RygelPhotoItemClass {
	RygelImageItemClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	gchar* artist;
	gchar* album;
	gchar* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_relational_expression_parent_class = NULL;

gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object);
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
RygelSearchExpression* rygel_search_expression_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType h_type, GBoxedCopyFunc h_dup_func, GDestroyNotify h_destroy_func, GType i_type, GBoxedCopyFunc i_dup_func, GDestroyNotify i_destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object) {
	RygelRelationalExpression * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
	static GQuark _tmp1__label6 = 0;
	static GQuark _tmp1__label7 = 0;
	static GQuark _tmp1__label8 = 0;
	self = (RygelRelationalExpression*) base;
	g_return_val_if_fail (media_object != NULL, FALSE);
	_tmp0_ = (const gchar*) ((RygelSearchExpression*) self)->operand1;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gboolean _tmp2_;
				_tmp2_ = rygel_relational_expression_compare_string (self, media_object->id);
				result = _tmp2_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gboolean _tmp3_;
				_tmp3_ = rygel_relational_expression_compare_string (self, ((RygelMediaObject*) media_object->parent)->id);
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				gboolean _tmp4_;
				_tmp4_ = rygel_relational_expression_compare_string (self, media_object->upnp_class);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_;
				_tmp5_ = rygel_media_object_get_title (media_object);
				_tmp6_ = rygel_relational_expression_compare_string (self, _tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("upnp:createClass")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp7_;
				gboolean _tmp8_;
				if (!RYGEL_IS_WRITABLE_CONTAINER (media_object)) {
					result = FALSE;
					return result;
				}
				_tmp8_ = rygel_relational_expression_compare_create_class (self, (_tmp7_ = media_object, RYGEL_IS_WRITABLE_CONTAINER (_tmp7_) ? ((RygelWritableContainer*) _tmp7_) : NULL));
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp9_;
				gboolean _tmp10_;
				if (!RYGEL_IS_PHOTO_ITEM (media_object)) {
					result = FALSE;
					return result;
				}
				_tmp10_ = rygel_relational_expression_compare_string (self, (_tmp9_ = media_object, RYGEL_IS_PHOTO_ITEM (_tmp9_) ? ((RygelPhotoItem*) _tmp9_) : NULL)->creator);
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label6) ? _tmp1__label6 : (_tmp1__label6 = g_quark_from_static_string ("upnp:artist")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp11_;
				gboolean _tmp12_;
				if (!RYGEL_IS_MUSIC_ITEM (media_object)) {
					result = FALSE;
					return result;
				}
				_tmp12_ = rygel_relational_expression_compare_string (self, (_tmp11_ = media_object, RYGEL_IS_MUSIC_ITEM (_tmp11_) ? ((RygelMusicItem*) _tmp11_) : NULL)->artist);
				result = _tmp12_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label7) ? _tmp1__label7 : (_tmp1__label7 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp13_;
				gboolean _tmp14_;
				if (!RYGEL_IS_MUSIC_ITEM (media_object)) {
					result = FALSE;
					return result;
				}
				_tmp14_ = rygel_relational_expression_compare_string (self, (_tmp13_ = media_object, RYGEL_IS_MUSIC_ITEM (_tmp13_) ? ((RygelMusicItem*) _tmp13_) : NULL)->album);
				result = _tmp14_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label8) ? _tmp1__label8 : (_tmp1__label8 = g_quark_from_static_string ("@childCount")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp15_;
				RygelMediaContainer* _tmp16_;
				RygelMediaContainer* container;
				gboolean _tmp17_;
				if (!RYGEL_IS_MEDIA_CONTAINER (media_object)) {
					result = FALSE;
					return result;
				}
				_tmp16_ = _g_object_ref0 ((_tmp15_ = media_object, RYGEL_IS_MEDIA_CONTAINER (_tmp15_) ? ((RygelMediaContainer*) _tmp15_) : NULL));
				container = _tmp16_;
				_tmp17_ = rygel_relational_expression_compare_int (self, container->child_count);
				result = _tmp17_;
				_g_object_unref0 (container);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}


static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base) {
	RygelRelationalExpression * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	self = (RygelRelationalExpression*) base;
	_tmp0_ = g_strdup_printf ("%s %d %s", (const gchar*) ((RygelSearchExpression*) self)->operand1, (gint) GPOINTER_TO_INT (((RygelSearchExpression*) self)->op), (const gchar*) ((RygelSearchExpression*) self)->operand2);
	result = _tmp0_;
	return result;
}


static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container) {
	gboolean result = FALSE;
	gboolean ret;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (container != NULL, FALSE);
	ret = FALSE;
	{
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _create_class_list;
		gint _tmp2_;
		gint _create_class_size;
		gint _create_class_index;
		_tmp0_ = rygel_writable_container_get_create_classes (container);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_create_class_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _create_class_list);
		_create_class_size = _tmp2_;
		_create_class_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			gchar* create_class;
			gboolean _tmp4_;
			_create_class_index = _create_class_index + 1;
			if (!(_create_class_index < _create_class_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _create_class_list, _create_class_index);
			create_class = (gchar*) _tmp3_;
			_tmp4_ = rygel_relational_expression_compare_string (self, create_class);
			if (_tmp4_) {
				ret = TRUE;
				_g_free0 (create_class);
				break;
			}
			_g_free0 (create_class);
		}
		_g_object_unref0 (_create_class_list);
	}
	result = ret;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* up_operand2;
	gchar* _tmp1_ = NULL;
	gchar* up_str;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_utf8_strup ((const gchar*) ((RygelSearchExpression*) self)->operand2, (gssize) (-1));
	up_operand2 = _tmp0_;
	_tmp1_ = g_utf8_strup (str, (gssize) (-1));
	up_str = _tmp1_;
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) self)->op)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			if (g_strcmp0 ((const gchar*) ((RygelSearchExpression*) self)->operand2, "true") == 0) {
				result = str != NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
				return result;
			} else {
				result = str == NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
				return result;
			}
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			result = g_strcmp0 (up_operand2, up_str) == 0;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			result = g_strcmp0 (up_operand2, up_str) != 0;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			gboolean _tmp2_;
			_tmp2_ = string_contains (up_str, up_operand2);
			result = _tmp2_;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			gboolean _tmp3_;
			_tmp3_ = g_str_has_prefix (up_str, up_operand2);
			result = _tmp3_;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		default:
		{
			result = FALSE;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
	}
	_g_free0 (up_str);
	_g_free0 (up_operand2);
}


gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint operand2;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = atoi ((const gchar*) ((RygelSearchExpression*) self)->operand2);
	operand2 = _tmp0_;
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) self)->op)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			result = integer == operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			result = integer != operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			result = integer < operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			result = integer <= operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			result = integer > operand2;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			result = integer >= operand2;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


RygelRelationalExpression* rygel_relational_expression_construct (GType object_type) {
	RygelRelationalExpression* self = NULL;
	self = (RygelRelationalExpression*) rygel_search_expression_construct (object_type, GUPNP_TYPE_SEARCH_CRITERIA_OP, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free);
	return self;
}


RygelRelationalExpression* rygel_relational_expression_new (void) {
	return rygel_relational_expression_construct (RYGEL_TYPE_RELATIONAL_EXPRESSION);
}


static void rygel_relational_expression_class_init (RygelRelationalExpressionClass * klass) {
	rygel_relational_expression_parent_class = g_type_class_peek_parent (klass);
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->satisfied_by = rygel_relational_expression_real_satisfied_by;
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->to_string = rygel_relational_expression_real_to_string;
}


static void rygel_relational_expression_instance_init (RygelRelationalExpression * self) {
}


GType rygel_relational_expression_get_type (void) {
	static volatile gsize rygel_relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRelationalExpression), 0, (GInstanceInitFunc) rygel_relational_expression_instance_init, NULL };
		GType rygel_relational_expression_type_id;
		rygel_relational_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelRelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&rygel_relational_expression_type_id__volatile, rygel_relational_expression_type_id);
	}
	return rygel_relational_expression_type_id__volatile;
}



