/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.FlatInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Iterator;

class Flattener
extends HierarchyEnumerator.Visitor {
    private static final boolean debug = false;
    private Cell flatCell;
    private int depth = 0;

    private void spaces() {
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(" ");
        }
    }

    private void createArcs(FlatInfo info) {
        Iterator it = info.getCell().getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Connection c0 = ai.getConnection(false);
            Connection c1 = ai.getConnection(true);
            Point2D p0 = info.getPositionInRoot(c0.getLocation());
            Point2D p1 = info.getPositionInRoot(c1.getLocation());
            PortInst pi0 = info.getFlatPort(c0.getPortInst());
            PortInst pi1 = info.getFlatPort(c1.getPortInst());
            ArcInst ai2 = ArcInst.newInstance(ai.getProto(), ai.getWidth(), pi0, p0, pi1, p1, null);
            if (!ai.isExtended()) continue;
            ai2.setExtended();
        }
    }

    private void addPortMappingsToParentCell(FlatInfo info) {
        NodeInst parentInst = (NodeInst)info.getParentInst();
        if (parentInst == null) {
            return;
        }
        Iterator it = info.getCell().getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            PortInst hierPort = e.getOriginalPort();
            PortInst flatPort = info.getFlatPort(hierPort);
            PortInst parentHierPort = parentInst.findPortInst(e.getName());
            FlatInfo parentInfo = (FlatInfo)info.getParentInfo();
            parentInfo.mapHierPortToFlatPort(parentHierPort, flatPort);
        }
    }

    private void addRootExportsToFlatCell(FlatInfo info) {
        Cell root = info.getCell();
        Iterator it = root.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            PortInst p = info.getFlatPort(e.getOriginalPort());
            Export eRoot = Export.newInstance(this.flatCell, p, e.getName());
            eRoot.setCharacteristic(e.getCharacteristic());
        }
    }

    Flattener(Cell outCell) {
        this.flatCell = outCell;
    }

    public HierarchyEnumerator.CellInfo newCellInfo() {
        return new FlatInfo();
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo inf) {
        FlatInfo info = (FlatInfo)inf;
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo inf) {
        FlatInfo info = (FlatInfo)inf;
        this.createArcs(info);
        this.addPortMappingsToParentCell(info);
        if (info.isRootCell()) {
            this.addRootExportsToFlatCell(info);
        }
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo inf) {
        FlatInfo info = (FlatInfo)inf;
        NodeProto np = no.getProto();
        if (np instanceof PrimitiveNode) {
            NodeInst ni = (NodeInst)no;
            if (!np.getName().equals("Facet-Center")) {
                AffineTransform at = info.getPositionInRoot(ni);
                NodeInst ni2 = NodeInst.newInstance(np, new Point2D.Double(0.0, 0.0), 1.0, 1.0, 0, this.flatCell, null);
                Iterator it = ni.getPortInsts();
                while (it.hasNext()) {
                    PortInst pi = (PortInst)it.next();
                    PortInst pi2 = ni2.findPortInst(pi.getPortProto().getName());
                    info.mapHierPortToFlatPort(pi, pi2);
                }
            }
        }
        return true;
    }
}

