/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class HighlightMessage
extends Highlight2 {
    protected String msg;
    protected Point2D loc;
    protected int corner;

    HighlightMessage(Cell c, String m, Point2D p, int co) {
        super(c);
        this.msg = m;
        this.loc = p;
        this.corner = co;
    }

    void internalDescribe(StringBuffer desc) {
        desc.append(", ");
        desc.append(this.msg);
    }

    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, boolean setConnected) {
        Point location = wnd.databaseToScreen(this.loc.getX(), this.loc.getY());
        if (this.corner != 0) {
            Font font = g.getFont();
            FontRenderContext frc = new FontRenderContext(null, true, true);
            GlyphVector gv = font.createGlyphVector(frc, this.msg);
            LineMetrics lm = font.getLineMetrics(this.msg, frc);
            Rectangle2D rasRect = gv.getLogicalBounds();
            int width = (int)rasRect.getWidth();
            int height = (int)((double)lm.getHeight() + 0.5);
            switch (this.corner) {
                case 1: {
                    location.y += height;
                    break;
                }
                case 2: {
                    location.y += height;
                    location.x -= width;
                    break;
                }
                case 3: {
                    location.y += height;
                    location.x -= width;
                }
            }
        }
        Color oldColor = g.getColor();
        g.setColor(new Color(255 - oldColor.getRed(), 255 - oldColor.getGreen(), 255 - oldColor.getBlue()));
        g.drawString(this.msg, location.x + 1, location.y + 1);
        g.setColor(oldColor);
        g.drawString(this.msg, location.x, location.y);
    }

    Rectangle2D getHighlightedArea(EditWindow wnd) {
        return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
    }
}

