/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRemove {
    public static void add(Library lib) {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(lib);
        AddRemove.addremove(libs, null, true, false);
    }

    public static void add(Cell cell) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell);
        AddRemove.addremove(null, cells, true, false);
    }

    public static void remove(Library lib) {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(lib);
        AddRemove.addremove(libs, null, false, false);
    }

    public static void remove(Cell cell) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell);
        AddRemove.addremove(null, cells, false, false);
    }

    public static void addremove(List<Library> libs, List<Cell> cells, boolean add, boolean undo2) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        CVSLibrary.LibsCells bad = CVSLibrary.notFromDELIB(cells);
        if (bad.cells.size() > 0) {
            CVS.showError("Error: the following Cells are not part of a DELIB library and cannot be acted upon individually", "CVS Add/Remove Error", bad.libs, bad.cells);
            return;
        }
        bad = CVSLibrary.getModified(libs, cells);
        if (bad.libs.size() > 0 || bad.cells.size() > 0) {
            CVS.showError("Error: the following Libraries or Cells must be saved first", "CVS " + (add ? "Add" : "Remove") + " Error", bad.libs, bad.cells);
            return;
        }
        ArrayList<Library> assertLibsInCVS = new ArrayList<Library>();
        for (Cell cell : cells) {
            Library lib = cell.getLibrary();
            if (libs.contains(lib) || assertLibsInCVS.contains(lib)) continue;
            assertLibsInCVS.add(lib);
        }
        bad = CVSLibrary.getNotInCVS(assertLibsInCVS, null);
        if (bad.libs.size() > 0) {
            CVS.showError("Error: cannot add DELIB cells if cell's DELIB library is not in cvs", "CVS " + (add ? "Add" : "Remove") + " Error", bad.libs, bad.cells);
            return;
        }
        CVSLibrary.LibsCells good = CVSLibrary.consolidate(libs, cells);
        if (!undo2) {
            if (!add) {
                StringBuffer list2 = new StringBuffer("Warning! CVS Remove will delete disk files for these Libraries and Cells!!!");
                for (Library lib : good.libs) {
                    list2.append("\n  " + lib.getName());
                }
                for (Cell cell : good.cells) {
                    list2.append("\n  " + cell.libDescribe());
                }
                if (!Job.getUserInterface().confirmMessage(list2.toString())) {
                    return;
                }
            }
            new AddRemoveJob(good.libs, good.cells, add).startJob();
        } else {
            new UndoAddRemoveJob(good.libs, good.cells).startJob();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UndoAddRemoveJob
    extends Job {
        private List<Library> libs;
        private List<Cell> cells;
        HashMap<File, ElectricObject> filesToUndo;

        private UndoAddRemoveJob(List<Library> libs, List<Cell> cells) {
            super("CVS Undo Add/Remove", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.libs = libs;
            this.cells = cells;
            if (this.libs == null) {
                this.libs = new ArrayList<Library>();
            }
            if (this.cells == null) {
                this.cells = new ArrayList<Cell>();
            }
        }

        @Override
        public boolean doIt() {
            for (Library lib : this.libs) {
                this.undo(lib);
            }
            for (Cell cell : this.cells) {
                this.undo(cell);
            }
            System.out.println("Undo CVS Add/Remove complete");
            return true;
        }

        private void undo(Library lib) {
            File libraryFile = TextUtils.getFile(lib.getLibFile());
            if (libraryFile == null) {
                return;
            }
            String libfile = libraryFile.getPath();
            if (!CVS.isDELIB(lib)) {
                if (this.undo(new File(libfile))) {
                    State state = CVSLibrary.getState(lib);
                    if (state == State.ADDED) {
                        CVSLibrary.setState(lib, State.UNKNOWN);
                    }
                    if (state == State.REMOVED) {
                        CVSLibrary.setState(lib, State.NONE);
                    }
                }
            } else {
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    this.undo(it.next());
                }
                File headerFile = new File(libfile, DELIB.getHeaderFile());
                this.undo(headerFile);
            }
        }

        private void undo(Cell cell) {
            if (!CVS.isDELIB(cell.getLibrary())) {
                return;
            }
            File libraryFile = TextUtils.getFile(cell.getLibrary().getLibFile());
            if (libraryFile == null) {
                return;
            }
            String libfile = libraryFile.getPath();
            File cellFile = new File(libfile, DELIB.getCellFile(cell));
            if (this.undo(cellFile)) {
                State state = CVSLibrary.getState(cell);
                if (state == State.ADDED) {
                    CVSLibrary.setState(cell, State.UNKNOWN);
                }
                if (state == State.REMOVED) {
                    CVSLibrary.setState(cell, State.NONE);
                }
            }
        }

        private boolean undo(File FD) {
            if (FD.isDirectory()) {
                return false;
            }
            File parent = FD.getParentFile();
            File CVSDIR = new File(parent, "CVS");
            if (!CVSDIR.exists()) {
                return false;
            }
            File entries = new File(CVSDIR, "Entries");
            if (!entries.exists()) {
                return false;
            }
            File entriestemp = new File(CVSDIR, "Entries.temp");
            String filename = FD.getName();
            boolean success2 = false;
            try {
                String line;
                LineNumberReader reader = new LineNumberReader(new FileReader(entries));
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(entriestemp, false)));
                while ((line = reader.readLine()) != null) {
                    if (line.equals("")) continue;
                    String[] parts = line.split("/");
                    boolean skip = false;
                    if (parts.length >= 2 && parts[1].equals(filename)) {
                        if (parts.length >= 3 && parts[2].equals("0")) {
                            skip = true;
                            success2 = true;
                        }
                        if (parts.length >= 3 && parts[2].startsWith("-")) {
                            line = line.replaceAll("/" + parts[2] + "/", "/" + parts[2].substring(1) + "/");
                            success2 = true;
                        }
                    }
                    if (skip) continue;
                    pw.println(line);
                }
                reader.close();
                pw.close();
                if (!entriestemp.renameTo(entries)) {
                    System.out.println("Unable to move " + entriestemp + " to " + entries + ", cannot undo add/remove of " + filename);
                    return false;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return success2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRemoveJob
    extends Job {
        private List<Library> libs;
        private List<Cell> cells;
        private boolean add;
        private int exitVal;
        private HashMap<String, Integer> addedCellDirs;
        private String cvsProgram = CVS.getCVSProgram();
        private String repository = CVS.getRepository();

        private AddRemoveJob(List<Library> libs, List<Cell> cells, boolean add) {
            super("CVS Add/Remove", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.libs = libs;
            this.cells = cells;
            this.add = add;
            this.exitVal = -1;
            if (this.libs == null) {
                this.libs = new ArrayList<Library>();
            }
            if (this.cells == null) {
                this.cells = new ArrayList<Cell>();
            }
            this.addedCellDirs = new HashMap();
        }

        @Override
        public boolean doIt() {
            String useDir = CVS.getUseDir(this.libs, this.cells);
            ArrayList<Library> stateChangeLibs = new ArrayList<Library>();
            ArrayList<Cell> stateChangeCells = new ArrayList<Cell>();
            for (Library lib : this.libs) {
                if (CVS.isDELIB(lib)) {
                    Iterator<Cell> it = lib.getCells();
                    while (it.hasNext()) {
                        Cell cell = it.next();
                        if (this.add) {
                            if (CVS.isFileInCVS(CVS.getCellFile(cell))) continue;
                            stateChangeCells.add(cell);
                            continue;
                        }
                        if (!CVS.isFileInCVS(CVS.getCellFile(cell))) continue;
                        stateChangeCells.add(cell);
                    }
                    continue;
                }
                if (this.add) {
                    URL fileURL = lib.getLibFile();
                    if (fileURL == null) {
                        System.out.println("Library not on disk yet. Save it before applying this command");
                        this.exitVal = 0;
                        return true;
                    }
                    if (CVS.isFileInCVS(new File(fileURL.getPath()))) continue;
                    stateChangeLibs.add(lib);
                    continue;
                }
                if (CVS.isFileInCVS(new File(lib.getLibFile().getPath()))) continue;
                stateChangeLibs.add(lib);
            }
            for (Cell cell : this.cells) {
                if (this.add) {
                    if (CVS.isFileInCVS(CVS.getCellFile(cell))) continue;
                    stateChangeCells.add(cell);
                    continue;
                }
                if (!CVS.isFileInCVS(CVS.getCellFile(cell))) continue;
                stateChangeCells.add(cell);
            }
            StringBuffer buf = new StringBuffer();
            for (Library lib : this.libs) {
                this.generate(buf, lib, useDir);
            }
            for (Cell cell : this.cells) {
                this.generate(buf, cell, useDir);
            }
            String addRemoveFiles = buf.toString();
            if (addRemoveFiles.trim().equals("")) {
                System.out.println("Nothing to " + (this.add ? "Add" : "Remove"));
                this.exitVal = 0;
                return true;
            }
            String command = this.add ? "add" : "remove -f";
            String message = "Running CVS " + (this.add ? "Add" : "Remove");
            this.exitVal = CVS.runCVSCommand(this.cvsProgram, this.repository, "-q " + command + " " + addRemoveFiles, message, useDir, System.out);
            this.fieldVariableChanged("exitVal");
            if (this.exitVal != 0) {
                return true;
            }
            System.out.println("CVS " + command + " complete");
            for (Cell cell : stateChangeCells) {
                if (this.add) {
                    CVSLibrary.setState(cell, State.ADDED);
                    continue;
                }
                CVSLibrary.setState(cell, State.REMOVED);
            }
            for (Library lib : stateChangeLibs) {
                if (this.add) {
                    CVSLibrary.setState(lib, State.ADDED);
                    continue;
                }
                CVSLibrary.setState(lib, State.REMOVED);
            }
            return true;
        }

        private void generate(StringBuffer buf, Library lib, String useDir) {
            File libraryFile = TextUtils.getFile(lib.getLibFile());
            if (libraryFile == null) {
                return;
            }
            String libfile = libraryFile.getPath();
            this.add(buf, libfile, useDir);
            if (CVS.isDELIB(lib)) {
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    this.generate(buf, it.next(), useDir);
                }
                File headerFile = new File(libfile, DELIB.getHeaderFile());
                this.add(buf, headerFile.getPath(), useDir);
            }
        }

        private void generate(StringBuffer buf, Cell cell, String useDir) {
            if (!CVS.isDELIB(cell.getLibrary())) {
                return;
            }
            File libraryFile = TextUtils.getFile(cell.getLibrary().getLibFile());
            if (libraryFile == null) {
                return;
            }
            String libfile = libraryFile.getPath();
            File celldirFile = new File(libfile, DELIB.getCellSubDir(cell.getId()));
            String celldir = celldirFile.getPath();
            if (!this.addedCellDirs.containsKey(celldir) && !libfile.equals(celldir)) {
                if (celldirFile.exists()) {
                    this.add(buf, celldir, useDir);
                }
                this.addedCellDirs.put(celldir, null);
            }
            File cellFile = new File(libfile, DELIB.getCellFile(cell));
            this.add(buf, cellFile.getPath(), useDir);
            if (this.add) {
                File headerFile = new File(libfile, DELIB.getHeaderFile());
                if (!this.libs.contains(cell.getLibrary()) && !CVS.isFileInCVS(headerFile)) {
                    this.add(buf, headerFile.getPath(), useDir);
                }
            }
        }

        private void add(StringBuffer buf, String file, String useDir) {
            File FD = new File(file);
            if (this.add && !CVS.isFileInCVS(FD, false, false) || !this.add && CVS.isFileInCVS(FD, false, false)) {
                if (file.startsWith(useDir)) {
                    file = file.substring(useDir.length() + 1, file.length());
                }
                buf.append(file + " ");
            }
        }

        @Override
        public void terminateOK() {
            if (this.exitVal != 0) {
                Job.getUserInterface().showErrorMessage("CVS " + (this.add ? "Add" : "Remove") + " Failed!  Please see messages window (exit status " + this.exitVal + ")", "CVS " + (this.add ? "Add" : "Remove") + " Failed!");
            }
        }
    }
}

