/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config.model;

import com.sun.electric.util.config.model.ConfigEntries;
import com.sun.electric.util.config.model.ConfigEntry;
import com.sun.electric.util.config.model.Injection;
import com.sun.electric.util.config.model.ParameterEntry;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter {
    private String name;
    private String ref;
    private String value;
    private Type type;
    private boolean runtimeParamter;

    public Parameter(String name, String ref, String value2, Type type, boolean runtimeParamter) {
        this.name = name;
        this.ref = ref;
        this.value = value2;
        this.type = type;
        this.runtimeParamter = runtimeParamter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ParameterEntry createParameter(Map<String, Injection> allInjections) throws ClassNotFoundException, LinkageError {
        ParameterEntry entry = null;
        entry = this.ref == null ? new ParameterEntry(this.name, this.createByType()) : new ParameterEntry(this.name, this.createByReference(allInjections));
        return entry;
    }

    private ConfigEntry<?> createByType() throws ClassNotFoundException {
        if (this.type.equals((Object)Type.Boolean)) {
            return new ConfigEntry.ConfigEntryPrimitive<Boolean>(Boolean.parseBoolean(this.value), this.runtimeParamter);
        }
        if (this.type.equals((Object)Type.Double)) {
            return new ConfigEntry.ConfigEntryPrimitive<Double>(Double.parseDouble(this.value), this.runtimeParamter);
        }
        if (this.type.equals((Object)Type.Integer)) {
            return new ConfigEntry.ConfigEntryPrimitive<Integer>(Integer.parseInt(this.value), this.runtimeParamter);
        }
        if (this.type.equals((Object)Type.String)) {
            return new ConfigEntry.ConfigEntryPrimitive<String>(this.value, this.runtimeParamter);
        }
        if (this.type.equals((Object)Type.Enum)) {
            return ConfigEntry.createForEnum(Class.forName(this.value.substring(0, this.value.lastIndexOf(46))), this.value.substring(this.value.lastIndexOf(46) + 1));
        }
        return null;
    }

    private ConfigEntry<?> createByReference(Map<String, Injection> allInjections) throws ClassNotFoundException, LinkageError {
        ConfigEntry<?> entry = ConfigEntries.getEntries().get(this.ref);
        if (entry != null) {
            return entry;
        }
        return allInjections.get(this.ref).createConfigEntry(allInjections);
    }

    public void setRuntimeParamter(boolean runtimeParamter) {
        this.runtimeParamter = runtimeParamter;
    }

    public boolean isRuntimeParamter() {
        return this.runtimeParamter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        String,
        Integer,
        Double,
        Boolean,
        Reference,
        Enum;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attributes {
        name,
        ref,
        value,
        type;

    }
}

