/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;

public abstract class DNSTask
extends TimerTask {
    private final JmDNSImpl _jmDNSImpl;

    protected DNSTask(JmDNSImpl jmDNSImpl) {
        this._jmDNSImpl = jmDNSImpl;
    }

    public JmDNSImpl getDns() {
        return this._jmDNSImpl;
    }

    public abstract void start(Timer var1);

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public DNSOutgoing addQuestion(DNSOutgoing out, DNSQuestion rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addQuestion(rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this._jmDNSImpl.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addQuestion(rec);
        }
        return newOut;
    }

    public DNSOutgoing addAnswer(DNSOutgoing out, DNSIncoming in, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAnswer(in, rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this._jmDNSImpl.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAnswer(in, rec);
        }
        return newOut;
    }

    public DNSOutgoing addAnswer(DNSOutgoing out, DNSRecord rec, long now) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAnswer(rec, now);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this._jmDNSImpl.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAnswer(rec, now);
        }
        return newOut;
    }

    public DNSOutgoing addAuthoritativeAnswer(DNSOutgoing out, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAuthorativeAnswer(rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this._jmDNSImpl.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAuthorativeAnswer(rec);
        }
        return newOut;
    }

    public DNSOutgoing addAdditionalAnswer(DNSOutgoing out, DNSIncoming in, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAdditionalAnswer(in, rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this._jmDNSImpl.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAdditionalAnswer(in, rec);
        }
        return newOut;
    }
}

