/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1471693133499000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "0.me.uk", true },
  { "007sascha.de", true },
  { "050media.nl", true },
  { "0513c.com", true },
  { "0au.de", true },
  { "0knowledge.de", true },
  { "0paste.com", true },
  { "0x.cx", true },
  { "0x.sk", true },
  { "0x0a.net", true },
  { "0x1337.eu", true },
  { "0x44.net", true },
  { "0x52.net", true },
  { "0x90.fi", true },
  { "0x90.io", true },
  { "0xa.in", true },
  { "0xee.eu", true },
  { "0xf00.ch", true },
  { "0xfc.de", true },
  { "1000minds.com", true },
  { "1001.best", true },
  { "1011100.com", true },
  { "1017scribes.com", true },
  { "1018hosting.nl", true },
  { "1022996493.rsc.cdn77.org", true },
  { "123test.fr", true },
  { "126ium.moe", true },
  { "12vpn.org", true },
  { "12vpnchina.com", true },
  { "1464424382.rsc.cdn77.org", true },
  { "14it.de", true },
  { "1750studios.com", true },
  { "17hats.com", true },
  { "188trafalgar.ca", true },
  { "18f.gov", true },
  { "18f.gsa.gov", true },
  { "1972969867.rsc.cdn77.org", true },
  { "1a-diamantscheiben.de", true },
  { "1a-jva.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "1co-jp.net", true },
  { "1cover.com", true },
  { "1cover.com.au", true },
  { "1hourproofreading.com", true },
  { "1km.ro", true },
  { "1q365a.com", true },
  { "1st-community.de", true },
  { "1stcapital.com.sg", true },
  { "1whw.co.uk", true },
  { "1xcess.com", true },
  { "2048game.co.uk", true },
  { "21.co.uk", true },
  { "247healthshop.com", true },
  { "24ip.com", true },
  { "24ip.de", true },
  { "24ip.fr", true },
  { "2600hq.com", true },
  { "28spots.net", true },
  { "2bis10.de", true },
  { "2brokegirls.org", true },
  { "2carpros.com", true },
  { "2e-systems.com", true },
  { "2gen.com", true },
  { "2kgwf.fi", true },
  { "2nains.ch", true },
  { "2nerds1bit.com", true },
  { "2or3.tk", true },
  { "2programmers.net", true },
  { "300m.com", true },
  { "301.website", true },
  { "314chan.org", true },
  { "321live.nl", true },
  { "33-km.ru", true },
  { "33drugstore.com", true },
  { "3473-wiki.de", true },
  { "35792.de", true },
  { "360ds.co.in", true },
  { "360gradus.com", true },
  { "365beautyworld.com", true },
  { "365healthworld.com", true },
  { "368mibn.com", true },
  { "3chit.cf", true },
  { "3do3dont.com", true },
  { "3r.org.uk", true },
  { "3s-hosting.de", true },
  { "403.ch", true },
  { "404.sh", true },
  { "42ms.org", true },
  { "4455software.com", true },
  { "4500.co.il", true },
  { "4679.space", false },
  { "4d2.xyz", true },
  { "4elements.com", false },
  { "4eyes.ch", true },
  { "4g-server.eu", false },
  { "4mm.org", true },
  { "4ourty2.org", true },
  { "4project.co.il", true },
  { "4sqsu.eu", true },
  { "4w-performers.link", false },
  { "4winds.pt", true },
  { "50plusnet.nl", true },
  { "57aromas.com", true },
  { "5apps.com", true },
  { "60ych.net", true },
  { "6120.eu", true },
  { "646.io", true },
  { "6660111.ru", true },
  { "692b8c32.de", true },
  { "6969.us", true },
  { "69square.com", true },
  { "7183.org", true },
  { "777coin.com", true },
  { "7kovrikov.ru", true },
  { "7sons.de", true },
  { "7thheavenrestaurant.com", true },
  { "888sport.dk", true },
  { "888sport.it", true },
  { "8ack.de", true },
  { "8t8.eu", true },
  { "8thportsmouth.org.uk", true },
  { "911911.pw", true },
  { "91tianmi.com", true },
  { "92url.com", true },
  { "960news.ca", true },
  { "99511.fi", true },
  { "9point6.com", true },
  { "a-plus.space", true },
  { "a2nutrition.com.au", true },
  { "aa-tour.ru", true },
  { "aaeblog.com", true },
  { "aaeblog.org", true },
  { "aanmpc.com", true },
  { "aapp.space", true },
  { "aaron-gustafson.com", true },
  { "aaronkimmig.de", true },
  { "aaronsilber.me", true },
  { "aatf.us", true },
  { "abacustech.co.jp", true },
  { "abareplace.com", true },
  { "abc.li", true },
  { "abcheck.se", true },
  { "abearofsoap.com", true },
  { "abecodes.net", false },
  { "abeestrada.com", true },
  { "aberdeenjudo.co.uk", true },
  { "abiapp.net", true },
  { "abilitylist.org", true },
  { "abilitynet.org.uk", true },
  { "abilymp06.net", true },
  { "abioniere.de", true },
  { "abiturma.de", true },
  { "abmahnhelfer.de", false },
  { "abmgood.com", true },
  { "abou.to", true },
  { "aboutmyip.info", true },
  { "aboutmyproperty.ca", true },
  { "abrilect.com", true },
  { "abthorpe.org", true },
  { "abury.fr", true },
  { "abury.me", true },
  { "ac-town.com", true },
  { "acabadosboston.com", true },
  { "accelerole.com", true },
  { "access-sofia.org", true },
  { "accountradar.com", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "accuenergy.com", true },
  { "acheconcursos.com.br", true },
  { "achenar.net", true },
  { "acheritage.co.uk", true },
  { "achromatisch.de", true },
  { "acisonline.net", true },
  { "aclu.org", false },
  { "acnpacific.com", true },
  { "acorns.com", true },
  { "acr.im", true },
  { "acritelli.com", true },
  { "acrylicwifi.com", true },
  { "activateplay.com", true },
  { "active.hu", true },
  { "actserv.co.ke", true },
  { "acuica.co.uk", false },
  { "acus.gov", true },
  { "ad-notam.pt", true },
  { "adam-kostecki.de", true },
  { "adambyers.com", true },
  { "adamkaminski.com", true },
  { "adamkostecki.de", true },
  { "adamradocz.com", true },
  { "adamricheimer.com", true },
  { "adams.dk", true },
  { "adams.net", true },
  { "adamstas.com", true },
  { "adastra.re", true },
  { "adayinthelifeof.nl", true },
  { "adblock.ovh", true },
  { "adblockextreme.com", true },
  { "adblockextreme.org", true },
  { "adboos.com", true },
  { "addaxpetroleum.com", true },
  { "adderall.space", true },
  { "addstar.jp", true },
  { "adduono.com", true },
  { "addvocate.com", true },
  { "adelaides.com", true },
  { "adelevie.com", true },
  { "adevel.eu", true },
  { "adigitali.biz", true },
  { "adimaja.com", true },
  { "adiponectinsupplement.info", true },
  { "adiponectinsupplement.net", true },
  { "adjagu.org", true },
  { "adlershop.ch", true },
  { "adme.co.il", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "admitcard.co.in", true },
  { "admsel.ec", true },
  { "adoal.net", true },
  { "adopteunsiteflash.com", true },
  { "adorai.tk", true },
  { "adquisitio.co.uk", true },
  { "adquisitio.de", true },
  { "adquisitio.es", true },
  { "adquisitio.fr", true },
  { "adquisitio.in", true },
  { "adquisitio.it", true },
  { "adrenaline-gaming.ru", false },
  { "adrl.ca", true },
  { "adsfund.org", true },
  { "aduvi.de", true },
  { "advanced-online.eu", true },
  { "advancedseotool.it", true },
  { "advancis.net", true },
  { "advelty.cz", true },
  { "adventistdeploy.org", true },
  { "adventureforest.de", true },
  { "adviespuntklokkenluiders.nl", true },
  { "adzuna.ca", true },
  { "adzuna.co.uk", true },
  { "adzuna.co.za", true },
  { "adzuna.com.au", true },
  { "adzuna.com.br", true },
  { "adzuna.de", true },
  { "adzuna.fr", true },
  { "adzuna.in", true },
  { "adzuna.nl", true },
  { "adzuna.pl", true },
  { "adzuna.ru", true },
  { "aeon.co", true },
  { "aerolog.co", true },
  { "aes256.ru", true },
  { "aevpn.net", true },
  { "aeyoun.com", true },
  { "afb24.de", true },
  { "affiliateroyale.com", true },
  { "affinitysync.com", true },
  { "aficotroceni.ro", true },
  { "afp548.com", true },
  { "africatravel.de", true },
  { "afrodigital.uk", true },
  { "afuh.de", true },
  { "afvallendoeje.nu", true },
  { "agalaxyfarfaraway.co.uk", true },
  { "ageg.ca", true },
  { "agenda-loto.net", true },
  { "agevio.com", true },
  { "agilebits.net", false },
  { "agonswim.com", true },
  { "agowa338.de", true },
  { "agro-id.gov.ua", true },
  { "agroline.by", true },
  { "agwa.name", true },
  { "ahabingo.com", true },
  { "ahd.com", true },
  { "ahmad.works", false },
  { "ahmerjamilkhan.org", true },
  { "ahoyconference.com", true },
  { "ahwatukeefoothillsmontessori.com", true },
  { "ahxxm.com", true },
  { "aia.de", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aiesecarad.ro", true },
  { "aikido-linz.at", true },
  { "aikido-wels.at", true },
  { "aircomms.com", true },
  { "airlea.com", true },
  { "airlinecheckins.com", true },
  { "airsoft.ch", true },
  { "aishnair.com", true },
  { "aisle3.space", true },
  { "aiticon.com", true },
  { "aivd.lol", true },
  { "ajouin.com", true },
  { "akachanikuji.com", true },
  { "akaoma.com", false },
  { "akelius.de", true },
  { "akerek.hu", true },
  { "akhilindurti.com", true },
  { "akhras.at", true },
  { "akombakom.net", true },
  { "akostecki.de", true },
  { "akoww.de", true },
  { "akropolis-ravensburg.de", true },
  { "akselinurmio.fi", true },
  { "akstudentsfirst.org", true },
  { "aktiv-naturheilmittel.at", true },
  { "aktiv-naturheilmittel.ch", true },
  { "aktiv-naturheilmittel.de", true },
  { "aladdin.ie", true },
  { "aladdinschools.appspot.com", true },
  { "alainwolf.ch", true },
  { "alainwolf.net", true },
  { "alair.cn", true },
  { "alaninkenya.org", true },
  { "alanlee.net", true },
  { "alanrickmanflipstable.com", true },
  { "alaricfavier.eu", true },
  { "alariel.de", true },
  { "alasta.info", true },
  { "alastyr.com", true },
  { "albertopimienta.com", true },
  { "albion2.org", true },
  { "alcazaar.com", true },
  { "aldes.co.za", true },
  { "aleax.me", true },
  { "alecpap.com", true },
  { "alela.fr", true },
  { "alenan.org", true },
  { "alertwire.com", true },
  { "alex-ross.co.uk", true },
  { "alexandra-schulze.de", true },
  { "alexandre.sh", true },
  { "alexbaker.org", true },
  { "alexgaynor.net", true },
  { "alexhaydock.co.uk", true },
  { "alexhd.de", true },
  { "alexisabarca.com", true },
  { "alexismeza.com", true },
  { "alexmerkel.com", true },
  { "alexmerkel.me", true },
  { "alexmerkel.xyz", true },
  { "alexn.org", true },
  { "alexsergeyev.com", true },
  { "alexsexton.com", true },
  { "alexvetter.de", true },
  { "alexwardweb.com", true },
  { "alexyang.me", true },
  { "alienstat.com", true },
  { "alittlebitcheeky.com", false },
  { "alkami.com", true },
  { "alkamitech.com", true },
  { "all.tf", false },
  { "all4os.com", true },
  { "allbenjoy.de", true },
  { "allcarepharmacy.com", true },
  { "allforyou.at", true },
  { "alliedfrozenstorage.com", true },
  { "allinnote.com", true },
  { "allinonecyprus.com", true },
  { "allmbw.com", true },
  { "allstarswithus.com", true },
  { "alltheducks.com", true },
  { "allthethings.co.nz", true },
  { "allthingssquared.com", true },
  { "allthingswild.co.uk", true },
  { "almeria-si.fr", true },
  { "almeria.fr", true },
  { "alnitech.com", true },
  { "alocato.com", true },
  { "alpca.org", true },
  { "alpha-force.net", true },
  { "alphabuild.io", true },
  { "alphalabs.xyz", true },
  { "alphassl.de", true },
  { "alphatrash.de", true },
  { "alt-three.com", true },
  { "alt.org", true },
  { "altedirect.com", true },
  { "alterbaum.net", true },
  { "altesses.eu", true },
  { "altestore.com", true },
  { "altfire.ca", true },
  { "altonblom.com", true },
  { "altopia.com", true },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "am3.se", true },
  { "ama.ne.jp", true },
  { "amaforums.org", true },
  { "amateri.com", true },
  { "amavis.org", true },
  { "amazing-gaming.fr", true },
  { "ambiente.one", true },
  { "ambiq.nl", true },
  { "amcvega.com", true },
  { "amdouglas.com", true },
  { "amdouglas.uk", true },
  { "amees.me", true },
  { "american-truck-simulator.de", true },
  { "american-truck-simulator.net", true },
  { "americanbio.com", true },
  { "americanworkwear.nl", true },
  { "americkykongres.cz", true },
  { "amerigroup.com", true },
  { "amerimarkdirect.com", true },
  { "amilx.org", true },
  { "amisharingstuff.com", true },
  { "amishsecurity.com", true },
  { "amitube.com", true },
  { "amnesy.fr", true },
  { "amoory.com", false },
  { "amv-crm.ru", true },
  { "anadoluefessk.org", true },
  { "anadoluefessporkulubu.org", true },
  { "anagra.ms", true },
  { "anakros.me", true },
  { "analytic-s.ml", true },
  { "ananke.io", true },
  { "anassiriphotography.com", false },
  { "anastasiafond.com", true },
  { "and-stuff.nl", true },
  { "and.com", true },
  { "anderslind.dk", true },
  { "andisadhdspot.com", true },
  { "andreaboero.it", true },
  { "andreas-kluge.eu", true },
  { "andreasfeusi.ch", true },
  { "andreaskluge.eu", true },
  { "andreasolsson.se", true },
  { "andreastoneman.com", true },
  { "andreigec.net", true },
  { "andrepicard.de", true },
  { "andrewbroekman.com", true },
  { "andrewhowden.com", true },
  { "andrewimeson.com", true },
  { "andrewmichaud.beer", true },
  { "andrewmichaud.com", true },
  { "andrewmichaud.me", true },
  { "andrewsun.com", true },
  { "andrewtebert.com", true },
  { "andrewthelott.net", true },
  { "andrewvoce.com", true },
  { "andrewx.net", true },
  { "andreypopp.com", true },
  { "andsat.org", true },
  { "andymartin.cc", true },
  { "andyuk.org", true },
  { "anedot.com", true },
  { "anedot.xyz", true },
  { "anetaben.nl", true },
  { "anfsanchezo.me", true },
  { "anghami.com", true },
  { "anglictinatabor.cz", true },
  { "angrapa.ru", true },
  { "angristan.fr", true },
  { "angularjs.org", true },
  { "animalnet.de", false },
  { "anime.my", false },
  { "animesfusion.com.br", true },
  { "animesharp.com", true },
  { "aniplus.cf", true },
  { "aniplus.gq", true },
  { "aniplus.ml", true },
  { "anitaalbersen.nl", true },
  { "anitube-nocookie.ch", true },
  { "anitube.ch", true },
  { "ankakaak.com", true },
  { "ankarakart.com.tr", true },
  { "ankaraprofesyonelnakliyat.com", true },
  { "ankaraprofesyonelnakliyat.com.tr", true },
  { "ankaraprofesyonelwebtasarim.com", true },
  { "ankarauzmanlarnakliyat.com", true },
  { "annahmeschluss.de", true },
  { "annarokina.com", true },
  { "annetta.com", true },
  { "annevankesteren.com", true },
  { "annevankesteren.nl", true },
  { "annevankesteren.org", true },
  { "annuaire-photographe.fr", true },
  { "anonboards.com", true },
  { "anoncom.net", true },
  { "anonukradio.org", true },
  { "anonym-surfen.de", true },
  { "anook.com", true },
  { "another.ch", true },
  { "ansdell.net", true },
  { "anshuman-chatterjee.com", true },
  { "anthenor.co.uk", true },
  { "antipolygraph.org", true },
  { "antocom.com", true },
  { "antoine-roux.fr", true },
  { "antoinedeschenes.com", true },
  { "antoniomarques.eu", true },
  { "anyprime.net", true },
  { "anyways.at", true },
  { "anzeiger.ag", true },
  { "ao-dev.com", true },
  { "ao2.it", true },
  { "aojf.fr", true },
  { "aopedeure.nl", true },
  { "aosus.org", true },
  { "apachehaus.de", false },
  { "apadvantage.com", true },
  { "apeasternpower.com", true },
  { "aperturesciencelabs.de", true },
  { "apervita.net", true },
  { "apexitsolutions.ca", true },
  { "api-geek.com", true },
  { "api.cloudflare.com", false },
  { "api.intercom.io", true },
  { "api.lookout.com", false },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apis.google.com", true },
  { "apmg-certified.com", true },
  { "apmg-cyber.com", true },
  { "apn-einstellungen.de", true },
  { "apnakliyat.com", true },
  { "apolloyl.com", true },
  { "aponow.de", true },
  { "aposke.com", true },
  { "app-arena.com", true },
  { "app.lookout.com", false },
  { "app.manilla.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", false },
  { "app.yinxiang.com", false },
  { "appart.ninja", true },
  { "appartementhaus-badria.de", true },
  { "appdrinks.com", true },
  { "appengine.google.com", true },
  { "appharbor.com", true },
  { "apple-watch-zubehoer.de", true },
  { "appleoosa.com", true },
  { "applez.xyz", true },
  { "applic8.com", true },
  { "appmobile.io", true },
  { "appointed.at", true },
  { "appraisal-comps.com", true },
  { "appreciationkards.com", true },
  { "approbo.com", true },
  { "apps-for-fishing.com", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "appsdash.io", true },
  { "appson.co.uk", true },
  { "appuro.com", true },
  { "aprovpn.com", true },
  { "aprsdroid.org", true },
  { "aprz.de", true },
  { "apstudynotes.org", true },
  { "aquapoint.kiev.ua", true },
  { "aquilaguild.com", true },
  { "aradulconteaza.ro", true },
  { "aramido.de", true },
  { "aranycsillag.net", true },
  { "arbeitskreis-asyl-eningen.de", true },
  { "arbitrarion.com", true },
  { "arbitrary.ch", true },
  { "arboworks.com", true },
  { "archlinux.de", true },
  { "areafiftylan.nl", true },
  { "areatrend.com", true },
  { "arendburgers.nl", true },
  { "argh.io", true },
  { "arguggi.co.uk", true },
  { "arima.co.ke", true },
  { "aristocrates.co", true },
  { "arivo.com.br", false },
  { "arjandejong.eu", true },
  { "arlen.io", true },
  { "arlen.se", true },
  { "armingrodon.de", true },
  { "armor.com", true },
  { "armory.consulting", true },
  { "armory.supplies", false },
  { "arnaudfeld.de", true },
  { "arnesolutions.com", true },
  { "arnor.org", true },
  { "aroonchande.com", true },
  { "arpa.ph", true },
  { "arrmaforum.com", true },
  { "arrowgrove.com", true },
  { "ars.toscana.it", true },
  { "art2web.net", true },
  { "artegusto.ru", true },
  { "arteseideias.com.pt", true },
  { "artetrama.com", true },
  { "articaexports.com", true },
  { "artifex21.com", true },
  { "artifex21.fr", true },
  { "artisanhd.com", true },
  { "artistnetwork.nl", true },
  { "artmoney.com", true },
  { "artofwhere.com", true },
  { "artspac.es", true },
  { "arturkohut.com", true },
  { "arty.name", true },
  { "arubasunsetbeach.com", true },
  { "arvamus.eu", true },
  { "arvid.io", true },
  { "arw.me", true },
  { "aryasenna.net", true },
  { "arzaroth.com", true },
  { "as.se", true },
  { "as200753.com", true },
  { "as200753.net", true },
  { "as9178.net", true },
  { "asandu.eu", true },
  { "asasuou.pw", true },
  { "ascamso.com", true },
  { "ascii.moe", true },
  { "asdpress.cn", true },
  { "aserver.co", true },
  { "ask.fedoraproject.org", true },
  { "ask.stg.fedoraproject.org", true },
  { "askfit.cz", true },
  { "askmagicconch.com", true },
  { "askwhy.cz", true },
  { "askwhy.eu", true },
  { "asm-x.com", true },
  { "asmui.ml", true },
  { "aspargesgaarden.no", true },
  { "aspires.co.jp", true },
  { "ass.org.au", true },
  { "assdecoeur.org", true },
  { "assekuranzjobs.de", true },
  { "astengox.com", true },
  { "astromelody.com", true },
  { "asun.co", true },
  { "asurepay.cc", true },
  { "at.search.yahoo.com", false },
  { "atavio.at", true },
  { "atavio.ch", true },
  { "atavio.de", true },
  { "atbeckett.com", true },
  { "atc.io", true },
  { "atchleyjazz.com", true },
  { "atchleyjazz.org", true },
  { "atchleylab.org", true },
  { "ateli.com", true },
  { "atg.soy", true },
  { "atgseed.co.uk", true },
  { "atgseed.uk", true },
  { "ath0.org", true },
  { "athenelive.com", true },
  { "athensbusinessresources.us", true },
  { "atishchenko.com", true },
  { "atisoft.com.tr", true },
  { "atisoft.net", true },
  { "atisoft.net.tr", true },
  { "atisoft.web.tr", true },
  { "atlantichomes.com.au", true },
  { "atlantischild.hu", true },
  { "atlassian.net", true },
  { "atletika.hu", true },
  { "atlex.nl", true },
  { "atolm.net", true },
  { "atop.io", true },
  { "atte.fi", true },
  { "attorney.org.il", true },
  { "aucubin.moe", false },
  { "audiovisualdevices.com.au", true },
  { "audisto.com", true },
  { "auditmatrix.com", true },
  { "auf-feindgebiet.de", true },
  { "augias.org", true },
  { "augiero.it", true },
  { "augustian-life.cz", true },
  { "augustiner-kantorei-erfurt.de", true },
  { "augustiner-kantorei.de", true },
  { "aujapan.ru", true },
  { "aulo.in", false },
  { "aunali1.com", true },
  { "aurainfosec.com", true },
  { "aurainfosec.com.au", true },
  { "auraredeye.com", true },
  { "auraredshield.com", true },
  { "ausnah.me", true },
  { "ausschreibungen-suedtirol.it", true },
  { "aussiehq.com.au", true },
  { "auth.adult", true },
  { "authentication.io", true },
  { "authint.com", true },
  { "authoritynutrition.com", true },
  { "auto-anleitung.de", true },
  { "auto-serwis.zgorzelec.pl", true },
  { "autokovrik-diskont.ru", true },
  { "autoledky.sk", true },
  { "automacity.com", true },
  { "autotsum.com", true },
  { "autumnwindsagility.com", true },
  { "avacariu.me", true },
  { "avalon-island.ru", true },
  { "avantmfg.com", true },
  { "avarty.com", true },
  { "avastantivirus.ro", true },
  { "avenueeyecare.com", true },
  { "avg.club", true },
  { "aviacao.pt", true },
  { "avinet.com", false },
  { "avmemo.com", true },
  { "avmoo.com", true },
  { "avsox.com", true },
  { "avtovokzaly.ru", true },
  { "awanderlustadventure.com", true },
  { "awxg.com", true },
  { "axka.com", false },
  { "axrec.de", true },
  { "aylak.com", true },
  { "ayurveda101.com", true },
  { "azabani.com", true },
  { "azimut.fr", true },
  { "azirevpn.com", true },
  { "aztrix.me", true },
  { "azzag.co.uk", true },
  { "azzorti.com", true },
  { "b-root-force.de", true },
  { "b2and.com", false },
  { "b303.me", true },
  { "baalsworld.de", true },
  { "babacasino.net", true },
  { "babak.de", true },
  { "babarkata.com", true },
  { "babelfisch.eu", true },
  { "baby-click.de", true },
  { "babybee.ie", true },
  { "babyfotograf-schweiz.ch", true },
  { "babyhouse.xyz", true },
  { "babysaying.me", true },
  { "bacchanallia.com", true },
  { "backeby.eu", true },
  { "backmountaingas.com", true },
  { "backscattering.de", true },
  { "backschues.net", true },
  { "bacula.jp", true },
  { "bad.horse", true },
  { "badcronjob.com", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "badhusky.com", true },
  { "badkamergigant.com", true },
  { "badlink.org", true },
  { "baer.im", true },
  { "baer.one", true },
  { "bagelsbakery.com", true },
  { "bah.im", true },
  { "baiker.info", true },
  { "baiyangliu.com", true },
  { "bajic.ch", true },
  { "bakabt.info", true },
  { "bakaweb.fr", true },
  { "bakkerdesignandbuild.com", true },
  { "balboa.io", true },
  { "balcan-underground.net", true },
  { "balikonos.cz", true },
  { "baliyano.com", true },
  { "balkonien.org", true },
  { "ball.holdings", true },
  { "ballotapi.com", true },
  { "bananabandy.com", true },
  { "bananium.fr", true },
  { "bandrcrafts.com", true },
  { "bank.simple.com", false },
  { "bankcardoffer.com", true },
  { "bankersonline.com", true },
  { "bankin.com", true },
  { "bankofdenton.com", true },
  { "banqingdiao.com", true },
  { "baofengtech.com", true },
  { "barbaros.info", true },
  { "barbu.family", true },
  { "barcodeberlin.com", true },
  { "barcoderealty.com", true },
  { "bardiharborow.com", true },
  { "barisi.me", true },
  { "barqo.co", true },
  { "barrelhead.org", true },
  { "barrut.me", true },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "bartel.ws", true },
  { "bartlamboo.nl", true },
  { "baruch.me", true },
  { "bashc.at", true },
  { "bashcode.ninja", true },
  { "basicsolutionsus.com", true },
  { "basnieuwenhuizen.nl", true },
  { "basnoslovno.com.ua", true },
  { "basnoslovno.ru", true },
  { "bassh.net", true },
  { "bastianstalder.ch", true },
  { "baud.ninja", true },
  { "bautied.de", true },
  { "bayden.com", true },
  { "bayrisch-fuer-anfaenger.de", true },
  { "bazdell.com", true },
  { "bbdos.ru", true },
  { "bblovess.cn", true },
  { "bbnx.net", true },
  { "bbuio.com", true },
  { "bc-bd.org", true },
  { "bcbsmagentprofile.com", true },
  { "bccx.com", true },
  { "bcdonadio.com", true },
  { "bcheng.cf", true },
  { "bckp.de", true },
  { "bcmlu.org", true },
  { "bcrook.com", false },
  { "bcsytv.com", true },
  { "bcvps.com", true },
  { "bcweightlifting.ca", true },
  { "bdikaros-network.net", true },
  { "beachi.es", true },
  { "beaglewatch.com", true },
  { "beamitapp.com", true },
  { "beanjuice.me", true },
  { "beans-one.com", false },
  { "beardydave.com", true },
  { "beastowner.li", true },
  { "beautykat.ru", true },
  { "beavers.io", true },
  { "bebef.de", true },
  { "bebesurdoue.com", true },
  { "bedabox.com", true },
  { "bedeta.de", true },
  { "bedreid.dk", true },
  { "beeksnetwork.nl", true },
  { "beepan.com", true },
  { "beercandle.com", true },
  { "beeznest.com", true },
  { "beframed.ch", true },
  { "befundonline.de", true },
  { "behere.be", true },
  { "beholdthehurricane.com", true },
  { "beier.io", true },
  { "beikeil.de", true },
  { "beinad.com", true },
  { "beinad.ru", true },
  { "belcompany.nl", true },
  { "believablebook.com", false },
  { "belliash.eu.org", true },
  { "belly-button-piercings.com", true },
  { "bely-mishka.by", true },
  { "bemyvictim.com", true },
  { "ben-energy.com", false },
  { "ben.ninja", true },
  { "benchling.com", true },
  { "bendechrai.com", true },
  { "bendemaree.com", true },
  { "bendingtheending.com", true },
  { "beneathvt.com", true },
  { "beneffy.com", true },
  { "benhartmann.de", true },
  { "benjamin.pe", true },
  { "benjaminblack.net", true },
  { "benjamins.com", true },
  { "benk.press", true },
  { "benmatthews.com.au", true },
  { "benni1.eu", true },
  { "benno.frl", true },
  { "benschnarr.com", true },
  { "bentertain.de", true },
  { "bentley.link", true },
  { "bentrask.com", true },
  { "benzkosmetik.de", true },
  { "beranovi.com", true },
  { "bergstoneware.com", false },
  { "berlinleaks.com", true },
  { "bermeitinger.eu", true },
  { "bermytraq.bm", true },
  { "berr.yt", true },
  { "berra.se", true },
  { "berst.cz", true },
  { "berthabailey.com", true },
  { "beryl.net", true },
  { "bespokestraps.com", true },
  { "best-wedding-quotes.com", true },
  { "bestbrakes.com", true },
  { "bestessayhelp.com", true },
  { "besthost.cz", true },
  { "bestlashesandbrows.com", true },
  { "bestorangeseo.com", true },
  { "betaclean.fr", true },
  { "betafive.net", true },
  { "betaworx.de", true },
  { "betaworx.eu", true },
  { "betcafearena.ro", true },
  { "betonmoney.com", true },
  { "betpamm.com", true },
  { "betplanning.it", true },
  { "bettercrypto.org", true },
  { "betterhelp.com", true },
  { "bettrlifeapp.com", true },
  { "bettween.com", true },
  { "betulashop.ch", true },
  { "betz.ro", true },
  { "bevinco2020.com", true },
  { "bevinsco.org", true },
  { "bexit-hosting.nl", true },
  { "bexit-security.eu", true },
  { "bexit-security.nl", true },
  { "bexit.nl", true },
  { "bexithosting.nl", true },
  { "bf.am", true },
  { "bfear.com", true },
  { "bfelob.gov", true },
  { "bfi.wien", true },
  { "bfw-online.de", true },
  { "bgcparkstad.nl", true },
  { "bgdaddy.com", true },
  { "bgmn.net", true },
  { "bgneuesheim.de", true },
  { "bhatia.at", true },
  { "bhtelecom.ba", true },
  { "bhuntr.com", true },
  { "biasmath.es", true },
  { "biathloncup.ru", true },
  { "bible-maroc.com", true },
  { "bible.ru", true },
  { "bibleonline.ru", true },
  { "biblerhymes.com", true },
  { "biblionaut.net", true },
  { "biddl.com", true },
  { "bieberium.de", true },
  { "bielsa.me", true },
  { "bienenblog.cc", true },
  { "bienici.com", true },
  { "bierbaumer.net", true },
  { "biergaizi.info", true },
  { "big-andy.co.uk", true },
  { "big-black.de", true },
  { "bigbluedoor.net", true },
  { "bigbrownpromotions.com.au", true },
  { "bigclassaction.com", true },
  { "biguixhe.net", true },
  { "bike-shack.com", true },
  { "bikermusic.net", true },
  { "bikiniseli.com", true },
  { "bildermachr.de", true },
  { "bildiri.ci", true },
  { "bildschirmflackern.de", true },
  { "billaud.eu.org", true },
  { "billiger-mietwagen.de", true },
  { "billigssl.dk", true },
  { "billin.net", true },
  { "billogram.com", true },
  { "billpro.com", true },
  { "billpro.com.au", true },
  { "bilrom.com", true },
  { "bimbo.com", true },
  { "bimbobakeriesusa.com", true },
  { "binaryabstraction.com", true },
  { "binaryevolved.com", true },
  { "bingofriends.com", true },
  { "bingostars.com", true },
  { "biodieseldata.com", true },
  { "bioemsan.cz", true },
  { "biofam.ru", true },
  { "biolindo.com", true },
  { "bionicspirit.com", true },
  { "biosignalanalytics.com", true },
  { "biosphere.cc", true },
  { "biou.me", true },
  { "bip.gov.sa", true },
  { "birdfeeder.online", true },
  { "birkman.com", true },
  { "birminghamsunset.com", true },
  { "bit-sentinel.com", true },
  { "bit.voyage", true },
  { "bit8.com", true },
  { "bitbeans.de", true },
  { "bitbr.net", true },
  { "bitbucket.org", false },
  { "bitchan.it", true },
  { "bitcoin-india.org", true },
  { "bitcoin.asia", true },
  { "bitcoin.ch", true },
  { "bitcoin.co.nz", true },
  { "bitcoin.de", true },
  { "bitcoin.im", true },
  { "bitcoin.info", true },
  { "bitcoin.us", true },
  { "bitcoinbitcoin.com", true },
  { "bitcoinhk.org", true },
  { "bitcoinprivacy.net", true },
  { "bitcoinworld.me", true },
  { "bitcoinx.ro", true },
  { "bitf.ly", true },
  { "bitfactory.ws", true },
  { "bitfehler.net", true },
  { "bitfinder.nl", true },
  { "bitfuse.net", true },
  { "bitgo.com", true },
  { "bitheus.com", true },
  { "bitlish.com", true },
  { "bitmex.com", true },
  { "bitminter.com", true },
  { "bitmoe.com", true },
  { "bitmon.net", true },
  { "bitnet.io", true },
  { "bitok.com", true },
  { "bitpod.de", true },
  { "bitref.com", true },
  { "bitsafe.systems", true },
  { "bitshaker.net", true },
  { "bitskins.co", true },
  { "bittersweetcandybowl.com", true },
  { "bivsi.com", true },
  { "bizcms.com", true },
  { "bjornhelmersson.se", true },
  { "bjornjohansen.no", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.eu", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blablacar.co.uk", true },
  { "blablacar.com", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "black-armada.com", true },
  { "black-armada.com.pl", true },
  { "black-armada.pl", true },
  { "blackberrycentral.com", true },
  { "blackburn.link", true },
  { "blackdesertsp.com", true },
  { "blackdragoninc.org", true },
  { "blackhelicopters.net", true },
  { "blackpayment.ru", true },
  { "blaise.io", true },
  { "blastersklan.com", true },
  { "blaudev.es", true },
  { "blauwwit.be", true },
  { "blazor.nl", true },
  { "blechschmidt.saarland", true },
  { "blendle.com", true },
  { "blendle.nl", true },
  { "blessnet.jp", true },
  { "blha303.com.au", true },
  { "blindsexdate.nl", true },
  { "blinkenlight.co.uk", true },
  { "blinkenlight.com.au", true },
  { "blmiller.com", true },
  { "blockchain.info", true },
  { "blocksatz-medien.de", true },
  { "bloemendal.me", true },
  { "blog.cyveillance.com", true },
  { "blog.gov.uk", true },
  { "blog.linode.com", false },
  { "blog.torproject.org", false },
  { "blogarts.net", true },
  { "blognone.com", true },
  { "blogreen.org", true },
  { "blubbablasen.de", true },
  { "blubberladen.de", true },
  { "blue-labs.org", true },
  { "blue-leaf81.net", true },
  { "blue42.net", true },
  { "bluechilli.com", true },
  { "blueflare.org", true },
  { "blueliv.com", true },
  { "bluemosh.com", true },
  { "blueperil.de", true },
  { "bluepoint.foundation", true },
  { "bluepoint.institute", true },
  { "bluescloud.xyz", true },
  { "blumenfeldart.com", true },
  { "blumiges-fischbachtal.de", true },
  { "blupig.net", true },
  { "blurringexistence.net", true },
  { "bluserv.net", true },
  { "blusmurf.net", true },
  { "blutroyal.de", true },
  { "bm-trading.nl", true },
  { "bmoattachments.org", true },
  { "bmone.net", true },
  { "bnhlibrary.com", true },
  { "bobiji.com", true },
  { "bockenauer.at", true },
  { "bodhi.fedoraproject.org", true },
  { "bodyblog.nl", true },
  { "boeddhashop.nl", true },
  { "boensou.com", true },
  { "boernecancerfonden.dk", true },
  { "bohramt.de", true },
  { "boilesen.com", true },
  { "boiseonlinemall.com", true },
  { "bokeyy.com", true },
  { "bonapp.restaurant", true },
  { "bondskampeerder.nl", true },
  { "bonfi.net", true },
  { "bonifacius.be", true },
  { "bonobo.cz", true },
  { "bookmein.in", true },
  { "bookofraonlinecasinos.com", true },
  { "bootjp.me", true },
  { "borchers-media.de", true },
  { "boringsecurity.net", true },
  { "boringsmith.com", true },
  { "boris.one", false },
  { "borisbesemer.com", true },
  { "borrelioz.com", true },
  { "borysek.net", true },
  { "botox.bz", true },
  { "bougeret.fr", true },
  { "bouncourseplanner.net", true },
  { "bouncyball.eu", false },
  { "bouncyballs.org", true },
  { "bourse-aux-jouets.org", true },
  { "bourse-puericulture.org", true },
  { "bouwbedrijfpurmerend.nl", true },
  { "bownty.dk", true },
  { "boxcryptor.com", true },
  { "boxintense.com", true },
  { "boypoint.de", true },
  { "bpadvisors.eu", true },
  { "bpastudies.org", true },
  { "bqtoolbox.com", true },
  { "br.search.yahoo.com", false },
  { "bradbrockmeyer.com", true },
  { "bradkovach.com", true },
  { "brage.info", true },
  { "brainfork.ml", true },
  { "brainster.co", false },
  { "braintreegateway.com", true },
  { "bramvanaken.be", true },
  { "bran.cc", true },
  { "bran.land", true },
  { "branchzero.com", true },
  { "brandbuilderwebsites.com", true },
  { "brandnewdays.nl", true },
  { "brandon.so", true },
  { "brandred.net", true },
  { "brasalcosmetics.com", true },
  { "bratteng.me", true },
  { "bratteng.xyz", true },
  { "brd.ro", true },
  { "breechdepot.com", true },
  { "breeswish.org", true },
  { "bregnedalsystems.dk", true },
  { "breitbild-beamer.de", true },
  { "brejoc.com", true },
  { "brewtrackr.com", true },
  { "brianmwaters.net", true },
  { "brianpcurran.com", true },
  { "brickoo.com", true },
  { "brideandgroomdirect.ie", true },
  { "bridholm.se", true },
  { "brightonbank.com", true },
  { "brightstarkids.co.uk", false },
  { "brightstarkids.com.au", false },
  { "brightstarkids.net", false },
  { "brightstarkids.sg", false },
  { "brilliantdecisionmaking.com", true },
  { "britishscienceweek.org", true },
  { "britzer-toner.de", true },
  { "brks.xyz", true },
  { "broadsheet.com.au", true },
  { "broersma.com", true },
  { "broeselei.at", true },
  { "broken-oak.com", true },
  { "bronevichok.ru", false },
  { "brossman.it", true },
  { "brossmanit.com", true },
  { "brownfieldstsc.org", true },
  { "brrr.fr", true },
  { "brunix.net", true },
  { "brunn.email", true },
  { "brunoramos.com", true },
  { "brunoramos.org", true },
  { "brunosouza.org", true },
  { "bryanquigley.com", true },
  { "bryn.xyz", true },
  { "bsalyzer.com", true },
  { "bsidessf.com", true },
  { "bsklabels.com", false },
  { "bsquared.org", true },
  { "bta.lv", false },
  { "btcdlc.com", true },
  { "btsoft.eu", true },
  { "bubblegumblog.com", true },
  { "buchheld.at", true },
  { "buck.com", true },
  { "buddhistische-weisheiten.org", true },
  { "budgetalk.com", true },
  { "budgetthostels.nl", true },
  { "budskap.eu", true },
  { "buettgens.net", true },
  { "buffalodrinkinggame.beer", true },
  { "bugcrowd.com", true },
  { "bugginslab.co.uk", true },
  { "bugs.chromium.org", true },
  { "bugtrack.io", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "buiko.com", true },
  { "build.chromium.org", false },
  { "buildbox.io", true },
  { "buildkite.com", true },
  { "built.by", true },
  { "bukkenfan.jp", true },
  { "bulktrade.de", true },
  { "bullbits.com", true },
  { "bulldog-hosting.de", true },
  { "bulmafox.com", true },
  { "bumarkamoda.com", true },
  { "bunbun.be", true },
  { "bund-von-theramore.de", true },
  { "bundaberg.com", true },
  { "bunsenlabs.org", true },
  { "bureaubolster.nl", true },
  { "burningcrash.de", true },
  { "burningflipside.com", true },
  { "burnworks.com", true },
  { "burtrum.me", true },
  { "burtrum.org", true },
  { "burzmali.com", true },
  { "busindre.com", true },
  { "business.facebook.com", false },
  { "business.lookout.com", false },
  { "businessesdirectory.eu", true },
  { "businessfurs.info", true },
  { "businesshosting.nl", true },
  { "busold.ws", true },
  { "bustimes.org", true },
  { "butchersworkshop.com", true },
  { "buyfox.de", true },
  { "buyinginvestmentproperty.com", true },
  { "buzzconcert.com", true },
  { "buzzconf.io", true },
  { "bvalle.com", true },
  { "bwcscorecard.org", true },
  { "bwear4all.de", true },
  { "by4cqb.cn", true },
  { "bygningsregistrering.dk", true },
  { "bypro.xyz", true },
  { "byronwade.com", true },
  { "byrtz.de", true },
  { "byte.wtf", true },
  { "bytejail.com", true },
  { "byteshark.org", true },
  { "bytesofcode.de", true },
  { "bytesund.biz", true },
  { "bytesystems.com", true },
  { "byteturtle.eu", true },
  { "bziaks.xyz", true },
  { "bztech.com.br", true },
  { "bzv-fr.eu", true },
  { "c.cc", true },
  { "c16t.uk", true },
  { "c1yd3i.me", true },
  { "c3b.info", false },
  { "c3w.at", true },
  { "ca.gparent.org", true },
  { "ca.search.yahoo.com", false },
  { "cabarave.com", true },
  { "cabsites.com", true },
  { "cabusar.fr", true },
  { "cacaolalina.com", true },
  { "cachethq.io", true },
  { "cackette.com", true },
  { "cadao.me", true },
  { "cadoth.net", true },
  { "caesarkabalan.com", true },
  { "caesreon.com", true },
  { "cafe-scientifique.org.ec", true },
  { "caffeinatedcode.com", true },
  { "cais.de", true },
  { "caizx.com", true },
  { "caja-pdf.es", true },
  { "cajapopcorn.com", true },
  { "cajunuk.co.uk", true },
  { "calaborlawnews.com", true },
  { "calculator-imt.com", true },
  { "calebmorris.com", true },
  { "calgoty.com", true },
  { "calibso.net", true },
  { "calix.com", true },
  { "call.me", false },
  { "callsigns.ca", true },
  { "calltrackingreports.com", true },
  { "calomel.org", true },
  { "calories.org", true },
  { "calvin.me", true },
  { "calvinallen.net", true },
  { "camaya.net", true },
  { "cambridgeanalytica.org", true },
  { "camconn.cc", true },
  { "camolist.com", true },
  { "campaign-ad.com", true },
  { "campbellsoftware.co.uk", true },
  { "campbrainybunch.com", true },
  { "camperdays.de", true },
  { "campermanaustralia.com", true },
  { "camperverzekerd.nl", true },
  { "campfourpaws.com", true },
  { "campus-finance.com", true },
  { "canadalife.de", true },
  { "canadasmotorcycle.ca", true },
  { "canarymod.net", true },
  { "candicontrols.com", true },
  { "cando.eu", true },
  { "candratech.com", true },
  { "canhazip.com", true },
  { "cannyfoxx.me", true },
  { "canyonshoa.com", true },
  { "canyoupwn.me", true },
  { "cao.gov", true },
  { "cao.la", true },
  { "caphane.com", true },
  { "capitalquadatv.org.nz", true },
  { "capitaltg.com", true },
  { "capogna.com", true },
  { "capper.de", true },
  { "capriccio.to", true },
  { "captchatheprize.com", true },
  { "captivatedbytabrett.com", true },
  { "capturapp.com", true },
  { "capturethepen.co.uk", true },
  { "caputo.com", true },
  { "carano-service.de", true },
  { "caraudio69.cz", true },
  { "carbonmade.com", false },
  { "carck.co.uk", true },
  { "cardloan-manual.net", true },
  { "cardrecovery.fr", true },
  { "cardstream.com", true },
  { "careerstuds.com", true },
  { "caremad.io", true },
  { "carey.li", true },
  { "carezone.com", false },
  { "cargobay.net", true },
  { "carigami.fr", true },
  { "carlandfaith.com", true },
  { "carlgo11.com", true },
  { "carlosalves.info", true },
  { "carnaticalifornia.com", true },
  { "carnildo.com", true },
  { "carsforbackpackers.com", true },
  { "carsten.pw", true },
  { "carstenfeuls.de", true },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "casa-su.casa", true },
  { "casedi.org", true },
  { "cashlink.io", true },
  { "casinolistings.com", true },
  { "casinoreal.com", true },
  { "casperpanel.com", true },
  { "castlejackpot.com", true },
  { "cat-box.de", true },
  { "catalyst-ecommerce.com", true },
  { "catgirl.pics", true },
  { "catinmay.com", true },
  { "cativa.net", true },
  { "catnapstudios.com", true },
  { "catnet.dk", false },
  { "catsmagic.pp.ua", true },
  { "cattivo.nl", true },
  { "cavac.at", true },
  { "caveclan.org", true },
  { "cavedroid.xyz", true },
  { "cbhq.net", true },
  { "ccayearbook.com", true },
  { "ccblog.de", true },
  { "ccja.ro", false },
  { "ccsys.com", true },
  { "cdlcenter.com", true },
  { "cdnb.co", true },
  { "cdnjs.com", true },
  { "cdt.org", true },
  { "ced-services.nl", true },
  { "ceilingpac.org", true },
  { "cejhon.cz", true },
  { "celec.gob.ec", true },
  { "celti.ie.eu.org", true },
  { "celti.name", true },
  { "cementscience.com", true },
  { "centennialrewards.com", true },
  { "centerpereezd.ru", false },
  { "centillien.com", true },
  { "centralpoint.be", true },
  { "centralpoint.nl", true },
  { "centralstatecu.org", true },
  { "centrepoint-community.com", false },
  { "centricweb.com", true },
  { "centrobill.com", true },
  { "ceopedia.org", true },
  { "cerastar.com", true },
  { "cerebelo.info", true },
  { "cerfrance.fr", true },
  { "ceritamalam.net", true },
  { "certcenter.com", true },
  { "certcenter.de", true },
  { "certible.com", true },
  { "certifi.io", true },
  { "certly.io", true },
  { "certnazionale.it", true },
  { "cervejista.com", true },
  { "cesal.net", true },
  { "cesidianroot.eu", true },
  { "cesobaly.cz", true },
  { "ceu.edu", true },
  { "cevrimici.com", true },
  { "cfa.gov", true },
  { "cfcnexus.org", true },
  { "cfcproperties.com", true },
  { "cfetengineering.com", true },
  { "cfh.com", true },
  { "cfo.gov", true },
  { "cfoitplaybook.com", true },
  { "cg-systems.hu", true },
  { "cgan.pw", true },
  { "cgbilling.com", true },
  { "cgtx.us", true },
  { "ch.search.yahoo.com", false },
  { "chabaudparfum.com", true },
  { "chahub.com", true },
  { "chainmonitor.com", true },
  { "chaletmanager.com", true },
  { "chamilo.org", true },
  { "changetip.com", true },
  { "chaos-inc.de", true },
  { "chaos.fail", true },
  { "chaoschemnitz.de", true },
  { "chaosdorf.de", true },
  { "chaoswebs.net", true },
  { "charge.co", true },
  { "charityclear.com", true },
  { "charlierogers.com", true },
  { "charmander.me", true },
  { "charmyadesara.com", true },
  { "chartpen.com", true },
  { "chatbot.me", true },
  { "chatear.social", true },
  { "chateau-belvoir.com", true },
  { "chatme.im", false },
  { "chatup.cf", true },
  { "chaulootz.com", true },
  { "chaz6.com", true },
  { "chazay.net", true },
  { "chcemvediet.sk", true },
  { "chch.it", true },
  { "cheapgeekts.com", false },
  { "chebedara.com", true },
  { "check.torproject.org", false },
  { "checkout.google.com", true },
  { "checktype.com", true },
  { "checkyourmath.com", true },
  { "cheerflow.com", true },
  { "cheesetart.my", false },
  { "cheetah85.de", true },
  { "chenapartment.com", true },
  { "chepaofen.com", true },
  { "cherrywoodtech.com", true },
  { "chestnut.cf", true },
  { "chfr.search.yahoo.com", false },
  { "chiaramail.com", true },
  { "chic-leather.com", true },
  { "chihiro.xyz", true },
  { "chikan-beacon.net", true },
  { "childcaresolutionscny.org", true },
  { "chilihosting.eu", true },
  { "chimeratool.com", true },
  { "china-line.org", true },
  { "chinternet.xyz", true },
  { "chiphell.com", true },
  { "chippy.ch", false },
  { "chiralsoftware.com", true },
  { "chireiden.net", true },
  { "chirgui.eu", true },
  { "chit.search.yahoo.com", false },
  { "chloe.re", true },
  { "chocolah.com.au", false },
  { "chocotough.nl", false },
  { "choosemypc.net", true },
  { "chorpinkpoemps.de", true },
  { "chotu.net", true },
  { "chris-edwards.net", true },
  { "chris-web.info", false },
  { "chrisandsarahinasia.com", true },
  { "chrisbrown.id.au", true },
  { "chrisfaber.com", true },
  { "chrisfinazzo.com", true },
  { "chrishamper.com", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chriskyrouac.com", true },
  { "chrismckee.co.uk", true },
  { "christadelphiananswers.org", true },
  { "christiaanconover.com", true },
  { "christiaandruif.nl", true },
  { "christianbro.gq", true },
  { "christianhoffmann.info", true },
  { "christianliebel.com", true },
  { "christiesantiques.com", true },
  { "christophheich.me", true },
  { "chrisupjohn.com", true },
  { "chriswarrick.com", true },
  { "chriswells.io", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromebooksforwork.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chrst.ph", true },
  { "chua.cf", true },
  { "chulado.com", true },
  { "chun.pro", true },
  { "ciat.no", true },
  { "cidbot.com", true },
  { "cienbeaute-lidl.fr", true },
  { "cig-dem.com", true },
  { "cigarblogs.net", true },
  { "cigarterminal.com", true },
  { "cimalando.eu", true },
  { "cimballa.com", true },
  { "cinefilzonen.se", true },
  { "cintdirect.com", true },
  { "cio.gov", true },
  { "cipherboy.com", true },
  { "cipherli.st", true },
  { "cirfi.com", true },
  { "cirope.com", true },
  { "cirrus0.de", true },
  { "ciscodude.net", true },
  { "ciscohomeanalytics.com", true },
  { "ciscommerce.net", true },
  { "citizensbankal.com", true },
  { "cittadesign.com", true },
  { "citya.com", true },
  { "ciubotaru.tk", true },
  { "ckleemann.de", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "cktennis.com", true },
  { "cl.search.yahoo.com", false },
  { "claimconnect.us", true },
  { "clan-ww.com", true },
  { "clanthor.com", true },
  { "clapping-rhymes.com", true },
  { "claralabs.com", true },
  { "clarkeaward.com", true },
  { "classdojo.com", true },
  { "classicday.nl", true },
  { "classicshop.ua", true },
  { "classicspublishing.com", true },
  { "clawe.de", true },
  { "clcleaningco.com", true },
  { "cldly.com", true },
  { "clearc.tk", false },
  { "clearkonjac.com", true },
  { "clearsettle-admin.com", true },
  { "clearviewwealthprojector.com.au", true },
  { "clerkendweller.uk", true },
  { "clevertarget.ru", true },
  { "clevisto.com", true },
  { "clickclickphish.com", true },
  { "clickenergy.com.au", true },
  { "clickforclever.com", true },
  { "clickphish.com", true },
  { "clientsecure.me", true },
  { "climateinteractive.org", true },
  { "climatestew.com", true },
  { "clintwilson.technology", true },
  { "clipped4u.com", true },
  { "clmde.de", true },
  { "clochix.net", true },
  { "clockcaster.com", true },
  { "clockworksms.com", true },
  { "close.com", true },
  { "cloud-project.com", true },
  { "cloud.google.com", true },
  { "cloud.wtf", true },
  { "cloudapi.vc", true },
  { "cloudbolin.es", true },
  { "cloudey.net", true },
  { "cloudflareonazure.com", true },
  { "cloudily.com", true },
  { "cloudimag.es", true },
  { "cloudmigrator365.com", true },
  { "cloudns.com.au", true },
  { "cloudpagesforwork.com", true },
  { "cloudpebble.net", true },
  { "cloudsecurityalliance.org", true },
  { "cloudspace-analytics.com", true },
  { "cloudstoragemaus.com", true },
  { "cloudstorm.me", true },
  { "cloudstrike.co", true },
  { "cloudup.com", true },
  { "cloverleaf.net", true },
  { "clownish.co.il", true },
  { "cloxy.com", true },
  { "clsimplex.com", true },
  { "clu-in.org", true },
  { "clubmate.rocks", true },
  { "clubmini.jp", true },
  { "clvrwebdesign.com", true },
  { "clycat.ru", true },
  { "clywedogmaths.co.uk", true },
  { "cmacacias.ch", true },
  { "cmahy.be", true },
  { "cmdline.org", true },
  { "cmlachapelle.ch", true },
  { "cmlancy.ch", true },
  { "cmplainpalais.ch", true },
  { "cmsbattle.com", true },
  { "cmscafe.ru", true },
  { "cnam.net", true },
  { "cni-certing.it", true },
  { "cnlic.com", true },
  { "co.search.yahoo.com", false },
  { "co50.com", true },
  { "coachingconsultancy.com", true },
  { "coam.co", true },
  { "cobalt.io", false },
  { "cocaine.ninja", true },
  { "cocker.cc", false },
  { "cocoaheads.at", true },
  { "cocolovesdaddy.com", true },
  { "codabix.com", true },
  { "codabix.de", true },
  { "codabix.net", true },
  { "code-poets.co.uk", true },
  { "code.facebook.com", false },
  { "code.fm", true },
  { "code.google.com", true },
  { "code67.com", true },
  { "codeferm.com", true },
  { "codeforce.io", true },
  { "codefoundry.it", true },
  { "codelayer.ca", true },
  { "codeplay.org", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepult.com", true },
  { "codepx.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", false },
  { "coderhangout.com", true },
  { "codesport.io", true },
  { "codeux.com", true },
  { "codewild.de", true },
  { "codewiththepros.org", true },
  { "codeyellow.nl", true },
  { "codingforspeed.com", true },
  { "codyevanscomputer.com", true },
  { "coffee-mamenoki.jp", true },
  { "cogent.cc", true },
  { "cogumelosmagicos.org", true },
  { "coi-verify.com", true },
  { "coiffeurschnittstelle.ch", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "coindam.com", false },
  { "coinessa.com", true },
  { "coinjar-sandbox.com", true },
  { "cojo.eu", true },
  { "coldawn.com", true },
  { "coldfff.com", true },
  { "coldhak.ca", true },
  { "colisfrais.com", true },
  { "collabornation.net", true },
  { "collada.org", true },
  { "collectiblebeans.com", true },
  { "collegepulse.org", true },
  { "collinmbarrett.com", false },
  { "collinsartworks.com", true },
  { "colognegaming.net", true },
  { "coloradocomputernetworking.net", true },
  { "coloradolottery.com", true },
  { "colorbrush.ru", true },
  { "coloringnotebook.com", true },
  { "colorlib.com", true },
  { "com.cc", true },
  { "comarkinstruments.net", true },
  { "combatshield.cz", true },
  { "comdurav.com", true },
  { "comercialtrading.eu", true },
  { "comfortticket.de", true },
  { "comhack.com", true },
  { "comicspines.com", true },
  { "comitesaustria.at", true },
  { "comiteshopping.com", true },
  { "commencepayments.com", true },
  { "commerciallocker.com", true },
  { "commoncore4kids.com", true },
  { "communityblog.fedoraproject.org", true },
  { "comodo.nl", true },
  { "compalytics.com", true },
  { "comparamejor.com", true },
  { "compareandrecycle.co.uk", true },
  { "compareandrecycle.com", true },
  { "compareinsurance.com.au", true },
  { "comparejewelleryprices.co.uk", true },
  { "comparetravelinsurance.com.au", true },
  { "compeuphoria.com", true },
  { "compiledworks.com", true },
  { "completionist.audio", true },
  { "completionist.me", true },
  { "compliance-systeme.de", true },
  { "complymd.com", true },
  { "compucorner.com.mx", true },
  { "compucorner.mx", true },
  { "compuscan.co.za", true },
  { "computeremergency.com.au", false },
  { "comssa.org.au", true },
  { "concentrade.de", true },
  { "condepenalba.com", true },
  { "config.schokokeks.org", false },
  { "confirm365.com", true },
  { "conformal.com", true },
  { "connect.ua", false },
  { "connected-verhuurservice.nl", true },
  { "connectfss.com", true },
  { "connectingconcepts.com", true },
  { "connext.de", true },
  { "connyduck.at", true },
  { "conrad-kostecki.de", true },
  { "consciousandglamorous.com", true },
  { "consciousbrand.co", true },
  { "consciousbrand.org.au", true },
  { "consciousbranding.org.au", true },
  { "consciousbrands.net.au", true },
  { "console.support", true },
  { "consonare.de", true },
  { "constructdigital.net", true },
  { "constructionjobs.com", true },
  { "consul.io", true },
  { "consumer.gov", true },
  { "consumersentinel.gov", true },
  { "contactbig.com", true },
  { "containerstatistics.com", true },
  { "contarkos.xyz", true },
  { "content-api-dev.azurewebsites.net", true },
  { "continuumgaming.com", false },
  { "contributor.google.com", true },
  { "controlcenter.gigahost.dk", true },
  { "conversiones.com", true },
  { "convert.zone", true },
  { "converter.ml", true },
  { "convocatoriafundacionpepsicomexico.org", false },
  { "cookinglife.nl", false },
  { "cookmedical.com", false },
  { "cool110.tk", true },
  { "coolaj86.com", true },
  { "coolchevy.org.ua", true },
  { "coopens.com", true },
  { "coore.jp", true },
  { "cooxa.com", true },
  { "copperhead.co", true },
  { "cor-ser.es", true },
  { "coralproject.net", true },
  { "cordlessdog.com", true },
  { "core.mx", true },
  { "coreless-stretchfilm.com", true },
  { "cornercircle.co.uk", true },
  { "coronelpicanha.com.br", true },
  { "corpfin.net", true },
  { "correctpaardbatterijnietje.nl", true },
  { "corruption-mc.net", true },
  { "corruption-rsps.net", true },
  { "corruption-server.net", true },
  { "cortexitrecruitment.com", true },
  { "coryadum.com", true },
  { "costablancavoorjou.com", true },
  { "costreportdata.com", true },
  { "cotonea.de", true },
  { "coughlan.de", true },
  { "count.sh", true },
  { "countermail.com", true },
  { "countybankdel.com", true },
  { "couragewhispers.ca", true },
  { "coursdeprogrammation.com", true },
  { "coursera.org", true },
  { "courtlistener.com", true },
  { "covenantbank.net", true },
  { "covenantoftheriver.org", true },
  { "coverduck.ru", true },
  { "covoiturage.fr", false },
  { "covybrat.cz", true },
  { "cowboyim.com", true },
  { "coweo.cz", true },
  { "cozmaadrian.ro", true },
  { "cpuvinf.eu.org", true },
  { "cpvmatch.eu", true },
  { "cqchome.com", true },
  { "cracker.in.th", true },
  { "cracking.org", true },
  { "crackingking.com", false },
  { "cradlepointecm.com", true },
  { "craftbeerbarn.co.uk", true },
  { "craftinginredlipstick.com", true },
  { "cranesafe.com", true },
  { "cravelyrics.com", true },
  { "crazycen.com", true },
  { "crazydomains.ae", true },
  { "crazydomains.co.nz", true },
  { "crazydomains.co.uk", true },
  { "crazydomains.com.au", true },
  { "crazydomains.in", true },
  { "crazyhotseeds.com", true },
  { "crbug.com", false },
  { "creativeplayuk.com", true },
  { "creditkarma.com", true },
  { "creditproautos.com", true },
  { "creep.im", true },
  { "crefelder.com", true },
  { "crendontech.com", true },
  { "crepererum.net", true },
  { "crestasantos.com", true },
  { "crestoncottage.com", true },
  { "criena.net", false },
  { "crimson.no", true },
  { "critical.today", true },
  { "criticalaim.com", true },
  { "crizk.com", true },
  { "crl-autos.com", true },
  { "crm.onlime.ch", false },
  { "crosscom.ch", true },
  { "crossfitblackwater.com", true },
  { "crosssec.com", true },
  { "crow.tw", true },
  { "crowd.supply", true },
  { "crowdjuris.com", true },
  { "crowdsupply.com", true },
  { "crudysql.com", true },
  { "crufad.org", true },
  { "crushroom.com", true },
  { "crute.me", true },
  { "cruzr.xyz", true },
  { "crypt.guru", true },
  { "crypticshell.co.uk", true },
  { "cryptify.eu", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "cryptobells.com", false },
  { "cryptobin.co", true },
  { "cryptobin.org", true },
  { "cryptocon.org", true },
  { "cryptography.io", true },
  { "cryptoisnotacrime.org", true },
  { "cryptojar.io", true },
  { "cryptolab.pro", true },
  { "cryptonit.net", true },
  { "cryptonym.com", true },
  { "cryptoparty.at", true },
  { "cryptoparty.dk", true },
  { "cryptopartyatx.org", true },
  { "cryptopartyutah.org", true },
  { "cryptopush.com", true },
  { "cryptoseb.pw", true },
  { "crystalchandelierservices.com", true },
  { "crystalclassics.co.uk", true },
  { "csacongress.org", true },
  { "csapak.com", true },
  { "csbs.fr", true },
  { "cselzer.com", true },
  { "csfm.com", true },
  { "csfs.org.uk", true },
  { "csgokings.eu", true },
  { "csokolade.hu", true },
  { "cspbuilder.info", true },
  { "cspvalidator.org", true },
  { "cssu.in", true },
  { "csuw.net", true },
  { "csvape.com", true },
  { "ct-status.org", true },
  { "cthomas.work", true },
  { "cthulhuden.com", true },
  { "ctns.de", true },
  { "ctoforhire.com.au", true },
  { "ctpe.net", true },
  { "cube.de", true },
  { "cubewano.com", true },
  { "cubua.com", true },
  { "cuibonobo.com", true },
  { "cuisinezest.com", true },
  { "culinae.nl", true },
  { "cultiv.nl", false },
  { "cupcake.io", true },
  { "cupcake.is", true },
  { "curacao-license.com", true },
  { "curiosity-driven.org", true },
  { "curlybracket.co.uk", true },
  { "curlyroots.com", true },
  { "curroapp.com", true },
  { "curtacircuitos.com.br", false },
  { "curveweb.co.uk", true },
  { "custe.rs", true },
  { "custodyxchange.com", true },
  { "customd.com", true },
  { "cutorrent.com", true },
  { "cuvva.co", true },
  { "cvjm-memmingen.de", true },
  { "cvmu.jp", true },
  { "cvr.dk", true },
  { "cvsoftub.com", true },
  { "cvursache.com", true },
  { "cwagner.me", true },
  { "cyanogenmod.xxx", true },
  { "cyberfrancais.ro", true },
  { "cyberguerrilla.info", true },
  { "cyberguerrilla.org", true },
  { "cyberhouse.at", true },
  { "cyberianhusky.com", true },
  { "cyberkov.com", true },
  { "cyberoptic.de", true },
  { "cyberpunk.ca", true },
  { "cybersecuritychallenge.be", true },
  { "cybershambles.com", true },
  { "cyberwire.nl", true },
  { "cybozu.cn", true },
  { "cybozu.com", true },
  { "cybozulive.com", true },
  { "cyclebeads.com", true },
  { "cydia-search.io", true },
  { "cyfly.org", true },
  { "cygnius.net", true },
  { "cymtech.net", true },
  { "cyon.ch", true },
  { "cyph.audio", true },
  { "cyph.com", true },
  { "cyph.im", true },
  { "cyph.video", true },
  { "cyphertite.com", true },
  { "cyprus-company-service.com", true },
  { "cysec.biz", true },
  { "czakey.net", true },
  { "czbix.com", true },
  { "czechamlp.com", true },
  { "czk.mk", true },
  { "czlx.co", true },
  { "d-20.fr", true },
  { "d-designerin.de", true },
  { "d-training.de", true },
  { "d3xt3r01.tk", true },
  { "d42.no", true },
  { "daallexx.eu", true },
  { "dachb0den.net", true },
  { "dadons-laserdiscs.com", true },
  { "dadtheimpaler.com", true },
  { "daduke.org", true },
  { "daemon.xin", true },
  { "dag-konsult.com", true },
  { "dailyenglishchallenge.com", true },
  { "dailystormerpodcasts.com", true },
  { "daimadi.com", true },
  { "dairyshrine.org", true },
  { "dakrib.net", true },
  { "dale-electric.com", true },
  { "dalfiume.it", true },
  { "dalingk.co", true },
  { "dallmeier.net", true },
  { "damianuv-blog.cz", true },
  { "dammekens.be", true },
  { "damngoodpepper.com", true },
  { "danaketh.com", true },
  { "dancerdates.net", true },
  { "daniel-ruf.de", true },
  { "danielalvarez.net", true },
  { "danielcowie.me", true },
  { "danieltollot.de", true },
  { "danielverlaan.nl", true },
  { "danielworthy.com", true },
  { "danilapisarev.com", true },
  { "danjesensky.com", true },
  { "dank.ninja", true },
  { "dankim.de", true },
  { "dannycrichton.com", true },
  { "dannyrohde.de", true },
  { "danonsecurity.com", true },
  { "danpiel.net", true },
  { "danscomp.com", true },
  { "danseressen.nl", true },
  { "danskoferie.dk", true },
  { "danw.io", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "daplie.com", true },
  { "darchoods.net", false },
  { "dargasia.is", true },
  { "dario.im", true },
  { "darioturchetti.me", true },
  { "dark-x.cf", true },
  { "darkag.ovh", true },
  { "darkdestiny.ch", true },
  { "darkengine.io", true },
  { "darkkeepers.dk", true },
  { "darknebula.space", false },
  { "darknode.in", true },
  { "darkpony.ru", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darkshop.nl", true },
  { "darkside.re", true },
  { "darksideof.it", true },
  { "darkspacelab.com", true },
  { "darkwater.info", true },
  { "darlo.co.uk", true },
  { "darom.jp", true },
  { "darrenm.net", true },
  { "darwinkel.net", false },
  { "dash-board.jp", false },
  { "dash.rocks", true },
  { "dashnimorad.com", true },
  { "data-abundance.com", true },
  { "data.haus", true },
  { "data.qld.gov.au", false },
  { "data102.com", true },
  { "databutlr.net", true },
  { "datacalle.com", true },
  { "datacandy.com", true },
  { "datajapan.co.jp", true },
  { "datapun.ch", true },
  { "dataretention.solutions", true },
  { "datascience.cafe", true },
  { "datasharesystem.com", true },
  { "datasnitch.co.uk", true },
  { "datatekniikka.com", false },
  { "datatekniikka.fi", false },
  { "dateno1.com", false },
  { "datorb.com", false },
  { "datortipsen.se", true },
  { "datsound.ru", true },
  { "daveoc64.co.uk", true },
  { "davevelopment.net", true },
  { "david-corry.com", true },
  { "david-schiffmann.de", true },
  { "david.kitchen", true },
  { "davidandersson.se", true },
  { "davidgouveia.net", true },
  { "davidgow.net", true },
  { "davidgrudl.com", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidmessenger.co.uk", true },
  { "davidnoren.com", true },
  { "davidreinhardt.de", true },
  { "davidscherzer.at", true },
  { "davisroi.com", true },
  { "daylightpirates.org", true },
  { "dbgamestudio.com", true },
  { "dbmteam.com", true },
  { "dbx.ovh", true },
  { "dc585.info", true },
  { "dccode.gov", true },
  { "dccoffeeproducts.com", true },
  { "dckd.nl", true },
  { "dcmt.co", true },
  { "dcpower.eu", true },
  { "dcurt.is", true },
  { "dd.art.pl", true },
  { "ddatsh.com", true },
  { "dden.ca", false },
  { "ddhosted.com", true },
  { "ddos-mitigation.co.uk", true },
  { "ddos-mitigation.info", true },
  { "de-medici.nl", true },
  { "de-spil.be", true },
  { "de.search.yahoo.com", false },
  { "deadbeef.ninja", true },
  { "dealbanana.com", true },
  { "dealbanana.it", true },
  { "dealcruiser.nl", true },
  { "dealpass.no", true },
  { "deanmorgan.org", true },
  { "deathy.ro", true },
  { "decafu.co", true },
  { "deco.me", true },
  { "decoder.link", true },
  { "decomplify.com", true },
  { "decor-d.com", true },
  { "decoratrix.com", true },
  { "decoyrouting.com", true },
  { "dedelta.net", true },
  { "dedeo.tk", true },
  { "dedicatutiempo.es", true },
  { "dedimax.de", true },
  { "dedmorozrzn.ru", true },
  { "deduijventil.nl", true },
  { "dee.pe", true },
  { "deepbluecrafting.co.uk", true },
  { "deepcovelabs.net", true },
  { "deeprecce.com", true },
  { "deepserve.info", true },
  { "deer.team", true },
  { "deetzen.de", true },
  { "defcon.org", true },
  { "degeberg.com", true },
  { "degeberg.dk", true },
  { "degroetenvanrosaline.nl", true },
  { "deight.co", true },
  { "deinballon.de", true },
  { "dekasan.ru", true },
  { "delfic.org", true },
  { "deliciisanatoase.ro", true },
  { "deliverance.co.uk", false },
  { "delta-data.ch", true },
  { "deltanet-production.de", true },
  { "delvj.org", true },
  { "dementiapraecox.de", true },
  { "demo.swedbank.se", true },
  { "democracy.io", true },
  { "democracychronicles.com", true },
  { "demomanca.com", false },
  { "demuzere.be", true },
  { "demuzere.com", true },
  { "demuzere.eu", true },
  { "demuzere.net", true },
  { "denh.am", true },
  { "denimio.com", true },
  { "denisjean.fr", true },
  { "dennisdoes.net", true },
  { "denniskoot.nl", true },
  { "dennogumi.org", true },
  { "dentallaborgeraeteservice.de", true },
  { "dentistglasgow.com", true },
  { "dentystabirmingham.co.uk", true },
  { "denverprophit.us", true },
  { "depechemode-live.com", true },
  { "dequehablamos.es", true },
  { "derbyshire-language-scheme.co.uk", true },
  { "derchris.me", true },
  { "dereferenced.net", true },
  { "deregowski.net", true },
  { "dergeilstestammderwelt.de", true },
  { "derhil.de", true },
  { "derp.army", true },
  { "derreichesack.com", true },
  { "dersoundhunter.de", true },
  { "derwolfe.net", true },
  { "desiccantpackets.com", true },
  { "designgears.com", true },
  { "desmaakvanplanten.be", true },
  { "destinationbijoux.fr", true },
  { "detectify.com", false },
  { "detector.exposed", true },
  { "detest.org", true },
  { "detoxsinutritie.ro", true },
  { "detteflies.com", true },
  { "detutorial.com", true },
  { "deuxsolutions.com", true },
  { "devb.nl", true },
  { "devcu.com", true },
  { "devdoodle.net", true },
  { "developer.mydigipass.com", false },
  { "developers.facebook.com", false },
  { "developfx.com", true },
  { "developmentaid.org", true },
  { "devh.net", true },
  { "devilshakerz.com", true },
  { "deviltracks.net", true },
  { "deviltraxxx.de", true },
  { "devincrow.me", true },
  { "devinfo.net", false },
  { "devklog.net", true },
  { "devlux.ch", true },
  { "devmsg.com", true },
  { "devnsec.com", true },
  { "devnull.team", true },
  { "devolution.ws", true },
  { "devopps.me", true },
  { "devopsconnected.com", true },
  { "devstaff.gr", true },
  { "devuan.org", true },
  { "dewalch.net", true },
  { "dfekt.no", true },
  { "dfranke.com", true },
  { "dgeex.eu", true },
  { "dhautefeuille.eu", true },
  { "dhauwer.nl", true },
  { "dhuy.net", true },
  { "diamante.ro", true },
  { "diarbag.us", true },
  { "diasdasemana.com", true },
  { "dibiphp.com", true },
  { "dicgaming.net", true },
  { "dick.red", true },
  { "didacte.com", true },
  { "diddens.de", true },
  { "die-besten-weisheiten.de", true },
  { "die-blahuts.de", true },
  { "die-partei-reutlingen.de", true },
  { "diegelernten.de", true },
  { "diegerbers.de", true },
  { "dienstplan.cc", true },
  { "dienstplan.one", true },
  { "dierenkruiden.nl", false },
  { "dieti.net", true },
  { "dietrich.cx", true },
  { "dighans.com", true },
  { "digidroom.be", true },
  { "digital-coach.it", true },
  { "digital-eastside.de", true },
  { "digital1st.co.uk", true },
  { "digitalehandtekeningen.nl", true },
  { "digitallocker.com", true },
  { "digitalnonplus.com", true },
  { "digitalquery.com", true },
  { "digitalskillswap.com", true },
  { "digitkon.com", true },
  { "digminecraft.com", true },
  { "dijkmanmuziek.nl", false },
  { "dillonkorman.com", true },
  { "dime-staging.com", true },
  { "dime.io", true },
  { "dinge.xyz", true },
  { "dinkum.online", true },
  { "dinube.com", true },
  { "diodeled.com", true },
  { "dipl.io", true },
  { "directebanking.com", true },
  { "directme.ga", true },
  { "dirkwolf.de", true },
  { "discipul.nl", true },
  { "discofitta.com", true },
  { "disconformity.net", true },
  { "discoveringdocker.com", true },
  { "dise-online.de", true },
  { "disinclined.org", true },
  { "disking.co.uk", true },
  { "disorderboutique.com", true },
  { "disposable.link", true },
  { "disruptivelabs.net", true },
  { "disruptivelabs.org", true },
  { "dissectcyber.com", true },
  { "dissimulo.me", true },
  { "dist.torproject.org", false },
  { "distinctivephotography.com.au", true },
  { "dittvertshus.no", true },
  { "divegearexpress.com", true },
  { "diversityflags.com", true },
  { "divingwithnic.com", true },
  { "dixiediner.com", true },
  { "dixmag.com", true },
  { "diybook.at", true },
  { "diycc.org", true },
  { "dizorg.net", true },
  { "djxmmx.net", true },
  { "djz4music.com", true },
  { "dk.search.yahoo.com", false },
  { "dkds.us", true },
  { "dl.google.com", true },
  { "dlc.viasinc.com", true },
  { "dlemper.de", true },
  { "dlscomputers.com.au", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dmeevalumate.com", true },
  { "dmi.es", true },
  { "dmlogic.com", true },
  { "dmxledlights.com", true },
  { "dn42.eu", true },
  { "dn42.us", true },
  { "dna.li", true },
  { "dnc.org.nz", true },
  { "dndtools.net", true },
  { "dnmlab.it", true },
  { "dns.google.com", true },
  { "dnscrypt.org", true },
  { "dnscurve.io", true },
  { "dnshallinta.fi", true },
  { "dnslog.com", true },
  { "dnsman.se", true },
  { "dobet.in", true },
  { "doc.python.org", true },
  { "docemeldoces.com", true },
  { "docid.io", true },
  { "docket.news", true },
  { "docloh.de", true },
  { "docs.google.com", true },
  { "docs.python.org", true },
  { "doctor-locks.co.uk", true },
  { "doctorfox.co.uk", true },
  { "doctorwho.cz", true },
  { "docucopies.com", true },
  { "docufiel.com", true },
  { "doesmycodehavebugs.today", true },
  { "doeswindowssuckforeveryoneorjustme.com", true },
  { "dogan.ch", false },
  { "dogbox.se", true },
  { "dogespeed.ga", true },
  { "dogfi.sh", true },
  { "dogoodbehappyllc.com", true },
  { "doku-gilde.de", true },
  { "dokuboard.com", true },
  { "dolarcanadense.com.br", true },
  { "dolphin-cloud.com", true },
  { "dolphin-hosting.com", true },
  { "dolphin-it.de", true },
  { "dolphincorp.co.uk", true },
  { "dolphinswithlasers.com", true },
  { "domadillo.com", true },
  { "domainexpress.de", true },
  { "domainkauf.de", true },
  { "domains.google.com", true },
  { "domainstaff.com", true },
  { "domfee.com", true },
  { "domhaase.me", true },
  { "dominikkulaga.pl", true },
  { "domodedovo.travel", true },
  { "donateaday.net", true },
  { "donmez.uk", false },
  { "donmez.ws", false },
  { "donner-reuschel.de", true },
  { "donnons.org", true },
  { "donotcall.gov", true },
  { "donotspellitgav.in", true },
  { "dontcageus.org", true },
  { "donthedragonwilson.com", true },
  { "doodledraw.ninja", true },
  { "doordecor.bg", true },
  { "dopost.it", true },
  { "dorianharmans.nl", true },
  { "dorianmuthig.com", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.net", true },
  { "doridian.org", true },
  { "dot.ro", true },
  { "dotbigbang.com", true },
  { "dotbox.org", true },
  { "dotsiam.com", true },
  { "doublefun.net", true },
  { "dougferris.id.au", true },
  { "dovecotadmin.org", true },
  { "dovetailnow.com", true },
  { "downloadsoftwaregratisan.com", true },
  { "downsouthweddings.com.au", true },
  { "doyoucheck.com", false },
  { "dpd.com.pl", true },
  { "dpsg-roden.de", true },
  { "dr2dr.ca", true },
  { "dragon-chem.eu", true },
  { "dragonisles.net", true },
  { "dragons-of-highlands.cz", true },
  { "dragonschool.org", true },
  { "drahcro.uk", true },
  { "drainagebuizen.nl", true },
  { "drakefortreasurer.sexy", true },
  { "drakeluce.com", true },
  { "dramaticpeople.com", true },
  { "dranderle.com", true },
  { "dranek.com", true },
  { "draw.uy", true },
  { "drawesome.uy", true },
  { "drawingcode.net", true },
  { "drdevil.ru", true },
  { "dreadbyte.com", true },
  { "dreamcreator108.com", true },
  { "dreamsforabetterworld.com.au", true },
  { "dreamtechie.com", true },
  { "dreid.org", true },
  { "dreizwosechs.de", true },
  { "dreweryinc.com", true },
  { "drhopeson.com", true },
  { "driesjtuver.nl", true },
  { "driftdude.nl", true },
  { "drino.org", false },
  { "drive.google.com", true },
  { "drivenes.net", true },
  { "driving-lessons.co.uk", true },
  { "drkmtrx.xyz", true },
  { "droidboss.com", true },
  { "droidwiki.de", false },
  { "dronepit.dk", true },
  { "dropbox.com", true },
  { "dropboxer.net", true },
  { "drpetervoigt.de", true },
  { "drrr.chat", true },
  { "drtroyhendrickson.com", true },
  { "drugagodba.si", true },
  { "drumbandesperanto.nl", true },
  { "drumbe.at", true },
  { "drupal.org", true },
  { "drycreekphoto.com", true },
  { "dsbrowser.com", true },
  { "dsebastien.net", true },
  { "dshiv.io", true },
  { "dsol.hu", true },
  { "dubrovskiy.net", true },
  { "dubrovskiy.pro", true },
  { "duckduckstart.com", true },
  { "ducohosting.com", true },
  { "duesee.org", true },
  { "duijf.info", true },
  { "duijfathome.nl", true },
  { "dukun.de", true },
  { "dumino.bg", true },
  { "duncancmt.com", true },
  { "dunea.nl", true },
  { "duo.money", true },
  { "durangoenergyllc.com", true },
  { "duria.de", true },
  { "durys.be", true },
  { "dutch1.nl", true },
  { "dutchrank.com", true },
  { "dutchrank.nl", true },
  { "dutchwanderers.nl", true },
  { "dutchweballiance.nl", true },
  { "dutyfreeonboard.com", true },
  { "duuu.ch", true },
  { "dvbris.co.uk", true },
  { "dvbris.com", true },
  { "dvorupotocnych.sk", true },
  { "dvwc.org", true },
  { "dworzak.ch", true },
  { "dxa.io", true },
  { "dycontrol.de", true },
  { "dyeager.org", true },
  { "dynaloop.net", true },
  { "dynamicnet.net", true },
  { "dynamicsnetwork.net", true },
  { "dyrenesverden.no", true },
  { "dziekonski.com", true },
  { "dzimejl.sk", true },
  { "dzlibs.io", true },
  { "dzyabchenko.com", true },
  { "e-kontakti.fi", true },
  { "e-mak.eu", true },
  { "e-teacher.pl", true },
  { "e-typ.eu", true },
  { "e.mail.ru", true },
  { "e3amn2l.com", true },
  { "e3kids.com", true },
  { "eagleridgecampground.com", true },
  { "eagletechz.com.br", true },
  { "eagleyecs.com", true },
  { "earga.sm", true },
  { "earmarks.gov", true },
  { "easy-rpg.org", true },
  { "easyconstat.com", true },
  { "easycosmetic.ch", true },
  { "easykonto.de", true },
  { "easyplane.it", true },
  { "easysimplecrm.com", false },
  { "eatery.co.il", true },
  { "eatlowcarb.de", true },
  { "eatsleeprepeat.net", true },
  { "eatvisor.co.uk", true },
  { "eauclairecommerce.com", true },
  { "eb7.jp", true },
  { "ebankcbt.com", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ebcs-solutions.com", true },
  { "ebermannstadt.de", true },
  { "ebp2p.com", true },
  { "ebpglobal.com", true },
  { "ecake.in", true },
  { "ecchidreams.com", true },
  { "ecco-verde.com", true },
  { "ecdn.cz", true },
  { "ecfs.link", true },
  { "ecg.fr", false },
  { "echomanchester.net", true },
  { "echosixmonkey.com", true },
  { "eckel.co", true },
  { "eckro.com", true },
  { "ecnetworker.com", true },
  { "ecogen.com.au", true },
  { "ecogen.net.au", true },
  { "econsumer.gov", true },
  { "ecorus.eu", true },
  { "ecosystem.atlassian.net", true },
  { "ecrimex.net", true },
  { "ectora.com", true },
  { "ecupcafe.com", false },
  { "ed.gs", true },
  { "edakoe.ru", true },
  { "edati.lv", true },
  { "edcphenix.tk", true },
  { "eddmixpanel.com", true },
  { "edelblack.ch", true },
  { "edesseglabor.hu", true },
  { "edgereinvent.com", true },
  { "edicct.com", true },
  { "ediscomp.sk", true },
  { "edissecurity.sk", true },
  { "edit.yahoo.com", false },
  { "edix.ru", true },
  { "edk.com.tr", true },
  { "edmundcelis.com", true },
  { "edoss.co.za", true },
  { "edp-collaborative.com", true },
  { "edpubs.gov", true },
  { "educationunlimited.com", true },
  { "educator-one.com", true },
  { "eduid.se", true },
  { "eduif.nl", true },
  { "eduroam.no", true },
  { "edxg.de", true },
  { "edyou.eu", true },
  { "eelsden.net", true },
  { "eelzak.nl", true },
  { "eeqj.com", true },
  { "eery.de", true },
  { "ef.gy", true },
  { "eff.org", true },
  { "efficienthealth.com", true },
  { "egfl.org.uk", true },
  { "egit.co", true },
  { "ego-world.org", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "egretail.no", true },
  { "ehipaa.com", true },
  { "ehipaadev.com", true },
  { "ehrlichesbier.de", true },
  { "ehuber.info", true },
  { "eicfood.com", true },
  { "eichornenterprises.com", true },
  { "eickemeyer.nl", true },
  { "eimacs.com", true },
  { "einaros.is", true },
  { "einheizpreis.de", true },
  { "einsatzstellenverwaltung.de", true },
  { "eirastudios.co.uk", false },
  { "ejeff.org", true },
  { "ekbanden.nl", false },
  { "ekokontakt.cz", true },
  { "ekostecki.de", true },
  { "eksisozluk.com", true },
  { "ekzarta.ru", true },
  { "el-soul.com", true },
  { "elanguest.pl", true },
  { "elanguest.ro", true },
  { "elanguest.ru", true },
  { "elars.de", true },
  { "elbetech.net", true },
  { "elearningpilot.com", true },
  { "electricant.com", true },
  { "electricant.nl", true },
  { "electricianforum.co.uk", true },
  { "electromc.com", true },
  { "electronic-ignition-system.com", true },
  { "electronicfasteners.com", true },
  { "eleicoes2016.com.br", true },
  { "elektropost.org", true },
  { "element-43.com", true },
  { "elemental.software", true },
  { "elementalrobotics.com", true },
  { "elemenx.com", true },
  { "elenag.ga", true },
  { "elephpant.cz", true },
  { "elglobo.com.mx", true },
  { "elgosblanc.com", true },
  { "eligible.com", true },
  { "eligibleapi.com", true },
  { "eligrey.com", true },
  { "elisa.ee", false },
  { "elisabeth-kostecki.de", true },
  { "elisabethkostecki.de", true },
  { "elite12.de", true },
  { "elitefishtank.com", false },
  { "elitegameservers.net", true },
  { "elitehosting.de", true },
  { "ella-kwikmed.com", true },
  { "ellegaard.dk", true },
  { "elliquiy.com", true },
  { "elliriehl.at", true },
  { "ellsinger.me", true },
  { "elmermx.ch", true },
  { "elnan.do", true },
  { "eloge.se", true },
  { "elpo.net", true },
  { "elsamakhin.com", true },
  { "elternforum-birmensdorf.ch", true },
  { "eluhome.de", true },
  { "elvidence.com.au", true },
  { "em-biotek.cz", true },
  { "emailfuermich.de", true },
  { "emailhunter.co", true },
  { "emailprivacytester.com", true },
  { "emaily.eu", true },
  { "emanuelduss.ch", true },
  { "embracethedarkness.co.uk", true },
  { "emielraaijmakers.nl", true },
  { "emilong.com", true },
  { "emilyhorsman.com", true },
  { "emilyshepherd.me", true },
  { "emirabiz.com", false },
  { "emjainteractive.com", true },
  { "empleostampico.com", false },
  { "empowerdb.com", true },
  { "emprego.pt", true },
  { "emptypath.com", true },
  { "emrenovation.com", true },
  { "en-maktoob.search.yahoo.com", false },
  { "enaim.de", true },
  { "encfs.win", true },
  { "encircleapp.com", true },
  { "encnet.de", true },
  { "encredible.de", true },
  { "encredible.org", true },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "encryptio.com", true },
  { "end.pp.ua", true },
  { "endlessdark.net", true },
  { "endlesshorizon.net", true },
  { "endlesstone.com", true },
  { "endofnet.org", true },
  { "enecoshop.nl", true },
  { "enefan.jp", true },
  { "energiekeurplus.nl", true },
  { "energy-drink-magazin.de", true },
  { "engelundlicht.ch", true },
  { "englerts.de", true },
  { "englishbulgaria.net", true },
  { "englishclub.com", true },
  { "englishforums.com", true },
  { "enjen.net", true },
  { "enjoy-nepal.de", true },
  { "enlightenedhr.com", true },
  { "enloestatebank.com", true },
  { "enorekcah.com", true },
  { "enquos.com", true },
  { "enscosupply.com", true },
  { "enskat.de", true },
  { "enskatson-sippe.de", true },
  { "ensured.com", true },
  { "ensured.nl", true },
  { "enteente.club", true },
  { "enteente.com", true },
  { "enteente.xyz", true },
  { "enterprisey.enterprises", true },
  { "entersynapse.com", false },
  { "entrepreneur.or.id", true },
  { "envelope.co.nz", true },
  { "enveloppenopmaat.nl", true },
  { "enviam.de", true },
  { "envygeeks.com", true },
  { "envygeeks.io", true },
  { "eoldb.org", true },
  { "eopugetsound.org", true },
  { "epanurse.com", true },
  { "epay.bg", true },
  { "epaygateway.net", true },
  { "epicsecure.de", true },
  { "epicsoft.de", true },
  { "epostplus.li", true },
  { "epublibre.org", true },
  { "eqorg.com", true },
  { "equilibre-yoga-jennifer-will.com", true },
  { "equipsupply.com", true },
  { "erawanarifnugroho.com", true },
  { "erepublik-deutschland.de", true },
  { "ericdiao.com", true },
  { "ericwie.se", true },
  { "ericyl.com", true },
  { "erigrid.eu", true },
  { "eriix.org", true },
  { "erisrenee.com", true },
  { "ernesto.at", true },
  { "erp-band.ru", true },
  { "erp.band", true },
  { "erpband.ru", true },
  { "erpcargo.com", true },
  { "errlytics.com", true },
  { "errolz.com", true },
  { "errors.zenpayroll.com", false },
  { "ersindemirtas.com", true },
  { "eru.me", true },
  { "erudikum.cz", true },
  { "erwinwensveen.nl", true },
  { "es.search.yahoo.com", false },
  { "escalate.eu", true },
  { "escapees.com", true },
  { "esclear.de", true },
  { "escritoriodearte.com", true },
  { "esg-abi2001.de", true },
  { "esigmbh.de", true },
  { "esko.bar", true },
  { "eskriett.com", true },
  { "esn-ypci.com", true },
  { "esoa.net", true },
  { "esocweb.com", true },
  { "espanol.search.yahoo.com", false },
  { "espci.fr", true },
  { "espgg.org", true },
  { "espra.com", true },
  { "esquonic.com", true },
  { "essentialoilsimports.com", true },
  { "esseriumani.com", true },
  { "essexghosthunters.co.uk", true },
  { "essoduke.org", true },
  { "estaleiro.org", true },
  { "esteam.se", true },
  { "estebanborges.com", true },
  { "estilos.com.pe", true },
  { "etaes.eu", true },
  { "etdonline.co.uk", true },
  { "eteesheet.com", true },
  { "etelej.com", true },
  { "eternitylove.us", true },
  { "eth0.nl", true },
  { "etha.nz", true },
  { "ethack.org", true },
  { "ethanfaust.com", true },
  { "ethercalc.com", true },
  { "ethercalc.org", true },
  { "etherpad.fr", true },
  { "ethicaldata.co.uk", true },
  { "ethicalexploiting.com", true },
  { "ethicall.org.uk", true },
  { "ethitter.com", true },
  { "ethlan.fr", true },
  { "ethosinfo.com", true },
  { "etkaddict.com", true },
  { "etrker.com", true },
  { "ets2mp.de", true },
  { "etula.ga", true },
  { "etyd.org", true },
  { "euanbaines.com", true },
  { "eugenekay.com", true },
  { "eulenleben.de", true },
  { "eulerpi.io", true },
  { "euph.eu", true },
  { "euro.ro", true },
  { "europop.com", true },
  { "euroshop.or.at", true },
  { "eurostrategy.vn.ua", true },
  { "eurotramp.com", true },
  { "ev-zertifikate.de", true },
  { "eva.cz", true },
  { "evalesc.com", true },
  { "evantage.org", true },
  { "evantageglobal.com", true },
  { "evasovova.cz", true },
  { "evdenevenakliyatankara.pw", true },
  { "evegalaxy.net", true },
  { "eventaro.com", true },
  { "everhome.de", true },
  { "everling.lu", true },
  { "everwaking.com", true },
  { "everylab.org", true },
  { "everymove.org", true },
  { "everythingkitchens.com", false },
  { "eveseat.net", true },
  { "eveshamglass.co.uk", true },
  { "evi.be", true },
  { "evilized.de", true },
  { "evin.ml", true },
  { "evites.me", true },
  { "evomon.com", true },
  { "evossd.tk", true },
  { "evowl.com", false },
  { "evrial.com", true },
  { "evstatus.com", true },
  { "ewe2.ninja", true },
  { "ewie.name", true },
  { "exceltobarcode.com", true },
  { "excessamerica.com", true },
  { "exchangeworks.co", true },
  { "exekutori.com", true },
  { "exemples-de-stands.com", true },
  { "exeria.de", true },
  { "exfiles.cz", true },
  { "exiahost.com", true },
  { "exno.co", true },
  { "exon.io", true },
  { "exoscale.ch", true },
  { "exoticads.com", true },
  { "expatads.com", true },
  { "experienceoz.com.au", true },
  { "expertmile.com", true },
  { "explodie.org", true },
  { "expo-asia.ru", true },
  { "expo-designers.com", true },
  { "express-vpn.com", true },
  { "expressemotion.net", true },
  { "expresshosting.org", true },
  { "expressvpn.com", true },
  { "expxkcd.com", true },
  { "extendwings.com", true },
  { "extracobanks.com", true },
  { "extranetpuc.com.br", true },
  { "extremenetworking.net", true },
  { "exy.pw", true },
  { "exyplis.com", true },
  { "eyasc.nl", true },
  { "eydesignguidelines.com", true },
  { "eyeglassuniverse.com", true },
  { "eyeonid.com", true },
  { "eytosh.net", true },
  { "eyyit.com", true },
  { "ez.fi", true },
  { "ezrefurb.co.uk", true },
  { "f-be.com", true },
  { "f-droid.org", true },
  { "f-thie.de", true },
  { "f2f.cash", true },
  { "fa-works.com", true },
  { "faber.org.ru", true },
  { "fabhub.io", true },
  { "fabianasantiago.com", true },
  { "fabienbaker.com", true },
  { "fableforge.nl", true },
  { "fabse.net", true },
  { "facebook.com", false },
  { "factor.cc", false },
  { "factorable.net", true },
  { "factuursturen.be", true },
  { "factuursturen.nl", true },
  { "factys.do", true },
  { "factys.es", true },
  { "fadilus.com", true },
  { "faeriecakes.be", true },
  { "fahrenwal.de", true },
  { "failproof.be", true },
  { "fairbill.com", true },
  { "faircom.co.za", true },
  { "fairlyoddtreasures.com", true },
  { "faizan.net", true },
  { "faktura.pl", true },
  { "fakturi.com", true },
  { "fakturoid.cz", true },
  { "falconvintners.com", true },
  { "falkena.net", true },
  { "falkp.no", true },
  { "fallenangeldrinks.co.uk", true },
  { "fallenangeldrinks.com", true },
  { "fallenangeldrinks.eu", true },
  { "fallenangelspirits.co.uk", true },
  { "fallenangelspirits.com", true },
  { "fallenangelspirits.uk", true },
  { "fallenspirits.co.uk", true },
  { "falsum.net", true },
  { "familie-kupschke.de", true },
  { "familie-monka.de", true },
  { "familie-sander.rocks", true },
  { "familiegrottendieck.de", true },
  { "familieholme.de", true },
  { "familjenfrodlund.se", true },
  { "fandomservices.com", true },
  { "fangs.ink", true },
  { "fanjoe.be", true },
  { "fant.dk", true },
  { "fanvoice.com", true },
  { "fanyue123.tk", true },
  { "faq.lookout.com", false },
  { "fargtorget.se", true },
  { "farhood.org", true },
  { "farmacialaboratorio.it", true },
  { "fasdoutreach.ca", true },
  { "fashion.net", true },
  { "faspirits.co.uk", true },
  { "faspirits.com", true },
  { "fassadenverkleidung24.de", true },
  { "fasset.jp", true },
  { "fastaim.de", true },
  { "fastcomcorp.com", true },
  { "fastcomcorp.net", true },
  { "fastmail.com", false },
  { "fastopen.ml", true },
  { "fatgeekflix.net", true },
  { "fatherhood.gov", true },
  { "fatlossguide.xyz", true },
  { "fatox.de", true },
  { "fatwin.pw", true },
  { "fatzebra.com.au", false },
  { "faucetbox.com", true },
  { "fawkex.me", true },
  { "fawong.com", true },
  { "fayolle.info", true },
  { "fbox.li", true },
  { "fca-tools.com", true },
  { "fcburk.de", true },
  { "fdj.im", true },
  { "fdsys.gov", false },
  { "fdt.name", true },
  { "fearsomegaming.com", true },
  { "fecik.sk", true },
  { "federalregister.gov", true },
  { "federicomigliavacca.it", true },
  { "fedorahosted.org", true },
  { "fedorapeople.org", true },
  { "fedrtc.org", true },
  { "fedux.com.ar", true },
  { "feedbin.com", false },
  { "feedhq.org", true },
  { "feedthebot.com", true },
  { "feel.aero", true },
  { "feen.us", true },
  { "feezmodo.com", true },
  { "feirlane.org", false },
  { "feliwyn.fr", true },
  { "felixrr.pro", true },
  { "feminists.co", true },
  { "fenno.net", true },
  { "fenteo.com", true },
  { "feragon.net", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "fernandes.org", true },
  { "ferrugem.org", true },
  { "festrip.com", true },
  { "fetch.co.uk", true },
  { "feuerwehr-oberkotzau.de", true },
  { "fewo-thueringer-wald.de", true },
  { "fexco.com", true },
  { "fexmen.com", true },
  { "ff-bad-hoehenstadt.de", true },
  { "ffbans.org", true },
  { "ffmradio.de", true },
  { "fhcdn.xyz", true },
  { "fi.google.com", true },
  { "fi.search.yahoo.com", false },
  { "ficus.io", true },
  { "fid.to", true },
  { "fidanza.eu", true },
  { "fidelapp.com", true },
  { "fierlafijn.net", true },
  { "fierman.eu", true },
  { "fierman.net", true },
  { "fierman.us", true },
  { "fiftyshadesofluca.ml", true },
  { "fightr.co", true },
  { "figuurzagers.nl", true },
  { "fiilr.com", true },
  { "fiken.no", true },
  { "fiksel.info", true },
  { "fikt.space", true },
  { "file-pdf.it", true },
  { "filedir.com", false },
  { "filemeal.com", true },
  { "filhodohomem.com", true },
  { "filip-prochazka.com", true },
  { "filippo.io", true },
  { "fillmysuitca.se", true },
  { "filoo.de", true },
  { "financieringsportaal.nl", true },
  { "finanzkontor.net", true },
  { "finditez.com", true },
  { "findyour.diet", true },
  { "finenet.com.tw", true },
  { "finfev.de", true },
  { "fingent.com", true },
  { "finisron.in", true },
  { "finkelstein.fr", true },
  { "finn.io", true },
  { "fionamcbride.com", true },
  { "firebaseio-demo.com", true },
  { "firebaseio.com", true },
  { "firebird.io", true },
  { "firebirdrangecookers.com", true },
  { "firecore.com", false },
  { "firefart.at", false },
  { "firehost.com", true },
  { "firemail.io", true },
  { "fireorbit.de", true },
  { "firevap.org", true },
  { "firexarxa.de", true },
  { "firma-offshore.com", true },
  { "firmapi.com", true },
  { "firstchoicecandy.com", true },
  { "firstderm.com", true },
  { "firstlook.org", true },
  { "firstmall.de", true },
  { "fischers.cc", true },
  { "fish-hook.ru", true },
  { "fit4medien.de", true },
  { "fitbylo.com", true },
  { "fitiapp.com", true },
  { "fitkram.cz", true },
  { "fitnesswerk.de", true },
  { "fitzsim.org", true },
  { "fivestarsitters.com", true },
  { "fixatom.com", true },
  { "fixhotsauce.com", true },
  { "fixmycomputerdude.com", true },
  { "fizz.buzz", true },
  { "fj.simple.com", false },
  { "flaemig42.de", true },
  { "flagspot.net", true },
  { "flajshans.cz", true },
  { "flamer-scene.com", false },
  { "flamewall.net", false },
  { "flamingcow.tv", true },
  { "flamingkeys.com", true },
  { "flamme-von-anor.de", true },
  { "flareon.net", true },
  { "flat.io", true },
  { "flawcheck.com", true },
  { "flawlesscowboy.xyz", true },
  { "flazznetworks.com", false },
  { "fless.co.uk", true },
  { "fletchto99.com", true },
  { "fleximus.org", false },
  { "flexinvesting.fi", true },
  { "flexport.com", true },
  { "flipagram.com", false },
  { "flipneus.net", true },
  { "flirchi.com", false },
  { "flocktofedora.org", true },
  { "floless.co.uk", true },
  { "floobits.com", true },
  { "floorball-haunwoehr.de", true },
  { "floort.net", true },
  { "florence.uk.net", true },
  { "florent-tatard.fr", true },
  { "florian-schlachter.de", true },
  { "florian-thie.de", true },
  { "florianmitrea.uk", true },
  { "floridaescapes.co.uk", true },
  { "floridafieros.org", true },
  { "florismouwen.com", true },
  { "floskelwolke.de", true },
  { "flouartistique.ch", true },
  { "flow.su", true },
  { "flowersandclouds.com", true },
  { "flowlo.me", true },
  { "flra.gov", true },
  { "flukethoughts.com", true },
  { "fluxent.de", false },
  { "fluxfingers.net", true },
  { "fly.moe", true },
  { "flynn.io", true },
  { "fmarchal.fr", true },
  { "fnb-griffinonline.com", true },
  { "fndout.com", true },
  { "fniephaus.com", true },
  { "fnordserver.eu", true },
  { "focusmark.jp", true },
  { "fokkusu.fi", true },
  { "folv.es", true },
  { "fondanastasia.ru", true },
  { "font-converter.net", true },
  { "food4health.guide", true },
  { "foodacademy.capetown", true },
  { "foodiebox.no", true },
  { "foodievenues.com", true },
  { "foodwise.marketing", true },
  { "footballmapped.com", true },
  { "foraje-profesionale.ro", true },
  { "foray-jero.me", true },
  { "forbook.net", true },
  { "fordbydesign.com", true },
  { "forewordreviews.com", true },
  { "forex-dan.com", true },
  { "forextimes.ru", true },
  { "forgix.com", true },
  { "formationseeker.com", true },
  { "formationsfactory.co.uk", false },
  { "formazioneopen.it", true },
  { "formula.cf", true },
  { "foro.io", false },
  { "forodeespanol.com", true },
  { "fortesanshop.it", true },
  { "fortnine.ca", true },
  { "fortress.sk", true },
  { "fortworth.ch", true },
  { "forum.linode.com", false },
  { "forum.quantifiedself.com", false },
  { "fossewaygardencentre.co.uk", true },
  { "fotocerita.net", true },
  { "fotofaerie.net", true },
  { "fotopasja.info", true },
  { "fotostudio-schweiz.ch", true },
  { "fotowettbewerb.co", true },
  { "fotowolfy.com", true },
  { "foxbnc.co.uk", true },
  { "foxdev.co", true },
  { "foxelbox.com", true },
  { "foxley-farm.co.uk", true },
  { "foxley-seeds.co.uk", true },
  { "foxleyseeds.co.uk", true },
  { "foxtrot.pw", true },
  { "fpy.cz", true },
  { "fr.search.yahoo.com", false },
  { "fr33d0m.link", true },
  { "frack.nl", true },
  { "fragnic.com", true },
  { "fraho.eu", true },
  { "fralef.me", false },
  { "francescopalazzo.com", true },
  { "francevpn.xyz", true },
  { "franckgirard.net", true },
  { "frangor.info", true },
  { "frank.fyi", true },
  { "frankhaala.com", true },
  { "frankierprofi.de", true },
  { "fransallen.com", true },
  { "franta.biz", true },
  { "franta.email", true },
  { "franzt.ovh", true },
  { "frasys.cloud", true },
  { "frasys.io", true },
  { "frasys.net", true },
  { "fraye.net", true },
  { "frederik-braun.com", true },
  { "fredvoyage.fr", true },
  { "free.com.tw", true },
  { "freeboson.org", true },
  { "freedom.press", false },
  { "freeform4u.de", true },
  { "freekdevries.nl", true },
  { "freelance.boutique", true },
  { "freelance.nl", true },
  { "freematthale.net", true },
  { "freemedforms.com", true },
  { "freenetproject.org", true },
  { "freeshell.de", true },
  { "freesitemapgenerator.com", true },
  { "freesoftwaredriver.com", true },
  { "freesounding.com", true },
  { "freesounding.ru", true },
  { "freethought.org.au", true },
  { "freetsa.org", true },
  { "freeweibo.com", true },
  { "freifunk-essen.de", true },
  { "freifunk-luenen.de", true },
  { "freiwurst.net", true },
  { "freqlabs.com", true },
  { "fresh-hotel.org", true },
  { "freshfind.xyz", true },
  { "fretscha.com", true },
  { "frezbo.com", true },
  { "frickelboxx.de", true },
  { "fridolinka.cz", true },
  { "friendica.ch", true },
  { "frillip.com", true },
  { "frippz.se", true },
  { "fritzrepair.com", true },
  { "frizo.com", true },
  { "frly.de", true },
  { "frob.nl", true },
  { "froggstack.de", true },
  { "fromlemaytoz.com", true },
  { "fromscratch.rocks", true },
  { "fronteers.nl", true },
  { "frontisme.nl", true },
  { "frontmin.com", true },
  { "froot.se", true },
  { "froxlor.support", true },
  { "frtr.gov", true },
  { "frugro.be", true },
  { "fruitusers.com", true },
  { "frusky.de", true },
  { "fsapubs.gov", true },
  { "fsbpaintrock.com", true },
  { "fsbturton.com", true },
  { "fsfi.is", true },
  { "fsm2016.org", true },
  { "ftc.gov", true },
  { "ftccomplaintassistant.gov", true },
  { "fteproxy.org", true },
  { "fugle.de", true },
  { "fuglede.dk", true },
  { "fukushima-web.com", true },
  { "fumo.se", true },
  { "functions-online.com", true },
  { "fundacionhijosdelsol.org", true },
  { "fundays.nl", true },
  { "funderburg.me", true },
  { "fundingempire.com", true },
  { "funi4u.com", true },
  { "funnyang.com", true },
  { "funrun.com", true },
  { "furgo.love", true },
  { "furkancaliskan.com", true },
  { "furry.be", true },
  { "furry.dk", true },
  { "futbol11.com", true },
  { "futos.de", true },
  { "fuzzing-project.org", true },
  { "fx5.de", true },
  { "fxp.co.il", true },
  { "fyfywka.com", true },
  { "fyn.nl", true },
  { "fysiohaenraets.nl", true },
  { "fzn.io", true },
  { "g-m-w.eu", true },
  { "g-marketing.ro", true },
  { "g-o.pl", true },
  { "g2a.co", true },
  { "g4w.co", true },
  { "g5led.nl", true },
  { "gabber.scot", true },
  { "gafachi.com", true },
  { "gagniard.org", true },
  { "gagor.pl", true },
  { "gaichon.com", true },
  { "gaiserik.com", true },
  { "gakkainavi-epsilon.jp", true },
  { "gakkainavi-epsilon.net", true },
  { "gakkainavi.jp", true },
  { "gakkainavi.net", true },
  { "gakkainavi4.com", true },
  { "gakkainavi4.jp", true },
  { "gakkainavi4.net", true },
  { "galactic-crew.org", true },
  { "gallery44.org", true },
  { "gam3rs.de", true },
  { "gamajo.com", true },
  { "gambit.pro", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gambitprint.com", true },
  { "game-files.net", true },
  { "game7.de", true },
  { "gamecave.de", true },
  { "gamecollector.be", true },
  { "gamedevelopers.pl", true },
  { "gamegix.com", true },
  { "gamenected.com", true },
  { "gamenected.de", true },
  { "gamepader.com", true },
  { "gamercredo.com", true },
  { "gamercredo.net", true },
  { "gamers-life.fr", true },
  { "gamesurferapp.com", true },
  { "gamingmedia.eu", true },
  { "gamingreinvented.com", true },
  { "gamingzoneservers.com", true },
  { "gamishou.fr", true },
  { "gamoloco.com", true },
  { "gampenhof.de", true },
  { "gancedo.com.es", true },
  { "ganhonet.com.br", true },
  { "gar-nich.net", true },
  { "garagegoossens.be", true },
  { "garantieabschluss.de", false },
  { "garbage-juice.com", true },
  { "garedtech.com", true },
  { "garron.net", true },
  { "garyjones.co.uk", true },
  { "gasbarkenora.com", true },
  { "gateworld.fr", true },
  { "gatilagata.com.br", true },
  { "gaussorgues.me", true },
  { "gautvedt.no", true },
  { "gavick.com", true },
  { "gaytorrent.ru", true },
  { "gc-mc.de", true },
  { "gc.net", true },
  { "gcs-ventures.com", true },
  { "gcsepod.com", true },
  { "ge1.me", true },
  { "ge3k.net", true },
  { "geblitzt.de", true },
  { "gechr.io", true },
  { "gee.is", true },
  { "geek-hub.de", true },
  { "geekandi.com", true },
  { "geekwu.org", true },
  { "geeky.software", true },
  { "geeq.ch", true },
  { "gehaowu.com", true },
  { "geli-graphics.com", true },
  { "gelog-software.de", true },
  { "gemeentemolenwaard.nl", true },
  { "gemeinfreie-lieder.de", true },
  { "gendrin.com", true },
  { "genehome.com.au", true },
  { "generali-worldwide.com", true },
  { "generationnext.pl", true },
  { "generic.cx", true },
  { "genossen.ru", true },
  { "genshiken-itb.org", true },
  { "genshiken.org", true },
  { "genslerwisp.com", true },
  { "genuu.com", true },
  { "genuxation.com", true },
  { "genuxtsg.com", true },
  { "genxbeats.com", true },
  { "genxnotes.com", true },
  { "genyhitch.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "geolad.com", true },
  { "georgemaschke.com", true },
  { "georgemaschke.net", true },
  { "georgesonarthurs.com.au", true },
  { "georgmayer.eu", true },
  { "geoscan.aero", true },
  { "geraintwhite.co.uk", true },
  { "gerardozamudio.mx", true },
  { "gerencianet.com.br", false },
  { "gereon.ch", true },
  { "germandarknes.net", true },
  { "gernert-server.de", true },
  { "geschwinder.net", true },
  { "gesiwista.net", true },
  { "get-asterisk.ru", true },
  { "get-erp.ru", true },
  { "get.zenpayroll.com", false },
  { "getbambu.com", false },
  { "getbox.me", true },
  { "getbutterfly.com", true },
  { "getcarefirst.com", true },
  { "getcarina.com", true },
  { "getcloak.com", false },
  { "getcolor.com", true },
  { "getdash.io", true },
  { "getdigitized.net", true },
  { "geterp.ru", true },
  { "getfedora.org", true },
  { "getfittedstore.com", true },
  { "gethttpsforfree.com", true },
  { "getinternet.de", true },
  { "getkai.co.nz", true },
  { "getlifti.com", true },
  { "getlolaccount.com", true },
  { "getmango.com", true },
  { "getnikola.com", true },
  { "getremembrall.com", true },
  { "getsello.com", false },
  { "getsensibill.com", true },
  { "getsetupfile.com", true },
  { "getspire.com", true },
  { "getsport.mobi", true },
  { "getts.ro", true },
  { "getvdownloader.com", true },
  { "gfm.tech", true },
  { "gfournier.ca", true },
  { "ggp2.com", true },
  { "ggx.us", true },
  { "gha.st", true },
  { "ghcif.de", true },
  { "gheorghesarcov.ga", true },
  { "gheorghesarcov.tk", true },
  { "ghostblog.info", true },
  { "giacomopelagatti.it", true },
  { "giftgofers.com", true },
  { "giftservices.nl", true },
  { "giftsn.com.sg", true },
  { "gifzilla.net", false },
  { "gig.ru", false },
  { "gigacloud.org", true },
  { "gigacog.com", true },
  { "gigawa.lt", true },
  { "gijsbertus.com", true },
  { "gilcloud.com", true },
  { "gingali.de", true },
  { "gintenreiter-photography.com", true },
  { "gipsic.com", true },
  { "gistfy.com", true },
  { "git.co", true },
  { "github.com", true },
  { "github.party", false },
  { "giveattheoffice.org", true },
  { "givemyanswer.com", true },
  { "givingnexus.org", false },
  { "gix.net.pl", true },
  { "gixtools.co.uk", true },
  { "gixtools.com", true },
  { "gixtools.net", true },
  { "gixtools.uk", true },
  { "gizzo.sk", true },
  { "gjcampbell.co.uk", true },
  { "gjspunk.de", true },
  { "gjung.com", true },
  { "glasgestaltung.biz", true },
  { "glass.google.com", true },
  { "glasschmuck-millefiori.de", true },
  { "glentakahashi.com", true },
  { "glidingshop.cz", true },
  { "glidingshop.de", true },
  { "glidingshop.eu", true },
  { "glitchsys.com", true },
  { "glittersjabloon.nl", true },
  { "globalcomix.com", true },
  { "globalexpert.co.nz", true },
  { "globalgivingtime.com", true },
  { "globalinstitutefortraining.org.au", true },
  { "globalittech.com", false },
  { "globalmusic.ga", true },
  { "globalperspectivescanada.com", true },
  { "globalsites.nl", true },
  { "globuli-info.de", true },
  { "gloomyvancouver.com", true },
  { "glossopnorthendafc.co.uk", true },
  { "glubbforum.de", true },
  { "gm-assicurazioni.it", true },
  { "gmail.com", false },
  { "gmcd.co", true },
  { "gmdu.net", true },
  { "gmta.nl", true },
  { "gmw-hannover.de", true },
  { "gmw-ingenieurbuero.de", true },
  { "gnetwork.eu", true },
  { "go-zh.org", true },
  { "go.xero.com", false },
  { "go2sh.de", true },
  { "goabonga.com", true },
  { "goalsetup.com", true },
  { "goaltree.ch", true },
  { "goat.xyz", true },
  { "goben.ch", true },
  { "gocardless.com", true },
  { "godesigner.ru", true },
  { "goerner.me", true },
  { "goerres2014.de", true },
  { "gofigure.fr", false },
  { "gogenenglish.com", true },
  { "gogetssl.com", true },
  { "goggs.eu", true },
  { "gogold-g.com", true },
  { "gohon.org", true },
  { "gokmenguresci.com", true },
  { "goldendata.io", true },
  { "goldenhillsoftware.com", true },
  { "goldmark.com.au", true },
  { "goldpreisfinder.at", true },
  { "goldpros.com", true },
  { "goldsecurity.com", true },
  { "golf18network.com", true },
  { "golfscape.com", true },
  { "gonzalosanchez.mx", true },
  { "gooby.co", true },
  { "goodmengroup.de", true },
  { "google", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "gopay.cz", true },
  { "gordonobrecht.com", true },
  { "gorschenin.com", true },
  { "gosccs.com", true },
  { "gosharewood.com", true },
  { "goshop.cz", true },
  { "gospelvestcination.de", true },
  { "gosuland.org", true },
  { "gotech.com.eg", true },
  { "gotgenes.com", true },
  { "gothamlimo.com", true },
  { "goto.google.com", true },
  { "gotocloud.ru", true },
  { "gotomi.info", true },
  { "gotowned.org", true },
  { "gotspot.com", true },
  { "governorhub.com", true },
  { "govillemo.ca", true },
  { "govtrack.us", true },
  { "gowe.wang", false },
  { "gozel.com.tr", true },
  { "gpfclan.de", true },
  { "gplintegratedit.com", true },
  { "gpo.gov", false },
  { "gprs.uk.com", true },
  { "gps.com.br", true },
  { "gpsfix.cz", true },
  { "gpstuner.com", true },
  { "gpsvideocanada.com", true },
  { "gr.search.yahoo.com", false },
  { "gra2.com", true },
  { "graavaapi.elasticbeanstalk.com", true },
  { "grace-wan.com", true },
  { "gracedays.org", true },
  { "gracesofgrief.com", false },
  { "graciousmay.com", true },
  { "grademypc.com", true },
  { "gradienthosting.co.uk", true },
  { "grafitec.ru", true },
  { "grafmurr.de", true },
  { "graingert.co.uk", true },
  { "grandcapital.id", true },
  { "grandcapital.ru", true },
  { "grandlinecsk.ru", true },
  { "grandmasfridge.org", true },
  { "grannyshouse.de", true },
  { "grantedby.me", true },
  { "granth.io", true },
  { "granular.ag", true },
  { "graph.no", true },
  { "graphire.io", true },
  { "gravitechthai.com", true },
  { "gravito.nl", true },
  { "gravity-net.de", true },
  { "graymalk.in", true },
  { "grazetech.com", true },
  { "grc.com", false },
  { "grcnode.co.uk", true },
  { "greatfire.org", true },
  { "greatnet.de", true },
  { "greedbutt.com", true },
  { "greenpeace-magazin.de", true },
  { "greenpeace.berlin", true },
  { "greenroach.ru", true },
  { "greensolid.biz", true },
  { "greenteamtwente.nl", true },
  { "gregmilton.com", true },
  { "gregmilton.org", true },
  { "gregorytlee.me", true },
  { "grepular.com", true },
  { "gresak.io", true },
  { "gresb.com", true },
  { "gretchelizartistry.com", true },
  { "greysolutions.it", true },
  { "grh.am", true },
  { "gribani.com", true },
  { "grieg-gaarden.no", true },
  { "grieg.no", true },
  { "griegfoundation.no", true },
  { "grieglogistics.no", true },
  { "griegshipbrokers.com", true },
  { "griegshipbrokers.no", true },
  { "griesser2.de", true },
  { "grigalanzsoftware.com", true },
  { "grimm-gastrobedarf.de", true },
  { "grimneko.de", true },
  { "gripopgriep.net", true },
  { "gritte.ch", true },
  { "grizzlys.com", true },
  { "grocock.me.uk", true },
  { "groetzner.net", true },
  { "grog.pw", true },
  { "groovinads.com", true },
  { "groovydisk.com", true },
  { "gropp.org", true },
  { "groseb.net", true },
  { "grossmann.gr", true },
  { "groszek.pl", true },
  { "groups.google.com", true },
  { "grsecurity.net", true },
  { "grunex.com", true },
  { "grytics.com", true },
  { "gs-net.at", true },
  { "gtamodshop.org", true },
  { "gtanda.tk", true },
  { "gtldna.com", true },
  { "gtlfsonlinepay.com", true },
  { "gtmasterclub.it", false },
  { "gtmetrix.com", true },
  { "gtraxapp.com", true },
  { "gts-schulsoftware.de", true },
  { "gudini.net", true },
  { "guerrilla.technology", true },
  { "guevener.de", true },
  { "guffr.it", true },
  { "gugaltika-ipb.org", true },
  { "gugga.dk", false },
  { "guguke.net", true },
  { "guidetoiceland.is", false },
  { "guillaumeperrin.io", true },
  { "guineapigmustach.es", true },
  { "gulenbase.no", true },
  { "gunnaro.com", true },
  { "guntbert.net", true },
  { "gunwatch.co.uk", true },
  { "guoqiang.info", true },
  { "guphi.net", true },
  { "gurkan.in", true },
  { "gurochan.ch", true },
  { "gurom.lv", true },
  { "guru-naradi.cz", true },
  { "gurusupe.com", true },
  { "gussi.is", true },
  { "guthabenkarten-billiger.de", true },
  { "guts.me", true },
  { "guvernalternativa.ro", true },
  { "gvt2.com", true },
  { "gvt3.com", true },
  { "gw2treasures.com", true },
  { "gwtest.us", true },
  { "gyboche.com", true },
  { "gyboche.science", true },
  { "gypsycatdreams.com", true },
  { "gyz.io", true },
  { "gz-architekten.de", true },
  { "gz-benz.com", true },
  { "gz-bmw.com", true },
  { "h-jo.net", true },
  { "h2check.org", true },
  { "haarkliniek.com", true },
  { "habanaavenue.com", true },
  { "habarisoft.com", true },
  { "hablemosdetecnologia.com.ve", false },
  { "hachre.de", false },
  { "hack.cz", true },
  { "hack.li", true },
  { "hackcraft.net", true },
  { "hackenkunjeleren.nl", true },
  { "hackenturet.dk", true },
  { "hacker.one", true },
  { "hackerforever.com", true },
  { "hackernet.se", true },
  { "hackerone-user-content.com", true },
  { "hackerone.com", true },
  { "hackerpoints.com", true },
  { "hackest.org", true },
  { "hackit.im", true },
  { "hackmd.io", true },
  { "hackthissite.org", true },
  { "hadleighswimmingclub.co.uk", true },
  { "hadzic.co", true },
  { "haeckl.eu", true },
  { "hafniatimes.com", true },
  { "hahayidu.org", true },
  { "haircrazy.com", true },
  { "haitschi.com", true },
  { "haitschi.de", true },
  { "haitschi.net", true },
  { "haitschi.org", true },
  { "hakase.kr", true },
  { "haktec.de", true },
  { "haku.moe", false },
  { "hallmarkestates.ca", true },
  { "halo.fr", true },
  { "hamali.bg", true },
  { "haman.nl", true },
  { "hana.ondemand.com", true },
  { "handiworker.com", true },
  { "handmadetutorials.ro", true },
  { "hangouts.google.com", true },
  { "hannover-banditen.de", true },
  { "hansen.hn", true },
  { "hansvaneijsden.com", true },
  { "hansvaneijsden.nl", true },
  { "hanu.la", true },
  { "haomwei.com", true },
  { "haozi.me", true },
  { "happyandrelaxeddogs.eu", true },
  { "happycoder.net", true },
  { "happygadget.me", true },
  { "happylifestyle.com", true },
  { "happyteamlabs.com", true },
  { "happytiger.eu", true },
  { "happyukgo.com", true },
  { "harabuhouse.com", true },
  { "harbor-light.net", true },
  { "hardeman.nu", true },
  { "hardertimes.com", true },
  { "hardfalcon.net", true },
  { "hardh.at", true },
  { "hardline.xyz", true },
  { "harmoney.co.nz", true },
  { "harmoney.com", true },
  { "harmoney.com.au", true },
  { "harmonycosmetic.com", true },
  { "harringtonca.com", true },
  { "harrisonsand.com", false },
  { "harrisonsdirect.co.uk", true },
  { "harristony.com", true },
  { "hartie95.de", true },
  { "harvestapp.com", true },
  { "harvester.fr", false },
  { "harvestrenewal.org", true },
  { "harz.cloud", true },
  { "haselsteiner.me", true },
  { "hash-list.com", true },
  { "hashiconf.com", true },
  { "hashicorp.com", true },
  { "hashimah.ca", true },
  { "hashnode.com", true },
  { "hashplex.com", true },
  { "hashru.nl", true },
  { "hashworks.net", true },
  { "haskovec.com", true },
  { "haste.ch", true },
  { "hastherebeenamassshooting.today", true },
  { "hatoko.net", true },
  { "haucke.xyz", true },
  { "haufschild.de", true },
  { "hauntedfishtank.com", true },
  { "hausverbrauch.de", true },
  { "haveeruexaminer.com", true },
  { "haveibeenpwned.com", true },
  { "havellab.de", true },
  { "havelland-obstler.de", true },
  { "hawkeyeinsight.com", true },
  { "hawksguild.com", true },
  { "haxo.nl", false },
  { "hazcod.com", true },
  { "hboeck.de", true },
  { "hbpowell.com", true },
  { "hcie.pl", true },
  { "hd-gaming.com", true },
  { "hd-offensive.at", true },
  { "hda.me", true },
  { "hdc.cz", true },
  { "hdeaves.uk", true },
  { "hdfgroup.org", true },
  { "hdhoang.space", true },
  { "hdm.io", true },
  { "hds-lan.de", true },
  { "hduin.xyz", true },
  { "hdwallpapers.net", true },
  { "head.org", true },
  { "healthcare.gov", false },
  { "healtheffectsofasbestos.com", true },
  { "healthfoam.com", true },
  { "healthiercompany.com", true },
  { "heartmdinstitute.com", true },
  { "heartsucker.com", true },
  { "heathmanners.com", true },
  { "heavensinferno.net", true },
  { "heavystresser.com", true },
  { "hebikhiv.nl", true },
  { "hec.global", true },
  { "hedgeschool.ie", true },
  { "hegen.com.pl", true },
  { "heh.ee", true },
  { "heha.co", false },
  { "heid.ws", true },
  { "heijblok.com", true },
  { "heinpost.nl", true },
  { "hejahanif.se", true },
  { "hejsupport.se", true },
  { "hele.cz", true },
  { "helgakristoffer.com", true },
  { "helgakristoffer.wedding", true },
  { "helichat.de", true },
  { "helix.am", true },
  { "hellersgas.com", true },
  { "helloacm.com", true },
  { "helloanselm.com", true },
  { "hellotandem.com", true },
  { "helloworldhost.com", true },
  { "hellscanyonraft.com", true },
  { "help.simpletax.ca", false },
  { "helpadmin.net", true },
  { "helpconnect.com.au", true },
  { "helpium.de", true },
  { "helpmebuild.com", true },
  { "hemlockhillscabinrentals.com", true },
  { "hencagon.com", true },
  { "hennadesigns.org", true },
  { "hennymerkel.com", true },
  { "henok.eu", true },
  { "henriknoerr.com", true },
  { "henriksen.is", true },
  { "henrock.net", true },
  { "henryphan.com", true },
  { "hentschke-bau.de", true },
  { "hentschke-invest.de", true },
  { "heppler.net", true },
  { "herbandpat.org", true },
  { "herbert.io", true },
  { "herbertmouwen.nl", true },
  { "hermes-net.de", true },
  { "herocentral.de", true },
  { "herpaderp.net", true },
  { "herr-webdesign.de", true },
  { "herrenfahrt.com", true },
  { "herrsmith.com", true },
  { "herzbotschaft.de", true },
  { "hetmer.com", true },
  { "heute-kaufen.de", true },
  { "heutger.net", true },
  { "hex2013.com", true },
  { "hexicurity.com", true },
  { "hexo.io", true },
  { "hexony.com", true },
  { "heycms.com", true },
  { "heyfringe.com", true },
  { "heyguevara.com", true },
  { "hg.python.org", true },
  { "hhhdb.com", true },
  { "hhmmmm.de", true },
  { "hibilog.com", true },
  { "hicl.org", true },
  { "hicn.gq", true },
  { "hicoria.com", true },
  { "hiddendepth.ie", true },
  { "hiddenmail.xyz", true },
  { "higgstools.org", true },
  { "highseer.com", true },
  { "highvelocitydesign.com", true },
  { "higp.de", true },
  { "hiisukun.com", true },
  { "hikariempire.com", true },
  { "hilahdih.cz", true },
  { "hilti.ee", false },
  { "hilti.kz", false },
  { "hilti.lv", false },
  { "hiphop.ren", true },
  { "hiphopconvention.nl", true },
  { "hippies.com.br", true },
  { "hipstercat.fr", true },
  { "hirake55.com", true },
  { "hisbrucker.net", true },
  { "history.google.com", false },
  { "hittipps.com", true },
  { "hiv.gov", true },
  { "hjw-kunstwerk.de", true },
  { "hk.search.yahoo.com", false },
  { "hlavacek.us", true },
  { "hledejpravnika.cz", true },
  { "hmm.nyc", false },
  { "hmsseahawk.com", true },
  { "hobby-gamerz-community.de", true },
  { "hobbyspeed.com", true },
  { "hochhaus.us", true },
  { "hochzeit-dana-laurens.de", true },
  { "hodne.io", true },
  { "hoffmeister.biz", true },
  { "hohm.in", true },
  { "holifestival-freyung.de", true },
  { "holisticon.de", true },
  { "hollowrap.com", true },
  { "holmesian.org", true },
  { "holofono.com", true },
  { "homads.com", false },
  { "homecareassociatespa.com", true },
  { "homedna.com", true },
  { "homehunting.pt", true },
  { "homeprivate.de", true },
  { "homeseller.co.uk", true },
  { "homeseller.com", true },
  { "homewatt.co.uk", true },
  { "homeyou.com", true },
  { "hompus.nl", false },
  { "honda-centrum.cz", true },
  { "hondart.cz", true },
  { "honeybadger.io", false },
  { "honeybeard.co.uk", true },
  { "honeycome.net", true },
  { "honoo.com", true },
  { "hoodoo.io", true },
  { "hoodoo.tech", true },
  { "hooray.beer", true },
  { "hopesb.org", true },
  { "hopewellproperties.co.uk", true },
  { "hopps.me", true },
  { "horvathd.eu", true },
  { "hory.me", true },
  { "horza.org", true },
  { "hoshinplan.com", true },
  { "hoshisato.com", true },
  { "hosiet.me", true },
  { "hosmussynergie.nl", true },
  { "hostam.link", true },
  { "hostanalyticsconsulting.com", true },
  { "hosteasy.nl", true },
  { "hosted-service.com", true },
  { "hostedbgp.net", true },
  { "hostedtalkgadget.google.com", true },
  { "hostelite.com", true },
  { "hostgarou.com", false },
  { "hostinaus.com.au", true },
  { "hostingactive.it", true },
  { "hostingfj.com", true },
  { "hostinghelp.guru", true },
  { "hostinginnederland.nl", true },
  { "hostix.de", true },
  { "hostmijnpagina.nl", true },
  { "hotchillibox.co.za", true },
  { "hotchoc.io", true },
  { "hotel-pension-sonnalp.eu", true },
  { "hotelmap.com", true },
  { "hoton.in", true },
  { "hotting.nl", true },
  { "houser.lu", true },
  { "housingstudents.org.uk", true },
  { "howbehealthy.com", true },
  { "howrandom.org", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "hozana.si", false },
  { "hpac-portal.com", true },
  { "hpisavageforum.com", true },
  { "hpkp-faq.de", true },
  { "hqhost.net", true },
  { "hr-intranet.com", true },
  { "hrackydomino.cz", true },
  { "hranicka.cz", true },
  { "hrbatypes.cz", true },
  { "hrobert.hu", true },
  { "hroschyk.cz", true },
  { "hs-group.net", true },
  { "hscorp.de", true },
  { "hsir.me", true },
  { "hsmr.cc", true },
  { "hsr.gov", true },
  { "hsts.date", true },
  { "hstsfail.appspot.com", true },
  { "htaccessbook.com", true },
  { "html5.org", true },
  { "htmlacademy.ru", true },
  { "http418.xyz", false },
  { "httpsecurityreport.com", true },
  { "httpswatch.com", true },
  { "huarongdao.com", true },
  { "huaxueba.com", true },
  { "huersch.com", true },
  { "huffduffer.com", true },
  { "hugocollignon.fr", true },
  { "hugosleep.com.au", true },
  { "huiser.nl", true },
  { "humankode.com", true },
  { "humblefinances.com", true },
  { "humeurs.net", true },
  { "humpteedumptee.in", true },
  { "hund.io", true },
  { "huntshomeinspections.com", true },
  { "hup.blue", true },
  { "hupp.se", true },
  { "hurd.is", true },
  { "huren.nl", true },
  { "hurricanelabs.com", true },
  { "husakbau.at", true },
  { "hushfile.it", true },
  { "husky.xyz", true },
  { "huskybutt.dog", true },
  { "huskyinc.us", true },
  { "hx53.de", true },
  { "hxying.com", true },
  { "hydrocloud.net", true },
  { "hydrozone.fr", true },
  { "hyk.me", true },
  { "hymerscollege.co.uk", true },
  { "hyper-text.org", true },
  { "i--b.com", true },
  { "i-partners.sk", true },
  { "i10z.com", false },
  { "i5y.co.uk", true },
  { "iactu.info", true },
  { "iainsimms.me", true },
  { "iamcarrico.com", true },
  { "iamokay.nl", true },
  { "ian.sh", true },
  { "ianix.com", true },
  { "iapws.com", true },
  { "ib-wedler.de", true },
  { "iba.community", true },
  { "iban.is", true },
  { "ibarf.nl", true },
  { "ibnuwebhost.com", true },
  { "ibron.co", true },
  { "icarlos.net", true },
  { "icebat.dyndns.org", true },
  { "iceloch.com", true },
  { "ichronos.net", true },
  { "icpc2016.in.th", true },
  { "icq-project.net", true },
  { "ict-concept.nl", true },
  { "ictinforensics.org", true },
  { "ictual.com", true },
  { "id-co.in", true },
  { "id-conf.com", false },
  { "id.atlassian.com", true },
  { "id.fedoraproject.org", false },
  { "id.mayfirst.org", false },
  { "id.search.yahoo.com", false },
  { "id0-rsa.pub", true },
  { "idacmedia.com", true },
  { "idaspis.com", true },
  { "ideadozz.hu", true },
  { "ideasmeetingpoint.com", true },
  { "ideation-inc.co.jp", true },
  { "ideaweb.de", true },
  { "idedr.com", true },
  { "idensys.nl", true },
  { "identitytheft.gov", true },
  { "idexxpublicationportal.com", true },
  { "idgard.de", true },
  { "idgsupply.com", true },
  { "idlekernel.com", true },
  { "idndx.com", true },
  { "idoc24.com", true },
  { "idolf.dk", true },
  { "idontplaydarts.com", true },
  { "idvl.de", true },
  { "iec.pe", false },
  { "ieeespmb.org", true },
  { "ies-italia.it", true },
  { "ies.id.lv", true },
  { "ieval.ro", true },
  { "ifasec.de", false },
  { "ifcfg.me", true },
  { "ifconfig.co", true },
  { "iflare.de", true },
  { "ifleurs.com", true },
  { "ifoss.me", true },
  { "ifxor.com", true },
  { "igforums.com", true },
  { "iggprivate.com", true },
  { "iggsoft.com", true },
  { "iggsoftware.com", true },
  { "igiftcards.nl", true },
  { "igk.de", true },
  { "igotoffer.com", true },
  { "igrivi.com", true },
  { "ihrlotto.de", true },
  { "ihrnationalrat.ch", true },
  { "ihsbsd.me", true },
  { "iirii.com", true },
  { "iispeed.com", true },
  { "ijohan.nl", true },
  { "ijsclubtilburg.nl", true },
  { "ikeyless.com", true },
  { "ikk.me", true },
  { "ikkatsu-satei.jp", true },
  { "iklive.org", true },
  { "ikon.name", true },
  { "ikvts.de", true },
  { "ikwilguidobellen.nl", true },
  { "ilbuongiorno.it", true },
  { "ile-kalorii.pl", true },
  { "ilhadocaranguejo.com.br", true },
  { "ilikerainbows.co", true },
  { "ilikerainbows.co.uk", false },
  { "illorenese.fr", true },
  { "ilrg.com", true },
  { "iluvscotland.co.uk", true },
  { "im-c-shop.com", true },
  { "im2net.com", true },
  { "imagefu.com", true },
  { "imagescostumes.com", true },
  { "imaginary.ca", true },
  { "imagr.io", true },
  { "imanolbarba.net", true },
  { "imbrian.org", true },
  { "imedikament.de", true },
  { "imeds.pl", true },
  { "imgg.es", true },
  { "imirhil.fr", true },
  { "imjad.cn", true },
  { "imlonghao.com", true },
  { "immaterium.de", true },
  { "immigrationdirect.com.au", true },
  { "immobilier-nice.fr", true },
  { "immoprotect.ca", true },
  { "immortals-co.com", true },
  { "immoverkauf24.at", true },
  { "immoverkauf24.de", true },
  { "immunicity.eu", true },
  { "immunicity.info", true },
  { "imolug.org", true },
  { "imoni-blog.net", true },
  { "imperialwebsolutions.com", true },
  { "impex.com.bd", true },
  { "imququ.com", true },
  { "imreh.net", true },
  { "imrejonk.nl", true },
  { "imu.li", true },
  { "in-depthoutdoors.com", true },
  { "in-flames.com", true },
  { "in.search.yahoo.com", false },
  { "in.xero.com", false },
  { "inb4.us", true },
  { "inbitcoin.it", true },
  { "inbounder.io", true },
  { "inbox-group.com", true },
  { "inbox.google.com", true },
  { "inbox.li", true },
  { "inboxen.org", true },
  { "incendiary-arts.com", true },
  { "inche-ali.com", true },
  { "incparadise.net", true },
  { "indiecert.net", false },
  { "indievelopment.nl", true },
  { "indoorskiassen.nl", true },
  { "indovinabank.com.vn", true },
  { "indredouglas.me", true },
  { "indusfastremit-ca.com", true },
  { "indusfastremit-us.com", true },
  { "indusfastremit.com", true },
  { "indust.me", false },
  { "industreiler.com", true },
  { "indybay.org", true },
  { "infcof.com", true },
  { "infilock.com", true },
  { "infinitusgaming.eu", true },
  { "influxus.com", false },
  { "infogrfx.com", true },
  { "informatiebeveiliging.nl", true },
  { "informatik.zone", true },
  { "informnapalm.org", true },
  { "infosec.ch", true },
  { "infosenior.ch", true },
  { "infotics.es", true },
  { "infra-con.dk", true },
  { "iniiter.com", true },
  { "inios.fr", true },
  { "initq.net", false },
  { "initrd.net", true },
  { "injigo.com", true },
  { "inkable.com.au", true },
  { "inkbunny.net", true },
  { "inksay.com", true },
  { "inleaked.com", true },
  { "inmyarea.com", true },
  { "innophate-security.com", true },
  { "innophate-security.nl", true },
  { "innovaptor.at", true },
  { "innovaptor.com", true },
  { "insane.zone", true },
  { "insideaudit.com", true },
  { "insightera.co.th", true },
  { "insighti.com", true },
  { "insighti.eu", true },
  { "insighti.org", true },
  { "insighti.sk", true },
  { "inspire-av.com", true },
  { "inspiroinc.com", true },
  { "inspy.me", true },
  { "instant-hack.com", true },
  { "instant.io", true },
  { "instantdev.io", true },
  { "instasex.ch", true },
  { "instela.com", true },
  { "institutoflordelavida.com", true },
  { "institutolancaster.com", true },
  { "intarweb.ca", true },
  { "integrationinc.com", false },
  { "integromat.com", true },
  { "intel.li", true },
  { "intelldynamics.com", true },
  { "interaffairs.com", true },
  { "interasistmen.se", true },
  { "interfug.de", true },
  { "interisaudit.com", true },
  { "interlun.com", true },
  { "intermedinet.nl", true },
  { "internect.co.za", true },
  { "internetbank.swedbank.se", true },
  { "internetbugbounty.org", true },
  { "internetcasinos.de", true },
  { "internethering.de", true },
  { "internetzentrale.net", true },
  { "internl.net", true },
  { "interociter-enterprises.com", true },
  { "interviewpipeline.co.uk", true },
  { "interways.de", true },
  { "intim-uslugi-kazan.net", true },
  { "intimateperrierjouet.com", true },
  { "intocities.de", false },
  { "inton.biz", true },
  { "intramanager.co.uk", true },
  { "intramanager.dk", true },
  { "intranetsec.fr", true },
  { "intrasoft.com.au", true },
  { "intxt.net", true },
  { "inusasha.de", true },
  { "investorforms.com", true },
  { "invictusmc.uk", true },
  { "invoicefinance.nl", true },
  { "inwestcorp.se", true },
  { "inzdr.com", true },
  { "iocheck.com", false },
  { "iodu.re", true },
  { "iolife.dk", true },
  { "iompost.com", true },
  { "iomstamps.com", true },
  { "ionas-law.ro", false },
  { "ionc.ca", true },
  { "ionlabs.kr", true },
  { "ionx.co.uk", true },
  { "iossifovlab.com", true },
  { "iotsms.io", true },
  { "ip-life.net", true },
  { "ip6.im", true },
  { "ip6.li", true },
  { "ipal.im", true },
  { "ipal.name", true },
  { "ipcfg.me", true },
  { "ipconsulting.se", true },
  { "iplabs.de", true },
  { "ipledgeonline.org", true },
  { "ipmotion.ca", true },
  { "ipomue.com", false },
  { "iprice.co.id", true },
  { "iprice.hk", true },
  { "iprice.my", true },
  { "iprice.ph", true },
  { "iprice.sg", true },
  { "iprice.vn", true },
  { "ipricethailand.com", true },
  { "ipsec.pl", true },
  { "ipswitch.com.tw", true },
  { "iptel.by", false },
  { "ipv6-adresse.dk", true },
  { "ipv6-handbuch.de", true },
  { "ipv6cloud.club", true },
  { "iqboxy.com", true },
  { "iqualtech.com", true },
  { "iranianlawschool.com", true },
  { "irazimina.ru", true },
  { "ircmett.de", true },
  { "iready.ro", true },
  { "ireef.tv", true },
  { "irgit.pl", true },
  { "iridiumbrowser.de", true },
  { "iridiumflare.de", true },
  { "irische-segenswuensche.info", true },
  { "irmag.ru", true },
  { "ironfistdesign.com", true },
  { "isaacman.tech", true },
  { "isbengrumpy.com", true },
  { "ischool.co.jp", true },
  { "iseek.biz", true },
  { "iseulde.com", true },
  { "isimonbrown.co.uk", true },
  { "isincheck.com", true },
  { "isitamor.pm", true },
  { "isitchristmas.com", true },
  { "isitup.org", true },
  { "iskaron.de", true },
  { "islandhosting.com", true },
  { "isletech.net", true },
  { "isogen5.com", true },
  { "isondo.com", true },
  { "isopres.de", true },
  { "isqrl.de", true },
  { "israkurort.com", true },
  { "isreedyintheuk.com", true },
  { "issuesofconcern.in", true },
  { "istanbul.systems", true },
  { "istanbultravelguide.info", true },
  { "istdieweltschonuntergegangen.de", true },
  { "istheapplestoredown.com", true },
  { "istheapplestoredown.de", true },
  { "istorrent.is", true },
  { "it-go.net", true },
  { "it-schwerin.de", true },
  { "it.search.yahoo.com", false },
  { "itb-online.co.uk", true },
  { "itdashboard.gov", true },
  { "itechgeek.com", true },
  { "iterror.co", true },
  { "itfh.eu", true },
  { "itforge.nl", true },
  { "itinsight.hu", true },
  { "itludens.com", true },
  { "itnota.com", true },
  { "itos.asia", true },
  { "itos.pl", true },
  { "itpol.dk", true },
  { "itriskltd.com", true },
  { "its-gutachten.de", true },
  { "its-v.de", true },
  { "its4living.com", true },
  { "itsadog.co.uk", true },
  { "itsagadget.com", true },
  { "itsatrap.nl", true },
  { "itsecguy.com", true },
  { "itsg-faq.de", true },
  { "itshost.ru", true },
  { "ivancacic.com", true },
  { "ivk.website", true },
  { "ivpn.net", true },
  { "iwalton.com", true },
  { "iwannarefill.com", true },
  { "iwilcox.me.uk", true },
  { "iwizerunek.pl", true },
  { "ix8.ru", true },
  { "izdiwho.com", true },
  { "izolight.ch", true },
  { "izoox.com", true },
  { "izzzorgconcerten.nl", true },
  { "j-lsolutions.com", true },
  { "j-navi.com", true },
  { "j0s.eu", true },
  { "j3e.de", true },
  { "jaba.hosting", true },
  { "jabber.at", true },
  { "jacekowski.org", true },
  { "jackdelik.de", true },
  { "jackf.me", true },
  { "jackfahnestock.com", true },
  { "jackyyf.com", false },
  { "jaclynjohnson.com", true },
  { "jacobhaug.com", true },
  { "jacobparry.ca", false },
  { "jacobphono.com", true },
  { "jacuzziprozone.com", true },
  { "jagerman.com", true },
  { "jagido.de", true },
  { "jahliveradio.com", false },
  { "jahofmann.de", true },
  { "jaispirit.com", true },
  { "jakenbake.com", true },
  { "jaketremper.com", true },
  { "jakub-boucek.cz", true },
  { "jakubboucek.cz", true },
  { "jakubtopic.cz", true },
  { "james.je", true },
  { "jamesbradach.com", true },
  { "jamesburton.london", true },
  { "jamesbywater.co.uk", true },
  { "jamesbywater.com", true },
  { "jamesbywater.me", true },
  { "jamesbywater.me.uk", true },
  { "jamesbywater.uk", true },
  { "jamesconroyfinn.com", true },
  { "jamesdoell.com", true },
  { "jameshost.net", true },
  { "jamesmaurer.com", true },
  { "jamesmilazzo.com", true },
  { "jamesmorrison.me", true },
  { "jamesrains.com", true },
  { "jamessan.com", true },
  { "jamielinux.com", true },
  { "jamiemagee.co.uk", true },
  { "jamiemagee.dk", true },
  { "jamon.ca", true },
  { "jamonsilva.com", true },
  { "jan27.org", true },
  { "janario.me", true },
  { "janbrodda.de", true },
  { "janoberst.com", true },
  { "janokacer.sk", true },
  { "janosh.com", true },
  { "jaot.info", true },
  { "japan-foods.co.uk", true },
  { "japan4you.org", true },
  { "japaniac.de", true },
  { "japlex.com", true },
  { "jaqen.ch", true },
  { "jaredeberle.org", true },
  { "jaredfernandez.com", true },
  { "jaroslavtrsek.cz", true },
  { "jarsater.com", true },
  { "jartza.org", true },
  { "jasonamorrow.com", true },
  { "jasonrobinson.me", true },
  { "jasperhammink.com", true },
  { "jastoria.pl", true },
  { "jav-collective.com", true },
  { "javelinsms.com", true },
  { "jayharris.ca", true },
  { "jaymecd.rocks", true },
  { "jayschulman.com", true },
  { "jayscoaching.com", false },
  { "jayshao.com", true },
  { "jazz-alliance.com", true },
  { "jazz-alliance.org", true },
  { "jazzanet.com", true },
  { "jazzinutrecht.info", true },
  { "jazzncheese.com", true },
  { "jbbd.fr", true },
  { "jbn.mx", true },
  { "jbradaric.me", true },
  { "jcaicedo.tk", true },
  { "jcch.de", true },
  { "jcoscia.com", true },
  { "jcraft.us", true },
  { "jctf.io", true },
  { "jcyz.cf", true },
  { "jdh8.org", true },
  { "jdubya.info", true },
  { "jean-remy.ch", true },
  { "jeff.forsale", true },
  { "jeff393.com", true },
  { "jeffcasavant.com", false },
  { "jefftickle.com", true },
  { "jekkt.com", true },
  { "jelly.cz", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jenjoit.de", true },
  { "jennedebleser.com", false },
  { "jennifersauer.nl", true },
  { "jennybeaned.com", true },
  { "jennythebaker.com", false },
  { "jensenbanden.no", true },
  { "jensrex.dk", true },
  { "jeremiahbenes.com", true },
  { "jeremye77.com", true },
  { "jeremyness.com", true },
  { "jerodslay.com", true },
  { "jeroendeneef.com", true },
  { "jessicabenedictus.nl", true },
  { "jesters-court.net", true },
  { "jetmirshatri.com", true },
  { "jetsetcharge.com", true },
  { "jetsieswerda.nl", true },
  { "jettlarue.com", true },
  { "jettshome.org", false },
  { "jetwhiz.com", true },
  { "jeugdkans.nl", true },
  { "jfmel.com", true },
  { "jfreitag.de", true },
  { "jgid.de", true },
  { "jh-media.eu", false },
  { "jhalderm.com", true },
  { "jhburton.co.uk", true },
  { "jhburton.uk", true },
  { "jhejderup.me", true },
  { "jie.dance", true },
  { "jikken.de", true },
  { "jimshaver.net", true },
  { "jinbo123.com", false },
  { "jira.com", true },
  { "jirav.com", true },
  { "jirav.io", true },
  { "jitsi.org", false },
  { "jka.io", true },
  { "jkb.pics", true },
  { "jkbuster.com", true },
  { "jkirsche.com", true },
  { "jkrippen.com", true },
  { "jlkhosting.com", true },
  { "jmdekker.it", true },
  { "jmedved.com", true },
  { "jmk.hu", true },
  { "jn1.me", true },
  { "joakimalgroy.com", true },
  { "jobbkk.com", true },
  { "jobflyapp.com", true },
  { "jobmedic.com", true },
  { "jobmob.co.il", true },
  { "jobss.co.uk", true },
  { "jodyboucher.com", true },
  { "joelj.org", true },
  { "joepitt.co.uk", true },
  { "joerss.at", true },
  { "jogorama.com.br", true },
  { "johannes.io", true },
  { "johannes.wtf", true },
  { "johndong.net", true },
  { "johners.me", true },
  { "johners.tech", true },
  { "johngallias.com", true },
  { "johnguant.com", true },
  { "johnhgaunt.com", true },
  { "johnmichel.org", true },
  { "johnrom.com", true },
  { "johnverkerk.com", true },
  { "jokewignand.nl", true },
  { "jonaskjodt.com", true },
  { "jonaswitmer.ch", true },
  { "jonathan-apps.com", true },
  { "jondevin.com", true },
  { "jonfor.net", true },
  { "jonlabelle.com", true },
  { "jonn.me", true },
  { "jonnichols.info", true },
  { "jonnybarnes.uk", true },
  { "jonpads.com", true },
  { "joostrijneveld.nl", true },
  { "jooto.com", true },
  { "jopsens.de", true },
  { "jordanhamilton.me", true },
  { "joretapo.fr", true },
  { "jorgemesa.me", true },
  { "jornadasciberdefensa2016.es", true },
  { "josahrens.me", true },
  { "josefjanosec.com", true },
  { "josephrees.uk", true },
  { "joshgrancell.com", true },
  { "joshi.su", true },
  { "joworld.net", true },
  { "joyofcookingandbaking.com", true },
  { "joyqi.com", true },
  { "jpbike.cz", true },
  { "jr5devdoug.xyz", true },
  { "jr5devdouglas.xyz", true },
  { "jr5proxdoug.xyz", true },
  { "jrc9.ca", true },
  { "jrgold.me", true },
  { "jrmd.io", true },
  { "js-online.net", true },
  { "jsg-technologies.de", true },
  { "json-viewer.com", true },
  { "jstore.ch", true },
  { "jthackery.com", false },
  { "jualssh.com", true },
  { "jugendsuenden.info", true },
  { "juhakoho.com", true },
  { "julianmeyer.de", true },
  { "juliansimioni.com", true },
  { "julibear.com", true },
  { "julido.de", true },
  { "juliemaurel.fr", true },
  { "jultube.de", true },
  { "jumba.com.au", true },
  { "jumbox.xyz", true },
  { "jump.bg", true },
  { "jump.wtf", true },
  { "junaos.xyz", true },
  { "junethack.net", true },
  { "jungesforumkonstanz.de", true },
  { "juniwalk.cz", true },
  { "junjung.me", true },
  { "junkdrome.org", true },
  { "junqtion.com", false },
  { "jupp0r.de", true },
  { "jurriaan.ninja", true },
  { "justchunks.net", true },
  { "justnaw.co.uk", true },
  { "justyy.com", true },
  { "juwairen.cn", true },
  { "jvoice.net", true },
  { "jwilsson.com", true },
  { "jwilsson.me", true },
  { "jwnotifier.org", true },
  { "jym.fit", true },
  { "jznet.org", true },
  { "k-dev.de", true },
  { "k-tube.com", true },
  { "kaangenc.me", true },
  { "kaasbijwijn.nl", true },
  { "kabuabc.com", true },
  { "kachlikova2.cz", true },
  { "kackscharf.de", true },
  { "kadioglumakina.com.tr", true },
  { "kaheim.de", true },
  { "kahopoon.net", true },
  { "kaileymslusser.com", true },
  { "kainz.bayern", true },
  { "kainz.be", true },
  { "kairion.de", true },
  { "kaisers.de", true },
  { "kaizeronion.com", true },
  { "kakao-karten.de", true },
  { "kakaravaara.fi", true },
  { "kalender.com", true },
  { "kalevlamps.co.uk", true },
  { "kall.is", true },
  { "kalmar.com", true },
  { "kaloix.de", true },
  { "kamcvicit.sk", true },
  { "kamitech.ch", true },
  { "kamixa.se", true },
  { "kana.me", true },
  { "kanehusky.com", true },
  { "kaneo-gmbh.de", true },
  { "kangarooislandholidayaccommodation.com.au", true },
  { "kanna.cf", true },
  { "kanotijd.nl", true },
  { "kantankye.nl", true },
  { "kantanmt.com", true },
  { "kantorosobisty.pl", true },
  { "kanzashi.com", true },
  { "kaplatz.is", true },
  { "kapseli.net", true },
  { "kapucini.si", false },
  { "kaputt.com", true },
  { "karaoketonight.com", true },
  { "karateka.org", true },
  { "karateka.ru", true },
  { "kardize24.pl", true },
  { "karguine.in", true },
  { "karmaplatform.com", true },
  { "karmaspa.se", true },
  { "karsofsystems.com", true },
  { "karting34.com", true },
  { "kartonmodellbau.org", true },
  { "kashdash.ca", true },
  { "kasko.io", true },
  { "kassa.at", true },
  { "katekligys.com", true },
  { "katericke.com", true },
  { "katiaetdavid.fr", true },
  { "katka.info", true },
  { "katnunn.co.uk", true },
  { "katproxy.site", true },
  { "katyl.info", true },
  { "kau-boys.com", true },
  { "kau-boys.de", true },
  { "kaufberatung.community", true },
  { "kausch.at", true },
  { "kavik.no", true },
  { "kavovary-kava.cz", true },
  { "kawaii.io", false },
  { "kawaiiku.com", true },
  { "kawaiiku.de", true },
  { "kazandaemon.ru", true },
  { "kb3.net", true },
  { "kba-online.de", true },
  { "kbcequitas.hu", true },
  { "kbit.dk", true },
  { "kbjorklu.com", true },
  { "kcolford.com", true },
  { "kd-plus.pp.ua", true },
  { "kdex.de", true },
  { "kdyby.org", true },
  { "ke7tlf.us", true },
  { "keaysmillwork.com", true },
  { "kedarastudios.com", true },
  { "keeleysam.com", true },
  { "keeleysam.me", true },
  { "keepa.com", true },
  { "keepclean.me", true },
  { "keeperapp.com", true },
  { "keepersecurity.com", true },
  { "keeweb.info", true },
  { "kefaloniatoday.com", true },
  { "keganthorrez.com", true },
  { "keisaku.org", true },
  { "keke-shop.ch", true },
  { "kekku.li", true },
  { "kekz.org", true },
  { "kempkens.io", true },
  { "kendra.io", true },
  { "kengilmour.com", true },
  { "kenkoelectric.com", true },
  { "kenners.org", true },
  { "kentacademiestrust.org.uk", true },
  { "keops-spine.fr", true },
  { "keops-spine.us", true },
  { "kerangalam.com", true },
  { "kermadec.com", true },
  { "kernel-error.de", true },
  { "keskeces.com", true },
  { "kesteren.com", true },
  { "kesteren.org", true },
  { "ketosecology.co.uk", true },
  { "kevinapease.com", true },
  { "kevincox.ca", true },
  { "keybase.io", true },
  { "keybored.me", true },
  { "keycdn.com", true },
  { "keyerror.com", true },
  { "keys.fedoraproject.org", true },
  { "kg-rating.com", true },
  { "kgm-irm.be", true },
  { "khanovaskola.cz", true },
  { "khetzal.info", true },
  { "khipu.com", true },
  { "khmath.com", true },
  { "ki-on.net", true },
  { "kiano.net", true },
  { "kick-in.nl", true },
  { "kickass.al", true },
  { "kickerplaza.nl", true },
  { "kid-dachau.de", true },
  { "kidbacker.com", true },
  { "kiebel.de", true },
  { "kiel-media.de", true },
  { "kienlen.org", true },
  { "kikuzuki.org", true },
  { "kilerd.me", true },
  { "kilianvalkhof.com", true },
  { "killerrobots.com", true },
  { "kilobyte22.de", true },
  { "kimberg.co.uk", true },
  { "kimmel.com", true },
  { "kinderbasar-luhe.de", true },
  { "kinderbuecher-kostenlos.de", true },
  { "kinderwagen-test24.de", true },
  { "kindleworth.com", true },
  { "kindof.ninja", true },
  { "kingant.net", true },
  { "kinganywhere.eu", true },
  { "kingmanhall.org", true },
  { "kinsights.com", false },
  { "kintone.com", true },
  { "kintore.tv", true },
  { "kiocloud.com", true },
  { "kionetworks.com", true },
  { "kirara.eu", true },
  { "kirbear.com", true },
  { "kirei.se", true },
  { "kirinas.com", true },
  { "kirkovsky.com", true },
  { "kirschbaum.me", true },
  { "kirstin-peters.de", true },
  { "kis-toitoidixi.de", true },
  { "kisalt.im", true },
  { "kissflow.com", true },
  { "kisstyle.ru", true },
  { "kita.id", true },
  { "kitabgaul.com", true },
  { "kitakemon.com", true },
  { "kitsostech.com", true },
  { "kitsta.com", true },
  { "kittmedia.com", true },
  { "kizil.net", true },
  { "kjaermaxi.me", true },
  { "kjarrval.is", true },
  { "kk-neudorf-duissern.de", true },
  { "kksg.com", true },
  { "klarmobil-empfehlen.de", true },
  { "klas.or.id", true },
  { "klasfauseweh.de", true },
  { "klatschreime.de", true },
  { "klausbrinch.dk", false },
  { "klausimas.lt", true },
  { "klauwd.com", true },
  { "klaxn.com", true },
  { "kle.cz", true },
  { "kleertjesvoordelig.nl", true },
  { "kleidertauschpartys.de", true },
  { "kleine-dingen.nl", true },
  { "kleinerarchitekturfuehrer.de", true },
  { "kleppe.co", true },
  { "kleteckova.cz", true },
  { "klicktojob.de", true },
  { "kliemann.me", true },
  { "klif1.nl", true },
  { "klimat-pro.pl", true },
  { "klingeletest.de", true },
  { "klunkergarten.org", true },
  { "klustekeningen.nl", true },
  { "km-net.pl", true },
  { "kmkz.jp", true },
  { "knapen.io", true },
  { "knccloud.com", true },
  { "kngk-group.ru", true },
  { "kngk.org", true },
  { "knip.ch", true },
  { "knot-store.com", true },
  { "knowledgehook.com", true },
  { "knygos.lt", true },
  { "kodakit.com", true },
  { "kodokushi.fr", true },
  { "koen.io", true },
  { "koenrouwhorst.nl", true },
  { "koenvdheuvel.me", false },
  { "koerper-wie-seele.de", false },
  { "koerperimpuls.ch", true },
  { "koezmangal.ch", true },
  { "koi-sama.net", true },
  { "kojima-life.co.jp", true },
  { "kojipkgs.fedoraproject.org", true },
  { "kokenmetaanbiedingen.nl", true },
  { "koketteriet.se", true },
  { "kolaykaydet.com", true },
  { "kollabria.com", true },
  { "kollawat.me", true },
  { "kolmann.eu", true },
  { "komandakovalchuk.com", false },
  { "komget.net", true },
  { "komikito.com", true },
  { "komiksbaza.pl", true },
  { "komoju.com", true },
  { "kompetenzwerft.de", true },
  { "kon-sil.de", true },
  { "konata.us", true },
  { "konijntjes.nl", true },
  { "konklone.com", true },
  { "konsertoversikt.no", true },
  { "koop-bremen.de", true },
  { "koophetlokaal.nl", true },
  { "koopjesnel.nl", true },
  { "koot.nl", true },
  { "koretech.nl", true },
  { "korinar.com", true },
  { "kornersafe.com", true },
  { "korobi.io", true },
  { "korobkovsky.ru", true },
  { "kosho.org", true },
  { "kostya.net", false },
  { "kotonehoko.net", true },
  { "koukni.cz", true },
  { "kozuch.biz", true },
  { "kpdyer.com", true },
  { "kpebetka.net", true },
  { "kpinvest.eu", true },
  { "krachtinverbinding.nl", true },
  { "kradalby.no", true },
  { "kraft.im", true },
  { "kraiwon.com", true },
  { "kraken.io", true },
  { "krasota.ru", false },
  { "kraynik.com", true },
  { "kream.io", true },
  { "kreationnext.com", true },
  { "kreativstrecke.de", true },
  { "kreavis.com", true },
  { "kredietpaspoort.nl", true },
  { "kredite.sale", true },
  { "kredite24.de", true },
  { "kreen.org", false },
  { "kriegskindernothilfe.de", true },
  { "kriegt.es", true },
  { "krisstarkey.co.uk", true },
  { "kristikala.nl", true },
  { "kristofferkoch.com", true },
  { "krizek.cc", true },
  { "krmela.com", true },
  { "kroetenfuchs.de", true },
  { "kromonos.net", true },
  { "kroodle.nl", true },
  { "kropkait.pl", true },
  { "krunut.com", true },
  { "krypsys.com", true },
  { "krypteia.org", true },
  { "kryptera.se", true },
  { "kryx.de", true },
  { "ks-watch.de", true },
  { "kschv-rdeck.de", true },
  { "ksfh-mail.de", true },
  { "kstan.me", true },
  { "kubik-rubik.de", false },
  { "kucom.it", true },
  { "kuehnel.org", true },
  { "kueulangtahunanak.net", true },
  { "kulde.net", true },
  { "kum.com", true },
  { "kumachan.biz", true },
  { "kumasanda.jp", true },
  { "kummerlaender.eu", true },
  { "kunstundunrat.de", true },
  { "kupelne-ptacek.sk", true },
  { "kuponrazzi.com", true },
  { "kuppingercole.com", true },
  { "kupschke.net", true },
  { "kura.io", false },
  { "kurehun.org", true },
  { "kurofuku.me", true },
  { "kurtmclester.com", true },
  { "kurz.pw", true },
  { "kuwago.io", true },
  { "kvalita-1a.cz", true },
  { "kwidz.fr", true },
  { "kwikmed.eu", true },
  { "kyanite.co", true },
  { "kybi.sk", true },
  { "kylelaker.com", true },
  { "kylinj.com", true },
  { "kynaston.org.uk", true },
  { "kynastonwedding.co.uk", true },
  { "kyosaku.org", true },
  { "l-lab.org", true },
  { "labaia.info", true },
  { "labs.directory", true },
  { "labs.moscow", true },
  { "lacasseroy.com", true },
  { "lacentral.com", true },
  { "lacledeslan.com", true },
  { "lacledeslan.ninja", true },
  { "lafkor.de", true },
  { "lagalerievirtuelle.fr", true },
  { "lagerauftrag.info", true },
  { "laglab.org", true },
  { "lagoza.name", true },
  { "lainchan.org", true },
  { "lakhesis.net", true },
  { "lalaya.fr", true },
  { "lambda-complex.org", true },
  { "lambdafive.co.uk", true },
  { "lamboo.be", true },
  { "laminine.info", true },
  { "lampl.info", true },
  { "lan2k.org", true },
  { "lana.swedbank.se", true },
  { "lanbyte.se", true },
  { "lancejames.com", true },
  { "land.nrw", true },
  { "langatang.com", true },
  { "langbein.org", true },
  { "langenbach.rocks", true },
  { "langendries.eu", true },
  { "langguth.io", true },
  { "langhun.me", true },
  { "lansinoh.co.uk", true },
  { "lapetition.be", true },
  { "lapidge.net", true },
  { "laposte.net", true },
  { "largescaleforums.com", true },
  { "larrysalibra.com", true },
  { "larsklene.nl", true },
  { "lasercloud.ml", true },
  { "laserfuchs.de", true },
  { "lashstuff.com", true },
  { "lask.in", true },
  { "lasnaves.com", true },
  { "lasst-uns-beten.de", true },
  { "lastpass.com", false },
  { "latenitefilms.com", false },
  { "lateralsecurity.com", true },
  { "latinphone.com", true },
  { "latitude42technology.com", true },
  { "latrine.cz", true },
  { "lauftreff-himmelgeist.de", true },
  { "laukstein.com", true },
  { "launchkey.com", true },
  { "laurel4th.org", true },
  { "lavalite.de", true },
  { "lavine.ch", true },
  { "lavval.com", true },
  { "lawformt.com", true },
  { "laxatus.com", true },
  { "laylo.nl", true },
  { "lazurit.com", true },
  { "lb-toner.de", true },
  { "lbayer.com", true },
  { "lbrt.xyz", true },
  { "lcti.biz", true },
  { "ld-begunjscica.si", true },
  { "ldarby.me.uk", true },
  { "le-dev.de", true },
  { "le-hosting.de", true },
  { "leadbook.ru", true },
  { "leadingsalons.com", true },
  { "leakedminecraft.net", true },
  { "leanclub.org", true },
  { "learnflakes.net", true },
  { "learningorder.com", true },
  { "learntube.cz", true },
  { "leatherfurnitureexpo.com", true },
  { "lechiennoir.net", true },
  { "ledhouse.sk", true },
  { "leedev.org", true },
  { "leerliga.de", true },
  { "leesilvey.com", true },
  { "lega-dental.com", true },
  { "legarage.org", true },
  { "legendofkrystal.com", true },
  { "legoutdesplantes.be", true },
  { "lehighmathcircle.org", true },
  { "leibniz-remscheid.de", true },
  { "leifdreizler.com", true },
  { "leilonorte.com", true },
  { "leinir.dk", true },
  { "leitner.com.au", true },
  { "lellyboi.ml", true },
  { "lemoine.at", true },
  { "lemp.io", true },
  { "lence.net", true },
  { "lengzzz.com", true },
  { "leninalbertop.com.ve", true },
  { "lenn1.de", true },
  { "lenovogaming.com", true },
  { "lenzw.de", true },
  { "leolana.com", true },
  { "leominstercu.com", false },
  { "leonard.io", true },
  { "leonardcamacho.me", true },
  { "leonax.net", true },
  { "leonklingele.de", true },
  { "leonmahler.consulting", true },
  { "leopold.email", true },
  { "leopoldina.net", true },
  { "lepont.pl", true },
  { "leppis-it.de", true },
  { "lerner.moscow", true },
  { "lerp.me", true },
  { "les-corsaires.net", true },
  { "lesdouceursdeliyana.com", true },
  { "lesnet.co.uk", true },
  { "lesperlesdunet.fr", true },
  { "letsmultiplayerplay.com", true },
  { "letstox.com", true },
  { "letustravel.tk", true },
  { "levendwater.org", true },
  { "levert.ch", true },
  { "levinus.de", true },
  { "lewis.li", true },
  { "lewisjuggins.co.uk", true },
  { "lexway.pk", true },
  { "lgiswa.com.au", true },
  { "lgrs.com.au", true },
  { "lhalbert.xyz", true },
  { "liaillustr.at", true },
  { "libbitcoin.org", true },
  { "libertas-tech.com", true },
  { "libertyrp.org", true },
  { "libfte.org", true },
  { "libraryfreedomproject.org", false },
  { "libreboot.org", true },
  { "librelamp.com", true },
  { "libsodium.org", true },
  { "liceserv.com", true },
  { "lichtspot.de", true },
  { "liderwalut.pl", true },
  { "liebel.org", true },
  { "lifeinitsownway.com", true },
  { "lifeskillsdirect.com", true },
  { "lifestylehunter.co.uk", true },
  { "lifetimemoneymachine.com", true },
  { "lifi.digital", true },
  { "lifi.is", true },
  { "light.mail.ru", true },
  { "lighting-centres.co.uk", true },
  { "lightme.us", true },
  { "lightpaste.com", true },
  { "lightspeed.com", false },
  { "likeaross.com", true },
  { "lillepuu.com", true },
  { "lilpwny.com", true },
  { "limeyeti.com", true },
  { "limitededitioncomputers.com", true },
  { "limitededitionsolutions.com", true },
  { "limpid.nl", true },
  { "limpido.it", true },
  { "lingolia.com", true },
  { "lingros-test.tk", true },
  { "linguatrip.com", false },
  { "lingvo-svoboda.ru", true },
  { "link.ba", true },
  { "link2serve.com", true },
  { "linkages.org", true },
  { "linkenheil.org", true },
  { "linkmaker.co.uk", true },
  { "linkonaut.net", true },
  { "linno.me", true },
  { "linode.com", false },
  { "linorman1997.me", true },
  { "linpx.com", true },
  { "linux-admin-california.com", true },
  { "linux.cn", true },
  { "linux.fi", true },
  { "linuxbabe.com", true },
  { "linuxbierwanderung.com", true },
  { "linuxcommand.ru", true },
  { "linuxeyecandy.com", true },
  { "linuxgeek.ro", true },
  { "linuxhostsupport.com", true },
  { "linuxlounge.net", true },
  { "linuxmonitoring.net", true },
  { "linuxwebservertips.in", true },
  { "linx.li", true },
  { "linx.net", true },
  { "linzgau.de", true },
  { "liquid.cz", true },
  { "liquidcomm.net", true },
  { "liquorsanthe.in", true },
  { "liris-beautywelt.de", true },
  { "lislan.org.uk", true },
  { "listafirmelor.com", true },
  { "lists.fedoraproject.org", true },
  { "lists.mayfirst.org", false },
  { "lists.stg.fedoraproject.org", true },
  { "litchidova.nl", true },
  { "litespeed.io", true },
  { "litevault.net", true },
  { "lithesalar.se", true },
  { "little.pw", true },
  { "litvideoserver.de", true },
  { "liud.im", true },
  { "liudon.org", true },
  { "liveforspeed.se", true },
  { "livej.am", true },
  { "livekaarten.nl", true },
  { "liverewrite.com", true },
  { "liverpoolmutualhomes.org", false },
  { "livnev.me", true },
  { "ljs.io", true },
  { "lkummer.cz", true },
  { "llamacuba.com", true },
  { "lloyd-day.me", true },
  { "lm-pumpen.de", true },
  { "lmddgtfy.net", true },
  { "lmintlcx.com", true },
  { "lmmtfy.io", true },
  { "lmsptfy.com", true },
  { "lntu.org", true },
  { "loadso.me", true },
  { "loancompare.co.za", true },
  { "lobste.rs", true },
  { "localbandz.com", true },
  { "localbitcoins.com", true },
  { "localchum.com", true },
  { "lockify.com", true },
  { "locktheirphone.com", true },
  { "locomore.com", true },
  { "locomotive.ca", true },
  { "lodash.com", true },
  { "loftboard.eu", true },
  { "logario.com.br", true },
  { "logement-saisonnier.com", true },
  { "logentries.com", false },
  { "logfile.at", true },
  { "logicsale.com", true },
  { "logicsale.de", true },
  { "logicsale.fr", true },
  { "logicsale.it", true },
  { "login.corp.google.com", true },
  { "login.launchpad.net", true },
  { "login.persona.org", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "loginseite.com", true },
  { "lognot.net", true },
  { "logopaediereinhard.de", true },
  { "logopoeia.com", true },
  { "lokaal.org", true },
  { "loli.bz", true },
  { "lolicore.ch", true },
  { "lolpatrol.de", true },
  { "lonal.com", true },
  { "london-transfers.com", true },
  { "londonlanguageexchange.com", true },
  { "longboarding-ulm.de", true },
  { "lookout.com", false },
  { "lookyman.net", true },
  { "loony.info", true },
  { "loophost.com.br", true },
  { "loopstart.org", true },
  { "lordjevington.co.uk", true },
  { "lore.azurewebsites.net", true },
  { "lost.host", true },
  { "lostinsecurity.com", true },
  { "lothai.re", false },
  { "lotsencafe.de", true },
  { "loucanfixit.com", true },
  { "louiewatch.com", true },
  { "love-schna.jp", true },
  { "lovelifelovelive.com", true },
  { "lovemomiji.com", true },
  { "lover-bg.com", true },
  { "loveto.at", true },
  { "lovingearth.net", true },
  { "lowmagnitude.com", true },
  { "lowsidetna.com", true },
  { "lpak.nl", true },
  { "lpbk-bethel.de", true },
  { "lpm-uk.com", true },
  { "lrhstsa.com", true },
  { "ls-a.org", true },
  { "ltn-tom-morel.fr", true },
  { "lucaterzini.com", true },
  { "luchscheider.de", true },
  { "lucidframeworks.com", true },
  { "lucielavickova.com", true },
  { "ludwig.im", true },
  { "luehne.de", true },
  { "luelistan.net", true },
  { "lufthansaexperts.com", true },
  { "lugbb.org", true },
  { "luis-checa.com", true },
  { "lukas.im", true },
  { "lukasberan.cz", true },
  { "lukasunger.cz", true },
  { "lukasunger.net", true },
  { "lukasztkacz.com", true },
  { "luke.ch", true },
  { "lukeng.me", true },
  { "lukeng.net", true },
  { "lumiere.com", true },
  { "lunakit.org", true },
  { "lunarift.com", true },
  { "lunarshark.com", true },
  { "luneta.nearbuysystems.com", false },
  { "lungdoc.us", true },
  { "lunix.io", true },
  { "luno.io", true },
  { "luom.net", true },
  { "luoxiao.im", true },
  { "lustrum.ch", true },
  { "lustrumxi.nl", true },
  { "luther.fi", true },
  { "luukklene.nl", true },
  { "luxwatch.com", true },
  { "lv0.it", true },
  { "lvrsystems.com", true },
  { "lwl.moe", true },
  { "lymia.moe", true },
  { "lynero.dk", true },
  { "lyness.io", true },
  { "lynkos.com", true },
  { "lynthium.com", true },
  { "lyst.co.uk", true },
  { "lyx.dk", true },
  { "lzzr.me", true },
  { "m-edmondson.co.uk", true },
  { "m.facebook.com", false },
  { "m.mail.ru", true },
  { "m.nu", true },
  { "m0wef.uk", true },
  { "ma2t.com", true },
  { "maarten.nyc", true },
  { "maartenvandekamp.nl", true },
  { "mac-torrents.me", true },
  { "macaque.io", true },
  { "macgeneral.de", true },
  { "mach-politik.ch", true },
  { "machbach.com", true },
  { "machon.biz", false },
  { "macker.io", true },
  { "maclemon.at", true },
  { "macleod.io", true },
  { "macnemo.de", true },
  { "maco.org.uk", true },
  { "madars.org", true },
  { "maddi.biz", true },
  { "madebymagnitude.com", true },
  { "madebyshore.com", true },
  { "madeitwor.se", true },
  { "madin.ru", true },
  { "madnetwork.org", true },
  { "madrants.net", true },
  { "madreacqua.org", true },
  { "madtec.de", true },
  { "maelstrom.ninja", true },
  { "mafamane.com", true },
  { "maff.scot", false },
  { "mafiasi.de", true },
  { "magneticanvil.com", true },
  { "mahamed91.pw", true },
  { "mahefa.co.uk", true },
  { "mahrer.net", true },
  { "mail-settings.google.com", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.yahoo.com", false },
  { "mail4you.in", true },
  { "mailbox.org", true },
  { "mailchuck.com", true },
  { "maildragon.com", true },
  { "mailer-dot.de", true },
  { "mailfence.com", true },
  { "mailgarant.nl", true },
  { "mailhost.it", true },
  { "mailinabox.email", true },
  { "mailmag.net", true },
  { "mainlined.org", true },
  { "mainlywrenches.co", true },
  { "majesnix.org", true },
  { "make-pizza.info", true },
  { "makeitdynamic.com", true },
  { "makeyourlaws.org", true },
  { "makowitz.cz", true },
  { "maktoob.search.yahoo.com", false },
  { "malash.me", true },
  { "malaysia.search.yahoo.com", false },
  { "malfait.nl", true },
  { "malinator.net", true },
  { "mall.cz", true },
  { "mall.hr", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "malnex.de", true },
  { "malware.watch", true },
  { "malwaretips.com", true },
  { "malwre.io", true },
  { "mamaison.io", true },
  { "mamaxi.org", true },
  { "mammaw.com", true },
  { "mammothmail.com", true },
  { "mammothmail.net", true },
  { "mammothmail.org", true },
  { "man3s.jp", true },
  { "manaboutahor.se", true },
  { "manage.cm", true },
  { "manage.zenpayroll.com", false },
  { "management-companie.ro", true },
  { "management-ethics.com", true },
  { "managemynetsuite.com", true },
  { "manageprojects.com", true },
  { "manager.linode.com", false },
  { "managewp.org", true },
  { "mandala-ausmalbilder.de", true },
  { "manfredimatteo.com", true },
  { "manhattanchoralensemble.org", true },
  { "manicode.com", true },
  { "manningbrothers.com", true },
  { "manoirdecontres.com", true },
  { "manowarus.com", true },
  { "mantor.org", false },
  { "manueli.de", true },
  { "maosensanguentadasdejesus.net", true },
  { "maowtm.org", true },
  { "marbogardenlidkoping.se", true },
  { "marcel-preuss.de", true },
  { "marcelpreuss.de", true },
  { "marcoececilia.it", true },
  { "marcofinke.de", true },
  { "marcohager.de", true },
  { "marcontrol.com", true },
  { "marcoslater.com", true },
  { "mareklecian.cz", true },
  { "mariaolesen.dk", true },
  { "marie-curie.fr", true },
  { "marie-elisabeth.dk", true },
  { "marie.club", true },
  { "marikafranke.de", true },
  { "marilsnijders.nl", true },
  { "marinelausa.com", true },
  { "mark-a-hydrant.com", true },
  { "mark-semmler.de", true },
  { "markaconnor.com", true },
  { "markayapilandirma.com", true },
  { "market.android.com", true },
  { "marketingdesignu.cz", true },
  { "markhaehnel.de", false },
  { "markido.com", true },
  { "markprof.ru", true },
  { "markrego.com", true },
  { "markri.nl", true },
  { "markt-heiligenstadt.de", true },
  { "marktboten.de", true },
  { "marktcontact.com", true },
  { "markusehrlicher.de", true },
  { "markusueberallassetmanagement.de", true },
  { "marlen.cz", true },
  { "marquiseclub.se", true },
  { "marsble.com", true },
  { "marshut.net", true },
  { "martelange.ovh", true },
  { "martensmxservice.nl", true },
  { "martialc.be", true },
  { "martiert.com", true },
  { "martijnvhoof.nl", true },
  { "martin-smith.info", true },
  { "martineve.com", true },
  { "martinkup.cz", true },
  { "martinkus.eu", true },
  { "martinp.no", true },
  { "marumagic.com", true },
  { "masa-yoga.com", true },
  { "mascosolutions.com", true },
  { "masjidtawheed.net", true },
  { "massdrop.com", true },
  { "masse.org", true },
  { "massivum.de", false },
  { "masterhaus.bg", true },
  { "masters.black", true },
  { "matatall.com", false },
  { "matchneedle.com", true },
  { "maternalsafety.org", true },
  { "mathembedded.com", true },
  { "mathhire.org", true },
  { "mathiasbynens.be", true },
  { "mathiasgarbe.de", true },
  { "matrip.de", true },
  { "matrix.ac", true },
  { "matspar.com", true },
  { "matspar.se", true },
  { "matt.tf", true },
  { "mattandreko.com", true },
  { "mattandyana.com", true },
  { "mattberryman.com", false },
  { "matteomarescotti.it", true },
  { "mattfin.ch", true },
  { "matthewohare.com", true },
  { "matthiasadler.info", true },
  { "matthiasschwab.de", true },
  { "mattia98.org", true },
  { "mattmccutchen.net", true },
  { "mattsvensson.com", true },
  { "mattwb65.com", true },
  { "maultrom.ml", true },
  { "mauriciog.com.ar", true },
  { "mauricioghiorzi.com.ar", true },
  { "mausi.co", true },
  { "mavenclinic.com", true },
  { "mavensecurity.com", true },
  { "maveris.com", true },
  { "mavisang.cf", true },
  { "mawe.red", true },
  { "max-moeglich.de", true },
  { "max.gov", true },
  { "maxbytes.nl", true },
  { "maxima.at", true },
  { "maximeferon.fr", true },
  { "maximelouet.me", true },
  { "maximilian-greger.com", true },
  { "maximiliankrieg.de", true },
  { "maxr1998.de", true },
  { "maxserver.com", true },
  { "maxtruxa.com", true },
  { "maxwell-english.co.jp", false },
  { "mazz-tech.com", true },
  { "mbaestlein.de", true },
  { "mbasic.facebook.com", false },
  { "mbilker.us", true },
  { "mbinf.de", true },
  { "mbinformatik.de", true },
  { "mblankhorst.nl", true },
  { "mbp.banking.co.at", false },
  { "mbweir.com", true },
  { "mc-venture.net", false },
  { "mc81.com", true },
  { "mca2017.org", true },
  { "mcard.vn", true },
  { "mcatnnlo.org", true },
  { "mcdonaldwhsl.com", true },
  { "mce.eu", true },
  { "mce.nyc", true },
  { "mce55.eu", true },
  { "mceconferencecentre.eu", true },
  { "mcgarderen.nl", true },
  { "mchristopher.com", true },
  { "mcl.gg", true },
  { "mclab.su", false },
  { "mcnext.net", true },
  { "mcooperlaw.com", true },
  { "mcrn.jp", true },
  { "mctherealm.net", true },
  { "md5file.com", true },
  { "mdek.at", true },
  { "mdewendt.de", true },
  { "mdkr.nl", true },
  { "mdpraha.cz", true },
  { "mdwftw.com", true },
  { "me.net.nz", true },
  { "mea.in.ua", true },
  { "meadowviewfarms.org", true },
  { "mealgoo.com", true },
  { "meamod.com", true },
  { "meap.xyz", true },
  { "mebio.us", false },
  { "mechanus.io", true },
  { "medallia.io", true },
  { "medba.se", true },
  { "meddelare.com", true },
  { "medexpress.co.uk", true },
  { "media-courses.com", true },
  { "mediaburst.co.uk", true },
  { "mediacru.sh", true },
  { "mediaselection.eu", true },
  { "mediastorm.us", true },
  { "mediawiki.org", true },
  { "mediawikicn.org", true },
  { "medirich.co", true },
  { "meditek-dv.ru", true },
  { "medium.com", true },
  { "medm-test.com", true },
  { "medo64.com", true },
  { "medovea.ru", true },
  { "medtehnika.ua", true },
  { "medusa.wtf", true },
  { "meedoenzaanstad.nl", true },
  { "meetbot.fedoraproject.org", true },
  { "meetfinch.com", true },
  { "meetingmanage.nl", true },
  { "meetingmanager.ovh", true },
  { "meetscompany.jp", true },
  { "mega.co.nz", true },
  { "mega.nz", true },
  { "megakiste.de", true },
  { "megaplan.cz", true },
  { "megaplan.ru", true },
  { "megasslstore.com", true },
  { "meghudson.com", true },
  { "mehmetince.net", true },
  { "mehrwert.de", true },
  { "meifrench.com", true },
  { "meillard-auto-ecole.ch", true },
  { "mein-gesundheitsmanager.com", true },
  { "mein-webportal.de", true },
  { "meine-email-im.net", true },
  { "meinebo.it", true },
  { "meizufans.eu", true },
  { "melcher.it", true },
  { "melearning.university", true },
  { "melf.nl", true },
  { "melissaadkins.com", true },
  { "melitopol.co.ua", true },
  { "melnikov.ch", true },
  { "melody-lyrics.com", true },
  { "melted.pw", true },
  { "melvinlow.com", true },
  { "memberpress.com", true },
  { "members.nearlyfreespeech.net", false },
  { "memo-linux.com", true },
  { "mensagemdaluz.com", true },
  { "mentax.net", false },
  { "menthix.net", true },
  { "menudrivetest.com", true },
  { "menuonlineordering.com", true },
  { "meozcraft.com", false },
  { "mercamaris.es", true },
  { "merccorp.de", true },
  { "mercuryamericas.com", true },
  { "mercurystorm.co.za", true },
  { "mereckas.com", true },
  { "meritz.rocks", true },
  { "merkel.me", true },
  { "merson.me", true },
  { "mertcangokgoz.com", true },
  { "mesmoque.com", true },
  { "mesvt.com", true },
  { "meta-db.com", true },
  { "meta.sc", true },
  { "metaether.net", true },
  { "metapeen.nl", true },
  { "metebalci.com", true },
  { "meteorapp.space", true },
  { "meteosky.net", true },
  { "metin2blog.de", true },
  { "metrobriefs.com", true },
  { "metzgerei-birkenhof.de", true },
  { "meuemail.pro", true },
  { "mevs.cz", true },
  { "mexicansbook.ru", false },
  { "meyeraviation.com", true },
  { "mfcatalin.com", false },
  { "mfiles.pl", true },
  { "mghiorzi.com.ar", true },
  { "mh-bloemen.co.jp", true },
  { "mhdsyarif.com", true },
  { "mheistermann.de", true },
  { "mhertel.com", false },
  { "mhict.nl", true },
  { "mhx.pw", true },
  { "miasarafina.de", true },
  { "michaelcullen.name", true },
  { "michaelleibundgut.com", true },
  { "michaeltroger.com", true },
  { "michal-kral.cz", true },
  { "michalborka.cz", true },
  { "michalspacek.cz", true },
  { "michasfahrschule.com", true },
  { "michel-wein.de", true },
  { "miconcinemas.com", true },
  { "miconware.de", true },
  { "microdots.de", true },
  { "microme.ga", true },
  { "micropple.net", true },
  { "microvb.com", true },
  { "midair.io", true },
  { "midirs.org", true },
  { "midlgx.com", true },
  { "midonet.org", true },
  { "midwestwomenworkers.org", true },
  { "mig5.net", true },
  { "mightysounds.cz", true },
  { "mijailovic.net", true },
  { "mijcorijneveld.nl", true },
  { "mijn-email.org", true },
  { "mijnkredietpaspoort.nl", true },
  { "mijnreisoverzicht.nl", true },
  { "mijntransacties.nl", true },
  { "mikadesign.se", false },
  { "mikadoe.nl", true },
  { "mikaela.info", true },
  { "mikaelemilsson.net", true },
  { "mike-bland.com", true },
  { "mikeburns.com", true },
  { "mikeg.de", true },
  { "mikepair.net", true },
  { "miketabor.com", true },
  { "mikewest.org", true },
  { "mikewillia.ms", true },
  { "mikeybot.com", true },
  { "miku.be", true },
  { "mil0.com", true },
  { "milahendri.com", false },
  { "milanpala.cz", true },
  { "milatrans.pl", true },
  { "millenniumweb.com", true },
  { "millistream.com", true },
  { "mim.properties", true },
  { "mimeit.de", true },
  { "mimovrste.com", true },
  { "mind-moves.es", true },
  { "mindbodycontinuum.com", true },
  { "mindcoding.ro", true },
  { "minecraft-forum.cf", true },
  { "minecraft-forum.ga", true },
  { "minecraft-forum.gq", true },
  { "minecraft-forum.ml", true },
  { "minecraft-forums.cf", true },
  { "minecraft-forums.ga", true },
  { "minecraft-forums.gq", true },
  { "minecraftforum.de", true },
  { "minecraftforum.ovh", true },
  { "minecraftforums.cf", true },
  { "minecraftforums.gq", true },
  { "minecraftforums.ml", true },
  { "minecraftvoter.com", true },
  { "mineover.es", true },
  { "minez-nightswatch.com", false },
  { "minikneet.com", true },
  { "miniskipper.at", true },
  { "minkondom.nu", true },
  { "minnesotadata.com", true },
  { "minobar.com", true },
  { "minora.io", true },
  { "minpingvin.dk", true },
  { "mintea-noua.ro", true },
  { "mintrak2.com", true },
  { "mipiaci.co.nz", true },
  { "mipiaci.com.au", true },
  { "mireservaonline.es", true },
  { "mirodasilva.be", true },
  { "mironet.cz", true },
  { "mirtes.cz", true },
  { "misakiya.co.jp", true },
  { "miskatonic.org", true },
  { "miss-inventory.co.uk", true },
  { "missdream.org", true },
  { "misskey.xyz", true },
  { "missrain.tw", true },
  { "mistacms.com", true },
  { "mister.hosting", true },
  { "misterl.net", true },
  { "mitchellrenouf.ca", true },
  { "mitell.jp", false },
  { "mitnetz-gas.de", true },
  { "mitnetz-strom.de", true },
  { "mittelunsachlich.de", true },
  { "mittenhacks.com", true },
  { "mitzpettel.com", true },
  { "mixposure.com", true },
  { "miyoshi-kikaku.com", true },
  { "mizd.at", true },
  { "mjanja.ch", true },
  { "mjcaffarattilaw.com", true },
  { "mjec.net", true },
  { "mkcert.org", true },
  { "mkes.com", false },
  { "mkp-deutschland.de", true },
  { "mktemp.org", true },
  { "mkw.st", true },
  { "mlemay.com", true },
  { "mlp.ee", true },
  { "mlpepilepsy.org", true },
  { "mm13.at", true },
  { "mma-acareporting.com", true },
  { "mmgazhomeloans.com", true },
  { "mmmm.com", true },
  { "mmonit.com", true },
  { "mmucha.de", true },
  { "mnd.sc", true },
  { "mnetworkingsolutions.co.uk", true },
  { "mnium.de", true },
  { "mnsure.org", true },
  { "mobal.com", true },
  { "mobidea.com", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobile.eti.br", true },
  { "mobile.united.com", false },
  { "mobile.usaa.com", false },
  { "mobilemedics.com", true },
  { "mobiletraff.co", true },
  { "mobility-events.ch", true },
  { "mobilpass.no", true },
  { "mobilux.lv", true },
  { "mobobe.com", true },
  { "mocloud.eu", true },
  { "modeldimension.com", true },
  { "modifiedmind.com", true },
  { "modmountain.com", true },
  { "modydev.club", true },
  { "moebel-nagel.de", true },
  { "moegirl.org", true },
  { "moen.io", true },
  { "mogry.net", true },
  { "mojaknjiznica.com", false },
  { "mojapraca.sk", true },
  { "mokhtarmial.com", true },
  { "mokote.com", true },
  { "mommel.com", true },
  { "mommelonline.de", true },
  { "mona.lu", true },
  { "monasterialis.eu", true },
  { "mondar.io", true },
  { "mondopoint.com", true },
  { "mondwandler.de", true },
  { "moneromerchant.com", true },
  { "moneygo.se", true },
  { "moniquedekermadec.com", true },
  { "monitman.solutions", true },
  { "monitzer.com", true },
  { "monix.io", true },
  { "monkeydust.net", true },
  { "monnyonle.hu", true },
  { "monobank.no", true },
  { "montanacures.org", true },
  { "montenero.pl", true },
  { "moo.la", true },
  { "moonagic.com", true },
  { "moonloupe.com", true },
  { "moonraptor.com", true },
  { "moonvpn.org", true },
  { "moov.is", true },
  { "moparcraft.com", true },
  { "moparcraft.net", true },
  { "moparcraft.org", true },
  { "moparisthebest.biz", true },
  { "moparisthebest.com", true },
  { "moparisthebest.info", true },
  { "moparisthebest.net", true },
  { "moparisthebest.org", true },
  { "moparscape.org", true },
  { "morbatex.com", true },
  { "morbitzer.de", true },
  { "moreapp.co.uk", true },
  { "morenci.ch", true },
  { "morethanadream.lv", true },
  { "morganino.eu", true },
  { "morganino.it", true },
  { "moriz.de", true },
  { "morningcalculation.com", true },
  { "mornings.com", true },
  { "morteruelo.net", true },
  { "mosstier.com", true },
  { "mostwuat.com", true },
  { "motd.ch", true },
  { "motherbase.io", true },
  { "mothereff.in", true },
  { "motionfreight.com", true },
  { "motionpicturesolutions.com", true },
  { "motocyklovedily.cz", true },
  { "motoryz.nl", true },
  { "mountainadventureseminars.com", true },
  { "mountainmusicpromotions.com", true },
  { "mountainroseherbs.com", true },
  { "moveek.com", true },
  { "movember.com", true },
  { "moviedollars.com", true },
  { "moviesabout.net", true },
  { "movinglogistics.nl", true },
  { "movlib.org", true },
  { "moy-gorod.od.ua", true },
  { "mozoa.net", true },
  { "mp3gratuiti.com", true },
  { "mp3juices.is", true },
  { "mpac.ca", true },
  { "mpc-hc.org", true },
  { "mpcompliance.com", true },
  { "mpetroff.net", true },
  { "mpintaamalabanna.it", true },
  { "mplant.io", true },
  { "mplusm.eu", true },
  { "mpreserver.com", true },
  { "mpserver12.org", true },
  { "mpsgarage.com.au", true },
  { "mqas.net", true },
  { "mr-hosting.com", true },
  { "mremallin.ca", true },
  { "mrettich.org", true },
  { "mrnonz.com", true },
  { "mrs-shop.com", true },
  { "msa-aesch.ch", true },
  { "msebera.cz", true },
  { "msiegmund.com", true },
  { "msmails.de", true },
  { "msno.no", true },
  { "mt.me.uk", true },
  { "mtamaki.com", true },
  { "mtasa.com", true },
  { "mtau.com", true },
  { "mtg-tutor.de", true },
  { "mthode.org", true },
  { "mths.be", true },
  { "mtn.cc", true },
  { "mtnz.co.za", true },
  { "mtouch.facebook.com", false },
  { "muabannhanh.com", false },
  { "mudcrab.us", true },
  { "muguayuan.com", true },
  { "mujadin.se", false },
  { "multigamecard.com", true },
  { "multigeist.de", true },
  { "multitheftauto.com", true },
  { "mumei.space", true },
  { "munich-rage.de", true },
  { "munki.org", true },
  { "munuc.org", true },
  { "murfy.nz", true },
  { "muriburi.land", true },
  { "murodese.org", true },
  { "murraycoin.org", true },
  { "murrayrun.com", true },
  { "muscleangels.com", true },
  { "mushikabu.net", true },
  { "musi.cx", true },
  { "musicgamegalaxy.de", true },
  { "musicwear.cz", true },
  { "musikkfondene.no", true },
  { "musmann.io", true },
  { "musthavesforreal.com", true },
  { "mutamatic.com", true },
  { "mutantmonkey.in", true },
  { "mutantmonkey.info", true },
  { "mutantmonkey.sexy", true },
  { "mutuelle.fr", true },
  { "muzykaprzeszladoplay.pl", true },
  { "mvanmarketing.nl", true },
  { "mvixturismo.com.br", true },
  { "mvno.io", true },
  { "mvsecurity.nl", true },
  { "mwavuli.co.ke", true },
  { "mwe.st", true },
  { "mx.org.ua", false },
  { "mx.search.yahoo.com", false },
  { "my-owncloud.com", true },
  { "my-pawnshop.com.ua", true },
  { "my.onlime.ch", false },
  { "my.swedbank.se", true },
  { "my.usa.gov", false },
  { "my.xero.com", false },
  { "myaccount.google.com", true },
  { "myairshop.gr", true },
  { "mybeautyjobs.de", true },
  { "mybon.at", true },
  { "mybudget.xyz", true },
  { "mycieokien.info", true },
  { "myclientsplus.com", true },
  { "mycollab.net", true },
  { "myconan.net", true },
  { "mydeos.com", false },
  { "mydnaresults.com", true },
  { "mydocserve.com", true },
  { "myg21.com", true },
  { "mygadgetguardian.lookout.com", false },
  { "mygreatjobs.de", true },
  { "mygretchen.de", true },
  { "myhostname.net", true },
  { "myiocc.org", true },
  { "myip.tech", true },
  { "mykontool.de", true },
  { "mylookout.com", false },
  { "myni.io", true },
  { "mynigma.org", true },
  { "myonline.hu", true },
  { "myownconference.com", true },
  { "myownconference.com.ua", true },
  { "myownconference.de", true },
  { "myownconference.es", true },
  { "myownconference.fr", true },
  { "myownconference.lt", true },
  { "myownconference.lv", true },
  { "myownconference.pl", true },
  { "myownconference.ru", true },
  { "mypagella.com", true },
  { "mypagella.eu", true },
  { "mypagella.it", true },
  { "myprintcard.de", true },
  { "myraytech.net", false },
  { "myruststats.com", true },
  { "mysecretcase.com", true },
  { "mysecretrewards.com", true },
  { "myshirtsize.com", true },
  { "mysmelly.com", true },
  { "mysoundtalks.com", true },
  { "mysticplumes.com", true },
  { "mytc.fr", true },
  { "mythslegendscollection.com", true },
  { "mytripcar.co.uk", true },
  { "mytripcar.com", true },
  { "mytripcar.de", true },
  { "mytripcar.es", true },
  { "mytty.net", true },
  { "mytweeps.com", true },
  { "myvpl.com", true },
  { "myworkinfo.com", true },
  { "myworth.com.au", true },
  { "myzina.cz", false },
  { "myzone.com", true },
  { "mziulu.me", true },
  { "n-pix.com", false },
  { "n2x.in", false },
  { "n4l.pw", true },
  { "nabankco.com", true },
  { "nabru.co.uk", true },
  { "nabytko.cz", true },
  { "nachsendeauftrag.net", true },
  { "nachsenden.info", true },
  { "nagaya.biz", true },
  { "nagb.gov", true },
  { "nagb.org", true },
  { "nagelfam.com", true },
  { "nagoya-kyuyo.com", true },
  { "nakedalarmclock.me", true },
  { "nakliyatsirketi.biz", true },
  { "nako.no", true },
  { "nalao-company.com", true },
  { "nalifornia.com", true },
  { "namacindia.com", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "nametiles.co", true },
  { "naminam.de", true },
  { "namorico.me", false },
  { "nan.zone", true },
  { "nanderson.me", true },
  { "nanogeneinc.com", true },
  { "nanogi.ga", true },
  { "nansay.cn", true },
  { "narach.com", true },
  { "narfation.org", true },
  { "nargileh.nl", true },
  { "naro.se", true },
  { "narodniki.com", true },
  { "narthollis.net", true },
  { "nartuk.com.ua", false },
  { "natalia.io", true },
  { "natalt.org", true },
  { "natanaelys.com", true },
  { "natenom.name", true },
  { "nathancheek.com", true },
  { "nathanmfarrugia.com", true },
  { "nathansmetana.com", true },
  { "nationalcentereg.org", true },
  { "nationalpriorities.org", true },
  { "natural-progesterone.net", true },
  { "naturesystems.cz", true },
  { "natuurbehangnederland.nl", true },
  { "naval.tf", true },
  { "navigate-it-services.de", true },
  { "navjobs.com", true },
  { "navstevnik.sk", true },
  { "navycs.com", true },
  { "nayahe.ru", true },
  { "nb.zone", true },
  { "nb6.de", true },
  { "nbg-ha.de", false },
  { "nbl.org.tw", true },
  { "nbp.com.pk", true },
  { "ncc60205.info", true },
  { "ncoding.at", true },
  { "ncpw.gov", true },
  { "ncrmnt.org", true },
  { "ncstep.org", true },
  { "ndarville.com", true },
  { "ndbt.com", true },
  { "nder.be", true },
  { "ne-on.org", true },
  { "ne1home.dyndns.org", true },
  { "neap.io", false },
  { "nearby.in.th", true },
  { "nebra.io", true },
  { "necesitodinero.org", true },
  { "nectarleaf.com", true },
  { "nedcdata.org", true },
  { "nedraconsult.ru", true },
  { "neel.ch", true },
  { "neftebitum-kngk.ru", true },
  { "neg9.org", false },
  { "negai.moe", true },
  { "negativecurvature.net", true },
  { "neilgreen.net", true },
  { "neilwynne.com", false },
  { "neko-life.com", true },
  { "neko.li", true },
  { "nekomimi.pl", false },
  { "nekosc.com", true },
  { "nella-project.org", true },
  { "nellacms.com", true },
  { "nellacms.org", true },
  { "nellafw.org", true },
  { "nemno.de", true },
  { "neo19.com", true },
  { "neosolution.ca", true },
  { "nerd42.de", true },
  { "nerdjokes.de", true },
  { "nerdydev.net", true },
  { "neris.io", true },
  { "nerull7.info", true },
  { "nestedquotes.ca", true },
  { "net-safe.info", true },
  { "netbank.com.au", true },
  { "netbox.cc", true },
  { "netbrief.ml", true },
  { "netbulls.io", true },
  { "netera.se", true },
  { "netfs.pl", false },
  { "netfxharmonics.com", false },
  { "nethackwiki.com", true },
  { "netherwind.eu", true },
  { "netlocal.ru", true },
  { "netmagik.com", true },
  { "netmazk.net", true },
  { "netprofile.com.au", true },
  { "netrelay.email", true },
  { "netrider.net.au", false },
  { "netsight.org", true },
  { "netsparker.com", false },
  { "netsystems.pro", true },
  { "nette.org", true },
  { "nettefoundation.com", true },
  { "nettools.link", true },
  { "nettopower.dk", true },
  { "netulo.com", true },
  { "netvizura.co.uk", true },
  { "netwarc.nl", true },
  { "netwerkmanager.nl", true },
  { "network-notes.com", true },
  { "network23.nl", true },
  { "networkalarmcorp.com", true },
  { "networking4all.com", true },
  { "networkingnexus.net", true },
  { "networkingphoenix.com", true },
  { "netzvieh.de", true },
  { "netzwerkwerk.de", true },
  { "neueonlinecasino2016.com", true },
  { "neuralgic.net", true },
  { "neuronasdigitales.com", true },
  { "neutralox.com", true },
  { "neuwal.com", true },
  { "nevadafiber.net", true },
  { "never-afk.de", true },
  { "new-black-order.com", true },
  { "newedivideo.it", true },
  { "newlooknow.com", true },
  { "newmediaone.net", true },
  { "newodesign.com", true },
  { "newportpropertygroup.com", true },
  { "newstarnootropics.com", true },
  { "newstone-tech.com", true },
  { "newsyslog.org", true },
  { "newtnote.com", true },
  { "nex.sx", true },
  { "nexlab.org", true },
  { "next176.sk", true },
  { "next24.io", true },
  { "nextend.net", true },
  { "nextgencel.com", true },
  { "nfo.so", true },
  { "ng-firewall.com", true },
  { "ng-security.com", true },
  { "nghe.net", true },
  { "nginxnudes.com", true },
  { "nichteinschalten.de", true },
  { "nichthelfer.de", true },
  { "nickloose.de", true },
  { "nickrickard.co.uk", true },
  { "nicky.io", true },
  { "nicoborghuis.nl", true },
  { "nicoknibbe.nl", true },
  { "nicolaeiotcu.ro", true },
  { "nicolaelmer.ch", true },
  { "nicolaw.uk", true },
  { "nidux.com", true },
  { "niduxcomercial.com", true },
  { "nierenpraxis-dr-merkel.de", true },
  { "nierenpraxis-merkel.de", true },
  { "nieselregen.com", false },
  { "niftiestsoftware.com", true },
  { "nightfirec.at", true },
  { "nightfirecat.com", true },
  { "nightwinds.tk", true },
  { "nijm.nl", true },
  { "nikao-tech.com", true },
  { "nikklassen.ca", true },
  { "niklaslindblad.se", true },
  { "nikobradshaw.com", true },
  { "nikolasbradshaw.com", true },
  { "nikolasgrottendieck.com", true },
  { "nikomo.fi", true },
  { "niloxy.com", true },
  { "nilrem.org", true },
  { "ninchat.com", true },
  { "nine-hells.net", false },
  { "ninespec.com", true },
  { "nippon-oku.com", true },
  { "nirada.info", true },
  { "nitho.me", true },
  { "nixien.fr", true },
  { "nkinka.de", true },
  { "nl-ix.net", true },
  { "nl.search.yahoo.com", false },
  { "nmctest.net", true },
  { "nmd.so", true },
  { "nmsnj.com", true },
  { "nnqc.nl", true },
  { "nnya.cat", true },
  { "no.search.yahoo.com", false },
  { "no17sifangjie.cc", true },
  { "nobly.de", true },
  { "nocit.dk", true },
  { "nocs.cn", true },
  { "nodari.com.ar", true },
  { "nodelia.com", true },
  { "nodespin.com", true },
  { "noedidacticos.com", true },
  { "noemax.com", true },
  { "noez.de", true },
  { "nohats.ca", true },
  { "nohup.se", true },
  { "noima.com", true },
  { "noisetrap.cz", true },
  { "nojestorget.se", true },
  { "nolatepayments.com", true },
  { "nolaviz.org", true },
  { "nolberg.net", true },
  { "nolte.work", false },
  { "nomadproject.io", true },
  { "nomesbiblicos.com", true },
  { "nomial.co.uk", true },
  { "nomorebytes.de", true },
  { "noname-ev.de", true },
  { "noob-box.net", false },
  { "noobunbox.net", true },
  { "noop.ch", true },
  { "noordsee.de", true },
  { "nopex.no", true },
  { "nopol.de", true },
  { "norandom.com", true },
  { "norb.at", true },
  { "nord-sud.be", true },
  { "norskpensjon.no", true },
  { "northcutt.com", true },
  { "northernmuscle.ca", true },
  { "nos-medias.fr", true },
  { "nos-oignons.net", true },
  { "nosecretshop.com", true },
  { "nossasenhoradodesterro.com.br", true },
  { "nostraforma.com", false },
  { "notadd.com", true },
  { "notalone.gov", true },
  { "notenoughtime.de", true },
  { "notificami.com", true },
  { "notjustbitchy.com", true },
  { "notoriousdev.com", true },
  { "nottheonion.net", true },
  { "nottres.com", true },
  { "notypiesni.sk", true },
  { "nouvelle-vague-saint-cast.fr", true },
  { "novacoast.com", true },
  { "novafreixo.pt", true },
  { "novelfeed.com", true },
  { "nowhere.dk", true },
  { "noxlogic.nl", true },
  { "npmcdn.com", true },
  { "npol.de", true },
  { "npw.net", true },
  { "nsboston.org", true },
  { "nsboutique.com", true },
  { "nshost.ro", true },
  { "nspeaks.com", true },
  { "nsweb.solutions", false },
  { "ntbs.pro", true },
  { "ntppool.org", true },
  { "nufla.de", true },
  { "nukenet.se", true },
  { "null-sec.ru", true },
  { "null.cat", true },
  { "null.tips", true },
  { "number.me", true },
  { "numberoneshoes.co.nz", true },
  { "nuos.org", true },
  { "nurserybook.co", true },
  { "nusatrip-api.com", true },
  { "nutleyeducationalfoundation.org", true },
  { "nutleyef.org", true },
  { "nutrienti.eu", true },
  { "nutritionculture.com", true },
  { "nuttyveg.com", true },
  { "nuvini.com", true },
  { "nuxer.fr", true },
  { "nvlop.xyz", true },
  { "nwa.xyz", true },
  { "nwgh.org", true },
  { "nwra.com", true },
  { "nwwc.dk", true },
  { "nyan.it", true },
  { "nyantec.com", true },
  { "nyffo.com", false },
  { "nyiad.edu", true },
  { "nyip.co.uk", true },
  { "nyip.edu", true },
  { "nymphetomania.net", true },
  { "nyronet.de", false },
  { "nyyu.tk", true },
  { "nzbs.io", false },
  { "o0o.one", true },
  { "o6asan.com", true },
  { "oaic.gov.au", true },
  { "oakslighting.co.uk", true },
  { "oasis.mobi", true },
  { "oasisim.net", true },
  { "obdolbacca.ru", true },
  { "obermeiers.eu", true },
  { "obscuredfiles.com", false },
  { "obsidianirc.net", true },
  { "obsydian.org", false },
  { "occentus.net", true },
  { "ochaken.cf", true },
  { "ochsundjunior.ch", true },
  { "ocotg.com", true },
  { "ocrami.us", true },
  { "octanio.com", true },
  { "octav.name", true },
  { "octocat.ninja", true },
  { "octothorpe.club", true },
  { "oddtime.net", true },
  { "ofcourselanguages.com", true },
  { "offshoot.rentals", true },
  { "offshore-firma.org", true },
  { "oftn.org", true },
  { "oguya.ch", true },
  { "ohiohealthfortune100.com", true },
  { "ohling.org", true },
  { "ohnemusik.com", true },
  { "ohsocool.org", true },
  { "oiepoie.nl", true },
  { "okane.love", true },
  { "oke.com.tw", true },
  { "okhrana.agency", true },
  { "okmx.de", true },
  { "okok-rent.com", true },
  { "okok.rent", true },
  { "okonetwork.org.uk", true },
  { "okutama.in.th", true },
  { "olafnorge.de", false },
  { "olcso-vps-szerver.hu", true },
  { "oliver-pietsch.de", true },
  { "olivierlemoal.fr", true },
  { "ollehbizev.co.kr", true },
  { "ollie.io", true },
  { "ollies.cloud", true },
  { "olliespage.net", true },
  { "ollning.com", true },
  { "olmari.fi", true },
  { "ols.io", true },
  { "omacostudio.com", true },
  { "omgaanmetidealen.com", true },
  { "omifind.com", true },
  { "omitech.co.uk", true },
  { "omniasl.com", true },
  { "omskit.ru", true },
  { "onaboat.se", true },
  { "ondrej.org", true },
  { "one---line.com", true },
  { "onedot.nl", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onefour.ga", true },
  { "onehourloan.sg", true },
  { "oneminute.io", true },
  { "onespiritinc.com", true },
  { "onet.space", true },
  { "oneway.ga", true },
  { "oneweb.hu", true },
  { "onewebdev.info", true },
  { "oneworldbank.com", true },
  { "onguardonline.gov", true },
  { "oniichan.us", true },
  { "onixcco.com.br", true },
  { "online-bouwmaterialen.nl", true },
  { "online-wetten.de", true },
  { "online.swedbank.se", true },
  { "onlinecensorship.org", true },
  { "onlinecompliance.org", true },
  { "onlinedemo.hu", true },
  { "onlinedeposit.us", true },
  { "onlinelegalmarketing.com", true },
  { "onlinelegalmedia.com", true },
  { "onlinelighting.com.au", true },
  { "onlinespielothek.com", true },
  { "onlinetravelmoney.co.uk", true },
  { "onlinewetten.de", true },
  { "only-roses.com", true },
  { "onlyshopstation.com", true },
  { "onmaps.de", true },
  { "onmarketbookbuilds.com", true },
  { "ono.es", true },
  { "onqproductions.com", true },
  { "onsitemassageco.com", true },
  { "onthebriteside.com", true },
  { "ontimestamp.com", true },
  { "ontras.com", true },
  { "onvori.com", true },
  { "onvori.de", true },
  { "onyxwall.link", true },
  { "onyxwall.net", true },
  { "ooonja.de", true },
  { "oopsmycase.com", true },
  { "oost.io", true },
  { "ooyo.be", true },
  { "open-bs.com", true },
  { "open-bs.ru", true },
  { "open-future.be", true },
  { "open-mesh.org", true },
  { "openacademies.com", true },
  { "openblox.org", true },
  { "openconnect.com.au", true },
  { "openkvk.nl", true },
  { "openmtbmap.org", true },
  { "opennippon.com", true },
  { "opennippon.ru", true },
  { "openpriv.pw", true },
  { "openstreetmap.is", true },
  { "opentrack.info", true },
  { "opentrash.org", true },
  { "openverse.com", true },
  { "openvz.org", true },
  { "openxmpp.com", true },
  { "opim.ca", true },
  { "opium.io", true },
  { "oplop.appspot.com", true },
  { "opperwall.net", true },
  { "opq.pw", true },
  { "oprbox.com", true },
  { "oprechtgezegd.nl", true },
  { "opsbears.com", true },
  { "opsmate.com", false },
  { "optimus.io", true },
  { "optmos.at", true },
  { "optometriepunt.nl", true },
  { "optumrxhealthstore.com", true },
  { "opus-codium.fr", true },
  { "oracaodocredo.com.br", true },
  { "orangutan-appeal.org.uk", true },
  { "orbiosales.com", true },
  { "orbitcom.de", true },
  { "orbograph-hrcm.com", true },
  { "orcahq.com", true },
  { "orcamoney.com", true },
  { "ordereat.fr", true },
  { "orderswift.com", true },
  { "orf-digitalsatkarte.at", true },
  { "orf-kartentausch.at", true },
  { "organic-superfood.net", true },
  { "oricejoc.com", true },
  { "orientalart.nl", true },
  { "orioncustompcs.com", false },
  { "orionfcu.com", true },
  { "orlives.de", true },
  { "oroweatorganic.com", true },
  { "osaiyuwu.com", true },
  { "oscarvk.ch", true },
  { "oscsdp.cz", true },
  { "oshayr.com", true },
  { "osm.is", true },
  { "osmosis.org", true },
  { "osquery.io", true },
  { "ossbinaries.com", true },
  { "osteammate.com", true },
  { "ostendorf.com", true },
  { "osterkraenzchen.de", true },
  { "osticketawesome.com", true },
  { "oszri.hu", true },
  { "otakurepublic.com", true },
  { "otchecker.com", true },
  { "otoy.com", true },
  { "otpsmart.com.ua", true },
  { "otrsdemo.hu", true },
  { "ottoproject.io", true },
  { "ourcloud.at", true },
  { "ourevents.net", true },
  { "outdoorproducts.com", true },
  { "outetc.com", true },
  { "outsider.im", true },
  { "overclockers.ge", true },
  { "overkillshop.com", true },
  { "override.io", true },
  { "overseamusic.de", true },
  { "oversight.garden", true },
  { "oversight.io", true },
  { "ovpn.to", true },
  { "ovvy.net", true },
  { "owensmith.website", true },
  { "own3d.ch", true },
  { "owncloud.help", true },
  { "ownit.se", false },
  { "ownmovies.fr", true },
  { "oxygaming.com", true },
  { "oxygenabsorbers.com", true },
  { "oxymc.com", true },
  { "oxynux.fr", true },
  { "oznamovacipovinnost.cz", true },
  { "ozvolvo.org", true },
  { "p-s-b.com", true },
  { "p.linode.com", false },
  { "p1c.pw", true },
  { "p3in.com", true },
  { "pace.car", true },
  { "pacelink.de", true },
  { "packagist.org", false },
  { "packer.io", true },
  { "packlane.com", true },
  { "pacoda.de", true },
  { "pactf.com", true },
  { "paestbin.com", true },
  { "pagerate.io", true },
  { "pagetoimage.com", true },
  { "pagewizz.com", true },
  { "paginapolitica.ro", true },
  { "pagure.io", true },
  { "pagure.org", true },
  { "pahae.de", true },
  { "painosso.org", true },
  { "pajonzeck.de", true },
  { "pajowu.de", true },
  { "pajuvuo.fi", true },
  { "pakke.de", true },
  { "pakremit.com", true },
  { "paku.me", true },
  { "palatin.at", true },
  { "palationtrade.com", true },
  { "palava.tv", true },
  { "pamplona.tv", true },
  { "pamsoft.pl", true },
  { "pan.digital", true },
  { "panaceallc.net", true },
  { "panamaequity.com", true },
  { "panamateakforestry.com", true },
  { "paneu.de", true },
  { "panmetro.com", true },
  { "panoti.com", true },
  { "panthur.com.au", false },
  { "pantou.org", false },
  { "pantsu.cat", true },
  { "pap.la", false },
  { "papayapythons.com", true },
  { "paperturn.com", true },
  { "paperwork.co.za", true },
  { "paradoxdesigns.org", true },
  { "paragon.com.sg", true },
  { "paragonie.com", true },
  { "paragreen.net", true },
  { "paranoxer.hu", true },
  { "parasitologyclub.org", true },
  { "paratlan.hu", true },
  { "parent5446.us", true },
  { "parentinterview.com", true },
  { "parentmail.co.uk", true },
  { "pariga.co.uk", true },
  { "parithy.net", true },
  { "parkingplus.co.il", true },
  { "parkingpoint.co.uk", true },
  { "parleu2016.nl", true },
  { "parsemail.org", true },
  { "particonpsplus.it", true },
  { "partirkyoto.jp", true },
  { "partnerbeam.com", true },
  { "partyhaus.ovh", true },
  { "partyvan.eu", true },
  { "partyvan.it", true },
  { "partyvan.moe", true },
  { "partyvan.nl", true },
  { "partyvan.se", true },
  { "passieposse.nl", true },
  { "passphrase.today", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passwd.io", true },
  { "password.codes", true },
  { "passwordrevelator.net", true },
  { "passwords.google.com", true },
  { "pasta-factory.co.il", true },
  { "pastaenprosecco.nl", true },
  { "pastaf.com", true },
  { "paste.linode.com", false },
  { "pastebin.linode.com", false },
  { "paster.li", true },
  { "pasteros.io", true },
  { "pastie.se", true },
  { "pataua.kiwi", true },
  { "patechmasters.com", true },
  { "paternitydnatest.com", true },
  { "patfs.com", true },
  { "patientinsight.net", true },
  { "patralos.at", true },
  { "patrickschneider.me", true },
  { "patriksimek.cz", true },
  { "patt.us", true },
  { "paul.reviews", true },
  { "paulbdelaat.nl", true },
  { "paulchen.at", true },
  { "paulinewesterman.nl", true },
  { "paulproell.at", true },
  { "paulschreiber.com", true },
  { "paulyang.cn", true },
  { "pauspam.net", true },
  { "paxwinkel.nl", false },
  { "pay.ubuntu.com", true },
  { "paylike.io", true },
  { "payment-network.com", true },
  { "paymentaccuracy.gov", true },
  { "payments-reference.org", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "payoff.com", true },
  { "paypal.com", false },
  { "paypaq.com", true },
  { "paypro.nl", false },
  { "payroll.ch", true },
  { "payroll.xero.com", false },
  { "paysera.com", true },
  { "payslipview.com", true },
  { "paytm.in", true },
  { "paytwopay.com", true },
  { "payupay.ru", true },
  { "pbapp.net", true },
  { "pbscreens.com", true },
  { "pccentral.nl", true },
  { "pcel.com", true },
  { "pcfeuerwehr.de", true },
  { "pcforum.sk", true },
  { "pchax.net", true },
  { "pclob.gov", true },
  { "pcloud.com", true },
  { "pctonic.net", true },
  { "pdamsidoarjo.co.id", true },
  { "pdf.yt", true },
  { "pe.search.yahoo.com", false },
  { "peaceandwool.com", true },
  { "peakapp.nl", true },
  { "pear2pear.de", true },
  { "pedicureduiven.nl", true },
  { "pedroventura.com", true },
  { "peercraft.com", true },
  { "peerherrmann.de", true },
  { "peername.com", true },
  { "peervpn.net", true },
  { "peifi.de", true },
  { "pekkapikkarainen.fi", true },
  { "pekkarik.ru", true },
  { "pekoe.se", true },
  { "pelanucto.cz", true },
  { "pencepay.com", true },
  { "penfold.fr", true },
  { "pengi.me", true },
  { "pennergold.net", true },
  { "pennyapp.io", true },
  { "pennylane.me.uk", true },
  { "pensiunealido.ro", true },
  { "pentagram.me", true },
  { "pentano.net", true },
  { "pentest.nl", true },
  { "pentesterlab.com", true },
  { "peoplesbankal.com", true },
  { "pepchid.com", false },
  { "pepperhead.com", true },
  { "pepperworldhotshop.de", true },
  { "per-pedes.at", true },
  { "perdel.cn", true },
  { "perfect.in.th", true },
  { "perfectionis.me", true },
  { "perfectseourl.com", true },
  { "perfektesgewicht.com", true },
  { "perfektesgewicht.de", true },
  { "performaterm.ro", true },
  { "performous.org", true },
  { "perishablepress.com", true },
  { "perot.me", true },
  { "perplex.nl", false },
  { "perspectivum.com", true },
  { "pestici.de", true },
  { "pet-nsk.ru", true },
  { "petabits.de", true },
  { "petchart.net", true },
  { "peter.org.ua", true },
  { "peterdavehello.org", true },
  { "petersmark.com", false },
  { "pethub.com", true },
  { "petja.me", false },
  { "petko.me", true },
  { "petplum.com", true },
  { "petplus.com", true },
  { "petpost.co.nz", true },
  { "petrachuk.ru", true },
  { "petravdbos.nl", true },
  { "petsittersservices.com", true },
  { "pettsy.com", true },
  { "pewboards.com", true },
  { "peytonfarrar.com", true },
  { "pfadfinder-aurich.de", true },
  { "pfarchimedes-pensioen123.nl", true },
  { "pfd-nz.com", true },
  { "pgmann.cf", true },
  { "pgmsource.com", true },
  { "pgpm.io", true },
  { "pgregg.com", true },
  { "pgtb.be", true },
  { "ph.search.yahoo.com", false },
  { "pharmaboard.de", true },
  { "pharmgkb.org", true },
  { "pharynks.com", true },
  { "phil.tw", true },
  { "philadelphia.com.mx", true },
  { "philadelphiadancefoundation.org", true },
  { "philipkohn.com", true },
  { "philipmordue.co.uk", true },
  { "phillmoore.com", true },
  { "phillprice.com", true },
  { "philosopherswool.com", true },
  { "philosophyguides.org", true },
  { "philphonic.de", true },
  { "phoebe.co.nz", true },
  { "phoenix.dj", true },
  { "phoenixlogan.com", true },
  { "phormance.com", true },
  { "photo.org.il", true },
  { "photoblogverona.com", true },
  { "php-tuning.de", true },
  { "phparcade.com", true },
  { "phpdistribution.com", true },
  { "phpdorset.co.uk", true },
  { "phperformances.fr", true },
  { "phpfashion.com", true },
  { "phpsecure.info", true },
  { "phryanjr.com", false },
  { "phryneas.de", true },
  { "phunehehe.net", true },
  { "phurl.de", true },
  { "pi-supply.com", true },
  { "picardiascr.com", true },
  { "pickme.nl", true },
  { "pickr.co", true },
  { "picksin.club", true },
  { "picoauto.com", true },
  { "piconepress.com", true },
  { "picotech.com", true },
  { "picsto.re", true },
  { "piekacz.co.uk", true },
  { "piekacz.eu.org", true },
  { "piekacz.net", true },
  { "pieperhome.de", true },
  { "pieq.eu", true },
  { "pieq.eu.org", true },
  { "pier28.com", true },
  { "pierre-denoblens.net", true },
  { "pierre-schmitz.com", true },
  { "pieterhordijk.com", true },
  { "pieterjangeeroms.me", true },
  { "pijuice.com", true },
  { "pileofgarbage.net", true },
  { "pilgermaske.org", true },
  { "piligrimname.com", true },
  { "piliszek.net", true },
  { "pimpmymac.ru", true },
  { "pincha.com.tw", true },
  { "pindanutjes.be", true },
  { "pinkcasino.co.uk", true },
  { "pinnaclelife.co.nz", true },
  { "pinnaclelife.nz", true },
  { "pipenny.net", true },
  { "pir9.com", true },
  { "pirateproxy.la", true },
  { "pirateproxy.pl", true },
  { "pirateproxy.pw", true },
  { "pirateproxy.sx", true },
  { "pirateproxy.tv", true },
  { "pirlitu.com", true },
  { "pirxpilot.me", true },
  { "pisexy.me", true },
  { "pisupp.ly", true },
  { "pitfire.io", false },
  { "pittonpreschool.com", true },
  { "piwko.co", true },
  { "pixel.facebook.com", false },
  { "pixel.google.com", true },
  { "pixelbash.de", true },
  { "pixelhero.co.uk", true },
  { "pixelminers.net", true },
  { "pixi.me", true },
  { "pixipics.com", true },
  { "piyabute.com", true },
  { "pjuu.com", false },
  { "pkgt.de", true },
  { "pl.search.yahoo.com", false },
  { "placefade.com", true },
  { "placehold.co", true },
  { "plaettliaktion.ch", true },
  { "plainjs.com", true },
  { "plaintech.net.au", true },
  { "plaintray.com", true },
  { "planboardapp.com", true },
  { "planet-work.com", true },
  { "planete-cocoon.com", true },
  { "planpharmacy.com", true },
  { "plasti-pac.ch", true },
  { "play.google.com", true },
  { "playkh.com", true },
  { "playmaker.io", true },
  { "please-deny.me", true },
  { "pleier-it.de", true },
  { "pleier.it", true },
  { "plexusmd.com", true },
  { "plfgr.eu.org", true },
  { "plhdb.org", true },
  { "pliosoft.com", true },
  { "plirt.ru", false },
  { "plixer.com", true },
  { "ploader.ru", true },
  { "plogable.co", true },
  { "ploxel.com", true },
  { "pluff.nl", true },
  { "pluga.co", true },
  { "plugin-planet.com", true },
  { "plumlocosoft.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", false },
  { "plzenskybarcamp.cz", true },
  { "pm13.cz", true },
  { "pm13.org", true },
  { "pmctire.com", true },
  { "pmg-offshore-company.com", true },
  { "pmg-purchase.com", true },
  { "pmg-purchase.net", true },
  { "pmnts.io", true },
  { "pmponline.de", true },
  { "pmt-documenten.nl", true },
  { "pnona.cz", true },
  { "po.gl", true },
  { "pocloud.homelinux.net", true },
  { "poed.com.au", true },
  { "poedgirl.com", true },
  { "pointaction.com", true },
  { "pointiswunderland.de", true },
  { "pointpro.de", true },
  { "pokemori.jp", true },
  { "pol.in.th", true },
  { "poleartschool.com", true },
  { "policeiwitness.sg", true },
  { "polimat.org", true },
  { "polis.or.at", true },
  { "polis.to", false },
  { "politic.org.ua", true },
  { "politically-incorrect.xyz", true },
  { "politiewervingshop.nl", true },
  { "politologos.org", true },
  { "pollpodium.nl", true },
  { "polymathematician.com", true },
  { "polynomapp.com", true },
  { "polypet.com.sg", true },
  { "polypho.nyc", true },
  { "pompompoes.com", true },
  { "pontualcomp.com", true },
  { "ponythread.com", true },
  { "poolvilla-margarita.net", false },
  { "poon.tech", true },
  { "port80.hamburg", true },
  { "portal.tirol.gv.at", true },
  { "portalplatform.net", true },
  { "portalzine.de", true },
  { "portosonline.pl", true },
  { "portraitsystem.biz", true },
  { "portvaletickets.com", true },
  { "poshpak.com", true },
  { "posobota.cz", true },
  { "post4me.at", true },
  { "postal.dk", true },
  { "postbox.life", true },
  { "postcodewise.co.uk", true },
  { "posteo.de", false },
  { "postfinance.ch", true },
  { "postn.eu", true },
  { "postpi.com", true },
  { "postscheduler.org", true },
  { "posttigo.com", true },
  { "posylka.de", true },
  { "potatofrom.space", true },
  { "potatoheads.net", true },
  { "potbar.com", true },
  { "potbox.com", true },
  { "pothe.com", true },
  { "pothe.de", true },
  { "potlytics.com", true },
  { "poussinooz.fr", true },
  { "povitria.net", true },
  { "power-of-interest.com", true },
  { "power99press.com", true },
  { "powercloud.technology", true },
  { "powerentertainment.tv", true },
  { "powergridess.com", true },
  { "powerplannerapp.com", true },
  { "powerwellness-korecki.de", true },
  { "powerxequality.com", true },
  { "ppipe.net", true },
  { "ppmoon.com", true },
  { "ppro.com", true },
  { "ppy3.com", true },
  { "pr1sm.com", true },
  { "pr2studio.com", true },
  { "practicallabs.com", true },
  { "prakharprasad.com", true },
  { "prayerrequest.com", true },
  { "prazynka.pl", true },
  { "precedecaritas.com.br", true },
  { "prediksisydney.com", true },
  { "predoiu.ro", true },
  { "prefis.com", true },
  { "prefontaine.name", true },
  { "prego-shop.de", true },
  { "preisser-it.de", true },
  { "preissler.co.uk", true },
  { "prekladysanca.cz", true },
  { "preloaded-hsts.badssl.com", true },
  { "premierheart.com", true },
  { "premiumzweirad.de", false },
  { "prepandgo-euro.com", true },
  { "preparetheword.com", true },
  { "prescotonline.co.uk", true },
  { "presidentials2016.com", true },
  { "press-anime-nenkan.com", true },
  { "pressrush.com", true },
  { "pretix.eu", true },
  { "pretty.hu", true },
  { "preworkout.me", true },
  { "prezola.com", true },
  { "pridetechdesign.com", true },
  { "pridoc.se", true },
  { "prilock.com", true },
  { "princessmargaretlotto.com", true },
  { "principaltoolbox.com", true },
  { "prior-it.be", true },
  { "priva.si", true },
  { "privacy.com", true },
  { "privacyinternational.org", true },
  { "privacyrup.net", true },
  { "privategiant.com", true },
  { "privatepokertour.com", true },
  { "privaterelay.com", true },
  { "privatestatic.com", true },
  { "privytime.com", true },
  { "prjktruby.com", true },
  { "prnt.li", true },
  { "pro-bike.ro", true },
  { "pro-link.eu", true },
  { "pro-zone.com", true },
  { "procensus.com", true },
  { "professionalboundaries.com", true },
  { "profidea.cz", true },
  { "profiles.google.com", true },
  { "profivps.com", true },
  { "profpay.com", true },
  { "profundr.com", true },
  { "progblog.net", true },
  { "progg.no", true },
  { "progreso.pl", true },
  { "progressiveplanning.com", true },
  { "prohostonline.fi", true },
  { "proitconsulting.com.au", true },
  { "projectarmy.net", true },
  { "projectascension.io", true },
  { "projectbenson.com", true },
  { "projectblackbook.us", true },
  { "projektzentrisch.de", true },
  { "promhadan.com", true },
  { "promoscuola.net", true },
  { "promotiongeeks.com", false },
  { "proofwiki.org", true },
  { "proos.nl", true },
  { "propagandism.org", true },
  { "propipesystem.com", true },
  { "prosocialmachines.com", true },
  { "prosoft.sk", true },
  { "prospo.co", true },
  { "protonmail.ch", true },
  { "protonmail.com", true },
  { "protoyou.de", true },
  { "proustmedia.de", true },
  { "prowhisky.de", true },
  { "proximato.com", true },
  { "proxybay.al", true },
  { "proxybay.co", true },
  { "proxybay.la", true },
  { "proxybay.top", true },
  { "proxyweb.us", true },
  { "prtpe.com", true },
  { "prvikvadrat.hr", true },
  { "prytkov.com", true },
  { "przemas.pl", true },
  { "psb1911.com", true },
  { "psicologia.co.ve", true },
  { "pste.pw", true },
  { "psw-group.de", true },
  { "psw.academy", true },
  { "psw.consulting", true },
  { "psw.net", true },
  { "psxtr.com", true },
  { "pt-server.de", true },
  { "ptbx.co", true },
  { "pterodactylus.cz", true },
  { "ptgoldensun.com", true },
  { "ptm.ro", true },
  { "ptn.moscow", true },
  { "ptsoft.de", true },
  { "puac.de", true },
  { "pubkey.is", true },
  { "publications.qld.gov.au", false },
  { "publicsuffix.org", true },
  { "pucssa.org", true },
  { "puddis.de", true },
  { "pugliese.fr", true },
  { "puiterwijk.org", true },
  { "pult.co", false },
  { "pumpgames.net", true },
  { "punknews.org", true },
  { "pupboss.com", true },
  { "purewebmasters.com", false },
  { "purplebricks.com", true },
  { "purplemoon.ch", true },
  { "purplestar.ch", true },
  { "purplestar.com", true },
  { "puryearlaw.com", true },
  { "puyblanc.info", true },
  { "pvcvoordeel.nl", false },
  { "pvtschlag.com", true },
  { "pwd.ovh", true },
  { "pwnies.dk", true },
  { "pxx.io", true },
  { "pygarage.com", true },
  { "pyol.org", true },
  { "pypa.io", true },
  { "pypi.python.org", true },
  { "pysays.net", true },
  { "python.org", false },
  { "q2.si", true },
  { "qa.fedoraproject.org", true },
  { "qa.stg.fedoraproject.org", true },
  { "qapital.com", true },
  { "qc.search.yahoo.com", false },
  { "qccareerschool.com", true },
  { "qcdesignschool.com", true },
  { "qceventplanning.com", true },
  { "qcmakeupacademy.com", true },
  { "qcstudentcenter.com", true },
  { "qcstyleacademy.com", true },
  { "qctravelschool.com", true },
  { "qetesh.de", true },
  { "qewc.com", true },
  { "qgustavor.tk", true },
  { "qikan.net", true },
  { "qiliang.wang", true },
  { "qingpat.com", true },
  { "qingpei.me", true },
  { "qionglu.pw", true },
  { "qixxit.de", true },
  { "qlrace.com", false },
  { "qonqa.de", true },
  { "qop.io", true },
  { "qorm.co.uk", true },
  { "qrlending.com", true },
  { "qtl.me", true },
  { "qtpower.co.uk", true },
  { "qtxh.net", true },
  { "quai10.org", true },
  { "qualityedgarsolutions.com", true },
  { "qualityhomesystems.com", true },
  { "qualityofcourse.com", true },
  { "qualityology.com", true },
  { "quantacloud.ch", true },
  { "quantenteranik.eu", true },
  { "quantoras.com", true },
  { "quantumfurball.net", true },
  { "quchao.com", true },
  { "quebecmailbox.com", true },
  { "queercinema.ch", true },
  { "queercoders.com", true },
  { "quera.ir", true },
  { "questsandrewards.com", true },
  { "quickpayservice.com", true },
  { "quietapple.org", true },
  { "quikpay.com.au", true },
  { "quintessa.org", true },
  { "quire.io", true },
  { "quli.nl", true },
  { "quotemaster.co.za", true },
  { "quotev.com", true },
  { "quppa.net", true },
  { "quuz.org", true },
  { "qvitoo.com", true },
  { "qwant.com", true },
  { "qwilink.me", true },
  { "r0t.co", true },
  { "r10n.com", true },
  { "r3s1stanc3.me", false },
  { "r40.us", true },
  { "r6-team.ru", true },
  { "r811.de", true },
  { "raah.co", true },
  { "raajheshkannaa.com", true },
  { "racasdecachorro.org", true },
  { "racermaster.xyz", false },
  { "racius.com", true },
  { "raconconsulting.co.uk", true },
  { "rad-route.de", true },
  { "radicaleducation.net", true },
  { "radiormi.com", false },
  { "radtke.bayern", true },
  { "radyn.com", true },
  { "rafaelcz.de", true },
  { "rage4.com", true },
  { "ragingserenity.com", true },
  { "raidstone.com", true },
  { "raidstone.net", true },
  { "raidstone.rocks", true },
  { "railgun.ac", true },
  { "railyardurgentcare.com", true },
  { "rainforest.engineering", true },
  { "raiseyourflag.com", true },
  { "raitza.de", true },
  { "ramatola.uk", true },
  { "rambitteh.ru", true },
  { "ramon-c.nl", true },
  { "ramsor-gaming.de", true },
  { "randc.org", true },
  { "randomcage.com", true },
  { "randstaddirect.nl", false },
  { "rangde.org", true },
  { "rantanda.com", true },
  { "rapenroer.nl", true },
  { "rapido.nu", true },
  { "rapidthunder.io", true },
  { "raspass.me", true },
  { "ratajczak.fr", true },
  { "ratd.net", true },
  { "ratuseks.net", true },
  { "ratuseks.us", true },
  { "raulfraile.net", true },
  { "rauros.net", true },
  { "rautermods.net", true },
  { "ravchat.com", true },
  { "ravindran.me", true },
  { "rawet.se", true },
  { "rawoil.com", true },
  { "rawsec.net", true },
  { "rawstorieslondon.com", true },
  { "raydan.space", true },
  { "raydobe.me", false },
  { "raymii.org", true },
  { "raymondjcox.com", true },
  { "razlaw.name", true },
  { "rbensch.com", true },
  { "rbhighinc.org", true },
  { "rburchell.com", true },
  { "rc4.io", true },
  { "rcafox.com", true },
  { "rcnitrotalk.com", true },
  { "rcorporation.be", true },
  { "rcpcbd.com", true },
  { "rdh.asia", true },
  { "rdns.im", true },
  { "reachr.com", true },
  { "reaconverter.com", true },
  { "reactivarte.es", true },
  { "reader.ga", true },
  { "readonly.de", true },
  { "readr.pw", true },
  { "real-it.nl", true },
  { "realcapoeira.ru", true },
  { "realgarant-shop.de", false },
  { "reallifeforums.com", true },
  { "realmic.net", true },
  { "realmofespionage.com", true },
  { "realmofespionage.xyz", true },
  { "realwaycome.com", true },
  { "reanimated.eu", true },
  { "reardenporn.com", true },
  { "recapp.ch", true },
  { "recht-freundlich.de", true },
  { "recommended.reviews", true },
  { "recon-networks.com", true },
  { "recyclingpromotions.us", true },
  { "red-t-shirt.ru", true },
  { "redar.xyz", true },
  { "redb.cz", true },
  { "redballoonsecurity.com", true },
  { "redbee.nl", true },
  { "redburn.com", true },
  { "redd.it", true },
  { "reddingsbrigade-zwolle.nl", true },
  { "reddit.com", true },
  { "reddit2kindle.com", true },
  { "rede-reim.de", true },
  { "rede.ca", true },
  { "redicabo.de", true },
  { "redigest.it", true },
  { "redirect.fedoraproject.org", true },
  { "redirect.stg.fedoraproject.org", true },
  { "redit.com", true },
  { "redletter.link", true },
  { "redlink.de", true },
  { "redmbk.com", true },
  { "rednsx.org", true },
  { "redports.org", false },
  { "redshield.co", true },
  { "redteam-pentesting.de", true },
  { "redzurl.com", true },
  { "reedloden.com", true },
  { "reezer.org", true },
  { "refundo.cz", true },
  { "refundo.sk", true },
  { "reg.ru", false },
  { "regalosymuestrasgratis.com", true },
  { "regar42.fr", false },
  { "regendevices.eu", true },
  { "regionale.org", true },
  { "regiovertrieb.de", true },
  { "register.gov.uk", true },
  { "regmyr.se", true },
  { "reic.me", true },
  { "reiki-coaching.nl", true },
  { "reimers.de", true },
  { "reishunger.de", true },
  { "reisyukaku.org", true },
  { "reithguard-it.de", true },
  { "rejo.in", true },
  { "relaxhavefun.com", true },
  { "release-monitoring.org", true },
  { "reliable-mail.de", true },
  { "remambo.jp", true },
  { "rememberthemilk.com", false },
  { "remodela.com.ve", true },
  { "remotestance.com", true },
  { "remoteutilities.com", true },
  { "renderloop.com", true },
  { "rene-schwarz.com", true },
  { "renemoser.net", true },
  { "renkenlaw.com", true },
  { "renlong.org", true },
  { "renrenche.com", false },
  { "rentcarassist.com", false },
  { "renteater.com", true },
  { "rentinsingapore.com.sg", true },
  { "renuo.ch", true },
  { "reox.at", true },
  { "repaxan.com", true },
  { "replicagunsswords.com", true },
  { "report-uri.com", true },
  { "report-uri.io", true },
  { "reporturi.com", true },
  { "reporturi.io", true },
  { "republique.org", true },
  { "repustate.com", true },
  { "reputationweaver.com", true },
  { "res42.com", true },
  { "resc.la", true },
  { "research.facebook.com", false },
  { "research.md", true },
  { "residentsinsurance.co.uk", true },
  { "resist.ca", true },
  { "resources.flowfinity.com", true },
  { "respice.xyz", true },
  { "responsibledisclosure.nl", true },
  { "restchart.com", true },
  { "restrito.org", true },
  { "retcor.net", true },
  { "retroarms.com", true },
  { "retroarms.cz", true },
  { "retrofitlab.com", true },
  { "reucon.com", true },
  { "revamed.com", false },
  { "revello.org", true },
  { "revensoftware.com", true },
  { "reverie.pw", true },
  { "revolt.tv", true },
  { "revthefox.co.uk", true },
  { "revtut.net", true },
  { "rewrite3.com", true },
  { "rezosup.net", true },
  { "rezosup.org", true },
  { "rgavmf.ru", true },
  { "rhdigital.pro", true },
  { "rheocube.com", true },
  { "rhering.de", true },
  { "rheuma-online.de", true },
  { "rhinelander.ca", true },
  { "rhodenmanorcattery.co.uk", true },
  { "rhodri.io", true },
  { "rhymix.org", true },
  { "rhynl.io", true },
  { "ribs.com", true },
  { "riccy.org", true },
  { "richardhering.de", true },
  { "richardwarrender.com", true },
  { "richiemail.net", true },
  { "richmondsunlight.com", false },
  { "richsiciliano.com", true },
  { "ricki-z.com", true },
  { "rickyromero.com", true },
  { "ricochet.im", true },
  { "rid-wan.com", false },
  { "ride-up.com", true },
  { "riesenmagnete.de", true },
  { "riesenweber.id.au", true },
  { "right-to-love.name", true },
  { "rightcapital.com", true },
  { "rigolitch.fr", true },
  { "riiconnect24.net", true },
  { "rijschoolgevonden.nl", false },
  { "rika.me", true },
  { "ring0.xyz", false },
  { "ringh.am", true },
  { "ringingliberty.com", true },
  { "rinobroer.nl", true },
  { "rischard.org", true },
  { "riseup.net", true },
  { "riskmgt.com.au", true },
  { "riskmitigation.ch", true },
  { "ristioja.ee", true },
  { "riversideauto.net", true },
  { "rivy.org", true },
  { "rix.ninja", true },
  { "riyono.com", true },
  { "rj.gg", true },
  { "rk6.cz", true },
  { "rlalique.com", true },
  { "rmb.li", true },
  { "rmmanfredi.com", true },
  { "rms.sexy", true },
  { "rmstudio.tw", true },
  { "rngmeme.com", true },
  { "ro.search.yahoo.com", false },
  { "roave.com", true },
  { "robandjanine.com", true },
  { "robertglastra.com", true },
  { "roberthurlbut.com", true },
  { "robertkrueger.de", true },
  { "robertof.ovh", true },
  { "robi-net.it", true },
  { "robigalia.org", true },
  { "robinadr.com", true },
  { "robinsonyu.com", true },
  { "robinwinslow.uk", true },
  { "robodeidentidad.gov", true },
  { "robohash.org", true },
  { "robspc.repair", true },
  { "robteix.com", true },
  { "robtex.com", true },
  { "robtex.net", true },
  { "robtex.org", true },
  { "robud.info", true },
  { "rockcanyonbank.com", true },
  { "rocketmill.co.uk", true },
  { "rocksberg.net", true },
  { "roddis.net", true },
  { "rodehutskors.net", true },
  { "rodney.id.au", true },
  { "rodolfo.gs", true },
  { "rodosto.com", true },
  { "roeckx.be", true },
  { "roeitijd.nl", true },
  { "roelf.org", true },
  { "roeper.party", true },
  { "rohedaten.de", true },
  { "rohlik.cz", true },
  { "rokki.ch", true },
  { "roland.io", true },
  { "rolandreed.cn", true },
  { "rolemaster.net", true },
  { "romab.com", true },
  { "romaimperator.com", true },
  { "romainmuller.xyz", true },
  { "roman-pavlik.cz", true },
  { "romeoferraris.com", false },
  { "romulusapp.com", false },
  { "ron2k.za.net", true },
  { "room-checkin24.de", true },
  { "room208.org", true },
  { "roombase.nl", true },
  { "roomhub.jp", true },
  { "roosterpgplus.nl", true },
  { "root.eu.org", true },
  { "rootforum.org", true },
  { "rootrelativity.com", true },
  { "roots.io", true },
  { "rootservice.org", true },
  { "rootswitch.com", true },
  { "rootwpn.com", true },
  { "rop.io", true },
  { "roquecenter.org", true },
  { "rosenkeller.org", true },
  { "rossen.be", true },
  { "rot47.net", true },
  { "rotterdamjazz.info", true },
  { "rottweil-hilft.de", true },
  { "rotunneling.net", true },
  { "rotzonline.com", true },
  { "roundcube.mayfirst.org", false },
  { "roundtheme.com", true },
  { "rous.se", true },
  { "rouvray.org", true },
  { "rowancasting.ie", true },
  { "royalacademy.org.uk", true },
  { "royalmarinesassociation.org.uk", true },
  { "royalpalacenogent.fr", true },
  { "royalpub.net", true },
  { "royzez.com", true },
  { "rozalisbengal.ro", true },
  { "rpy.xyz", true },
  { "rr.in.th", true },
  { "rring.me", true },
  { "rrke.cc", true },
  { "rsajeey.info", true },
  { "rsampaio.info", true },
  { "rsi.im", false },
  { "rssr.se", true },
  { "rtcx.net", true },
  { "rtd.uk.com", true },
  { "ru-sprachstudio.ch", true },
  { "ru.search.yahoo.com", false },
  { "ruanmi.de", true },
  { "rubberfurs.org", true },
  { "rubecodeberg.com", true },
  { "rubendv.be", true },
  { "rubi-ka.net", true },
  { "rubysecurity.org", true },
  { "rudeotter.com", true },
  { "ruderverein-gelsenkirchen.de", true },
  { "rugstorene.co.uk", true },
  { "runcarina.com", true },
  { "runementors.com", true },
  { "runreport.fr", true },
  { "runtondev.com", true },
  { "runway2street.com", true },
  { "ruobiyi.com", true },
  { "rusadmin.biz", true },
  { "rusempire.ru", true },
  { "rushball.net", true },
  { "rusl.net", true },
  { "rutgerschimmel.nl", true },
  { "ruudkoot.nl", true },
  { "rwanderlust.com", true },
  { "rws-vertriebsportal.de", true },
  { "rww.name", true },
  { "rxbusiness.com", true },
  { "ryan-goldstein.com", true },
  { "ryanhowell.io", true },
  { "ryankearney.com", true },
  { "ryanmcdonough.co.uk", true },
  { "ryansmithphotography.com", true },
  { "ryanteck.uk", false },
  { "s-c.se", true },
  { "s-cubed.net", true },
  { "s13d.fr", true },
  { "sabahattin-gucukoglu.com", true },
  { "saccani.net", true },
  { "safar.sk", true },
  { "safcstore.com", true },
  { "safejourney.education", true },
  { "safematix.com", true },
  { "safeme.ga", true },
  { "safemovescheme.co.uk", true },
  { "safescan.com", true },
  { "safic.net", true },
  { "sagerus.com", true },
  { "sageth.com", true },
  { "saharalondon.com", true },
  { "saikarra.com", false },
  { "sailormoonevents.org", false },
  { "saintsrobotics.com", true },
  { "salaervergleich.com", true },
  { "sale4ru.ru", true },
  { "saleaks.org", true },
  { "salesmachine.io", true },
  { "salmo23.com.br", true },
  { "salmododia.net", true },
  { "salmos91.com", true },
  { "salon.io", true },
  { "saltercane.com", true },
  { "saltstack.cz", true },
  { "salverainha.org", true },
  { "samaritansnet.org", true },
  { "samba.org", true },
  { "sambeso.net", true },
  { "samegoal.com", true },
  { "samegoal.org", true },
  { "samfunnet.no", false },
  { "samifar.in", true },
  { "samizdat.cz", true },
  { "samkelleher.com", true },
  { "saml2.com", true },
  { "samuelkeeley.com", true },
  { "samwu.tw", false },
  { "sanandreasstories.com", true },
  { "sanasalud.org", true },
  { "sanasport.cz", true },
  { "sanatfilan.com", true },
  { "sanchez.adv.br", true },
  { "sandbagexpress.com", true },
  { "sandbox.mydigipass.com", false },
  { "sanderdorigo.nl", true },
  { "sandervankasteel.nl", true },
  { "sandor.wtf", true },
  { "sanglierhurlant.fr", true },
  { "sanhei.ch", true },
  { "sanradon.by", true },
  { "santanderideas.com", true },
  { "santing.net", true },
  { "saorsat.ie", true },
  { "sarah-beckett-harpist.com", true },
  { "sarahbeckettharpist.com", true },
  { "sarahlicity.co.uk", true },
  { "sarahlicity.me.uk", true },
  { "sarahs-roestcafe.de", true },
  { "sarahsweetlife.com", true },
  { "sarakas.com", true },
  { "sarasturdivant.com", true },
  { "sardegnatirocini.it", true },
  { "sarindia.de", true },
  { "sarisonproductions.com", true },
  { "sash.pw", true },
  { "saskpension.com", true },
  { "sat4all.com", true },
  { "satmep.com", true },
  { "satrent.com", true },
  { "satrent.se", true },
  { "satsukii.moe", true },
  { "saturne.tk", true },
  { "saucyfox.net", true },
  { "saulchristie.com", true },
  { "saunas.fr", true },
  { "save.gov", true },
  { "saveaward.gov", true },
  { "savenet.org", true },
  { "savetheinternet.eu", true },
  { "saveyour.biz", true },
  { "savic.com", true },
  { "savingsstoreonline.ca", true },
  { "savvytime.com", true },
  { "sazuz.cz", true },
  { "sb-group.dk", true },
  { "sbssoft.ru", true },
  { "sc4le.com", true },
  { "scaling.solutions", true },
  { "scandicom.fi", true },
  { "scanpay.dk", true },
  { "schachburg.de", true },
  { "schallert.com", true },
  { "schlabbi.com", true },
  { "schlarp.com", true },
  { "schmitz.link", false },
  { "schneids.me", true },
  { "schnell-gold.com", true },
  { "schnouki.net", true },
  { "schoepski.de", true },
  { "schokokeks.org", true },
  { "schont.org", true },
  { "schooltrends.co.uk", true },
  { "schoolze.com", true },
  { "schorel.ovh", true },
  { "schorelweb.nl", true },
  { "schreibnacht.de", true },
  { "schreinerei-jahreis.de", true },
  { "schritt4fit.de", true },
  { "schrodinger.io", true },
  { "schroepfglas-versand.de", true },
  { "schumanandmonnet.eu", true },
  { "schwarzer.it", true },
  { "schwarzkopfforyou.de", true },
  { "schwarzwaldcon.de", true },
  { "schwinabart.com", true },
  { "schwinger.me", true },
  { "scicasts.com", true },
  { "sciencex.com", true },
  { "scotthel.me", true },
  { "scotthelme.co.uk", true },
  { "scotthelme.com", true },
  { "scottstorey.co.uk", true },
  { "scourt.org.ua", true },
  { "scoutdb.ch", true },
  { "scp-trens.notaires.fr", true },
  { "scrambl.is", true },
  { "scrambler.in", false },
  { "scrap.tf", true },
  { "scrapings.net", true },
  { "scrayos.net", true },
  { "screencaster.io", true },
  { "screenlight.tv", true },
  { "screenresolution.space", true },
  { "scribe.systems", true },
  { "scrion.com", true },
  { "script.google.com", true },
  { "scriptict.nl", true },
  { "scs-simulatoren.de", true },
  { "sculpture.support", true },
  { "sdcardrecovery.de", true },
  { "sdrobs.com", true },
  { "sdsl-speedtest.de", true },
  { "se.search.yahoo.com", false },
  { "seanholcroft.co.uk", true },
  { "search-one.de", true },
  { "search.yahoo.com", false },
  { "searchbrothers.com", true },
  { "seatbeltpledge.com", true },
  { "seattlefabrication.com", true },
  { "sebastianboegl.de", true },
  { "sec.gd", true },
  { "secandtech.com", true },
  { "secboom.com", true },
  { "secctexasgiving.org", false },
  { "secondary-survivor.com", true },
  { "secondary-survivor.help", true },
  { "secondary-survivor.net", true },
  { "secondarysurvivor.help", true },
  { "secondarysurvivorportal.com", true },
  { "secondarysurvivorportal.help", true },
  { "secpatrol.de", true },
  { "secretpanties.com", true },
  { "secretserveronline.com", true },
  { "sectia22.ro", true },
  { "section.io", true },
  { "sectun.com", true },
  { "secure-games.us", true },
  { "secure-graphic.de", true },
  { "secure-server-hosting.com", true },
  { "secure.advancepayroll.com.au", true },
  { "secure.chat", true },
  { "secure.facebook.com", false },
  { "securedevelop.net", true },
  { "securedrop.org", false },
  { "secureideas.com", false },
  { "secureonline.co", true },
  { "secureradio.net", true },
  { "securify.nl", true },
  { "security-carpet.com", true },
  { "security.google.com", true },
  { "securityheaders.com", true },
  { "securityheaders.io", true },
  { "securityprimes.in", true },
  { "securitysnobs.com", false },
  { "securitysoapbox.com", true },
  { "securitystreak.com", true },
  { "securiviera.ch", true },
  { "secuvera.de", true },
  { "seedbox.fr", true },
  { "seele.ca", false },
  { "seen.life", true },
  { "segitz.de", true },
  { "segurosocial.gov", false },
  { "seifried.org", true },
  { "seiko-dojo.com", true },
  { "selcusters.nl", true },
  { "selecadm.name", true },
  { "selectel.ru", true },
  { "selectorders.com", true },
  { "selectruckscalltrackingreports.com", true },
  { "selent.me", true },
  { "self-injury.net", true },
  { "selfcarecentral.com", true },
  { "selfici.com", true },
  { "selfici.cz", true },
  { "selldorado.com", true },
  { "sellme.biz", true },
  { "sellocdn.com", true },
  { "semen3325.xyz", true },
  { "seminariruum.ee", true },
  { "semps-servers.de", true },
  { "semps.de", true },
  { "semyonov.su", true },
  { "semyonov.us", true },
  { "sendc.at", true },
  { "sendcat.com", true },
  { "sendinvoice.nl", true },
  { "sendmeback.de", true },
  { "sendya.me", true },
  { "senedirect.com", true },
  { "sensibus.com", false },
  { "seo-nerd.de", true },
  { "seo.consulting", true },
  { "sephr.com", true },
  { "septakkordeon.de", true },
  { "seq.tf", true },
  { "sequencing.com", true },
  { "serbanpaun.ro", true },
  { "serenitycreams.com", true },
  { "serfdom.io", true },
  { "serized.pw", true },
  { "serveradminz.com", true },
  { "serverco.com", true },
  { "servercode.ca", true },
  { "servergno.me", false },
  { "serveroffline.net", false },
  { "serverpedia.de", true },
  { "serverstuff.info", true },
  { "servertastic.com", true },
  { "servethecity-karlsruhe.de", false },
  { "servious.org", true },
  { "seryo.moe", true },
  { "seryo.net", true },
  { "seryovpn.com", true },
  { "sesha.co.za", true },
  { "sessionslogning.dk", true },
  { "setfix.de", true },
  { "setphaserstostun.org", true },
  { "setuid.de", true },
  { "setuid.io", true },
  { "setuid0.kr", true },
  { "sevenmatches.com", true },
  { "sevsopr.ru", true },
  { "sexton.uk.com", false },
  { "sexwork.net", true },
  { "seyahatsagliksigortalari.com", true },
  { "seyr.me", true },
  { "sftool.gov", true },
  { "sg.search.yahoo.com", false },
  { "sgcaccounts.co.uk", true },
  { "sh-network.de", true },
  { "shaaaaaaaaaaaaa.com", true },
  { "shadex.net", true },
  { "shadowkitsune.net", true },
  { "shadowsocks.net", true },
  { "shadowsworldonline.co.uk", true },
  { "shagi29.ru", true },
  { "shaitan.eu", true },
  { "shakepeers.org", true },
  { "shakespearesolutions.com.au", true },
  { "shan.io", true },
  { "shanewadleigh.com", true },
  { "shannoneichorn.com", true },
  { "sharepic.xyz", true },
  { "sharepointdrive.com", true },
  { "sharescope.co.uk", true },
  { "shasso.com", true },
  { "shauncrowley.co.uk", true },
  { "shaundanielz.com", true },
  { "shaunwheelhou.se", true },
  { "shawcentral.ca", true },
  { "shawnh.net", true },
  { "shazbots.org", true },
  { "sheilasdrivingschool.com", true },
  { "shellfire.de", true },
  { "shellvatore.us", true },
  { "shenghaiautoparts.com", true },
  { "shenyuqi.com", true },
  { "shep.co.il", true },
  { "sherbers.de", true },
  { "shft.cl", true },
  { "shh.sh", true },
  { "shiftins.com", false },
  { "shiftplanning.com", true },
  { "shiinko.com", false },
  { "shinju.moe", true },
  { "shinnyosangha.org", true },
  { "shiona.xyz", true },
  { "shipard.com", true },
  { "shipcloud.io", true },
  { "shiroki-k.net", true },
  { "shodan.io", true },
  { "shome.de", true },
  { "shopapi.cz", true },
  { "shopbakersnook.com", true },
  { "shoplandia.co", true },
  { "shorebreaksecurity.com", true },
  { "shortdiary.me", true },
  { "shortpath.com", true },
  { "shortr.li", true },
  { "showkeeper.tv", true },
  { "showsonar.com", true },
  { "shtorku.com", true },
  { "shu-kin.net", true },
  { "shulan.moe", true },
  { "shv25.se", true },
  { "shyrydan.es", true },
  { "si-benelux.nl", true },
  { "sichere-kartenakzeptanz.de", true },
  { "siciliadigitale.pro", true },
  { "siddhant.me", true },
  { "sideshowbarker.net", true },
  { "sidium.de", true },
  { "sidnicio.us", true },
  { "siebens.net", true },
  { "sieh.es", true },
  { "siewert-kau.de", true },
  { "sig6.org", true },
  { "sigabrt.org", true },
  { "sightcure.jp", true },
  { "sighup.nz", true },
  { "signere.com", true },
  { "signing-milter.org", true },
  { "signslabelstapesandmore.com", true },
  { "signtul.com", false },
  { "sigterm.sh", true },
  { "sikatehtaat.fi", true },
  { "sikayetvar.com", true },
  { "silentcircle.com", false },
  { "silentkernel.fr", true },
  { "silentlink.io", true },
  { "silentundo.org", true },
  { "silicagelpackets.ca", true },
  { "silkebaekken.no", true },
  { "silver-heart.co.uk", true },
  { "silverbowflyshop.com", true },
  { "silverdragonart.com", true },
  { "silvergoldbull.com", true },
  { "silvergoldbull.de", true },
  { "silverhome.ninja", true },
  { "silverpvp.com", false },
  { "silverwind.io", true },
  { "silvistefi.com", true },
  { "simbihaiti.com", true },
  { "simbolo.co.uk", false },
  { "simobilklub.si", true },
  { "simod.org", false },
  { "simon-hofmann.org", true },
  { "simoncommunity.org.uk", true },
  { "simongong.net", true },
  { "simonkjellberg.com", true },
  { "simonkjellberg.se", true },
  { "simonreich.de", true },
  { "simonsreich.de", true },
  { "simonwessel.net", true },
  { "simphony.cz", true },
  { "simple.com", false },
  { "simpleai.net", true },
  { "simplednscrypt.org", true },
  { "simplelearner.com", true },
  { "simplepractice.com", true },
  { "simpletax.ca", false },
  { "simplexsupport.com", false },
  { "simplia.cz", true },
  { "simplixos.org", true },
  { "simply-premium.com", true },
  { "simplycharlottemason.com", true },
  { "simplyfixit.co.uk", true },
  { "simplymozzo.se", true },
  { "simplystudio.com", true },
  { "sin30.net", true },
  { "sincron.org", true },
  { "singleuse.link", true },
  { "singlu10.org", true },
  { "singul4rity.com", true },
  { "sinneserweiterung.de", true },
  { "sinoscandinavia.se", true },
  { "sinosky.org", true },
  { "siraweb.org", true },
  { "sirenslove.com", true },
  { "sirius-lee.net", true },
  { "siriuspup.com", true },
  { "sistem-maklumat.com.my", true },
  { "sistemy48.ru", false },
  { "sisv.eu", true },
  { "sitehost.io", true },
  { "sites.google.com", true },
  { "sitesko.de", true },
  { "sitesten.com", true },
  { "sizingservers.be", false },
  { "sizzle.co.uk", true },
  { "sjoorm.com", true },
  { "skalender.ch", true },
  { "skanvordoff.ru", true },
  { "skaraborgsassistans.com", false },
  { "skarrok.com", true },
  { "skatclub-beratzhausen.de", true },
  { "skatn.de", true },
  { "skeeley.com", true },
  { "skhoop.cz", true },
  { "ski-insurance.com.au", true },
  { "skia.org", true },
  { "skigebiete-test.de", true },
  { "skilldetector.com", true },
  { "skilletfood.com", true },
  { "skills2services.com", true },
  { "skimming.net", true },
  { "skipfault.com", true },
  { "skk.io", true },
  { "skoda-clever-lead.de", true },
  { "skoda-im-dialog.de", true },
  { "skoda-nurdiebesten.de", true },
  { "skoda-service-team-cup.de", true },
  { "skogsbruket.fi", true },
  { "skogskultur.fi", true },
  { "skoleniphp.cz", true },
  { "skotty.io", true },
  { "skou.dk", true },
  { "skullhouse.nyc", true },
  { "skydrive.live.com", false },
  { "skyminds.net", true },
  { "skyoy.com", true },
  { "skyway.capital", true },
  { "slack-files.com", true },
  { "slack.com", true },
  { "sladic.si", true },
  { "slainvet.net", true },
  { "slamdjapan.com", true },
  { "slamix.nl", true },
  { "slaps.be", true },
  { "slashdesign.it", false },
  { "slattery.co", true },
  { "slauber.de", true },
  { "sleio.com", true },
  { "slever.cz", true },
  { "slevomat.cz", true },
  { "sliceone.com", true },
  { "slidebatch.com", true },
  { "slightfuture.click", true },
  { "slightfuture.com", true },
  { "slix.io", true },
  { "sloancom.com", true },
  { "slope.haus", true },
  { "slotboss.co.uk", true },
  { "slotcar.com", true },
  { "slowfood.es", true },
  { "slse.ca", true },
  { "slxh.eu", true },
  { "slxh.nl", true },
  { "slycurity.de", true },
  { "smalldata.tech", true },
  { "smallplanet.ch", true },
  { "smares.de", true },
  { "smart-ov.nl", true },
  { "smartairkey.com", true },
  { "smartcleaningcenter.nl", true },
  { "smartftp.com", true },
  { "smarthdd.com", true },
  { "smarthomedna.com", true },
  { "smarthouse.de", true },
  { "smartlend.se", true },
  { "smartlocksmith.com", true },
  { "smartmessages.net", true },
  { "smartphone.continental.com", false },
  { "smartpolicingplatform.com", true },
  { "smartrak.co.nz", true },
  { "smartshiftme.com", true },
  { "smartship.co.jp", true },
  { "smartsparrow.com", true },
  { "smartwurk.nl", true },
  { "smb445.com", true },
  { "smdavis.us", true },
  { "sme-gmbh.net", true },
  { "smiatek.name", true },
  { "smirkingwhorefromhighgarden.pro", true },
  { "smith.is", true },
  { "smithandcanova.co.uk", true },
  { "smittix.co.uk", true },
  { "smkw.com", true },
  { "smm.im", true },
  { "smoo.st", true },
  { "smoothics.com", true },
  { "smove.sg", true },
  { "smow.com", true },
  { "smow.de", true },
  { "sms1.ro", true },
  { "snailing.org", true },
  { "snakehosting.dk", false },
  { "snapappointments.com", true },
  { "snapappts.com", true },
  { "snazel.co.uk", true },
  { "sneakpod.de", true },
  { "sneakynote.com", true },
  { "sneezry.com", true },
  { "snelwerk.be", true },
  { "snfdata.com", true },
  { "sniderman.eu.org", true },
  { "sniep.net", true },
  { "snille.com", true },
  { "snl.no", true },
  { "snoozedds.com", true },
  { "snoqualmiefiber.org", true },
  { "snow-online.com", true },
  { "snow-online.de", true },
  { "snowcrestdesign.com", true },
  { "snughealth.org.uk", true },
  { "sny.no", true },
  { "so-healthy.co.uk", true },
  { "sobabox.ru", true },
  { "sobie.ch", true },
  { "soci.ml", true },
  { "social-events.net", true },
  { "social-media-strategies.it", true },
  { "socialbillboard.com", true },
  { "socialdevelop.biz", true },
  { "socialgrowing.cl", true },
  { "socialhams.net", false },
  { "socialhead.io", true },
  { "socialnous.co", true },
  { "socialrank.com", true },
  { "societyhilldance.com", true },
  { "socioambiental.org", true },
  { "sockeye.cc", false },
  { "sockeye.io", true },
  { "sodi.nl", true },
  { "sofort.com", true },
  { "sofortueberweisung.de", true },
  { "softwarebetrieb.de", true },
  { "softwaredesign.foundation", true },
  { "sogeek.me", true },
  { "sogutma.com.tr", true },
  { "soia.ca", true },
  { "soju.fi", true },
  { "sokkenhoek.nl", true },
  { "sol-3.de", true },
  { "solar-ec.com", true },
  { "soldecom.com", true },
  { "soleus.nu", true },
  { "solidfuelappliancespares.co.uk", true },
  { "solidus.systems", true },
  { "solihullcarnival.co.uk", true },
  { "solihulllionsclub.org.uk", true },
  { "solinter.com.br", true },
  { "soll-i.ch", true },
  { "solsystems.ru", true },
  { "solutionhoisthire.com.au", true },
  { "solved.tips", true },
  { "somebodycares.org", true },
  { "someshit.xyz", true },
  { "somethingnew.xyz", true },
  { "sona-gaming.com", true },
  { "sonafe.info", true },
  { "sondergaard.de", true },
  { "soondy.com", true },
  { "soph.us", true },
  { "soply.com", true },
  { "soporte.cc", true },
  { "sortaweird.net", true },
  { "sorz.org", true },
  { "sos.sk", true },
  { "sosaka.ml", true },
  { "sosecu.red", true },
  { "sotar.us", true },
  { "sotor.de", true },
  { "souki.cz", true },
  { "soulfulglamour.uk", true },
  { "soulogic.com", false },
  { "soumikghosh.com", true },
  { "soundforsound.co.uk", true },
  { "soundgasm.net", true },
  { "soundtalks.com", true },
  { "sour.is", true },
  { "sourcely.net", true },
  { "sourceway.de", true },
  { "sous-surveillance.net", true },
  { "southernutahinfluencers.com", true },
  { "southside-crew.club", true },
  { "southside-crew.com", true },
  { "southworcestershiregpservices.co.uk", true },
  { "souvik.me", true },
  { "souyidai.com", true },
  { "soved.eu", true },
  { "sovereignshare.com", true },
  { "sown.dyndns.org", true },
  { "sowncloud.de", true },
  { "sp.rw", true },
  { "spacecompute.com", true },
  { "spacedust.xyz", true },
  { "spacefish.biz", true },
  { "spacehq.org", true },
  { "spaggel.nl", true },
  { "sparelib.com", true },
  { "sparklebastard.com", true },
  { "sparsa.army", true },
  { "spauted.com", true },
  { "spawn.cz", true },
  { "spaysy.com", true },
  { "spdf.net", true },
  { "spectrosoftware.de", true },
  { "speculor.net", true },
  { "speed-mailer.com", true },
  { "speedcounter.net", true },
  { "speedmann.de", true },
  { "speedtest-russia.com", true },
  { "speedy.lt", true },
  { "speedyprep.com", true },
  { "speich.net", true },
  { "speidel.com.tr", true },
  { "sperrstun.de", true },
  { "spherenix.org", true },
  { "spicydog.org", true },
  { "spicydog.tk", true },
  { "spicymatch.com", true },
  { "spideroak.com", true },
  { "spiegels.nl", true },
  { "spielcasinos.com", true },
  { "spiet.nl", true },
  { "spillmaker.no", true },
  { "spins.fedoraproject.org", true },
  { "spirit-dev.net", true },
  { "spiritbionic.ro", true },
  { "spitefultowel.com", true },
  { "splikity.com", true },
  { "splitdna.com", true },
  { "sportifik.com", true },
  { "sportwette.eu", true },
  { "spot-events.com", true },
  { "spreadsheets.google.com", true },
  { "spreed.me", true },
  { "spritchard.photos", true },
  { "sprueche-zum-valentinstag.de", true },
  { "sprueche-zur-geburt.info", true },
  { "sprueche-zur-hochzeit.de", true },
  { "sprueche-zur-konfirmation.de", true },
  { "spuffin.com", true },
  { "spydersec.com", true },
  { "spyroszarzonis.com", true },
  { "sqlapius.net", true },
  { "sqr-training.com", true },
  { "square-gaming.org", true },
  { "square-src.de", true },
  { "square.com", false },
  { "square.gs", true },
  { "squareup.com", false },
  { "squawk.cc", true },
  { "squeezemetrics.com", true },
  { "src.fedoraproject.org", true },
  { "srchub.org", true },
  { "srevilak.net", true },
  { "sritest.io", true },
  { "srna.sk", true },
  { "sro.center", true },
  { "srpdb.com", true },
  { "srrr.ca", true },
  { "srv47.de", true },
  { "ss.lv", false },
  { "ssbrm.ch", true },
  { "sscd.no", true },
  { "ssl-zertifikate.de", true },
  { "ssl.google-analytics.com", true },
  { "ssl.rip", true },
  { "ssl247.co.uk", true },
  { "ssl247.com.mx", true },
  { "ssl247.de", true },
  { "ssl247.dk", true },
  { "sslcertificaten.nl", true },
  { "sslcheck.nl", true },
  { "ssldecoder.org", true },
  { "sslmate.com", true },
  { "sslpoint.com", true },
  { "sslzilla.de", true },
  { "ssnc.org", true },
  { "sss3s.com", true },
  { "sstewartgallus.com", true },
  { "ssworld.ga", true },
  { "staack.com", true },
  { "stablelib.com", true },
  { "stabletoken.com", true },
  { "stackptr.com", true },
  { "stadionmanager.com", true },
  { "stadjerspasonline.nl", true },
  { "stadtbauwerk.at", true },
  { "stage-props-blank-guns.com", true },
  { "stage.wepay.com", false },
  { "stageirites.fr", true },
  { "stagingjobshq.com", true },
  { "stagstickets.co.uk", true },
  { "stahl.xyz", true },
  { "stalder.work", true },
  { "stalker-shop.com", true },
  { "stalkerhispano.com", true },
  { "stanandjerre.org", true },
  { "standardssuck.org", true },
  { "standingmist.com", true },
  { "star-citizen.wiki", true },
  { "starapple.nl", true },
  { "starcomproj.com", true },
  { "starmusic.ga", true },
  { "starpeak.org", true },
  { "starsam80.net", true },
  { "starstreak.net", true },
  { "startupsort.com", true },
  { "stash.ai", true },
  { "statecover.com.au", true },
  { "stateofexception.io", true },
  { "static.or.at", true },
  { "static.wepay.com", false },
  { "staticisnoise.com", true },
  { "stationary-traveller.eu", true },
  { "stationaryjourney.com", true },
  { "stationnementdenuit.ca", true },
  { "statuschecks.net", true },
  { "statuscode.ch", true },
  { "stay.black", true },
  { "stbennett.org", true },
  { "stderr.cc", true },
  { "steakovercooked.com", true },
  { "stealsaga.net", true },
  { "steamdb.info", true },
  { "steckregal-super.de", true },
  { "steelephys.com.au", true },
  { "stefanovski.io", true },
  { "stefanweiser.de", true },
  { "stefany.eu", true },
  { "steidlewirt.de", true },
  { "steigerplank.com", true },
  { "stellanova-planeten.de", true },
  { "stellenticket.de", true },
  { "stemsims.com", true },
  { "stephanierxo.com", true },
  { "stephenandburns.com", true },
  { "stereo.lu", true },
  { "stereochro.me", false },
  { "sterlingtrader.com", false },
  { "sternplastic.com", true },
  { "stesti.cz", true },
  { "stevegrav.es", true },
  { "stevensononthe.net", true },
  { "steventress.com", true },
  { "stewartremodelingadvantage.com", true },
  { "stichtingsticky.nl", true },
  { "stick2bike.de", true },
  { "sticklerjs.org", true },
  { "stigharder.com", true },
  { "stinkytrashhound.com", true },
  { "stirling.co", true },
  { "stirlingpoon.xyz", true },
  { "stjohnin.com", true },
  { "stjohnmiami.org", true },
  { "stkbn.com", true },
  { "stmbgr.com", true },
  { "stn.me.uk", false },
  { "stnl.de", true },
  { "stocktrade.de", false },
  { "stocktrader.com", true },
  { "stoffe-monster.de", true },
  { "stoffelen.nl", true },
  { "stoianlawfirm.com", true },
  { "stoick.me", true },
  { "stolina.de", true },
  { "stolkschepen.nl", true },
  { "stomt.com", true },
  { "stopwoodfin.org", true },
  { "storecove.com", true },
  { "storedsafe.com", true },
  { "storefrontify.com", true },
  { "stormhub.org", true },
  { "stormyyd.com", true },
  { "storvann.net", true },
  { "storvann.no", true },
  { "storycollective.nl", true },
  { "stqry.com", true },
  { "str0.at", true },
  { "strasweb.fr", false },
  { "strchr.com", true },
  { "streampanel.net", false },
  { "streams.dyndns.org", true },
  { "streamzilla.com", true },
  { "stressfreehousehold.com", true },
  { "stretchmyan.us", true },
  { "stricted.net", true },
  { "strictlysudo.com", true },
  { "strijkshop.be", true },
  { "stripe.com", true },
  { "strobeltobias.de", true },
  { "strobeto.de", true },
  { "stroeercrm.de", true },
  { "strongest-privacy.com", true },
  { "structurally.net", true },
  { "strugee.net", true },
  { "stuartbaxter.co", false },
  { "stuartbell.co.uk", true },
  { "studenckiemetody.pl", true },
  { "student.andover.edu", true },
  { "studentloans.gov", true },
  { "studentskydenik.cz", true },
  { "studer.su", true },
  { "studienportal.eu", true },
  { "studlan.no", true },
  { "studyhub.cf", true },
  { "stugb.de", true },
  { "stulda.cz", true },
  { "stumf.si", true },
  { "stuntmen.xyz", true },
  { "stupendous.net", true },
  { "stupus.com", true },
  { "stuur.nl", true },
  { "stw-group.at", true },
  { "stygium.net", true },
  { "styleci.io", true },
  { "stylenda.com", true },
  { "styles.pm", true },
  { "su1ph3r.io", true },
  { "suave.io", true },
  { "subdimension.org", false },
  { "subeesu.com", true },
  { "sublevel.net", true },
  { "subrosa.io", true },
  { "subseq.net", false },
  { "subtitle.rip", true },
  { "sudo.im", true },
  { "sudo.ws", true },
  { "sufix.cz", true },
  { "suian.or.jp", true },
  { "suite73.org", true },
  { "sulek.eu", true },
  { "sumoscout.de", true },
  { "sunbritetv.com", true },
  { "sundayfundayjapan.com", true },
  { "suneilpatel.com", true },
  { "sunflyer.cn", false },
  { "sunjaydhama.com", true },
  { "sunnyfruit.ru", true },
  { "suos.io", true },
  { "supastuds.com", true },
  { "supcro.com", true },
  { "super-o-blog.com", true },
  { "superbabysitting.ch", true },
  { "superbart.nl", true },
  { "superbshare.com", true },
  { "supereight.net", true },
  { "superhome.com.au", true },
  { "superkonsult.se", true },
  { "supermarx.nl", true },
  { "supersalescontest.nl", true },
  { "superswingtrainer.com", true },
  { "superwally.org", true },
  { "supplies24.at", true },
  { "supplies24.es", true },
  { "support.mayfirst.org", false },
  { "suprlink.net", true },
  { "surfone-leucate.com", true },
  { "surgenet.nl", true },
  { "surkatty.org", true },
  { "survature.com", true },
  { "surveypirate.com", true },
  { "survivalmonkey.com", true },
  { "susanbpilates.co", true },
  { "susanbpilates.com", true },
  { "susastudentenjobs.de", true },
  { "sushifrick.de", true },
  { "sustainability.gov", true },
  { "sustsol.com", true },
  { "svager.cz", true },
  { "svallee.fr", false },
  { "svarovani.tk", true },
  { "sveneckelmann.de", true },
  { "svenskacasino.com", true },
  { "svijet-medija.hr", true },
  { "swaggerdile.com", true },
  { "swaleacademiestrust.org.uk", true },
  { "swansdoor.org", true },
  { "swapadoodle.com", true },
  { "sway-cdn.com", true },
  { "sway.com", true },
  { "swedishhost.com", true },
  { "swedishhost.se", true },
  { "sweetll.me", true },
  { "sweetstreats.ca", true },
  { "swehack.org", false },
  { "swift-devedge.de", true },
  { "swimming.ca", true },
  { "swiss-cyber-experts.ch", true },
  { "swite.com", true },
  { "swyn.net", true },
  { "sx3.no", true },
  { "syam.cc", true },
  { "sycamorememphis.org", false },
  { "sychov.pro", true },
  { "sydgrabber.tk", true },
  { "syezd.com.au", true },
  { "sykepleien.no", true },
  { "sylaps.com", true },
  { "sylvaindurand.org", true },
  { "sylvan.me", true },
  { "sylvanorder.com", true },
  { "synackr.com", true },
  { "synapticconsulting.co.uk", true },
  { "synatra.co", true },
  { "sync-it.no", true },
  { "syncappate.com", true },
  { "synchrocube.com", true },
  { "syncmylife.net", true },
  { "syncserve.net", true },
  { "syneic.com", true },
  { "synfin.org", true },
  { "synony.me", true },
  { "syntaxnightmare.com", true },
  { "syriatalk.biz", true },
  { "syriatalk.org", true },
  { "sysadmins.ro", true },
  { "sysctl.se", false },
  { "sysdb.io", true },
  { "sysmike.de", true },
  { "sysmike.net", true },
  { "syso.name", true },
  { "syss.de", true },
  { "system.is", true },
  { "systemintegra.ru", true },
  { "systemreboot.net", true },
  { "syzygy-tables.info", true },
  { "szagun.net", true },
  { "szaszm.tk", true },
  { "szaydon.me", false },
  { "szechenyi2020.hu", true },
  { "szongott.net", true },
  { "t-hawk.com", true },
  { "t-point.eu", true },
  { "t-shirts4less.nl", true },
  { "t0dd.eu", false },
  { "t23m-navi.jp", false },
  { "t7e.de", true },
  { "tabla-periodica.com", true },
  { "tablotv.com", false },
  { "taborsky.cz", true },
  { "tacomafia.net", true },
  { "tacticalsquare.com", true },
  { "tadigitalstore.com", true },
  { "tahf.net", true },
  { "tailpuff.net", true },
  { "taken.pl", true },
  { "takeshifujimoto.com", true },
  { "takkaaaaa.com", true },
  { "takusan.ru", true },
  { "talado.gr", false },
  { "talentcast.nl", true },
  { "talideon.com", false },
  { "talk.google.com", true },
  { "talkgadget.google.com", true },
  { "talktwincities.com", true },
  { "tallr.se", true },
  { "tallshoe.com", true },
  { "talsi.eu", true },
  { "tangiblesecurity.com", true },
  { "taniesianie.pl", true },
  { "tankski.co.uk", true },
  { "tannenhof-moelln.de", true },
  { "tantalos.nl", true },
  { "tante-bugil.net", true },
  { "tapfinder.ca", true },
  { "tappublisher.com", true },
  { "taquilla.com", true },
  { "taranis.re", true },
  { "tarhauskielto.fi", true },
  { "tartaneagle.org.uk", false },
  { "tartaros.fi", true },
  { "tas2580.net", true },
  { "taskforce512.de", true },
  { "taskotron.fedoraproject.org", true },
  { "taskotron.stg.fedoraproject.org", true },
  { "taskstats.com", true },
  { "taskstream.com", true },
  { "taskulu.com", true },
  { "tasmansecurity.com", true },
  { "tastycake.net", true },
  { "tatilbus.com", false },
  { "tatort-fanpage.de", true },
  { "tauchkater.de", true },
  { "tavoittaja.fi", true },
  { "taxaroo.com", true },
  { "taxbench.com", true },
  { "taxspeaker.com", true },
  { "taxsquirrel.com", true },
  { "tazemama.biz", true },
  { "tazj.in", false },
  { "tazz.in", true },
  { "tbarter.com", false },
  { "tbrss.com", true },
  { "tbspace.de", true },
  { "tc-bonito.de", true },
  { "tcao.info", true },
  { "tcdw.net", true },
  { "tcgrepublic.com", true },
  { "tcomms.org", true },
  { "tdelmas.eu", true },
  { "tdelmas.ovh", true },
  { "tdrs.info", true },
  { "teachercreatedmaterials.com", true },
  { "teachforcanada.ca", true },
  { "team-one.racing", true },
  { "teamblueridge.org", true },
  { "teamnorthgermany.de", true },
  { "teampaddymurphy.ie", true },
  { "teampoint.cz", true },
  { "teamtouring.net", true },
  { "teamupturn.com", true },
  { "teamzeus.cz", true },
  { "tecart-cloud.de", true },
  { "tecart-system.de", true },
  { "tecartcrm.de", true },
  { "tech-essential.com", true },
  { "tech-rat.com", true },
  { "tech-seminar.jp", true },
  { "techandtux.de", true },
  { "techassist.io", true },
  { "techcavern.ml", true },
  { "techcentric.com", false },
  { "techelements.co", true },
  { "techhipster.net", true },
  { "techhub.ml", true },
  { "techllage.com", true },
  { "techloaner.com", true },
  { "techmajesty.com", true },
  { "techmatehq.com", true },
  { "technoparcepsilon.fr", true },
  { "technosavvyport.com", true },
  { "technotonic.com.au", false },
  { "techpivot.net", true },
  { "techpointed.com", true },
  { "techvalue.gr", true },
  { "tecnogaming.com", true },
  { "tecture.de", true },
  { "teddy.ch", true },
  { "tedeh.net", true },
  { "teebeedee.org", true },
  { "teemo.gg", true },
  { "teemperor.de", true },
  { "tehotuotanto.net", true },
  { "tehrabbitt.com", false },
  { "telefonkonferenz.ch", true },
  { "telekollektiv.org", true },
  { "teleogistic.net", true },
  { "telescam.com", true },
  { "tellingua.com", true },
  { "temizmama.com", true },
  { "temp.pm", true },
  { "tempcraft.net", true },
  { "tempus-aquilae.de", true },
  { "tendertool.nl", true },
  { "tenenz.com", true },
  { "tengroup.com", true },
  { "tennisadmin.com", true },
  { "tent.io", true },
  { "tentations-voyages.com", true },
  { "tenyx.de", true },
  { "teodio.cl", true },
  { "teos.online", true },
  { "teoskanta.fi", true },
  { "tepid.org", true },
  { "terrab.de", true },
  { "terracloud.de", true },
  { "terraelectronica.ru", true },
  { "terraform.io", true },
  { "terrastaffinggroup.com", true },
  { "terravirtua.com", true },
  { "terraweb.net", true },
  { "terrax.info", true },
  { "terrax.net", true },
  { "terrty.net", true },
  { "tescoirelandpayslips.com", true },
  { "testandroid.xyz", true },
  { "testingbot.com", true },
  { "testnode.xyz", true },
  { "testsuite.org", true },
  { "tetsumaki.net", true },
  { "teuniz.nl", true },
  { "teunstuinposters.nl", true },
  { "textburst.com", true },
  { "texte-zur-taufe.de", true },
  { "texter-linz.at", true },
  { "texterseo.at", true },
  { "textoplano.xyz", true },
  { "textracer.dk", true },
  { "textualapp.com", true },
  { "texy.info", true },
  { "tezcam.tk", true },
  { "tf-network.de", true },
  { "tf2b.com", true },
  { "tfnapps.de", true },
  { "tgr.re", true },
  { "th.search.yahoo.com", false },
  { "thackbarth.net", true },
  { "thaicyberpoint.com", true },
  { "thaihostcool.com", true },
  { "thca.ca", true },
  { "the-construct.com", true },
  { "the-earth-yui.net", true },
  { "the-gist.io", true },
  { "the-paddies.de", true },
  { "theamateurs.net", true },
  { "theamp.com", true },
  { "theberkshirescompany.com", true },
  { "thebigwave.de", true },
  { "thebikeinsurer.co.uk", true },
  { "thebimhub.com", true },
  { "thebreakroom.org", true },
  { "thecandidforum.com", true },
  { "thecitizens.com", true },
  { "thecitywarehouse.clothing", true },
  { "theclementinebutchers.com", true },
  { "thecloudmigrator.com", true },
  { "theclubjersey.com", true },
  { "thecustomizewindows.com", true },
  { "thedark1337.com", true },
  { "thedevrycommonsbrasil.com", true },
  { "thedisc.nl", true },
  { "thedreamtravelgroup.co.uk", true },
  { "theendofzion.com", true },
  { "theescapistswiki.com", true },
  { "thefarbeyond.com", true },
  { "thefootballanalyst.com", true },
  { "thefox.co", true },
  { "thefrozenfire.com", false },
  { "thegcccoin.com", true },
  { "thego2swatking.com", false },
  { "thegoldregister.co.uk", true },
  { "thegraciousgourmet.com", true },
  { "thegvoffice.net", true },
  { "thehackerblog.com", true },
  { "thehiddenbay.eu", true },
  { "thehiddenbay.me", true },
  { "thehiddenbay.net", true },
  { "thehonorguard.org", true },
  { "thehotfix.net", true },
  { "theinitium.com", true },
  { "theintercept.com", true },
  { "theinvisibletrailer.com", true },
  { "theitsage.com", true },
  { "thejserver.de", true },
  { "thekelvinliu.com", true },
  { "thelapine.ca", true },
  { "thelastsurprise.com", true },
  { "thelocals.ru", true },
  { "themarshallproject.org", true },
  { "themeaudit.com", true },
  { "themicrocapital.com", true },
  { "themillerslive.com", true },
  { "themoep.at", true },
  { "themostexpensiveworkofart.com", true },
  { "thenocman.com", true },
  { "thenorthschool.org.uk", true },
  { "theodorejones.info", true },
  { "theojones.name", true },
  { "thepaymentscompany.com", true },
  { "thepb.in", true },
  { "thepiratebay.al", true },
  { "thepiratebay.poker", true },
  { "theploughharborne.co.uk", true },
  { "therapynotes.com", true },
  { "therewill.be", true },
  { "therockawaysny.com", true },
  { "thescientists.nl", true },
  { "theseed.io", true },
  { "theseletarmall.com", true },
  { "theseoframework.com", true },
  { "thesession.org", false },
  { "theshadestore.com", true },
  { "thesharepointfarm.com", true },
  { "theshopally.com", true },
  { "thesled.net", true },
  { "thestagchorleywood.co.uk", true },
  { "thestory.ie", true },
  { "thetechnical.me", true },
  { "thetomharling.com", true },
  { "thetradinghall.com", true },
  { "thetuxkeeper.de", true },
  { "theunitedstates.io", true },
  { "theurbanyoga.com", true },
  { "theweilai.com", false },
  { "thewindow.com", true },
  { "theworldsend.eu", true },
  { "theyosh.nl", true },
  { "thezero.org", true },
  { "thibautcharles.net", true },
  { "thierfreund.de", true },
  { "thierryhayoz.ch", true },
  { "thinkcoding.de", true },
  { "thinkcoding.org", true },
  { "thinkindifferent.net", true },
  { "thinklikeanentrepreneur.com", true },
  { "thinktux.net", true },
  { "thirdpartytrade.com", true },
  { "thisisforager.com", true },
  { "thisserver.dontexist.net", true },
  { "thiswebhost.com", true },
  { "thkb.net", true },
  { "thom4s.info", true },
  { "thomas-grobelny.de", true },
  { "thomasbreads.com", true },
  { "thomasgriffin.io", true },
  { "thomashunter.name", false },
  { "thomasnet.fr", true },
  { "thomastimepieces.com.au", true },
  { "thomspooren.nl", true },
  { "thomwiggers.nl", true },
  { "thorbis.com", true },
  { "thorbiswebsitedesign.com", true },
  { "thorgames.nl", true },
  { "thouni.de", true },
  { "threatcentral.io", true },
  { "threedpro.me", true },
  { "threelions.ch", true },
  { "throwaway.link", true },
  { "throwpass.com", true },
  { "thrx.net", true },
  { "thusoy.com", true },
  { "thyngster.com", false },
  { "tianshili.me", true },
  { "ticketmates.com.au", true },
  { "ticketoplichting.nl", true },
  { "tickettoaster.de", true },
  { "tickopa.co.uk", true },
  { "tickreport.com", true },
  { "tictactux.de", true },
  { "tid.jp", false },
  { "tidycustoms.net", true },
  { "tiendavertigo.com", true },
  { "tiendschuurstraat.nl", true },
  { "tiens-ib.cz", true },
  { "tifan.net", true },
  { "tiffnix.com", true },
  { "tigerchef.com", true },
  { "tigerdile.com", true },
  { "tikutiku.pl", true },
  { "timbuktutimber.com", true },
  { "timetab.org", true },
  { "timmersgems.com", true },
  { "timmy.ws", true },
  { "timtaubert.de", true },
  { "timwittenberg.com", true },
  { "tinfoilsecurity.com", false },
  { "tinkertry.com", false },
  { "tinte24.de", true },
  { "tintenfix.net", true },
  { "tinylan.com", true },
  { "tinyvpn.net", true },
  { "tinyvpn.org", true },
  { "tiplanet.org", true },
  { "tipps-fuer-den-haushalt.de", true },
  { "tippspiel.cc", true },
  { "tipsyk.ru", true },
  { "tit.systems", true },
  { "tittelbach.at", true },
  { "tjenestetorvet.dk", true },
  { "tlach.cz", true },
  { "tlo.hosting", true },
  { "tlo.link", true },
  { "tlo.network", true },
  { "tlo.xyz", true },
  { "tls.builders", true },
  { "tls.care", true },
  { "tls.li", true },
  { "tls1914.org", true },
  { "tm-solutions.eu", true },
  { "tmaward.net", true },
  { "tmi-products.eu", true },
  { "tmi-produkter.se", true },
  { "tmitchell.io", true },
  { "tmpraider.net", true },
  { "tmpsantos.com.br", true },
  { "tmtopup.com", true },
  { "tncnanet.com.br", true },
  { "tnes.dk", true },
  { "tno.io", true },
  { "tnrsca.jp", false },
  { "tobias-kluge.de", true },
  { "tobiasmathes.com", true },
  { "tobiasmathes.name", true },
  { "tobiassachs.de", true },
  { "tobiassattler.com", true },
  { "toccoig.com", true },
  { "todesschaf.org", true },
  { "todo.is", true },
  { "todoist.com", true },
  { "tofu.im", true },
  { "togelonlinecommunity.com", true },
  { "tokaido.com", true },
  { "tokke.dk", true },
  { "tokoone.com", false },
  { "tollsjekk.no", true },
  { "tom.horse", true },
  { "tomasjacik.cz", true },
  { "tomask.info", true },
  { "tomaspialek.cz", true },
  { "tomatenaufdenaugen.de", true },
  { "tomaw.net", true },
  { "tombrossman.com", true },
  { "tomcort.com", true },
  { "tomeara.net", true },
  { "tomfisher.eu", true },
  { "tomharling.co.uk", true },
  { "tomharling.uk", true },
  { "tomli.me", true },
  { "tommsy.com", true },
  { "tommyads.com", true },
  { "tomo.gr", false },
  { "tomrei.com", true },
  { "tomrichards.net", true },
  { "tomudding.nl", true },
  { "tomvote.com", true },
  { "tomwiggers.nl", true },
  { "tomwilson.io", true },
  { "tonage.de", true },
  { "toncusters.nl", true },
  { "tonegidoarchief.nl", true },
  { "toner24.at", true },
  { "toner24.co.uk", true },
  { "toner24.es", true },
  { "toner24.fr", true },
  { "toner24.it", true },
  { "toner24.nl", true },
  { "toner24.pl", true },
  { "tonerdepot.de", true },
  { "tonerjet.at", true },
  { "tonerjet.co.uk", true },
  { "tonerklick.de", true },
  { "tonerkurier.de", true },
  { "tonermaus.de", true },
  { "tonermonster.de", true },
  { "tonex.de", true },
  { "tonex.nl", true },
  { "tonkinson.com", true },
  { "tonsit.com", true },
  { "tonsit.org", true },
  { "tonymanning.com", false },
  { "tonytan.cn", true },
  { "tonytan.io", true },
  { "tonywebster.com", true },
  { "toolbox.ninja", true },
  { "toomanypillows.com", true },
  { "tooolroc.org", true },
  { "top-stage.net", true },
  { "topbrakes.com", true },
  { "topdevbox.net", true },
  { "topmarine.se", true },
  { "topnewstoday.org", true },
  { "topnovini.com", true },
  { "toptexture.com", true },
  { "toptranslation.com", true },
  { "tor2web.org", true },
  { "torahanytime.com", true },
  { "tormentedradio.com", true },
  { "torproject.org", false },
  { "torprojects.com", true },
  { "torquato.de", false },
  { "torrent.fedoraproject.org", true },
  { "torrent.is", true },
  { "torsten-schmitz.net", true },
  { "tosecure.link", true },
  { "toshkov.com", true },
  { "toshnix.com", true },
  { "tosteberg.se", true },
  { "totalbeauty.co.uk", true },
  { "totalcarcheck.co.uk", true },
  { "totalchecklist.com", true },
  { "totaltriathlon.com", true },
  { "totch.de", true },
  { "totem-eshop.cz", true },
  { "totem-international.com", true },
  { "toucedo.de", false },
  { "touch.facebook.com", false },
  { "touch.mail.ru", true },
  { "touhou.cc", true },
  { "tourispo.com", true },
  { "tout-art.ch", true },
  { "toutart.ch", true },
  { "towandalibrary.org", true },
  { "townhousedevelopments.com.au", true },
  { "tox.im", true },
  { "toxme.se", true },
  { "toysperiod.com", true },
  { "tp-iryuubun.com", true },
  { "tp-kabushiki.com", true },
  { "tp-kyouyufudousan.com", true },
  { "tp-law.jp", true },
  { "tpbproxy.co", true },
  { "tpe-edu.com", true },
  { "tppleague.me", true },
  { "tr.search.yahoo.com", false },
  { "traas.org", true },
  { "trabbel.org", true },
  { "trackchair.com", true },
  { "trade-smart.ru", true },
  { "tradeacademy.in", true },
  { "tradedesk.co.za", true },
  { "tradeinvent.co.uk", true },
  { "trademan.ky", true },
  { "tradinghope.com", true },
  { "tradiz.org", true },
  { "trainex.org", true },
  { "trakfusion.com", true },
  { "transacid.de", true },
  { "transformify.org", true },
  { "transitpoint.us", true },
  { "translate.fedoraproject.org", true },
  { "translate.googleapis.com", true },
  { "translate.stg.fedoraproject.org", true },
  { "transmithe.net", true },
  { "transportal.sk", true },
  { "transverify.com", true },
  { "trashnothing.com", true },
  { "trauertexte.info", true },
  { "travador.com", true },
  { "travelinsurance.co.nz", true },
  { "travisf.net", true },
  { "treebaglia.xyz", true },
  { "treeby.net", true },
  { "treeschat.com", true },
  { "trell.co.in", true },
  { "trendkraft.de", true },
  { "tresorit.com", true },
  { "tresorsecurity.com", true },
  { "tretkowski.de", true },
  { "tribaldos.com", true },
  { "tribut.de", true },
  { "trident-online.de", true },
  { "trik.es", true },
  { "trim-a-slab.com", true },
  { "trimage.org", true },
  { "trineco.com", true },
  { "trineco.fi", true },
  { "trinityaffirmations.com", true },
  { "trinnes.net", true },
  { "triop.se", true },
  { "tripdelta.com", true },
  { "triple-mmm.de", true },
  { "tripseats.com", true },
  { "troi.de", true },
  { "trollme.me", true },
  { "trophee-discount.com", true },
  { "truckerswereld.nl", true },
  { "truckstop-magazin.de", true },
  { "trueblueessentials.com", true },
  { "truejob.com", true },
  { "trueteaching.com", true },
  { "trufflemonkey.co.uk", true },
  { "truserve.org", true },
  { "trustedinnovators.com", true },
  { "trusteecar.com", true },
  { "trustmeimfancy.com", true },
  { "truthmessages.pw", true },
  { "trw-reseller.com", true },
  { "tryoneday.co", true },
  { "trywesayyes.com", true },
  { "trzepak.pl", true },
  { "ts3.consulting", true },
  { "tsecy.com", true },
  { "tsgbit.net", true },
  { "tsrstore.gq", true },
  { "tsumi.it", true },
  { "ttcf.ca", true },
  { "tty.space", true },
  { "ttz.im", true },
  { "tuamoronline.com", true },
  { "tubepro.de", true },
  { "tucny.com", true },
  { "tucuxi.org", true },
  { "tuingereedschappen.net", true },
  { "tuitle.com", true },
  { "tumutanzi.com", true },
  { "tunai.id", true },
  { "tunebitfm.de", true },
  { "tuningblog.eu", true },
  { "tunnelblick.net", true },
  { "tuntitili.fi", true },
  { "turbobit.ch", true },
  { "turnik-67.ru", true },
  { "turtle.ai", true },
  { "turtlementors.com", true },
  { "tuvalie.com", true },
  { "tuxcall.de", true },
  { "tuxcloud.net", true },
  { "tuxgeo.com", false },
  { "tuxplace.nl", true },
  { "tuxz.net", true },
  { "tuzaijidi.com", true },
  { "tw.search.yahoo.com", false },
  { "twaka.com", true },
  { "twarog.cc", true },
  { "twd2.me", true },
  { "twd2.net", false },
  { "twelve.rocks", true },
  { "twentymilliseconds.com", true },
  { "twist.party", true },
  { "twisto.cz", true },
  { "twitter.com", false },
  { "twitteroauth.com", true },
  { "twofactorauth.org", true },
  { "twolinepassbrewing.com", true },
  { "twopif.net", true },
  { "tx041cap.org", true },
  { "txclimbers.com", true },
  { "txf.pw", true },
  { "ty2u.com", true },
  { "tyche.io", true },
  { "tyl.io", true },
  { "tylerschmidtke.com", true },
  { "typecodes.com", true },
  { "typeonejoe.com", true },
  { "typewolf.com", true },
  { "typing.com", true },
  { "typingrevolution.com", true },
  { "tysye.ca", true },
  { "tzappa.net", true },
  { "u-blox.com", true },
  { "uae-company-service.com", true },
  { "uangteman.com", true },
  { "uasmi.com", true },
  { "uat-activesg.com", true },
  { "ub3rk1tten.com", false },
  { "ubanquity.com", true },
  { "uber.com.au", true },
  { "uberboxen.net", true },
  { "ubertt.org", true },
  { "ubicv.com", true },
  { "ublox.com", true },
  { "ucfirst.nl", true },
  { "udomain.net", true },
  { "uerdingen.info", true },
  { "ufgaming.com", true },
  { "ufotable.uk", false },
  { "uhc.gg", true },
  { "ui8.net", true },
  { "uk.search.yahoo.com", false },
  { "ukchemicalresearch.org", true },
  { "ukdefencejournal.org.uk", true },
  { "ukdropshipment.co.uk", true },
  { "ukdropshipment.com", true },
  { "ukhas.net", true },
  { "ukrainians.ch", true },
  { "ukwct.org.uk", true },
  { "ulabox.cat", true },
  { "ulabox.com", true },
  { "ulabox.es", true },
  { "ulmo.dk", true },
  { "ulrik.moe", true },
  { "ultieme.be", true },
  { "umassfive.coop", true },
  { "umgardi.ca", true },
  { "umisonoda.com", true },
  { "umwandeln-online.de", true },
  { "un-zero-un.fr", true },
  { "unapp.me", true },
  { "unblocked-networks.org", true },
  { "under30stravelinsurance.com.au", true },
  { "undernet.uy", true },
  { "undo.co.il", true },
  { "undone.me", true },
  { "unexpected.nu", true },
  { "unfiltered.nyc", true },
  { "uni-games.com", true },
  { "unicef.pl", true },
  { "unicooo.com", true },
  { "unicredit.ba", true },
  { "unicredit.ro", true },
  { "unicreditbank.hu", true },
  { "unicreditbank.rs", true },
  { "unicreditbank.ru", true },
  { "uniekglas.nl", true },
  { "uniform-agri.com", true },
  { "unila.edu.br", true },
  { "unionplat.ru", true },
  { "unionstationapp.com", true },
  { "unison.com", true },
  { "unit7jazz.com", true },
  { "unit7jazz.org", true },
  { "united.com", false },
  { "unitedadmins.com", true },
  { "unitel2000.de", true },
  { "universalcarremote.com", true },
  { "universalpaymentgateway.com", true },
  { "university4industry.com", true },
  { "universogay.com", true },
  { "unixadm.org", false },
  { "unknownphenomena.net", true },
  { "uno-pizza.ru", true },
  { "unoccupyabq.org", true },
  { "unpossible.xyz", true },
  { "unpr.dk", true },
  { "unravel.ie", true },
  { "uns.vn", true },
  { "unseen.tw", true },
  { "unsystem.net", true },
  { "unterfrankenclan.de", true },
  { "unterschicht.tv", true },
  { "untoldstory.eu", true },
  { "unun.fi", true },
  { "unwiredbrain.com", true },
  { "unyq.me", false },
  { "uonstaffhub.com", true },
  { "uow.ninja", true },
  { "up1.ca", true },
  { "upani.net", true },
  { "upboard.jp", true },
  { "upitnik.rs", true },
  { "upload.facebook.com", false },
  { "uploadbeta.com", true },
  { "upstats.eu", true },
  { "upstox.com", true },
  { "uptic.net", true },
  { "uptimed.com", true },
  { "uptimenotguaranteed.com", true },
  { "uptrends.com", true },
  { "uptrends.de", true },
  { "ur-lauber.de", true },
  { "urandom.eu.org", true },
  { "urban.melbourne", true },
  { "urbanesecurity.com", true },
  { "urbanmelbourne.info", true },
  { "uripura.de", true },
  { "urlchomp.com", true },
  { "urspringer.de", true },
  { "us-immigration.com", true },
  { "usaa.com", false },
  { "usaab.org", true },
  { "usakitchensandflooring.com", true },
  { "usbcraft.com", true },
  { "usbirthcertificate.com", true },
  { "usbtypeccompliant.com", true },
  { "uscntalk.com", true },
  { "usd.de", true },
  { "use.be", true },
  { "usercare.com", true },
  { "useresponse.com", true },
  { "usgande.com", true },
  { "usimmigration.us", true },
  { "usitcolours.bg", true },
  { "usleep.net", true },
  { "usparklodging.com", true },
  { "uspsoig.gov", true },
  { "ust.space", true },
  { "utdsgda.com", true },
  { "utilia.tools", true },
  { "utilityapi.com", true },
  { "utleieplassen.no", true },
  { "utonia.ch", true },
  { "utopianhomespa.com", true },
  { "utopians.dk", true },
  { "uttnetgroup.fr", true },
  { "uvarov.pw", false },
  { "v0tti.com", false },
  { "v2.pw", true },
  { "vaddder.com", true },
  { "vagrantup.com", true },
  { "vakuutuskanava.fi", true },
  { "val-sec.com", true },
  { "valentin-sundermann.de", true },
  { "validbrands.com", true },
  { "valkohattu.fi", true },
  { "valkyrja.xyz", true },
  { "valleyridgepta.org", true },
  { "vallis.net", true },
  { "valmagus.com", true },
  { "valopv.be", true },
  { "valordolarblue.com.ar", true },
  { "valshamar.is", true },
  { "valsk.is", true },
  { "valtoaho.com", true },
  { "vampirism.eu", true },
  { "vandalfsen.me", true },
  { "vanestack.com", true },
  { "vanetv.com", true },
  { "vangeluwedeberlaere.be", true },
  { "vanhoutte.be", true },
  { "vanitas.xyz", true },
  { "vanitynailworkz.com", true },
  { "vanlaanen.com", true },
  { "vansieleghem.com", true },
  { "vantien.com", true },
  { "vantru.is", true },
  { "vapemania.eu", true },
  { "vapordepot.jp", true },
  { "varden.info", true },
  { "varghese.de", true },
  { "varunagw.com", false },
  { "varvy.com", true },
  { "vat-eu.com", true },
  { "vattulainen.fi", true },
  { "vaultproject.io", true },
  { "vavai.net", true },
  { "vazue.com", true },
  { "vbest.net", true },
  { "vbhelp.org", true },
  { "vbulletin-russia.com", true },
  { "vbulletinrussia.com", true },
  { "vcientertainment.com", true },
  { "vcr.re", true },
  { "vcsjones.com", true },
  { "vdbongard.com", true },
  { "vdcomp.cz", true },
  { "vdrpro.com", true },
  { "ve.search.yahoo.com", false },
  { "veblen.com", true },
  { "vechkasov.ru", true },
  { "vegalitarian.org", true },
  { "veggiesbourg.fr", true },
  { "veil-framework.com", true },
  { "velasense.com", true },
  { "venicerealdeal.com", true },
  { "venturepro.com", true },
  { "verifikatorindonesia.com", true },
  { "veriny.tf", true },
  { "verizonguidelines.com", true },
  { "versbeton.nl", true },
  { "versia.ru", true },
  { "versicherungskontor.net", true },
  { "veryhax.de", true },
  { "vespacascadia.com", true },
  { "vetdnacenter.com", true },
  { "vetinte.eu", false },
  { "vfdworld.com", true },
  { "vfree.org", true },
  { "vgatest.nl", true },
  { "vglimg.com", true },
  { "vhost.co.id", true },
  { "viaprinto.de", true },
  { "viasinc.com", false },
  { "viciousviscosity.xyz", true },
  { "victorcanera.com", true },
  { "victorjacobs.com", true },
  { "vid-immobilien.de", true },
  { "vide-greniers.org", true },
  { "vide-maisons.org", true },
  { "videogamesartwork.com", true },
  { "videomail.io", false },
  { "videotogel.net", true },
  { "vidid.net", true },
  { "vieclam24h.vn", false },
  { "viemeister.com", true },
  { "viennan.net", true },
  { "viewmyrecords.com", true },
  { "vigilantnow.com", true },
  { "vigilo.cf", true },
  { "vigilo.ga", true },
  { "vigo-krankenversicherung.de", true },
  { "vigo-tarife.de", true },
  { "vijos.org", true },
  { "vikasbabyworld.de", true },
  { "vikashkumar.me", true },
  { "vikings.net", true },
  { "viktorsvantesson.net", true },
  { "villenvinkit.com", true },
  { "vimeo.com", true },
  { "vincentcox.com", true },
  { "vincentkooijman.at", true },
  { "vincentkooijman.nl", true },
  { "vincentpancol.com", true },
  { "vincitraining.com", true },
  { "vintageheartcoffee.com", true },
  { "vinyculture.com", true },
  { "viperdns.com", true },
  { "vipmusic.ga", true },
  { "vipnettikasinoklubi.com", true },
  { "virtualdesignmedia.com", true },
  { "virtualsanity.com", true },
  { "viscopic.com", true },
  { "visioflux-premium.com", true },
  { "visionless.me", false },
  { "visiontree-beta.eu", true },
  { "visiontree.eu", true },
  { "vistaalmar.es", true },
  { "vistarait.com", true },
  { "vistb.me", true },
  { "vitagenda.nl", true },
  { "vitalita.cz", true },
  { "vitalorange.com", true },
  { "vitapingu.de", true },
  { "vitkausk.as", true },
  { "vitrado.de", true },
  { "vitta.me", true },
  { "vivaldi.club", true },
  { "vivatv.com.tw", true },
  { "vivendi.de", true },
  { "viviotech.net", false },
  { "vjirovsky.cz", true },
  { "vleij.com", true },
  { "vleij.se", true },
  { "vlora.city", true },
  { "vm0.eu", true },
  { "vmem.jp", true },
  { "vmoagents.com", false },
  { "vmrdev.com", true },
  { "vn.search.yahoo.com", false },
  { "vnvisa.center", true },
  { "vnvisa.ru", true },
  { "vocaloid.my", true },
  { "voceinveste.com", true },
  { "vogt.tech", true },
  { "voidi.ca", true },
  { "vokeapp.com", true },
  { "volcrado.com", true },
  { "volkergropp.de", true },
  { "vomitb.in", true },
  { "vonavycukor.sk", true },
  { "vonedelmann.de", true },
  { "vop.li", true },
  { "vorlif.org", true },
  { "vorodevops.com", true },
  { "votocek.cz", true },
  { "votockova.cz", true },
  { "vpl.me", false },
  { "vpn.ht", true },
  { "vpnhot.com", true },
  { "vpnzoom.com", true },
  { "vps-szerver-berles.hu", true },
  { "vratny.space", true },
  { "vrobert.fr", false },
  { "vrtak-cz.net", true },
  { "vsean.net", true },
  { "vserver-preis-vergleich.de", true },
  { "vsund.de", true },
  { "vulnerability.ch", true },
  { "vulners.com", true },
  { "vumetric.com", true },
  { "vuosaarenmontessoritalo.fi", true },
  { "vux.li", true },
  { "vxapps.com", true },
  { "vxstream-sandbox.com", true },
  { "vyber-odhadce.cz", true },
  { "vyberodhadce.cz", true },
  { "vyplnto.cz", true },
  { "vzk.io", false },
  { "w-spotlight.appspot.com", true },
  { "w.wiki", true },
  { "w4a.fr", true },
  { "w4nvu.org", true },
  { "w4xzr.top", true },
  { "w4xzr.xyz", true },
  { "wa-stromerzeuger.de", true },
  { "wachter.biz", true },
  { "waelti.xxx", true },
  { "waffle.at", true },
  { "wail.net", true },
  { "wait.jp", true },
  { "waka-mono.com", true },
  { "wakamiyasumiyosi.com", true },
  { "wakened.net", true },
  { "walkeryoung.ca", true },
  { "walkingforhealth.org.uk", true },
  { "wallet.google.com", true },
  { "wallpapers.pub", true },
  { "wallsblog.dk", true },
  { "walnutgaming.co.uk", false },
  { "walnutgaming.com", false },
  { "wan.pp.ua", true },
  { "wanban.io", true },
  { "wander.al", true },
  { "wangqiliang.cn", true },
  { "wangqiliang.com", true },
  { "wangqiliang.xn--fiqs8s", true },
  { "wangql.cn", true },
  { "wangql.net", true },
  { "warandpeace.xyz", true },
  { "warekon.com", true },
  { "warhaggis.com", true },
  { "warhistoryonline.com", true },
  { "warmservers.com", true },
  { "warped.com", true },
  { "warr.ath.cx", true },
  { "warrencreative.com", false },
  { "warsentech.com", true },
  { "warsh.moe", true },
  { "wartorngalaxy.com", true },
  { "wasema.com", true },
  { "wasserspucker.de", true },
  { "wassim.is", true },
  { "watchium.com", true },
  { "waterfedpole.com", true },
  { "watersb.org", true },
  { "watertrails.io", true },
  { "watsonhall.uk", true },
  { "wave.is", true },
  { "wavefrontsystemstech.com", true },
  { "wavesboardshop.com", true },
  { "waylaydesign.com", true },
  { "waze.com", true },
  { "wbg-vs.de", true },
  { "wdbgroup.co.uk", true },
  { "wdesk.com", true },
  { "wdt.cz", true },
  { "wealthcentral.com.au", true },
  { "wealthprojector.com", true },
  { "wealthprojector.com.au", true },
  { "wealthreport.com.au", true },
  { "wear2work.nl", true },
  { "wearandcare.net", true },
  { "wearvr.com", true },
  { "weather-and-climate.com", true },
  { "weathermyway.rocks", true },
  { "web.cc", true },
  { "web4all.fr", true },
  { "web4pro.fr", true },
  { "webandmore.de", false },
  { "webandwords.com.au", true },
  { "webassadors.com", false },
  { "webchat.domains", true },
  { "webcollect.org.uk", true },
  { "webdesign-kronberg.de", true },
  { "webdesigneauclaire.com", true },
  { "webdevops.io", true },
  { "webeau.com", true },
  { "webelement.sk", true },
  { "webergrillrestaurant.com", true },
  { "webfilings-eu-mirror.appspot.com", true },
  { "webfilings-eu.appspot.com", true },
  { "webfilings-mirror-hrd.appspot.com", true },
  { "webfilings.appspot.com", true },
  { "webhosting4.net", true },
  { "weblogic.pl", true },
  { "weblogzwolle.nl", true },
  { "webm.to", true },
  { "webmail.gigahost.dk", false },
  { "webmail.onlime.ch", false },
  { "webmail.schokokeks.org", false },
  { "webmaniabr.com", true },
  { "webmarketingfestival.it", true },
  { "webmax.com.tr", true },
  { "webnosql.com", true },
  { "webogram.org", true },
  { "webperformance.ru", true },
  { "webrebels.org", true },
  { "webs4all.ro", true },
  { "webscale.nl", true },
  { "websectools.com", true },
  { "webseitendesigner.com", false },
  { "webseitenserver.com", true },
  { "websenat.de", true },
  { "webstore.be", true },
  { "webstory.xyz", true },
  { "webstudio-n.com", true },
  { "webstylemedia.com", true },
  { "webswitch.io", true },
  { "webtalis.nl", true },
  { "webtasarim.pw", true },
  { "webtheapp.com", true },
  { "webtiles.co.uk", true },
  { "webtobesocial.de", true },
  { "webtorrent.io", true },
  { "webtrh.cz", true },
  { "webwit.nl", true },
  { "webwork.pw", true },
  { "webyazilimankara.com", true },
  { "webzanem.com", true },
  { "weeblr.com", true },
  { "weekdone.com", true },
  { "weekly-residence.com", true },
  { "weggeweest.nl", true },
  { "wegner.no", true },
  { "weicn.org", true },
  { "weirdesigns.com", true },
  { "weisse-liste.de", true },
  { "welches-kinderfahrrad.de", true },
  { "welcomehelp.de", true },
  { "wellacapability.com", true },
  { "wellastore.ru", true },
  { "welldrake.com", true },
  { "wellensteyn.ru", true },
  { "welovemail.com", true },
  { "welpy.com", false },
  { "welteneroberer.de", true },
  { "weltengilde.de", true },
  { "weltenhueter.de", true },
  { "weltmeisterschaft.net", true },
  { "wenjs.me", true },
  { "wepay.com", false },
  { "wepay.in.th", true },
  { "wer-kommt-her.de", true },
  { "werally.com", true },
  { "werbewelt-tv.de", true },
  { "werken-bij-inwork.nl", true },
  { "werkenbijkfc.nl", true },
  { "wesleycabus.be", true },
  { "wesleyharris.ca", true },
  { "wessner.org", true },
  { "westcountrystalking.com", true },
  { "westeros.hu", true },
  { "westsuburbanbank.com", true },
  { "westsussexconnecttosupport.org", true },
  { "wetofu.top", true },
  { "wetoxic.com", true },
  { "wetthost.com", true },
  { "wetttipps.com", true },
  { "wetttipps.de", true },
  { "wevahoo.com", true },
  { "wevolver.com", true },
  { "wf-bigsky-master.appspot.com", true },
  { "wf-demo-eu.appspot.com", true },
  { "wf-demo-hrd.appspot.com", true },
  { "wf-dogfood-hrd.appspot.com", true },
  { "wf-hosting.de", true },
  { "wf-pentest.appspot.com", true },
  { "wf-staging-hr.appspot.com", true },
  { "wf-training-hrd.appspot.com", true },
  { "wf-training-master.appspot.com", true },
  { "wf-trial-hrd.appspot.com", true },
  { "wfh.ovh", true },
  { "wfh.se", true },
  { "wftda.com", true },
  { "whatanime.ga", true },
  { "whatnext.limited", true },
  { "whatsapp.com", true },
  { "whatsmychaincert.com", true },
  { "whatsstalk.me", true },
  { "whatsupgold.com.tw", true },
  { "whatwg.org", true },
  { "whd-guide.de", true },
  { "when-release.ru", false },
  { "when.fm", true },
  { "whereisjason.com", true },
  { "wherephoto.com", true },
  { "whey-protein.ch", true },
  { "whiskeyriver.co.uk", true },
  { "whiskynerd.ca", true },
  { "whisp.ly", true },
  { "whispeer.de", true },
  { "whitehouse.gov", true },
  { "whocalld.com", true },
  { "whocalled.us", true },
  { "wholebites.com", true },
  { "wholesomeharvestbread.com", true },
  { "wholikes.us", true },
  { "whonix.org", true },
  { "whoshotya.de", true },
  { "wiberg.nu", true },
  { "wideboxmacau.com", true },
  { "widememory.com", true },
  { "wiedu.net", true },
  { "wienholding.at", true },
  { "wieninternational.at", true },
  { "wifimask.com", true },
  { "wifirst.net", true },
  { "wiimotion.de", true },
  { "wiire.me", true },
  { "wijnservices.nl", true },
  { "wiki.python.org", true },
  { "wikibooks.org", true },
  { "wikiclash.info", false },
  { "wikidata.org", true },
  { "wikidsystems.com", false },
  { "wikimediafoundation.org", true },
  { "wikimilk.org", true },
  { "wikinews.org", true },
  { "wikipedia.org", true },
  { "wikiquote.org", true },
  { "wikisource.org", true },
  { "wikiversity.org", true },
  { "wikivoyage.org", true },
  { "wiktionary.org", true },
  { "wiktoriaslife.com", true },
  { "wildbee.org", true },
  { "wilddog.com", true },
  { "wilf1rst.com", true },
  { "willberg.bayern", true },
  { "willcipriano.com", true },
  { "william.si", true },
  { "williamfeely.info", true },
  { "williamsapiens.com", true },
  { "williamsonshore.com", true },
  { "willnorris.com", true },
  { "willosagiede.com", true },
  { "wills.co.tt", true },
  { "wimake.solutions", true },
  { "wind.moe", true },
  { "windrunner.se", true },
  { "windscribe.com", true },
  { "winebid.com", true },
  { "winecodeavocado.com", true },
  { "winghill.com", true },
  { "wingumd.net", true },
  { "winhistory-forum.net", true },
  { "winmodels.org", true },
  { "winmodels.ru", true },
  { "winpack.cf", true },
  { "winpack.eu.org", true },
  { "winsec.nl", true },
  { "winter.engineering", false },
  { "winterfeldt.de", true },
  { "wintodoor.com", true },
  { "wipply.com", false },
  { "wirc.gr", true },
  { "wiretrip.io", true },
  { "wis.no", true },
  { "wispapp.com", true },
  { "wisv.ch", true },
  { "wisweb.no", true },
  { "witae.com", true },
  { "withgoogle.com", true },
  { "withinsecurity.com", true },
  { "withmy.beer", true },
  { "withyoutube.com", true },
  { "wittcher.com", true },
  { "wittydonut.com", true },
  { "witway.nl", false },
  { "wizzley.com", true },
  { "wizzr.nl", true },
  { "wje-online.de", true },
  { "wjglerum.nl", true },
  { "wkv.com", true },
  { "wlaws.com", true },
  { "wlzhiyin.cn", true },
  { "wm-talk.net", true },
  { "wmcuk.net", true },
  { "wnu.com", true },
  { "wo2forum.nl", true },
  { "wodka-division.de", true },
  { "wofford-ecs.org", true },
  { "wohlgemuth.rocks", false },
  { "wohnsitz-ausland.com", true },
  { "wolfachtal-alpaka.de", true },
  { "wolfemg.com", true },
  { "wolfesden.com", true },
  { "wolfsden.cz", true },
  { "wolfwings.us", true },
  { "womb.city", true },
  { "womf.org", true },
  { "wonder.com.mx", true },
  { "wonderhost.info", true },
  { "wonderlandmovies.de", true },
  { "wondermags.com", true },
  { "wondershift.biz", true },
  { "wondy.com", true },
  { "woodbury.io", true },
  { "woodlandschurch.net", true },
  { "woodlandsmetro.church", true },
  { "woodomat.com", true },
  { "woording.com", true },
  { "wootton95.com", true },
  { "worcesterfestival.co.uk", true },
  { "word-grabber.com", true },
  { "wordsmart.it", true },
  { "wordxtra.net", true },
  { "woresite.jp", true },
  { "workfone.io", true },
  { "workingclassmedia.com", true },
  { "workray.com", true },
  { "workwithgo.com", true },
  { "worldcubeassociation.org", true },
  { "woutergeraedts.nl", true },
  { "woutervdb.com", true },
  { "wow-foederation.de", true },
  { "wowapi.org", true },
  { "wownmedia.com", true },
  { "wp-tao.com", true },
  { "wpac.de", true },
  { "wpfortify.com", true },
  { "wphostingblog.nl", true },
  { "wpletter.de", false },
  { "wpmeetup-berlin.de", true },
  { "wpostats.com", true },
  { "wpserp.com", true },
  { "wpvulndb.com", true },
  { "wql.zj.cn", true },
  { "wrara.org", true },
  { "wrgms.com", true },
  { "wrightdoumawedding.com", true },
  { "wrldevelopment.com", true },
  { "wrwg.ca", true },
  { "wsa.poznan.pl", true },
  { "wscales.com", true },
  { "wss.com.ve", true },
  { "wtfismyip.com", true },
  { "wth.in", true },
  { "wubocong.com", true },
  { "wubthecaptain.eu", true },
  { "wuetix.de", true },
  { "wufu.org", true },
  { "wunderkarten.de", true },
  { "wunderlist.com", true },
  { "wundi.net", true },
  { "wurzelzwerg.net", true },
  { "wvg.myds.me", true },
  { "wvr-law.de", false },
  { "ww2onlineshop.com", false },
  { "www.aclu.org", false },
  { "www.airbnb.com", true },
  { "www.apollo-auto.com", true },
  { "www.banking.co.at", false },
  { "www.capitainetrain.com", false },
  { "www.captaintrain.com", false },
  { "www.cloudflare.com", false },
  { "www.cyveillance.com", true },
  { "www.dropbox.com", true },
  { "www.dropcam.com", false },
  { "www.entropia.de", false },
  { "www.eternalgoth.co.uk", true },
  { "www.etsy.com", true },
  { "www.evernote.com", false },
  { "www.facebook.com", false },
  { "www.fastmail.com", true },
  { "www.gamesdepartment.co.uk", false },
  { "www.getcloak.com", false },
  { "www.gmail.com", false },
  { "www.googlemail.com", false },
  { "www.gov.uk", false },
  { "www.gpo.gov", false },
  { "www.grc.com", false },
  { "www.healthcare.gov", false },
  { "www.heliosnet.com", true },
  { "www.honeybadger.io", false },
  { "www.icann.org", false },
  { "www.intercom.io", false },
  { "www.irccloud.com", false },
  { "www.lastpass.com", false },
  { "www.linode.com", false },
  { "www.lookout.com", false },
  { "www.makeyourlaws.org", true },
  { "www.mydigipass.com", false },
  { "www.mylookout.com", false },
  { "www.noisebridge.net", false },
  { "www.opsmate.com", true },
  { "www.paypal.com", false },
  { "www.python.org", true },
  { "www.rememberthemilk.com", true },
  { "www.schokokeks.org", true },
  { "www.simbolo.co.uk", false },
  { "www.simple.com", false },
  { "www.therapynotes.com", true },
  { "www.tinfoilsecurity.com", false },
  { "www.torproject.org", false },
  { "www.twitter.com", false },
  { "www.united.com", false },
  { "www.usaa.com", false },
  { "www.viasinc.com", true },
  { "www.vino75.com", false },
  { "www.wepay.com", false },
  { "wxcafe.net", true },
  { "wxster.com", true },
  { "wyeworks.com", true },
  { "wzrd.in", true },
  { "wzyboy.org", true },
  { "x.io", true },
  { "x.st", true },
  { "x3led.com", true },
  { "x509.io", true },
  { "x64architecture.com", true },
  { "xa1.uk", true },
  { "xalqbank-online.az", true },
  { "xandocs.com", true },
  { "xatr0z.org", false },
  { "xbb.hk", true },
  { "xbb.li", true },
  { "xbind.io", true },
  { "xboxdownloadthat.com", true },
  { "xbrlsuccess.appspot.com", true },
  { "xbt.co", true },
  { "xcentricmold.com", true },
  { "xcoop.me", true },
  { "xd.cm", true },
  { "xdd.io", true },
  { "xdeftor.com", true },
  { "xellos.ml", true },
  { "xendo.net", true },
  { "xenesisziarovky.sk", true },
  { "xetown.com", true },
  { "xett.com", true },
  { "xf-liam.com", true },
  { "xg3n1us.de", true },
  { "xgclan.com", true },
  { "xho.me", true },
  { "xiangweiqing.co.uk", true },
  { "xiaody.me", true },
  { "xiaofengsky.com", true },
  { "xiaoguo.net", true },
  { "xiaolan.me", true },
  { "xiaolvmu.me", true },
  { "xichtsbuch.de", true },
  { "xichuangke.com", true },
  { "xilef.org", true },
  { "xinbiji.cn", true },
  { "xkviz.net", true },
  { "xmerak.com", true },
  { "xmpp.dk", true },
  { "xmppwocky.net", true },
  { "xmr.to", true },
  { "xn--3lqp21gwna.cn", true },
  { "xn--3lqp21gwna.xn--fiqs8s", true },
  { "xn--3lqp21gwna.xn--fiqz9s", true },
  { "xn--3lqt7ir4md4tzwa.cn", true },
  { "xn--3lqt7ir4md4tzwa.xn--fiqs8s", true },
  { "xn--4dbjwf8c.cf", true },
  { "xn--4dbjwf8c.ga", true },
  { "xn--4dbjwf8c.ml", true },
  { "xn--4dbjwf8c.tk", true },
  { "xn--7xa.google.com", true },
  { "xn--datenrettung-mnchen-jbc.com", true },
  { "xn--hfk-allgu-schwaben-stb.de", true },
  { "xn--jobbrse-d1a.de", true },
  { "xn--jp-6l5cs1yf3ivjsglphyv.net", true },
  { "xn--knstler-n2a.tips", false },
  { "xn--lgb3a8bcpn.cf", true },
  { "xn--lgb3a8bcpn.ga", true },
  { "xn--lgb3a8bcpn.gq", true },
  { "xn--lgb3a8bcpn.ml", true },
  { "xn--ls8hi7a.tk", true },
  { "xn--maraa-rta.org", true },
  { "xn--mgbbh2a9fub.xn--ngbc5azd", true },
  { "xn--pbt947am3ab71g.com", true },
  { "xn--qckss0j.tk", true },
  { "xn--t8j4aa4nyhxa7duezbl49aqg5546e264d.net", true },
  { "xn--u9jv84l7ea468b.com", true },
  { "xnode.org", false },
  { "xoffy.com", true },
  { "xolphin.nl", true },
  { "xotika.tv", true },
  { "xpd.se", true },
  { "xps2pdf.co.uk", true },
  { "xqin.net", true },
  { "xrockx.de", true },
  { "xsmobile.de", true },
  { "xss.ht", true },
  { "xss.sk", true },
  { "xtremegaming.it", true },
  { "xtrim.ru", true },
  { "xtronics.com", true },
  { "xuc.me", true },
  { "xuexb.com", true },
  { "xunn.io", true },
  { "xuntier.ch", true },
  { "xwalck.se", true },
  { "xwaretech.info", true },
  { "xxbase.com", false },
  { "xyfun.net", true },
  { "yacobo.com", true },
  { "yafuoku.ru", true },
  { "yagihiro.tech", true },
  { "yahvehyireh.com", true },
  { "yak.is", true },
  { "yakmade.com", true },
  { "yakmoo.se", true },
  { "yal.sh", true },
  { "yamadaya.tv", true },
  { "yamaken.jp", true },
  { "yamamo10.com", true },
  { "yameveo.com", true },
  { "yanaduday.com", true },
  { "yanovich.net", true },
  { "yanwh.xyz", true },
  { "yaoidreams.com", true },
  { "yapbreak.fr", true },
  { "yaporn.tv", false },
  { "yatesun.com", true },
  { "yawnbox.com", true },
  { "yaxim.org", true },
  { "ycc.wtf", true },
  { "ydy.jp", true },
  { "yecl.net", true },
  { "yello.website", true },
  { "yellowcar.website", true },
  { "yenniferallulli.com", true },
  { "yenniferallulli.de", true },
  { "yenniferallulli.es", true },
  { "yenniferallulli.moda", true },
  { "yenniferallulli.nl", true },
  { "yesonline.asia", true },
  { "yesonline.me", true },
  { "yetcore.io", true },
  { "yetzt.me", false },
  { "yhaupenthal.org", true },
  { "yinlei.org", true },
  { "yippie.nl", true },
  { "yjsw.sh.cn", true },
  { "yksityisyydensuoja.fi", true },
  { "ymarion.de", true },
  { "ynode.co", true },
  { "ynode.com", true },
  { "yobst.tk", true },
  { "yolobert.de", true },
  { "yoloprod.fr", true },
  { "yoloseo.com", true },
  { "yombo.net", true },
  { "yoramvandevelde.net", true },
  { "yorcom.nl", true },
  { "yorname.ml", true },
  { "yosemo.de", true },
  { "youcancraft.de", true },
  { "youcontrol.ru", true },
  { "youdowell.com", true },
  { "youkaryote.com", true },
  { "youkaryote.org", true },
  { "youkok2.com", true },
  { "yoursecondphone.co", true },
  { "yourstrongbox.com", true },
  { "yourznc.com", true },
  { "youtous.me", true },
  { "youyoulemon.com", true },
  { "ypart.eu", true },
  { "ypiresia.fr", true },
  { "yplanapp.com", true },
  { "ys-shop.biz", true },
  { "ytvwld.de", true },
  { "yuan.ga", true },
  { "yufan.me", true },
  { "yuhen.ru", true },
  { "yuko.moe", true },
  { "yum.beer", true },
  { "yunity.org", true },
  { "yunzhu.li", true },
  { "yunzhu.org", true },
  { "yusa.me", false },
  { "yutabon.com", true },
  { "yuyu.io", true },
  { "yvesx.com", true },
  { "yyyy.xyz", true },
  { "z-vector.com", true },
  { "z.ai", true },
  { "z0rro.net", true },
  { "z1h.de", true },
  { "z33.ch", true },
  { "zaalleatherwear.nl", true },
  { "zacarias.com.ar", true },
  { "zadieheimlich.com", true },
  { "zadroweb.com", true },
  { "zahe.me", true },
  { "zakmccrac.de", true },
  { "zalan.do", true },
  { "zamorano.edu", true },
  { "zap.yt", true },
  { "zapier.com", true },
  { "zaufanatrzeciastrona.pl", true },
  { "zbasenem.pl", true },
  { "zberger.com", true },
  { "zbigniewgalucki.eu", true },
  { "zbp.at", true },
  { "zcarot.com", false },
  { "zcarrot.com", true },
  { "zcon.nl", true },
  { "zdbl.de", true },
  { "zdrojak.cz", true },
  { "ze3kr.com", true },
  { "zebry.nl", true },
  { "zeedroom.be", true },
  { "zefu.ca", true },
  { "zehdenick-bleibt-bunt.de", true },
  { "zehntner.ch", true },
  { "zeitzer-turngala.de", true },
  { "zellari.ru", true },
  { "zen-trader.com", false },
  { "zenithmedia.ca", true },
  { "zeno-system.com", true },
  { "zentraler-kreditausschuss.de", true },
  { "zenvideocloud.com", true },
  { "zeplin.io", true },
  { "zera.com.au", true },
  { "zerekin.net", true },
  { "zerocool.io", true },
  { "zeropush.com", true },
  { "zertif.info", true },
  { "zerudi.com", true },
  { "zespia.tw", true },
  { "zeto365.pl", true },
  { "zetorzeszow.pl", true },
  { "zett4.me", true },
  { "zgrep.org", true },
  { "zhang-hao.com", true },
  { "zhanghao.me", true },
  { "zhangruilin.com", true },
  { "zhangyuhao.com", true },
  { "zhaofeng.li", true },
  { "zhh.in", true },
  { "zhihua-lai.com", true },
  { "zhovner.com", true },
  { "zifb.in", true },
  { "zima.io", true },
  { "zimiao.moe", true },
  { "zingarastore.com", true },
  { "zionvps.com", true },
  { "zippy-download.com", true },
  { "zippy-download.de", true },
  { "zixiao.wang", true },
  { "zizoo.com", true },
  { "zju.tv", true },
  { "zjubtv.com", true },
  { "zjutv.com", true },
  { "zlatosnadno.cz", true },
  { "zlavomat.sk", true },
  { "zmy.im", true },
  { "znation.nl", true },
  { "zocken.com", true },
  { "zoe.vc", true },
  { "zoeller.me", true },
  { "zohar.wang", true },
  { "zoneminder.com", true },
  { "zonglovani.info", true },
  { "zoomingin.net", true },
  { "zooom.azurewebsites.net", true },
  { "zooparadies.eu", true },
  { "zorium.org", true },
  { "zorntt.fr", true },
  { "zortium.report", true },
  { "zorz.info", true },
  { "zotero.org", true },
  { "zoznamrealit.sk", true },
  { "zravypapir.cz", true },
  { "zrn.in", true },
  { "zscales.com", true },
  { "ztan.tk", true },
  { "zulu7.com", true },
  { "zuram.net", true },
  { "zvncloud.com", true },
  { "zvps.uk", true },
  { "zwerimex.com", true },
  { "zx6rninja.de", true },
  { "zyf.pw", true },
  { "zzsec.org", true },
  { "zzw.ca", true },
};
