/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolValue1;
import gnu.bytecode.MiscAttr;

public class RuntimeAnnotationsAttr
extends MiscAttr {
    int numEntries;

    public RuntimeAnnotationsAttr(String name, byte[] data, AttrContainer container) {
        super(name, data, 0, data.length);
        this.addToFrontOf(container);
        this.numEntries = this.u2(0);
    }

    @Override
    public void print(ClassTypeWriter dst) {
        dst.print("Attribute \"");
        dst.print(this.getName());
        dst.print("\", length:");
        dst.print(this.getLength());
        dst.print(", number of entries: ");
        dst.println(this.numEntries);
        int saveOffset = this.offset;
        this.offset = saveOffset + 2;
        for (int i = 0; i < this.numEntries; ++i) {
            this.printAnnotation(2, dst);
        }
        this.offset = saveOffset;
    }

    public void printAnnotation(int indentation, ClassTypeWriter dst) {
        int type_index = this.u2();
        dst.printSpaces(indentation);
        dst.printOptionalIndex(type_index);
        dst.print('@');
        dst.printContantUtf8AsClass(type_index);
        int num_element_value_pairs = this.u2();
        dst.println();
        indentation += 2;
        for (int i = 0; i < num_element_value_pairs; ++i) {
            int element_name_index = this.u2();
            dst.printSpaces(indentation);
            dst.printOptionalIndex(element_name_index);
            dst.printConstantTersely(element_name_index, 1);
            dst.print(" => ");
            this.printAnnotationElementValue(indentation, dst);
            dst.println();
        }
    }

    public void printAnnotationElementValue(int indentation, ClassTypeWriter dst) {
        int tag = this.u1();
        if ((dst.flags & 8) != 0) {
            dst.print("[kind:");
            if (tag >= 65 && tag <= 122) {
                dst.print((char)tag);
            } else {
                dst.print(tag);
            }
            dst.print("] ");
        }
        int expected = 0;
        switch (tag) {
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                if (expected == 0) {
                    expected = 3;
                }
            }
            case 74: {
                if (expected == 0) {
                    expected = 5;
                }
            }
            case 68: {
                if (expected == 0) {
                    expected = 6;
                }
            }
            case 70: {
                if (expected == 0) {
                    expected = 4;
                }
            }
            case 115: {
                if (expected == 0) {
                    expected = 1;
                }
                int const_value_index = this.u2();
                CpoolEntry entry = dst.getCpoolEntry(const_value_index);
                dst.printOptionalIndex(entry);
                if (tag == 90 && entry != null && entry.getTag() == 3) {
                    CpoolValue1 cint = (CpoolValue1)entry;
                    if (cint.value == 0 || cint.value == 1) {
                        dst.print(cint.value == 0 ? "false" : "true");
                        break;
                    }
                }
                dst.printConstantTersely(const_value_index, expected);
                break;
            }
            case 101: {
                int type_name_index = this.u2();
                int const_name_index = this.u2();
                dst.print("enum[");
                if ((dst.flags & 8) != 0) {
                    dst.print("type:");
                }
                dst.printOptionalIndex(type_name_index);
                dst.printContantUtf8AsClass(type_name_index);
                if ((dst.flags & 8) != 0) {
                    dst.print(" value:");
                } else {
                    dst.print(' ');
                }
                dst.printOptionalIndex(const_name_index);
                dst.printConstantTersely(const_name_index, 1);
                dst.print("]");
                break;
            }
            case 99: {
                int class_info_index = this.u2();
                dst.printOptionalIndex(class_info_index);
                dst.printContantUtf8AsClass(class_info_index);
                break;
            }
            case 64: {
                dst.println();
                dst.printSpaces(indentation + 2);
                this.printAnnotation(indentation + 2, dst);
                break;
            }
            case 91: {
                int num_values = this.u2();
                dst.print("array length:");
                dst.print(num_values);
                for (int i = 0; i < num_values; ++i) {
                    dst.println();
                    dst.printSpaces(indentation + 2);
                    dst.print(i);
                    dst.print(": ");
                    this.printAnnotationElementValue(indentation + 2, dst);
                }
                break;
            }
        }
    }
}

