/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;

public class CodeFragment
extends Label {
    CodeFragment next;
    byte[] insns;
    int length;
    int handlerIndex = -1;
    boolean unreachable_save;
    short[] linenumbers;

    public CodeFragment(CodeAttr codeAttr) {
        super(codeAttr);
    }

    public void emit(CodeAttr codeAttr) {
        codeAttr.reserve(this.length);
        System.arraycopy(this.insns, 0, codeAttr.code, codeAttr.PC, this.length);
        this.define(codeAttr);
        if (this.handlerIndex >= 0) {
            codeAttr.exception_table[4 * this.handlerIndex + 2] = (short)codeAttr.PC;
        }
        if (this.linenumbers != null) {
            for (int i = 0; i < this.linenumbers.length; i += 2) {
                codeAttr.lines.put(this.linenumbers[i + 1], this.linenumbers[i] + codeAttr.PC);
            }
        }
        codeAttr.PC += this.length;
    }
}

