/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure2;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import kawa.standard.Scheme;

public class SlotGet
extends Procedure2
implements HasSetter,
CanInline,
Inlineable {
    static Class[] noClasses = new Class[0];
    boolean isStatic;
    Procedure setter;
    public static final SlotGet field = new SlotGet("field", false, SlotSet.set$Mnfield$Ex);
    public static final SlotGet staticField = new SlotGet("static-field", true, SlotSet.set$Mnstatic$Mnfield$Ex);

    public SlotGet(String string, boolean bl) {
        super(string);
        this.isStatic = bl;
    }

    public SlotGet(String string, boolean bl, Procedure procedure) {
        super(string);
        this.isStatic = bl;
        this.setter = procedure;
    }

    public static Object field(Object object2, String string) {
        return field.apply2(object2, string);
    }

    public static Object staticField(Object object2, String string) {
        return staticField.apply2(object2, string);
    }

    public Object apply2(Object object2, Object object3) {
        Field field;
        Class<?> clazz;
        if (!(object3 instanceof String) && !(object3 instanceof FString)) {
            throw WrongType.make(null, this, 2, object3);
        }
        Language language = Language.getDefaultLanguage();
        String string = Compilation.mangleNameIfNeeded(object3.toString());
        Class<?> clazz2 = clazz = this.isStatic ? SlotGet.coerceToClass(object2) : object2.getClass();
        if (clazz.isArray() && "length".equals(string)) {
            int n = Array.getLength(object2);
            return language.coerceToObject(n);
        }
        if ("class".equals(string)) {
            return clazz;
        }
        boolean bl = false;
        try {
            field = clazz.getField(string);
        }
        catch (Exception exception) {
            field = null;
        }
        if (field != null) {
            if (this.isStatic && (field.getModifiers() & 8) == 0) {
                throw new RuntimeException("cannot access non-static field `" + string + "' using `" + this.getName() + '\'');
            }
            try {
                return language.coerceToObject(field.getType(), field.get(object2));
            }
            catch (IllegalAccessException illegalAccessException) {
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            String string2 = null;
            java.lang.reflect.Method method = null;
            try {
                string2 = ClassExp.slotToMethodName("get", string);
                method = clazz.getMethod(string2, noClasses);
            }
            catch (Exception exception) {
                string2 = ClassExp.slotToMethodName("is", string);
                method = clazz.getMethod(string2, noClasses);
            }
            if (this.isStatic && (method.getModifiers() & 8) == 0) {
                throw new RuntimeException("cannot call non-static getter method `" + string2 + "' using `" + this.getName() + '\'');
            }
            Object object4 = method.invoke(object2, Values.noArgs);
            object4 = language.coerceToObject(method.getReturnType(), object4);
            return object4;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl) {
            throw new RuntimeException("illegal access for field " + string);
        }
        throw new RuntimeException("no such field " + string + " in " + clazz.getName());
    }

    static Class coerceToClass(Object object2) {
        if (object2 instanceof Class) {
            return (Class)object2;
        }
        if (object2 instanceof Type) {
            return ((Type)object2).getReflectClass();
        }
        throw new RuntimeException("argument is neither Class nor Type");
    }

    public void setN(Object[] objectArray) {
        int n = objectArray.length;
        if (n != 3) {
            throw new WrongArguments(this.getSetter(), n);
        }
        this.set2(objectArray[0], objectArray[1], objectArray[2]);
    }

    public void set2(Object object2, Object object3, Object object4) {
        SlotSet.apply(this.isStatic, object2, (String)object3, object4);
    }

    static Object getField(Type type, String string) {
        if (type instanceof ClassType && string != null) {
            ClassType classType = (ClassType)type;
            gnu.bytecode.Field field = classType.getField(Compilation.mangleNameIfNeeded(string));
            if (field != null) {
                return field;
            }
            String string2 = ClassExp.slotToMethodName("get", string);
            Method method = classType.getMethod(string2, Type.typeArray0);
            return method;
        }
        return null;
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        if (this.isStatic) {
            return Invoke.inlineClassName(applyExp, 0, (InlineCalls)expWalker);
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        if (n != 2) {
            String string = n < 2 ? "too few" : "too many";
            compilation.error('e', string + " arguments to `" + this.getName() + '\'');
            compilation.compileConstant(null, target);
            return;
        }
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        Type type = this.isStatic ? Scheme.exp2Type(expression) : expression.getType();
        String string = ClassMethods.checkName(expression2);
        if ("class".equals(string) && type instanceof ClassType) {
            compilation.loadClassRef(type.getName());
            target.compileFromStack(compilation, Type.java_lang_Class_type);
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        if (type instanceof ClassType && string != null) {
            ClassType classType = (ClassType)type;
            ClassType classType2 = compilation.curClass != null ? compilation.curClass : compilation.mainClass;
            Object object2 = SlotGet.getField(classType, string);
            if (object2 instanceof gnu.bytecode.Field) {
                boolean bl;
                gnu.bytecode.Field field = (gnu.bytecode.Field)object2;
                int n2 = field.getModifiers();
                boolean bl2 = bl = (n2 & 8) != 0;
                if (this.isStatic && !bl) {
                    compilation.error('e', "cannot access non-static field `" + string + "' using `" + this.getName() + '\'');
                }
                if (classType2 != null && !classType2.isAccessible(classType, n2)) {
                    compilation.error('e', "field " + classType.getName() + '.' + string + " is not accessible here");
                }
                expressionArray[0].compile(compilation, bl ? Target.Ignore : Target.pushValue(classType));
                if (bl) {
                    boolean bl3 = false;
                    if (!bl3) {
                        codeAttr.emitGetStatic(field);
                    }
                } else {
                    codeAttr.emitGetField(field);
                }
                Type type2 = field.getType();
                Language language = Language.getDefaultLanguage();
                Class clazz = type2.getReflectClass();
                if (clazz != null) {
                    type2 = language.getTypeFor(clazz);
                }
                target.compileFromStack(compilation, type2);
                return;
            }
            if (object2 instanceof Method) {
                Method method = (Method)object2;
                int n3 = method.getModifiers();
                boolean bl = method.getStaticFlag();
                if (this.isStatic && !bl) {
                    compilation.error('e', "cannot call non-static getter method `" + string + "' using `" + this.getName() + '\'');
                }
                if (classType2 != null && !classType2.isAccessible(classType, n3)) {
                    compilation.error('e', "method " + method + " is not accessible here");
                }
                expressionArray[0].compile(compilation, bl ? Target.Ignore : Target.pushValue(classType));
                if (bl) {
                    codeAttr.emitInvokeStatic(method);
                } else if (classType.isInterface()) {
                    codeAttr.emitInvokeInterface(method);
                } else {
                    codeAttr.emitInvokeVirtual(method);
                }
                target.compileFromStack(compilation, method.getReturnType());
                return;
            }
            if (type != Type.pointer_type) {
                compilation.error('e', "no slot `" + string + "' in " + classType.getName());
            }
        } else if (type instanceof ArrayType && "length".equals(string) && !this.isStatic) {
            expressionArray[0].compile(compilation, Target.pushValue(type));
            codeAttr.emitArrayLength();
            target.compileFromStack(compilation, LangPrimType.intType);
            return;
        }
        ApplyExp.compile(applyExp, compilation, target);
    }

    public Type getReturnType(Expression[] expressionArray) {
        int n = expressionArray.length;
        if (n == 2) {
            Expression expression = expressionArray[0];
            Expression expression2 = expressionArray[1];
            Type type = this.isStatic ? Scheme.exp2Type(expression) : expression.getType();
            String string = ClassMethods.checkName(expression2, true);
            if (type instanceof ClassType && string != null) {
                ClassType classType = (ClassType)type;
                Object object2 = SlotGet.getField(classType, string);
                if (object2 instanceof gnu.bytecode.Field) {
                    return ((gnu.bytecode.Field)object2).getType();
                }
                if (object2 instanceof Method) {
                    return ((Method)object2).getReturnType();
                }
            } else if (type instanceof ArrayType && "length".equals(string) && !this.isStatic) {
                return LangPrimType.intType;
            }
        }
        return Type.pointer_type;
    }

    public Procedure getSetter() {
        return this.setter == null ? super.getSetter() : this.setter;
    }

    public static Expression makeGetField(Expression expression, String string) {
        Expression[] expressionArray = new Expression[]{expression, new QuoteExp((Object)string)};
        return new ApplyExp(field, expressionArray);
    }
}

