/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.expr.Compilation;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleSet;
import gnu.mapping.WrappedException;
import gnu.text.Path;
import gnu.text.URLPath;
import java.io.File;
import java.net.URL;

public class ModuleManager {
    private String compilationDirectory = "";
    static ModuleManager instance = new ModuleManager();
    public static final long LAST_MODIFIED_CACHE_TIME = 1000L;
    public long lastModifiedCacheTime = 1000L;
    ModuleInfo[] modules;
    int numModules;
    ModuleSet packageInfoChain;

    public void setCompilationDirectory(String string) {
        int n;
        if (string == null) {
            string = "";
        }
        if ((n = string.length()) > 0) {
            char c = File.separatorChar;
            if (string.charAt(n - 1) != c) {
                string = string + c;
            }
        }
        this.compilationDirectory = string;
    }

    public String getCompilationDirectory() {
        return this.compilationDirectory;
    }

    public static ModuleManager getInstance() {
        return instance;
    }

    public ModuleInfo getModule(int n) {
        return n >= this.numModules ? null : this.modules[n];
    }

    public ModuleInfo find(Compilation compilation) {
        ModuleExp moduleExp = compilation.getModule();
        ClassType classType = moduleExp.classFor(compilation);
        String string = moduleExp.getFileName();
        Path path = ModuleInfo.absPath(string);
        ModuleInfo moduleInfo = this.findWithSourcePath(path, string);
        moduleInfo.className = classType.getName();
        moduleInfo.exp = moduleExp;
        compilation.minfo = moduleInfo;
        moduleInfo.comp = compilation;
        return moduleInfo;
    }

    private void add(ModuleInfo moduleInfo) {
        if (this.modules == null) {
            this.modules = new ModuleInfo[10];
        } else if (this.numModules == this.modules.length) {
            ModuleInfo[] moduleInfoArray = new ModuleInfo[2 * this.numModules];
            System.arraycopy(this.modules, 0, moduleInfoArray, 0, this.numModules);
            this.modules = moduleInfoArray;
        }
        this.modules[this.numModules++] = moduleInfo;
    }

    public ModuleInfo searchWithClassName(String string) {
        int n = this.numModules;
        while (--n >= 0) {
            ModuleInfo moduleInfo = this.modules[n];
            if (!string.equals(moduleInfo.className)) continue;
            return moduleInfo;
        }
        return null;
    }

    public static synchronized ModuleInfo findWithClass(Class clazz) {
        ModuleInfo moduleInfo = (ModuleInfo)ModuleInfo.mapClassToInfo.get(clazz);
        if (moduleInfo == null) {
            moduleInfo = new ModuleInfo();
            moduleInfo.setModuleClass(clazz);
        }
        return moduleInfo;
    }

    public ModuleInfo findWithClassName(String string) {
        ModuleInfo moduleInfo = this.searchWithClassName(string);
        if (moduleInfo != null) {
            return moduleInfo;
        }
        try {
            return ModuleManager.findWithClass(ClassType.getContextClass(string));
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    private ModuleInfo searchWithAbsSourcePath(String string) {
        int n = this.numModules;
        while (--n >= 0) {
            ModuleInfo moduleInfo = this.modules[n];
            if (!string.equals(moduleInfo.getSourceAbsPathname())) continue;
            return moduleInfo;
        }
        return null;
    }

    public synchronized ModuleInfo findWithSourcePath(Path path, String string) {
        String string2 = path.toString();
        ModuleInfo moduleInfo = this.searchWithAbsSourcePath(string2);
        if (moduleInfo == null) {
            moduleInfo = new ModuleInfo();
            moduleInfo.sourcePath = string;
            moduleInfo.sourceAbsPath = path;
            moduleInfo.sourceAbsPathname = string2;
            this.add(moduleInfo);
        }
        return moduleInfo;
    }

    public ModuleInfo findWithSourcePath(String string) {
        return this.findWithSourcePath(ModuleInfo.absPath(string), string);
    }

    public ModuleInfo findWithURL(URL uRL) {
        URLPath uRLPath = URLPath.valueOf(uRL);
        String string = uRL.toExternalForm();
        return this.findWithSourcePath(uRLPath, string);
    }

    public void register(String string, String string2, String string3) {
        if (this.searchWithClassName(string) != null) {
            return;
        }
        Path path = Path.valueOf(string2);
        Path path2 = path.getCanonical();
        String string4 = path2.toString();
        if (this.searchWithAbsSourcePath(string4) != null) {
            return;
        }
        ModuleInfo moduleInfo = new ModuleInfo();
        if (path.isAbsolute()) {
            moduleInfo.sourceAbsPath = path;
            moduleInfo.sourceAbsPathname = string4;
        } else {
            try {
                Class<?> clazz = this.packageInfoChain.getClass();
                String string5 = clazz.getName().replace('.', '/') + ".class";
                URL uRL = clazz.getClassLoader().getResource(string5);
                moduleInfo.sourceAbsPath = path2 = URLPath.valueOf(uRL).resolve(string2);
                moduleInfo.sourceAbsPathname = path2.toString();
            }
            catch (Throwable throwable) {
                return;
            }
        }
        moduleInfo.className = string;
        moduleInfo.sourcePath = string2;
        moduleInfo.uri = string3;
        this.add(moduleInfo);
    }

    public synchronized void loadPackageInfo(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object object2;
        String string2 = string + "." + "$ModulesMap$";
        Object object3 = this.packageInfoChain;
        while (object3 != null) {
            object2 = object3.getClass().getName();
            if (((String)object2).equals(string2)) {
                // empty if block
            }
            object3 = ((ModuleSet)object3).next;
        }
        object3 = Class.forName(string2);
        object2 = (ModuleSet)((Class)object3).newInstance();
        ((ModuleSet)object2).next = this.packageInfoChain;
        this.packageInfoChain = object2;
        ((ModuleSet)object2).register(this);
    }

    public void clear() {
        ModuleSet moduleSet = this.packageInfoChain;
        while (moduleSet != null) {
            ModuleSet moduleSet2 = moduleSet.next;
            moduleSet.next = null;
            moduleSet = moduleSet2;
        }
        this.packageInfoChain = null;
        this.modules = null;
        this.numModules = 0;
    }
}

