/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.models.Display;
import gnu.kawa.models.Model;
import gnu.kawa.models.Paintable;
import gnu.kawa.models.WithTransform;
import gnu.mapping.WrappedException;
import gnu.text.Path;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class DrawImage
extends Model
implements Paintable,
Serializable {
    BufferedImage image;
    Path src;
    String description;

    public DrawImage() {
    }

    public void makeView(Display display, Object object2) {
        display.addImage(this, object2);
    }

    void loadImage() {
        if (this.image == null) {
            try {
                this.image = ImageIO.read(this.src.openInputStream());
            }
            catch (Throwable throwable) {
                throw WrappedException.wrapIfNeeded(throwable);
            }
        }
    }

    public DrawImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void paint(Graphics2D graphics2D) {
        this.loadImage();
        graphics2D.drawImage(this.image, null, null);
    }

    public Rectangle2D getBounds2D() {
        this.loadImage();
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        return new Rectangle2D.Float(0.0f, 0.0f, n, n2);
    }

    public Paintable transform(AffineTransform affineTransform) {
        return new WithTransform(this, affineTransform);
    }

    public Image getImage() {
        this.loadImage();
        return this.image;
    }

    public Path getSrc() {
        return this.src;
    }

    public void setSrc(Path path) {
        this.src = path;
    }
}

