/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.CharSeq;
import java.io.Reader;

public class QueueReader
extends Reader
implements Appendable {
    char[] buffer;
    int readAheadLimit;
    int mark;
    int pos;
    int limit;
    boolean EOFseen;

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        this.readAheadLimit = n;
        this.mark = this.pos;
    }

    public synchronized void reset() {
        if (this.readAheadLimit > 0) {
            this.pos = this.mark;
        }
    }

    void resize(int n) {
        int n2 = this.limit - this.pos;
        if (this.readAheadLimit > 0 && this.pos - this.mark <= this.readAheadLimit) {
            n2 = this.limit - this.mark;
        } else {
            this.mark = this.pos;
        }
        char[] cArray = this.buffer.length < n2 + n ? new char[2 * n2 + n] : this.buffer;
        System.arraycopy(this.buffer, this.mark, cArray, 0, n2);
        this.buffer = cArray;
        this.pos -= this.mark;
        this.mark = 0;
        this.limit = n2;
    }

    public QueueReader append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public synchronized QueueReader append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        int n3 = n2 - n;
        this.reserveSpace(n3);
        int n4 = this.limit;
        char[] cArray = this.buffer;
        if (charSequence instanceof String) {
            ((String)charSequence).getChars(n, n2, cArray, n4);
        } else if (charSequence instanceof CharSeq) {
            ((CharSeq)charSequence).getChars(n, n2, cArray, n4);
        } else {
            int n5 = n4;
            for (int i = n; i < n2; ++i) {
                cArray[n5++] = charSequence.charAt(i);
            }
        }
        this.limit = n4 + n3;
        this.notifyAll();
        return this;
    }

    public void append(char[] cArray) {
        this.append(cArray, 0, cArray.length);
    }

    public synchronized void append(char[] cArray, int n, int n2) {
        this.reserveSpace(n2);
        System.arraycopy(cArray, n, this.buffer, this.limit, n2);
        this.limit += n2;
        this.notifyAll();
    }

    public synchronized QueueReader append(char c) {
        this.reserveSpace(1);
        this.buffer[this.limit++] = c;
        this.notifyAll();
        return this;
    }

    public synchronized void appendEOF() {
        this.EOFseen = true;
    }

    protected void reserveSpace(int n) {
        if (this.buffer == null) {
            this.buffer = new char[100 + n];
        } else if (this.buffer.length < this.limit + n) {
            this.resize(n);
        }
    }

    public synchronized boolean ready() {
        return this.pos < this.limit || this.EOFseen;
    }

    public void checkAvailable() {
    }

    public synchronized int read() {
        while (this.pos >= this.limit) {
            if (this.EOFseen) {
                return -1;
            }
            this.checkAvailable();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        char c = this.buffer[this.pos++];
        return c;
    }

    public synchronized int read(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        while (this.pos >= this.limit) {
            if (this.EOFseen) {
                return -1;
            }
            this.checkAvailable();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        int n3 = this.limit - this.pos;
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(this.buffer, this.pos, cArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public synchronized void close() {
        this.pos = 0;
        this.limit = 0;
        this.mark = 0;
        this.EOFseen = true;
        this.buffer = null;
    }
}

