/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import java.awt.BorderLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import kawa.ReplDocument;
import kawa.ReplPane;
import kawa.repl;

public class GuiConsole
extends JFrame
implements ActionListener,
ReplDocument.DocumentCloseListener {
    private static String CLOSE = "Close";
    private static String EXIT = "Exit";
    private static String NEW = "New";
    private static String NEW_SHARED = "New (Shared)";
    private static String PURGE_MESSAGE = "Purge Buffer";
    static int window_number = 0;
    ReplPane pane;
    ReplDocument document;

    public static void main(String[] stringArray) {
        repl.noConsole = false;
        int n = repl.processArgs(stringArray, 0, stringArray.length);
        repl.getLanguage();
        repl.setArgs(stringArray, n);
        repl.checkInitFile();
        new GuiConsole();
    }

    public GuiConsole() {
        this(Language.getDefaultLanguage(), Environment.getCurrent(), false);
    }

    public GuiConsole(ReplDocument replDocument) {
        super("Kawa");
        this.init(replDocument);
    }

    void init(ReplDocument replDocument) {
        this.document = replDocument;
        this.document.addDocumentCloseListener(this);
        this.pane = new ReplPane(this.document);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", new JScrollPane(this.pane));
        this.setupMenus();
        this.setLocation(100 * ++window_number, 50 * window_number);
        this.setSize(700, 500);
        this.setVisible(true);
    }

    public GuiConsole(Language language, Environment environment, boolean bl) {
        super("Kawa");
        repl.getLanguage();
        this.init(new ReplDocument(language, environment, bl));
    }

    public void closed(ReplDocument replDocument) {
        this.close();
    }

    void close() {
        this.document.removeDocumentCloseListener(this);
        this.dispose();
    }

    private void setupMenus() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GuiConsole.this.close();
            }
        };
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Utilities");
        menuBar.add(menu);
        menuBar.add(menu2);
        MenuItem menuItem = new MenuItem(NEW);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem(NEW_SHARED);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem(CLOSE);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem(EXIT);
        menuItem.addActionListener(this);
        this.addWindowListener(windowAdapter);
        menu.add(menuItem);
        menuItem = new MenuItem(PURGE_MESSAGE);
        menuItem.addActionListener(this);
        menu2.add(menuItem);
        this.setMenuBar(menuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(NEW)) {
            new GuiConsole(this.document.language, Environment.getGlobal(), false);
        } else if (string.equals(NEW_SHARED)) {
            new GuiConsole(this.document.language, this.document.environment, true);
        } else if (string.equals(EXIT)) {
            System.exit(0);
        } else if (string.equals(CLOSE)) {
            this.close();
        } else if (string.equals(PURGE_MESSAGE)) {
            this.pane.document.deleteOldText();
        } else {
            OutPort.outDefault().println("Unknown menu action: " + string);
        }
    }
}

