/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.ScopeExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Procedure;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;
import kawa.standard.require;

public class ImportFromLibrary
extends Syntax {
    public static final ImportFromLibrary instance = new ImportFromLibrary();
    public String[] classPrefixPath = new String[]{"", "kawa.lib."};
    private static final String BUILTIN = "";
    private static final String MISSING = null;
    static final String[][] SRFI97Map = new String[][]{{"1", "lists", "gnu.kawa.slib.srfi1"}, {"2", "and-let*", MISSING}, {"5", "let", MISSING}, {"6", "basic-string-ports", ""}, {"8", "receive", ""}, {"9", "records", ""}, {"11", "let-values", ""}, {"13", "strings", MISSING}, {"14", "char-sets", MISSING}, {"16", "case-lambda", ""}, {"17", "generalized-set!", ""}, {"18", "multithreading", MISSING}, {"19", "time", MISSING}, {"21", "real-time-multithreading", MISSING}, {"23", "error", ""}, {"25", "multi-dimensional-arrays", ""}, {"26", "cut", ""}, {"27", "random-bits", MISSING}, {"28", "basic-format-strings", ""}, {"29", "localization", MISSING}, {"31", "rec", MISSING}, {"38", "with-shared-structure", MISSING}, {"39", "parameters", ""}, {"41", "streams", MISSING}, {"42", "eager-comprehensions", MISSING}, {"43", "vectors", MISSING}, {"44", "collections", MISSING}, {"45", "lazy", MISSING}, {"46", "syntax-rules", MISSING}, {"47", "arrays", MISSING}, {"48", "intermediate-format-strings", MISSING}, {"51", "rest-values", MISSING}, {"54", "cat", MISSING}, {"57", "records", MISSING}, {"59", "vicinities", MISSING}, {"60", "integer-bits", MISSING}, {"61", "cond", MISSING}, {"63", "arrays", MISSING}, {"64", "testing", "gnu.kawa.slib.testing"}, {"66", "octet-vectors", MISSING}, {"67", "compare-procedures", MISSING}, {"69", "basic-hash-tables", "gnu.kawa.slib.srfi69"}, {"71", "let", MISSING}, {"74", "blobs", MISSING}, {"78", "lightweight-testing", MISSING}, {"86", "mu-and-nu", MISSING}, {"87", "case", MISSING}, {"95", "sorting-and-merging", "kawa.lib.srfi95"}};

    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        String string;
        int n;
        Object object2;
        Object object3;
        Procedure procedure = null;
        Object object4 = pair.getCdr();
        if (!(object4 instanceof Pair)) {
            return false;
        }
        Pair pair2 = (Pair)object4;
        Object object5 = pair2.getCar();
        if (LList.listLength(object5, false) <= 0) {
            translator.error('e', "expected <library reference> which must be a list");
            return false;
        }
        Object object6 = pair2.getCdr();
        if (object6 instanceof Pair && ((Pair)object6).getCar() instanceof Procedure) {
            procedure = (Procedure)((Pair)object6).getCar();
        }
        Object object7 = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (object5 instanceof Pair) {
            pair2 = (Pair)object5;
            object3 = pair2.getCar();
            object2 = pair2.getCdr();
            if (object3 instanceof Pair) {
                if (object7 != null) {
                    translator.error('e', "duplicate version reference - was " + object7);
                }
                object7 = object3;
                System.err.println("import version " + object3);
            } else if (object3 instanceof String) {
                if (object2 instanceof Pair) {
                    translator.error('e', "source specifier must be last elemnt in library reference");
                }
                string2 = (String)object3;
            } else {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(Compilation.mangleNameIfNeeded(object3.toString()));
            }
            object5 = object2;
        }
        object3 = null;
        if (string2 != null && (object3 = require.lookupModuleFromSourcePath(string2, scopeExp)) == null) {
            translator.error('e', "malformed URL: " + string2);
            return false;
        }
        object2 = stringBuffer.toString();
        if (((String)object2).startsWith("srfi.")) {
            int n2;
            String string3 = Compilation.demangleName(((String)object2).substring(5));
            n = string3.indexOf(46);
            if (n < 0) {
                string = null;
                n = string3.length();
            } else {
                string = string3.substring(n + 1);
            }
            String string4 = null;
            if (n >= 2 || string3.charAt(0) == ':') {
                n2 = 1;
                while (true) {
                    if (n2 == n) {
                        string4 = string3.substring(1, n);
                        break;
                    }
                    if (Character.digit(string3.charAt(n2), 10) < 0) break;
                    ++n2;
                }
            }
            if (string4 == null) {
                translator.error('e', "SRFI library reference must have the form: (srfi :NNN [name])");
                return false;
            }
            n2 = SRFI97Map.length;
            do {
                if (--n2 >= 0) continue;
                translator.error('e', "unknown SRFI number '" + string4 + "' in SRFI library reference");
                return false;
            } while (!SRFI97Map[n2][0].equals(string4));
            String string5 = SRFI97Map[n2][1];
            String string6 = SRFI97Map[n2][2];
            if (string != null && !string.equals(string5)) {
                translator.error('w', "the name of SRFI " + string4 + " should be '" + string5 + '\'');
            }
            if (string6 == BUILTIN) {
                return true;
            }
            if (string6 == MISSING) {
                translator.error('e', "sorry - Kawa does not support SRFI " + string4 + " (" + string5 + ')');
                return false;
            }
            object2 = string6;
        }
        int n3 = this.classPrefixPath.length;
        for (n = 0; n < n3; ++n) {
            string = this.classPrefixPath[n] + (String)object2;
            try {
                object3 = ModuleManager.getInstance().findWithClassName(string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object3 == null) {
            translator.error('e', "unknown class " + (String)object2);
            return false;
        }
        require.importDefinitions(null, (ModuleInfo)object3, procedure, vector, scopeExp, translator);
        return true;
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        return null;
    }
}

