/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.io;

import gnu.kawa.io.BinaryOutPort;
import gnu.kawa.io.LogWriter;
import gnu.kawa.io.Path;
import gnu.kawa.io.PrettyWriter;
import gnu.kawa.io.WriterManager;
import gnu.lists.AbstractFormat;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.PrintConsumer;
import gnu.mapping.Environment;
import gnu.mapping.ThreadLocation;
import gnu.text.Printable;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;

public class OutPort
extends PrintConsumer
implements Printable {
    Path path;
    protected Writer base;
    static final int FLUSH_ON_FINALIZE = 1;
    static final int CLOSE_ON_FINALIZE = 2;
    static final int IS_CLOSED = 4;
    static final int IS_DOMTERM = 8;
    int flags;
    protected PrettyWriter bout;
    protected WriterManager.WriterRef unregisterRef;
    public boolean printReadable;
    static BinaryOutPort outInitial = BinaryOutPort.makeStandardPort(System.out, "/dev/stdout");
    private static BinaryOutPort errInitial;
    public static final ThreadLocation<OutPort> outLocation;
    public static final ThreadLocation<OutPort> errLocation;
    static Writer logFile;
    NumberFormat numberFormat;
    public AbstractFormat objectFormat;

    protected OutPort(Writer base2, PrettyWriter out, boolean autoflush) {
        super(out, autoflush);
        this.bout = out;
        this.base = base2;
        if (this.closeOnExit()) {
            this.unregisterRef = WriterManager.instance.register(this);
        }
    }

    protected OutPort(OutPort out, boolean autoflush) {
        this((Writer)out, out.bout, autoflush);
    }

    protected OutPort(Writer out, boolean autoflush) {
        this(out, out instanceof OutPort ? ((OutPort)out).bout : new PrettyWriter(out, true), autoflush);
    }

    public OutPort(Writer base2, boolean printPretty, boolean autoflush) {
        this(base2, new PrettyWriter(base2, printPretty), autoflush);
    }

    public OutPort(Writer base2, boolean printPretty, boolean autoflush, Path path) {
        this(base2, new PrettyWriter(base2, printPretty), autoflush);
        this.path = path;
    }

    public OutPort(OutputStream out) {
        this(out, null);
    }

    public OutPort(OutputStream out, Path path) {
        this((Writer)new OutputStreamWriter(out), true, path);
    }

    public OutPort(Writer out) {
        this(out, out instanceof OutPort ? ((OutPort)out).bout : new PrettyWriter(out, false), false);
    }

    public OutPort(Writer base2, Path path) {
        this(base2, false, false);
        this.path = path;
    }

    public OutPort(Writer base2, boolean autoflush, Path path) {
        this(base2, false, autoflush);
        this.path = path;
    }

    public static BinaryOutPort getSystemOut() {
        return outInitial;
    }

    public static BinaryOutPort getSystemErr() {
        return errInitial;
    }

    public static OutPort outDefault() {
        return outLocation.get();
    }

    public static void setOutDefault(OutPort o) {
        outLocation.set(o);
    }

    public static OutPort errDefault() {
        return errLocation.get();
    }

    public static void setErrDefault(OutPort e) {
        errLocation.set(e);
    }

    public PrettyWriter getPrettyWriter() {
        return this.bout;
    }

    public boolean isPrettyPrinting() {
        return this.bout.isPrettyPrinting();
    }

    public static OutPort openFile(Object fname) throws IOException {
        return OutPort.openFile(fname, Environment.user().get("port-char-encoding"));
    }

    public static OutPort openFile(Object fname, Object conv) throws IOException {
        Path path = Path.valueOf(fname);
        OutputStream strm = path.openOutputStream();
        strm = new BufferedOutputStream(strm);
        OutPort op = conv == Boolean.FALSE ? new BinaryOutPort(strm, path) : new OutPort((Writer)(conv == null || conv == Boolean.TRUE ? new OutputStreamWriter(strm) : new OutputStreamWriter(strm, conv.toString())), path);
        op.flags = 2;
        return op;
    }

    public void echo(char[] buf, int off, int len) throws IOException {
        if (this.base instanceof LogWriter) {
            ((LogWriter)this.base).echo(buf, off, len);
        }
    }

    public static void closeLogFile() throws IOException {
        if (logFile != null) {
            logFile.close();
            logFile = null;
        }
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile((Writer)null);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile((Writer)null);
        }
    }

    public static void setLogFile(String name) throws IOException {
        if (logFile != null) {
            OutPort.closeLogFile();
        }
        logFile = new PrintWriter(new BufferedWriter(new FileWriter(name)));
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile(logFile);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile(logFile);
        }
    }

    protected static final boolean isWordChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '-' || ch == '+';
    }

    @Override
    public void print(int v) {
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(long v) {
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(double v) {
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(float v) {
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(boolean v) {
        if (this.objectFormat == null) {
            super.print(v);
        } else {
            this.objectFormat.writeBoolean(v, this);
        }
    }

    @Override
    public void print(String v) {
        this.write(v == null ? "(null)" : v);
    }

    @Override
    public void print(Object v) {
        if (this.objectFormat != null) {
            this.objectFormat.writeObject(v, this);
        } else if (v instanceof Consumable) {
            ((Consumable)v).consume(this);
        } else {
            super.print(v == null ? "null" : v);
        }
    }

    @Override
    public void print(Consumer out) {
        out.write("#<output-port");
        if (this.path != null) {
            out.write(32);
            out.write(this.path.toString());
        }
        out.write(62);
    }

    @Override
    public void startElement(Object type) {
        if (this.objectFormat != null) {
            this.objectFormat.startElement(type, this);
        } else {
            this.print('(');
            this.print(type);
        }
    }

    @Override
    public void endElement() {
        if (this.objectFormat != null) {
            this.objectFormat.endElement(this);
        } else {
            this.print(')');
        }
    }

    @Override
    public void startAttribute(Object attrType) {
        if (this.objectFormat != null) {
            this.objectFormat.startAttribute(attrType, this);
        } else {
            this.print(' ');
            this.print(attrType);
            this.print(": ");
        }
    }

    @Override
    public void endAttribute() {
        if (this.objectFormat != null) {
            this.objectFormat.endAttribute(this);
        } else {
            this.print(' ');
        }
    }

    public void writeWordEnd() {
        this.bout.writeWordEnd();
    }

    public void writeWordStart() {
        this.bout.writeWordStart();
    }

    public void freshLine() {
        if (!this.atLineStart()) {
            this.println();
        }
    }

    public int getColumnNumber() {
        return this.bout.getColumnNumber();
    }

    public void setColumnNumber(int column) {
        this.bout.setColumnNumber(column);
    }

    public boolean atLineStart() {
        return this.bout.atLineStart();
    }

    void flushBuffer() {
        this.bout.forcePrettyOutput();
    }

    public void clearBuffer() {
        this.bout.clearBuffer();
    }

    public void closeThis() {
        try {
            if (!(this.base instanceof OutPort) || ((OutPort)this.base).bout != this.bout) {
                this.bout.closeThis();
                this.base = null;
                this.out = null;
            }
        }
        catch (IOException ex) {
            this.setError();
        }
        WriterManager.instance.unregister(this.unregisterRef);
        this.unregisterRef = null;
    }

    public boolean isOpen() {
        return (this.flags & 4) == 0;
    }

    public boolean isDomTerm() {
        return (this.flags & 8) != 0;
    }

    public void setDomTerm(boolean v) {
        this.flags = v ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public void close() {
        try {
            if (this.base instanceof OutPort && ((OutPort)this.base).bout == this.bout) {
                this.base.close();
                this.base = null;
            } else if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException ex) {
            this.setError();
        }
        WriterManager.instance.unregister(this.unregisterRef);
        this.unregisterRef = null;
        this.flags = 4;
    }

    protected boolean closeOnExit() {
        return true;
    }

    public void finalize() {
        if ((this.flags & 1) != 0) {
            this.flush();
        }
        if ((this.flags & 2) != 0) {
            this.close();
        } else {
            this.closeThis();
        }
    }

    public static void runCleanups() {
        WriterManager.instance.run();
    }

    public void startLogicalBlock(String prefix, boolean perLine, String suffix) {
        this.bout.startLogicalBlock(prefix, perLine, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLogicalBlock(String prefix, String suffix, int indent) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.bout.startLogicalBlock(prefix, false, suffix);
            this.bout.addIndentation(prefix == null ? indent : indent - prefix.length(), false);
        }
    }

    public void endLogicalBlock(String suffix) {
        this.bout.endLogicalBlock(suffix);
    }

    public void writeBreak(int kind) {
        this.bout.writeBreak(kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSpaceLinear() {
        Object object2 = this.lock;
        synchronized (object2) {
            this.write(32);
            this.writeBreak(78);
        }
    }

    public void writeBreakLinear() {
        this.writeBreak(78);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSpaceFill() {
        Object object2 = this.lock;
        synchronized (object2) {
            this.write(32);
            this.writeBreak(70);
        }
    }

    public void writeBreakFill() {
        this.writeBreak(70);
    }

    public void setIndentation(int amount, boolean current) {
        this.bout.addIndentation(amount, current);
    }

    static {
        OutPort.outInitial.flags = 1;
        errInitial = BinaryOutPort.makeStandardPort(System.err, "/dev/stderr");
        OutPort.errInitial.flags = 1;
        outLocation = new ThreadLocation("out-default");
        outLocation.setGlobal(outInitial);
        errLocation = new ThreadLocation("err-default");
        errLocation.setGlobal(errInitial);
    }
}

