/* wptDlgs.h - WinPT dialog headerfile
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef WPT_DIALOGS_H
#define WPT_DIALOGS_H

/*-- Clipboard dialogs --*/
BOOL CALLBACK clip_edit_dlg_proc( HWND dlg, 
				    UINT msg, 
				    WPARAM wparam,
				    LPARAM lparam );

BOOL CALLBACK clip_encrypt_dlg_proc( HWND dlg, 
				       UINT msg,
				       WPARAM wparam,
				       LPARAM lparam );

BOOL CALLBACK clip_sign_dlg_proc( HWND dlg, 
				    UINT msg, 
				    WPARAM wparam, 
				    LPARAM lparam );

BOOL CALLBACK clip_signenc_dlg_proc( HWND dlg, 
				       UINT msg, 
				       WPARAM wparam, 
				       LPARAM 
				       lparam );

BOOL CALLBACK clip_verify_dlg_proc( HWND dlg, 
				      UINT msg,
				      WPARAM wparam,
				      LPARAM lparam );

BOOL CALLBACK clip_import_dlg_proc( HWND dlg, 
				      UINT msg, 
				      WPARAM wparam, 
				      LPARAM lparam );

/*-- Keyserver handling dialogs --*/
BOOL CALLBACK keyserver_proxy_dlg_proc( HWND dlg, 
					  UINT msg, 
					  WPARAM wparam,
					  LPARAM lparam );

BOOL CALLBACK keyserver_dlg_proc( HWND dlg, 
				    UINT msg,
				    WPARAM wparam, 
				    LPARAM lparam );

BOOL CALLBACK hkpsearch_dlg_proc( HWND dlg, 
				    UINT msg, 
				    WPARAM, 
				    LPARAM lparam );

/*-- Key handling dialogs --*/
BOOL CALLBACK keygen_dlg_proc( HWND dlg, 
				 UINT msg, 
				 WPARAM wparam, 
				 LPARAM lparam );

BOOL CALLBACK keygen_wizard_dlg_proc( HWND dlg, 
				      UINT msg, 
				      WPARAM wparam, 
				      LPARAM lparam );

BOOL CALLBACK keymanager_dlg_proc( HWND dlg, 
				     UINT msg,
				     WPARAM wparam, 
				     LPARAM lparam );

BOOL CALLBACK keycache_dlg_proc( HWND dlg, 
				   UINT msg, 
				   WPARAM wparam, 
				   LPARAM lparam );

BOOL CALLBACK keysign_dlg_proc( HWND dlg, 
				  UINT msg, 
				  WPARAM wparam, 
				  LPARAM lparam );

BOOL CALLBACK keysig_dlg_proc( HWND dlg, 
				 UINT msg, 
				 WPARAM wparam, 
				 LPARAM lparam );

BOOL CALLBACK ownertrust_dlg_proc( HWND dlg, 
				     UINT msg, 
				     WPARAM wparam, 
				     LPARAM lparam );

BOOL CALLBACK keyedit_main_dlg_proc( HWND dlg, 
				     UINT msg, 
				     WPARAM wparam, 
				     LPARAM lparam );

BOOL CALLBACK keyedit_adduid_dlg_proc( HWND dlg, 
					 UINT msg, 
					 WPARAM wparam,
					 LPARAM lparam );

BOOL CALLBACK keyedit_addsubkey_dlg_proc( HWND dlg, 
					    UINT msg, 
					    WPARAM wparam,
					    LPARAM lparam );

BOOL CALLBACK keyedit_addrevoker_dlg_proc( HWND dlg, 
					   UINT msg, 
					   WPARAM wparam, 
					   LPARAM lparam );

BOOL CALLBACK keyedit_addphoto_dlg_proc( HWND dlg, 
					UINT msg, 
					WPARAM wparam, 
					LPARAM lparam );

BOOL CALLBACK keyedit_ownertrust_dlg_proc( HWND dlg, 
					     UINT msg, 
					     WPARAM wparam, 
					     LPARAM lparam );
BOOL CALLBACK keyedit_setpref_dlg_proc (HWND dlg, UINT msg, 
					WPARAM wparam, LPARAM lparam);
				 
BOOL CALLBACK keyprops_dlg_proc(HWND dlg, 
				   UINT msg,
				   WPARAM wparam, 
				   LPARAM lparam);
				   
BOOL CALLBACK keytrust_dlg_proc(HWND dlg, 
				   UINT msg, 
				   WPARAM wparam, 
				   LPARAM lparam);
				   
BOOL CALLBACK key_revoke_dlg_proc(HWND dlg, 
				     UINT msg, 
				     WPARAM wparam,  
				     LPARAM lparam);
				     
BOOL CALLBACK date_dlg_proc(HWND dlg, 
			       UINT msg,
			       WPARAM wparam, 
			       LPARAM lparam);

BOOL CALLBACK import_status_dlg_proc( HWND dlg, 
					UINT msg, 
					WPARAM wparam, 
					LPARAM lparam );

BOOL CALLBACK sig_class_dlg_proc( HWND dlg, 
				    UINT msg,
				    WPARAM wparam, 
				    LPARAM lparam );

BOOL CALLBACK key_revokers_dlg_proc( HWND dlg, 
				       UINT msg, 
				       WPARAM wparam, 
				       LPARAM lparam );

/*-- Group manager --*/
BOOL CALLBACK group_manager_dlg_proc(HWND dlg, 
					UINT msg, 
					WPARAM wparam, 
					LPARAM lparam);

/*-- File manager --*/
BOOL CALLBACK file_manager_dlg_proc(HWND dlg, 
				       UINT msg, 
				       WPARAM wparam,
				       LPARAM lparam);

BOOL CALLBACK file_secdel_confirm_dlg_proc( HWND dlg, 
					   UINT msg, 
					   WPARAM wparam, 
					   LPARAM lparam );

BOOL CALLBACK space_wipefrees_dlg_proc( HWND dlg, 
				       UINT msg, 
				       WPARAM wparam, 
				       LPARAM lparam );

BOOL CALLBACK file_sign_dlg_proc(HWND dlg, 
				    UINT msg, 
				    WPARAM wparam,
				    LPARAM lparam);

BOOL CALLBACK file_encrypt_dlg_proc(HWND dlg, 
				       UINT msg, 
				       WPARAM wparam, 
				       LPARAM lparam);

BOOL CALLBACK file_import_dlg_proc(HWND dlg, 
				      UINT msg, 
				      WPARAM wparam, 
				      LPARAM lparam);

BOOL CALLBACK file_export_dlg_proc(HWND dlg, 
				      UINT msg, 
				      WPARAM wparam, 
				      LPARAM lparam);

BOOL CALLBACK
file_preferences_dlg_proc (HWND dlg, 
			   UINT msg, 
			   WPARAM wparam, 
			   LPARAM lparam);

/*
BOOL CALLBACK file_prefs_dlg_proc(HWND dlg, 
				     UINT msg, 
				     WPARAM wparam, 
				     LPARAM lparam);
*/
BOOL CALLBACK file_stat_dlg_proc( HWND dlg, 
				    UINT msg, 
				    WPARAM wparam, 
				    LPARAM lparam );

BOOL CALLBACK file_save_dlg_proc( HWND dlg, 
				    UINT msg, 
				    WPARAM wparam, 
				    LPARAM lparam );

BOOL CALLBACK mdsum_dlg_proc( HWND dlg, 
			     UINT msg, 
			     WPARAM wparam, 
			     LPARAM lparam );

/*-- Filemanager verify log --*/
int file_verify_create_dlg( void );

/*-- Key generation callback */
int keygen_cb_dlg_create (void);
void keygen_cb_dlg_destroy (void);
void keygen_cb (void *opaque, const char *what, 
	        int type, unsigned curretn, unsigned total);

/*-- Data callback --*/
struct data_callback_s;
typedef struct data_callback_s *data_callback_t;

int data_cb_dlg_create( data_callback_t ctx );
void data_cb_dlg_destroy( void );
data_callback_t data_cb_new( const char *filename, listview_ctrl_t lv, HWND dlg );

/*-- Text input --*/
BOOL CALLBACK text_input_dlg_proc( HWND dlg, 
				   UINT msg, 
				   WPARAM wparam,
				   LPARAM lparam );

/*-- About dialogs --*/
BOOL CALLBACK about_winpt_dlg_proc( HWND dlg, 
				    UINT msg, 
				    WPARAM wparam,
				    LPARAM lparam );

/*-- Preferences dialogs --*/
BOOL CALLBACK prefs_dlg_proc( HWND dlg, 
				UINT msg, 
				WPARAM wparam,
				LPARAM lparam );

BOOL CALLBACK gpgprefs_dlg_proc(HWND hwnd,
				   UINT msg, 
				   WPARAM wparam,
				   LPARAM lparam);

BOOL CALLBACK gpgopt_dlg_proc( HWND dlg, 
			       UINT msg, 
			       WPARAM wparam,
			       LPARAM lparam );

/*-- Pseudo dialogs --*/
BOOL CALLBACK passphrase_callback_proc( HWND dlg, 
					UINT msg, 
					WPARAM wparam,
					LPARAM lparam );
int clip_decrypt_dlg( HWND hwnd );

void progress_callback (void * opaque, const char * what, int type,
		        unsigned off, unsigned max);

/*-- Misc --*/
BOOL CALLBACK first_run_dlg_proc( HWND dlg, 
				    UINT msg, 
				    WPARAM wparam, 
				    LPARAM lparam );
BOOL CALLBACK elgamal_warn_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, 
				     LPARAM lparam );

void * get_http_file_dlg (HWND root);

/*-- Card dialogs --*/
BOOL CALLBACK card_edit_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, 
				  LPARAM lparam );
BOOL CALLBACK pin_cb_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, 
			       LPARAM lparam );
BOOL CALLBACK card_changepin_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, 
				       LPARAM lparam );
BOOL CALLBACK card_keygen_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, 
				    LPARAM lparam );

/*-- wptClipImportDlg.cpp --*/
void print_import_status( int *import_res, int is_revcert );

/*-- wptMapi.cpp --*/
BOOL CALLBACK winpt_mail_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam);

#endif /* WPT_DIALOGS_H */
