/* implist.c -  list keys from a file
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <ctype.h>

#include "openpgp.h"
#include "util.h"
#include "context.h"
#include "context.h"
#include "key.h"
#include "ops.h"


void
gpgme_implist_create_revcert( gpgme_key_t *r_key, gpgme_revcert_t cert, gpgme_key_t pubk )
{
    size_t size = 1, len = 0;
    const char *fmt_reason = "Revocation cert; Code %02X; Reason %s";
    const char *fmt = "Revocation cert; Code %02X";
    const char * s = "Key revocation certificate";
    gpgme_key_t key;
    
    if( !r_key || !pubk )
        return;
    
    _gpgme_key_new( &key );

    if( !cert ) {
        key->keys.key_algo = 0;
        key->keys.key_len = 0;
	key->keys.timestamp = 0;
	memset( key->keys.keyid, '0', sizeof key->keys.keyid );
	key->uids = calloc (1, sizeof *key->uids + strlen (s) +1);
	if (!key->uids)
	    return;
	strcpy (key->uids->name, s);
        return;
    }
    
    /* fixme: add the public key to the gpgme_revcert_t */
    key->keys.key_algo = pubk->keys.key_algo;
    /*key->created = pubk->keys.timestamp;*/
    key->keys.key_len = pubk->keys.key_len;
    key->keys.timestamp = cert->timestamp;
    strcpy( key->keys.keyid, cert->keyid );
    safe_free( key->uids );
    if( cert->reason ) {
        size += strlen( cert->reason );
	len = strlen( fmt_reason ) + size;
	key->uids = calloc( 1, sizeof *key->uids + len + 1 );
	if( key->uids )
	    _snprintf( key->uids->name, len, fmt_reason, cert->code, cert->reason );
    }
    else {
	len = strlen( fmt ) + size;
	key->uids = calloc( 1, sizeof *key->uids + len + 1  );
	if( key->uids->name )
	    _snprintf( key->uids->name, len, fmt, cert->code );
    }
    *r_key = key;
} /* gpgme_implist_create_revcert */
