/* wptCommonDlg.cpp
 *	Copyright (C) 2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"

#include "wptTypes.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"


static BOOL CALLBACK
http_file_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static http_file_s * ctx;

    switch (msg) {
    case WM_INITDIALOG:
	ctx = (struct http_file_s*)lparam;
	if (!ctx)
	    BUG (0);
	SetForegroundWindow (dlg);
	break;

    case WM_COMMAND:
	switch (LOWORD (wparam)) {
	case IDOK:
	    if (!GetDlgItemText (dlg, IDC_HTTP_URL, ctx->url, sizeof ctx->url-1)) {
		msg_box (dlg, _("Please enter an URL."), _("HTTP"), MB_ERR);
		return FALSE;
	    }
	    ctx->cancel = 0;
	    EndDialog (dlg, TRUE);
	    break;

	case IDCANCEL:
	    ctx->cancel = 1;
	    EndDialog (dlg, FALSE);
	    break;
	}
    }

    return FALSE;
}


void *
get_http_file_dlg (HWND root)
{
    http_file_s * ctx;

    ctx = new http_file_s;
    if (!ctx)
	BUG (0);
    memset (ctx, 0, sizeof *ctx);
    DialogBoxParam (glob_hinst, (LPCTSTR)IDD_WINPT_HTTP, root,
		    http_file_dlg_proc, (LPARAM)ctx);

    return ctx;
}
