/* wptKeyCacheDlg.cpp - Key caching dialog
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptNLS.h"
#include "wptGPG.h"
#include "wptTypes.h"
#include "wptW32API.h"
#include "wptVersion.h"


BOOL CALLBACK
keycache_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    gpgme_error_t err;
    refresh_cache_s * rcs;
    char * pubring = NULL, * secring = NULL;
    
    switch( msg ) {
    case WM_INITDIALOG:
        rcs = (refresh_cache_s *)lparam;
        if (!rcs)
	    BUG (NULL);
        
        SetForegroundWindow (dlg);
        ShowWindow (dlg, SW_SHOW);
	center_window (dlg);
#ifndef LANG_DE
        SetWindowText (dlg, _("WinPT Key Caching"));
#endif
        ShowWindow (GetDlgItem (dlg, IDC_KEYCACHE_INFO), SW_SHOW);
        SetDlgItemText( dlg, IDC_KEYCACHE_INFO, _("Caching keyrings, please wait...") );
        
	pubring = get_gnupg_keyring (1, NO_STRICT);
	if (!pubring)
	    BUG (0);
	secring = get_gnupg_keyring (0, NO_STRICT);
	if (!secring)
	    BUG (0);
        if (rcs->tr_update)
            gpgme_op_rebuild_cache ();
        if (rcs->kr_update) {
            keycache_set_reload (rcs->kr_reload);
            err = keycache_init (pubring, secring);
	    if (err)
		msg_box (dlg, gpgme_strerror (err), _("Key Cache"), MB_ERR);
        }
	free_if_alloc (pubring);
	free_if_alloc (secring);
        EndDialog (dlg, TRUE);
        return FALSE;
    }
    
    return FALSE;
} /* keycache_dlg_proc */
