/* wptKeygenDlg.cpp - Key callback generation dialog
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptNLS.h"
#include "wptErrors.h"

static HWND dlg_hwnd = NULL;
static int dlg_init = 0;


static BOOL CALLBACK
keygen_cb_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    switch( msg ) {    
    case WM_INITDIALOG:
        SetDlgItemText( dlg, IDC_KEYPROG_CB, "" );
        SetForegroundWindow( dlg );
	center_window( dlg );
        dlg_hwnd = dlg;
        return TRUE;
    }
    
    return FALSE;
} /* keygen_cb_dlg_proc */


static DWORD WINAPI
keygen_cb_thread( void *opaque )
{
    DialogBoxParam( glob_hinst, (LPCSTR)IDD_WINPT_KEYPROG, GetActiveWindow(),
                    keygen_cb_dlg_proc, NULL );
    ExitThread( 0 );
    return 0;
} /* keygen_cb_dlg_thread */


int
keygen_cb_dlg_create( void )
{
    DWORD tid;
    HANDLE thread_hd;
    SECURITY_ATTRIBUTES sec_attr;
    
    if( dlg_init == 1 )
        return 0;
    
    memset( &sec_attr, 0, sizeof sec_attr );
    sec_attr.bInheritHandle = FALSE;
    sec_attr.lpSecurityDescriptor = NULL;
    sec_attr.nLength = sizeof sec_attr;
    thread_hd = CreateThread( &sec_attr, 0, keygen_cb_thread, NULL, 0, &tid );
    if( !thread_hd ) {
        msg_box( NULL, _("Could not create key generation thread"), _("Key Generation"), MB_ERR );
        return WPTERR_GENERAL;
    }	
    
    return 0;
} /* keygen_cb_dlg_create */

void
keygen_cb_dlg_destroy( void )
{
    if( dlg_hwnd ) {
        EndDialog( dlg_hwnd, TRUE );
        dlg_hwnd = NULL;
    }
} /* keygen_cb_dlg_destroy */


void
keygen_cb (void * opaque, const char * what, int type, unsigned curretn, unsigned total)
{
    static char cb[8192] = {0};
    static int cb_pos = 0;
    
    if (!opaque && !what && !type && !curretn && !total) {
        memset (cb, 0, sizeof cb);
        cb_pos = 0;
        return;
    }
    
    if (cb_pos >= (DIM (cb)-1))
        cb_pos = 0;
    cb[cb_pos] = (char)type;
    cb_pos++;
    cb[cb_pos] = '\0';
    
    SetDlgItemText (dlg_hwnd, IDC_KEYPROG_CB, cb);
} /* keygen_cb */
