/* wptPassphraseDlg.cpp - Dialog to get the passphrase
 *	Copyright (C) 2001-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptDlgs.h"
#include "wptNLS.h"
#include "wptW32API.h"
#include "wptUTF8.h"
#include "wptVersion.h"
#include "wptTypes.h"


struct passphrase_s {
    char * title;
    char pwd[256];
    int repeat;
    int cancel;
};


static BOOL CALLBACK
passwd_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static passphrase_s * pwd;
    static int hide = 1;
    int nbytes;
    
    switch (msg) {
    case WM_INITDIALOG:
	hide = 1;
        pwd = (passphrase_s *)lparam;
        if (pwd == NULL)
            dlg_fatal_error (dlg, "Could not get dialog param!");
#ifndef LANG_DE
        SetWindowText (dlg, _("Passphrase Dialog"));
#endif
	CheckDlgButton (dlg, IDC_PASSWD_HIDE, BST_CHECKED);
        if (pwd->title)
            SetWindowText (dlg, pwd->title);
	if (pwd->repeat)
	    SetDlgItemText (dlg, IDC_PASSWD_INFO, _("Repeat Passphrase"));
	else
	    SetDlgItemText (dlg, IDC_PASSWD_INFO, _("Enter Passphrase"));
        SetFocus (GetDlgItem (dlg, IDC_PASSWD_PWD ));
	center_window2 (dlg, HWND_TOPMOST);
	center_window (dlg);
        SetForegroundWindow (dlg);
        return FALSE;
        
    case WM_COMMAND:
	if( HIWORD( wparam ) == BN_CLICKED && LOWORD( wparam ) == IDC_PASSWD_HIDE ) {
	    HWND hwnd = GetDlgItem( dlg, IDC_PASSWD_PWD );
	    hide ^= 1;
	    SendMessage( hwnd, EM_SETPASSWORDCHAR, hide? '*' : 0, 0 );
	    SetFocus( hwnd );
	}

        switch( LOWORD( wparam ) ) {
        case IDOK:
            pwd->cancel = 0;
            nbytes = GetDlgItemText( dlg, IDC_PASSWD_PWD, pwd->pwd, sizeof pwd->pwd -1 );
            if( !nbytes )
                strcpy( pwd->pwd, "" );
            SetDlgItemText( dlg, IDC_PASSWD_PWD, "" );
            EndDialog( dlg, TRUE );
            return TRUE;
            
        case IDCANCEL:
            pwd->cancel = 1;
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* passwd_dlg_proc */


char *
request_passphrase (const char * title, int init, int * ret_cancel)
{
    passphrase_s pass;
    char * p;

    memset (&pass, 0, sizeof pass);
    if (title && *title) {
	pass.title = m_strdup (title);
	if (!pass.title)
	    BUG (0);
    }
    pass.repeat = init == 0? 1: 0;
    DialogBoxParam (glob_hinst, (LPCTSTR)IDD_WINPT_PASSWD, glob_hwnd,
		    passwd_dlg_proc, (LPARAM)&pass);
    if (pass.cancel == 1) {
	*ret_cancel = 1;
	return NULL;
    }
    p = m_strdup (pass.pwd);
    if (!p)
	BUG (0);
    free_if_alloc (pass.title);
    memset (&pass, 0, sizeof pass);
    return p;
} /* request_passphrase */


char *
request_passphrase2 (const char * title, int * ret_cancel)
{
    char * pass1, * pass2;
    int equal = 0, cancel = 0;

    *ret_cancel = 1;
    while (!equal) {
	pass1 = request_passphrase (title, 1, &cancel);
	if (cancel)
	    return NULL;
	pass2 = request_passphrase (title, 0, &cancel);
	if (cancel) {
	    sfree_if_alloc (pass1);
	    return NULL;
	}

	if (strcmp (pass1, pass2)) {
	    msg_box (NULL, _("Passphrases do not match. Please try again."),
		     title, MB_INFO);
	    sfree_if_alloc (pass1);
	    sfree_if_alloc (pass2);
	}
	else {
	    if (is_8bit_string (pass1)) {
		msg_box (NULL, _("The passphrase contains 8-bit characters.\n"
				 "It is not suggested to use charset specific characters."),
			 title, MB_ERR);
		equal = 0;
		sfree_if_alloc (pass1);
		sfree_if_alloc (pass2);
	    }
	    else
		equal = 1;
	}
    }
    sfree_if_alloc (pass2);
    *ret_cancel = 0;
    return pass1;
}
